/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseRK;
import neqsim.thermo.system.SystemEos;

public class SystemRKEos
extends SystemEos {
    private static final long serialVersionUID = 1000L;

    public SystemRKEos() {
        this(298.15, 1.0, false);
    }

    public SystemRKEos(double T, double P) {
        this(T, P, false);
    }

    public SystemRKEos(double T, double P, boolean checkForSolids) {
        super(T, P, checkForSolids);
        this.attractiveTermNumber = 5;
        this.modelName = "RK-EOS";
        for (int i = 0; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseRK();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.setNumberOfPhases(4);
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemRKEos clone() {
        SystemRKEos clonedSystem = null;
        try {
            clonedSystem = (SystemRKEos)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

