/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.system;

import neqsim.thermo.phase.PhaseGEUnifacPSRK;
import neqsim.thermo.phase.PhasePureComponentSolid;
import neqsim.thermo.phase.PhaseSrkEos;
import neqsim.thermo.system.SystemEos;

public class SystemUNIFACpsrk
extends SystemEos {
    private static final long serialVersionUID = 1000L;

    public SystemUNIFACpsrk() {
        this(298.15, 1.0, false);
    }

    public SystemUNIFACpsrk(double T, double P) {
        this(T, P, false);
    }

    public SystemUNIFACpsrk(double T, double P, boolean checkForSolids) {
        super(T, P, checkForSolids);
        this.attractiveTermNumber = 0;
        this.modelName = "UNIFAC-GE-model";
        this.solidPhaseCheck = checkForSolids;
        this.phaseArray[0] = new PhaseSrkEos();
        this.phaseArray[0].setTemperature(T);
        this.phaseArray[0].setPressure(P);
        for (int i = 1; i < this.numberOfPhases; ++i) {
            this.phaseArray[i] = new PhaseGEUnifacPSRK();
            this.phaseArray[i].setTemperature(T);
            this.phaseArray[i].setPressure(P);
        }
        if (this.solidPhaseCheck) {
            this.setNumberOfPhases(4);
            this.phaseArray[this.numberOfPhases - 1] = new PhasePureComponentSolid();
            this.phaseArray[this.numberOfPhases - 1].setTemperature(T);
            this.phaseArray[this.numberOfPhases - 1].setPressure(P);
            this.phaseArray[this.numberOfPhases - 1].setRefPhase(this.phaseArray[1].getRefPhase());
        }
    }

    @Override
    public SystemUNIFACpsrk clone() {
        SystemUNIFACpsrk clonedSystem = null;
        try {
            clonedSystem = (SystemUNIFACpsrk)super.clone();
        }
        catch (Exception ex) {
            logger.error("Cloning failed.", (Throwable)ex);
        }
        return clonedSystem;
    }
}

