/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.gerg;

import org.netlib.util.StringW;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class DETAIL {
    double RDetail;
    int NcDetail = 21;
    int MaxFlds = 21;
    int NTerms = 58;
    double epsilon = 1.0E-15;
    int[] fn = new int[this.NTerms + 1];
    int[] gn = new int[this.NTerms + 1];
    int[] qn = new int[this.NTerms + 1];
    double[] an = new double[this.NTerms + 1];
    double[] un = new double[this.NTerms + 1];
    int[] bn = new int[this.NTerms + 1];
    int[] kn = new int[this.NTerms + 1];
    double[][][] Bsnij2 = new double[this.MaxFlds + 1][this.MaxFlds + 1][19];
    double[] Bs = new double[19];
    double[] Csn = new double[this.NTerms + 1];
    double[] Fi = new double[this.MaxFlds + 1];
    double[] Gi = new double[this.MaxFlds + 1];
    double[] Qi = new double[this.MaxFlds + 1];
    double[] Ki25 = new double[this.MaxFlds + 1];
    double[] Ei25 = new double[this.MaxFlds + 1];
    double[][] Kij5 = new double[this.MaxFlds + 1][this.MaxFlds + 1];
    double[][] Uij5 = new double[this.MaxFlds + 1][this.MaxFlds + 1];
    double[][] Gij5 = new double[this.MaxFlds + 1][this.MaxFlds + 1];
    double[] Tun = new double[this.NTerms + 1];
    double Told;
    double[][] n0i = new double[this.MaxFlds + 1][8];
    double[][] th0i = new double[this.MaxFlds + 1][8];
    double[] MMiDetail = new double[this.MaxFlds + 1];
    double[] xold = new double[this.MaxFlds + 1];
    double K3;
    double dPdDsave;

    public double sq(double x) {
        return x * x;
    }

    public void MolarMassDetail(double[] x, doubleW Mm) {
        Mm.val = 0.0;
        for (int i = 1; i <= this.NcDetail; ++i) {
            Mm.val += x[i] * this.MMiDetail[i];
        }
    }

    public void PressureDetail(double T, double D, double[] x, doubleW P, doubleW Z) {
        doubleW[][] ar = new doubleW[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ar[i][j] = new doubleW(0.0);
            }
        }
        this.xTermsDetail(x);
        this.AlpharDetail(0, 2, T, D, ar);
        Z.val = 1.0 + ar[0][1].val / this.RDetail / T;
        P.val = D * this.RDetail * T * Z.val;
        this.dPdDsave = this.RDetail * T + 2.0 * ar[0][1].val + ar[0][2].val;
    }

    public void DensityDetail(double T, double P, double[] x, doubleW D, intW ierr, StringW herr) {
        doubleW P2 = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        ierr.val = 0;
        herr.val = "";
        if (Math.abs(P) < this.epsilon) {
            D.val = 0.0;
            return;
        }
        double tolr = 1.0E-7;
        D.val = D.val > -this.epsilon ? P / this.RDetail / T : Math.abs(D.val);
        double plog = Math.log(P);
        double vlog = -Math.log(D.val);
        for (int it = 1; it <= 20; ++it) {
            if (vlog < -7.0 || vlog > 100.0) {
                ierr.val = 1;
                herr.val = "Calculation failed to converge in DETAIL method, ideal gas density returned.";
                D.val = P / this.RDetail / T;
                return;
            }
            D.val = Math.exp(-vlog);
            this.PressureDetail(T, D.val, x, P2, Z);
            if (this.dPdDsave < this.epsilon || P2.val < this.epsilon) {
                vlog += 0.1;
                continue;
            }
            double dpdlv = -D.val * this.dPdDsave;
            double vdiff = (Math.log(P2.val) - plog) * P2.val / dpdlv;
            vlog -= vdiff;
            if (!(Math.abs(vdiff) < tolr)) continue;
            D.val = Math.exp(-vlog);
            return;
        }
        ierr.val = 1;
        herr.val = "Calculation failed to converge in DETAIL method, ideal gas density returned.";
        D.val = P / this.RDetail / T;
    }

    public void PropertiesDetail(double T, double D, double[] x, doubleW P, doubleW Z, doubleW dPdD, doubleW d2PdD2, doubleW d2PdTD, doubleW dPdT, doubleW U, doubleW H, doubleW S, doubleW Cv, doubleW Cp, doubleW W, doubleW G, doubleW JT, doubleW Kappa) {
        doubleW A = new doubleW(0.0);
        doubleW[] a0 = new doubleW[3];
        for (int i = 0; i < 3; ++i) {
            a0[i] = new doubleW(0.0);
        }
        doubleW[][] ar = new doubleW[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ar[i][j] = new doubleW(0.0);
            }
        }
        doubleW Mm = new doubleW(0.0);
        this.MolarMassDetail(x, Mm);
        this.xTermsDetail(x);
        this.Alpha0Detail(T, D, x, a0);
        this.AlpharDetail(2, 3, T, D, ar);
        double R = this.RDetail;
        double RT = R * T;
        Z.val = 1.0 + ar[0][1].val / RT;
        P.val = D * RT * Z.val;
        dPdD.val = RT + 2.0 * ar[0][1].val + ar[0][2].val;
        dPdT.val = D * R + D * ar[1][1].val;
        A.val = a0[0].val + ar[0][0].val;
        S.val = -a0[1].val - ar[1][0].val;
        U.val = A.val + T * S.val;
        Cv.val = -(a0[2].val + ar[2][0].val);
        if (D > this.epsilon) {
            H.val = U.val + P.val / D;
            G.val = A.val + P.val / D;
            Cp.val = Cv.val + T * this.sq(dPdT.val / D) / dPdD.val;
            d2PdD2.val = (2.0 * ar[0][1].val + 4.0 * ar[0][2].val + ar[0][3].val) / D;
            JT.val = (T / D * dPdT.val / dPdD.val - 1.0) / Cp.val / D;
        } else {
            H.val = U.val + RT;
            G.val = A.val + RT;
            Cp.val = Cv.val + R;
            d2PdD2.val = 0.0;
            JT.val = 1.0E20;
        }
        W.val = 1000.0 * Cp.val / Cv.val * dPdD.val / Mm.val;
        if (W.val < 0.0) {
            W.val = 0.0;
        }
        W.val = Math.sqrt(W.val);
        Kappa.val = W.val * W.val * Mm.val / (RT * 1000.0 * Z.val);
        d2PdTD.val = 0.0;
    }

    void xTermsDetail(double[] x) {
        int n;
        int i;
        boolean icheck = false;
        for (i = 1; i <= this.NcDetail; ++i) {
            if (Math.abs(x[i] - this.xold[i]) > 1.0E-7) {
                icheck = true;
            }
            this.xold[i] = x[i];
        }
        if (!icheck) {
            return;
        }
        this.K3 = 0.0;
        double U = 0.0;
        double G = 0.0;
        double Q = 0.0;
        double F = 0.0;
        for (n = 1; n <= 18; ++n) {
            this.Bs[n] = 0.0;
        }
        for (i = 1; i <= this.NcDetail; ++i) {
            if (!(x[i] > 0.0)) continue;
            double xi2 = this.sq(x[i]);
            this.K3 += x[i] * this.Ki25[i];
            U += x[i] * this.Ei25[i];
            G += x[i] * this.Gi[i];
            Q += x[i] * this.Qi[i];
            F += xi2 * this.Fi[i];
            for (int n2 = 1; n2 <= 18; ++n2) {
                this.Bs[n2] = this.Bs[n2] + xi2 * this.Bsnij2[i][i][n2];
            }
        }
        this.K3 = this.sq(this.K3);
        U = this.sq(U);
        for (i = 1; i <= this.NcDetail - 1; ++i) {
            if (!(x[i] > 0.0)) continue;
            for (int j = i + 1; j <= this.NcDetail; ++j) {
                if (!(x[j] > 0.0)) continue;
                double xij = 2.0 * x[i] * x[j];
                this.K3 += xij * this.Kij5[i][j];
                U += xij * this.Uij5[i][j];
                G += xij * this.Gij5[i][j];
                for (int n3 = 1; n3 <= 18; ++n3) {
                    this.Bs[n3] = this.Bs[n3] + xij * this.Bsnij2[i][j][n3];
                }
            }
        }
        this.K3 = Math.pow(this.K3, 0.6);
        U = Math.pow(U, 0.2);
        double Q2 = this.sq(Q);
        for (n = 13; n <= 58; ++n) {
            this.Csn[n] = this.an[n] * Math.pow(U, this.un[n]);
            if (this.gn[n] == 1) {
                this.Csn[n] = this.Csn[n] * G;
            }
            if (this.qn[n] == 1) {
                this.Csn[n] = this.Csn[n] * Q2;
            }
            if (this.fn[n] != 1) continue;
            this.Csn[n] = this.Csn[n] * F;
        }
    }

    void Alpha0Detail(double T, double D, double[] x, doubleW[] a0) {
        a0[0].val = 0.0;
        a0[1].val = 0.0;
        a0[2].val = 0.0;
        double LogD = D > this.epsilon ? Math.log(D) : Math.log(this.epsilon);
        double LogT = Math.log(T);
        for (int i = 1; i <= this.NcDetail; ++i) {
            if (!(x[i] > 0.0)) continue;
            double LogxD = LogD + Math.log(x[i]);
            double SumHyp0 = 0.0;
            double SumHyp1 = 0.0;
            double SumHyp2 = 0.0;
            for (int j = 4; j <= 7; ++j) {
                double LogHyp;
                if (!(this.th0i[i][j] > 0.0)) continue;
                double th0T = this.th0i[i][j] / T;
                double ep = Math.exp(th0T);
                double em = 1.0 / ep;
                double hsn = (ep - em) / 2.0;
                double hcn = (ep + em) / 2.0;
                if (j == 4 || j == 6) {
                    LogHyp = Math.log(Math.abs(hsn));
                    SumHyp0 += this.n0i[i][j] * LogHyp;
                    SumHyp1 += this.n0i[i][j] * (LogHyp - th0T * hcn / hsn);
                    SumHyp2 += this.n0i[i][j] * this.sq(th0T / hsn);
                    continue;
                }
                LogHyp = Math.log(Math.abs(hcn));
                SumHyp0 += -this.n0i[i][j] * LogHyp;
                SumHyp1 += -this.n0i[i][j] * (LogHyp - th0T * hsn / hcn);
                SumHyp2 += this.n0i[i][j] * this.sq(th0T / hcn);
            }
            a0[0].val += x[i] * (LogxD + this.n0i[i][1] + this.n0i[i][2] / T - this.n0i[i][3] * LogT + SumHyp0);
            a0[1].val += x[i] * (LogxD + this.n0i[i][1] - this.n0i[i][3] * (1.0 + LogT) + SumHyp1);
            a0[2].val += -x[i] * (this.n0i[i][3] + SumHyp2);
        }
        a0[0].val = a0[0].val * this.RDetail * T;
        a0[1].val *= this.RDetail;
        a0[2].val *= this.RDetail;
    }

    void AlpharDetail(int itau, int idel, double T, double D, doubleW[][] ar) {
        int n;
        double[] Sum0 = new double[this.NTerms + 1];
        double[] SumB = new double[this.NTerms + 1];
        double[] Dknn = new double[10];
        double[] Expn = new double[5];
        double[] CoefD1 = new double[this.NTerms + 1];
        double[] CoefD2 = new double[this.NTerms + 1];
        double[] CoefD3 = new double[this.NTerms + 1];
        double[] CoefT1 = new double[this.NTerms + 1];
        double[] CoefT2 = new double[this.NTerms + 1];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                ar[i][j].val = 0.0;
            }
        }
        if (Math.abs(T - this.Told) > 1.0E-7) {
            for (n = 1; n <= 58; ++n) {
                this.Tun[n] = Math.pow(T, -this.un[n]);
            }
        }
        this.Told = T;
        double Dred = this.K3 * D;
        Dknn[0] = 1.0;
        for (n = 1; n <= 9; ++n) {
            Dknn[n] = Dred * Dknn[n - 1];
        }
        Expn[0] = 1.0;
        for (n = 1; n <= 4; ++n) {
            Expn[n] = Math.exp(-Dknn[n]);
        }
        double RT = this.RDetail * T;
        for (n = 1; n <= 58; ++n) {
            CoefT1[n] = this.RDetail * (this.un[n] - 1.0);
            CoefT2[n] = CoefT1[n] * this.un[n];
            SumB[n] = 0.0;
            Sum0[n] = 0.0;
            if (n <= 18) {
                double Sum2 = this.Bs[n] * D;
                if (n >= 13) {
                    Sum2 += -this.Csn[n] * Dred;
                }
                SumB[n] = Sum2 * this.Tun[n];
            }
            if (n >= 13) {
                Sum0[n] = this.Csn[n] * Dknn[this.bn[n]] * this.Tun[n] * Expn[this.kn[n]];
                double bkd = (double)this.bn[n] - (double)this.kn[n] * Dknn[this.kn[n]];
                double ckd = (double)(this.kn[n] * this.kn[n]) * Dknn[this.kn[n]];
                CoefD1[n] = bkd;
                CoefD2[n] = bkd * (bkd - 1.0) - ckd;
                CoefD3[n] = (bkd - 2.0) * CoefD2[n] + ckd * ((double)(1 - this.kn[n]) - 2.0 * bkd);
                continue;
            }
            CoefD1[n] = 0.0;
            CoefD2[n] = 0.0;
            CoefD3[n] = 0.0;
        }
        for (n = 1; n <= 58; ++n) {
            double s0 = Sum0[n] + SumB[n];
            double s1 = Sum0[n] * CoefD1[n] + SumB[n];
            double s2 = Sum0[n] * CoefD2[n];
            double s3 = Sum0[n] * CoefD3[n];
            ar[0][0].val += RT * s0;
            ar[0][1].val += RT * s1;
            ar[0][2].val += RT * s2;
            ar[0][3].val += RT * s3;
            if (itau <= 0) continue;
            ar[1][0].val -= CoefT1[n] * s0;
            ar[1][1].val -= CoefT1[n] * s1;
            ar[2][0].val += CoefT2[n] * s0;
        }
    }

    public void SetupDetail() {
        int j;
        int i;
        int[] sn = new int[this.NTerms + 1];
        int[] wn = new int[this.NTerms + 1];
        double[] Ei = new double[this.MaxFlds + 1];
        double[] Ki = new double[this.MaxFlds + 1];
        double[] Si = new double[this.MaxFlds + 1];
        double[] Wi = new double[this.MaxFlds + 1];
        double[][] Kij = new double[this.MaxFlds + 1][this.MaxFlds + 1];
        double[][] Gij = new double[this.MaxFlds + 1][this.MaxFlds + 1];
        double[][] Eij = new double[this.MaxFlds + 1][this.MaxFlds + 1];
        double[][] Uij = new double[this.MaxFlds + 1][this.MaxFlds + 1];
        this.RDetail = 8.31451;
        this.MMiDetail[1] = 16.043;
        this.MMiDetail[2] = 28.0135;
        this.MMiDetail[3] = 44.01;
        this.MMiDetail[4] = 30.07;
        this.MMiDetail[5] = 44.097;
        this.MMiDetail[6] = 58.123;
        this.MMiDetail[7] = 58.123;
        this.MMiDetail[8] = 72.15;
        this.MMiDetail[9] = 72.15;
        this.MMiDetail[10] = 86.177;
        this.MMiDetail[11] = 100.204;
        this.MMiDetail[12] = 114.231;
        this.MMiDetail[13] = 128.258;
        this.MMiDetail[14] = 142.285;
        this.MMiDetail[15] = 2.0159;
        this.MMiDetail[16] = 31.9988;
        this.MMiDetail[17] = 28.01;
        this.MMiDetail[18] = 18.0153;
        this.MMiDetail[19] = 34.082;
        this.MMiDetail[20] = 4.0026;
        this.MMiDetail[21] = 39.948;
        this.Told = 0.0;
        for (i = 1; i <= this.NTerms; ++i) {
            this.an[i] = 0.0;
            this.bn[i] = 0;
            this.gn[i] = 0;
            this.fn[i] = 0;
            this.kn[i] = 0;
            this.qn[i] = 0;
            sn[i] = 0;
            this.un[i] = 0.0;
            wn[i] = 0;
        }
        for (i = 1; i <= this.MaxFlds; ++i) {
            Ei[i] = 0.0;
            this.Fi[i] = 0.0;
            this.Gi[i] = 0.0;
            Ki[i] = 0.0;
            this.Qi[i] = 0.0;
            Si[i] = 0.0;
            Wi[i] = 0.0;
            this.xold[i] = 0.0;
            for (j = 1; j <= this.MaxFlds; ++j) {
                Eij[i][j] = 1.0;
                Gij[i][j] = 1.0;
                Kij[i][j] = 1.0;
                Uij[i][j] = 1.0;
            }
        }
        this.an[1] = 0.1538326;
        this.an[2] = 1.341953;
        this.an[3] = -2.998583;
        this.an[4] = -0.04831228;
        this.an[5] = 0.3757965;
        this.an[6] = -1.589575;
        this.an[7] = -0.05358847;
        this.an[8] = 0.88659463;
        this.an[9] = -0.71023704;
        this.an[10] = -1.471722;
        this.an[11] = 1.32185035;
        this.an[12] = -0.78665925;
        this.an[13] = 2.29129E-9;
        this.an[14] = 0.1576724;
        this.an[15] = -0.4363864;
        this.an[16] = -0.04408159;
        this.an[17] = -0.003433888;
        this.an[18] = 0.03205905;
        this.an[19] = 0.02487355;
        this.an[20] = 0.07332279;
        this.an[21] = -0.001600573;
        this.an[22] = 0.6424706;
        this.an[23] = -0.4162601;
        this.an[24] = -0.06689957;
        this.an[25] = 0.2791795;
        this.an[26] = -0.6966051;
        this.an[27] = -0.002860589;
        this.an[28] = -0.008098836;
        this.an[29] = 3.150547;
        this.an[30] = 0.007224479;
        this.an[31] = -0.7057529;
        this.an[32] = 0.5349792;
        this.an[33] = -0.07931491;
        this.an[34] = -1.418465;
        this.an[35] = -5.99905E-17;
        this.an[36] = 0.1058402;
        this.an[37] = 0.03431729;
        this.an[38] = -0.007022847;
        this.an[39] = 0.02495587;
        this.an[40] = 0.04296818;
        this.an[41] = 0.7465453;
        this.an[42] = -0.2919613;
        this.an[43] = 7.294616;
        this.an[44] = -9.936757;
        this.an[45] = -0.005399808;
        this.an[46] = -0.2432567;
        this.an[47] = 0.04987016;
        this.an[48] = 0.003733797;
        this.an[49] = 1.874951;
        this.an[50] = 0.002168144;
        this.an[51] = -0.6587164;
        this.an[52] = 2.05518E-4;
        this.an[53] = 0.009776195;
        this.an[54] = -0.02048708;
        this.an[55] = 0.01557322;
        this.an[56] = 0.006862415;
        this.an[57] = -0.001226752;
        this.an[58] = 0.002850908;
        this.bn[1] = 1;
        this.bn[2] = 1;
        this.bn[3] = 1;
        this.bn[4] = 1;
        this.bn[5] = 1;
        this.bn[6] = 1;
        this.bn[7] = 1;
        this.bn[8] = 1;
        this.bn[9] = 1;
        this.bn[10] = 1;
        this.bn[11] = 1;
        this.bn[12] = 1;
        this.bn[13] = 1;
        this.bn[14] = 1;
        this.bn[15] = 1;
        this.bn[16] = 1;
        this.bn[17] = 1;
        this.bn[18] = 1;
        this.bn[19] = 2;
        this.bn[20] = 2;
        this.bn[21] = 2;
        this.bn[22] = 2;
        this.bn[23] = 2;
        this.bn[24] = 2;
        this.bn[25] = 2;
        this.bn[26] = 2;
        this.bn[27] = 2;
        this.bn[28] = 3;
        this.bn[29] = 3;
        this.bn[30] = 3;
        this.bn[31] = 3;
        this.bn[32] = 3;
        this.bn[33] = 3;
        this.bn[34] = 3;
        this.bn[35] = 3;
        this.bn[36] = 3;
        this.bn[37] = 3;
        this.bn[38] = 4;
        this.bn[39] = 4;
        this.bn[40] = 4;
        this.bn[41] = 4;
        this.bn[42] = 4;
        this.bn[43] = 4;
        this.bn[44] = 4;
        this.bn[45] = 5;
        this.bn[46] = 5;
        this.bn[47] = 5;
        this.bn[48] = 5;
        this.bn[49] = 5;
        this.bn[50] = 6;
        this.bn[51] = 6;
        this.bn[52] = 7;
        this.bn[53] = 7;
        this.bn[54] = 8;
        this.bn[55] = 8;
        this.bn[56] = 8;
        this.bn[57] = 9;
        this.bn[58] = 9;
        this.kn[13] = 3;
        this.kn[14] = 2;
        this.kn[15] = 2;
        this.kn[16] = 2;
        this.kn[17] = 4;
        this.kn[18] = 4;
        this.kn[21] = 2;
        this.kn[22] = 2;
        this.kn[23] = 2;
        this.kn[24] = 4;
        this.kn[25] = 4;
        this.kn[26] = 4;
        this.kn[27] = 4;
        this.kn[29] = 1;
        this.kn[30] = 1;
        this.kn[31] = 2;
        this.kn[32] = 2;
        this.kn[33] = 3;
        this.kn[34] = 3;
        this.kn[35] = 4;
        this.kn[36] = 4;
        this.kn[37] = 4;
        this.kn[40] = 2;
        this.kn[41] = 2;
        this.kn[42] = 2;
        this.kn[43] = 4;
        this.kn[44] = 4;
        this.kn[46] = 2;
        this.kn[47] = 2;
        this.kn[48] = 4;
        this.kn[49] = 4;
        this.kn[51] = 2;
        this.kn[53] = 2;
        this.kn[54] = 1;
        this.kn[55] = 2;
        this.kn[56] = 2;
        this.kn[57] = 2;
        this.kn[58] = 2;
        this.un[1] = 0.0;
        this.un[2] = 0.5;
        this.un[3] = 1.0;
        this.un[4] = 3.5;
        this.un[5] = -0.5;
        this.un[6] = 4.5;
        this.un[7] = 0.5;
        this.un[8] = 7.5;
        this.un[9] = 9.5;
        this.un[10] = 6.0;
        this.un[11] = 12.0;
        this.un[12] = 12.5;
        this.un[13] = -6.0;
        this.un[14] = 2.0;
        this.un[15] = 3.0;
        this.un[16] = 2.0;
        this.un[17] = 2.0;
        this.un[18] = 11.0;
        this.un[19] = -0.5;
        this.un[20] = 0.5;
        this.un[21] = 0.0;
        this.un[22] = 4.0;
        this.un[23] = 6.0;
        this.un[24] = 21.0;
        this.un[25] = 23.0;
        this.un[26] = 22.0;
        this.un[27] = -1.0;
        this.un[28] = -0.5;
        this.un[29] = 7.0;
        this.un[30] = -1.0;
        this.un[31] = 6.0;
        this.un[32] = 4.0;
        this.un[33] = 1.0;
        this.un[34] = 9.0;
        this.un[35] = -13.0;
        this.un[36] = 21.0;
        this.un[37] = 8.0;
        this.un[38] = -0.5;
        this.un[39] = 0.0;
        this.un[40] = 2.0;
        this.un[41] = 7.0;
        this.un[42] = 9.0;
        this.un[43] = 22.0;
        this.un[44] = 23.0;
        this.un[45] = 1.0;
        this.un[46] = 9.0;
        this.un[47] = 3.0;
        this.un[48] = 8.0;
        this.un[49] = 23.0;
        this.un[50] = 1.5;
        this.un[51] = 5.0;
        this.un[52] = -0.5;
        this.un[53] = 4.0;
        this.un[54] = 7.0;
        this.un[55] = 3.0;
        this.un[56] = 0.0;
        this.un[57] = 1.0;
        this.un[58] = 0.0;
        this.fn[13] = 1;
        this.fn[27] = 1;
        this.fn[30] = 1;
        this.fn[35] = 1;
        this.gn[5] = 1;
        this.gn[6] = 1;
        this.gn[25] = 1;
        this.gn[29] = 1;
        this.gn[32] = 1;
        this.gn[33] = 1;
        this.gn[34] = 1;
        this.gn[51] = 1;
        this.gn[54] = 1;
        this.gn[56] = 1;
        this.qn[7] = 1;
        this.qn[16] = 1;
        this.qn[26] = 1;
        this.qn[28] = 1;
        this.qn[37] = 1;
        this.qn[42] = 1;
        this.qn[47] = 1;
        this.qn[49] = 1;
        this.qn[52] = 1;
        this.qn[58] = 1;
        sn[8] = 1;
        sn[9] = 1;
        wn[10] = 1;
        wn[11] = 1;
        wn[12] = 1;
        Ei[1] = 151.3183;
        Ei[2] = 99.73778;
        Ei[3] = 241.9606;
        Ei[4] = 244.1667;
        Ei[5] = 298.1183;
        Ei[6] = 324.0689;
        Ei[7] = 337.6389;
        Ei[8] = 365.5999;
        Ei[9] = 370.6823;
        Ei[10] = 402.636293;
        Ei[11] = 427.72263;
        Ei[12] = 450.325022;
        Ei[13] = 470.840891;
        Ei[14] = 489.558373;
        Ei[15] = 26.95794;
        Ei[16] = 122.7667;
        Ei[17] = 105.5348;
        Ei[18] = 514.0156;
        Ei[19] = 296.355;
        Ei[20] = 2.610111;
        Ei[21] = 119.6299;
        Ki[1] = 0.4619255;
        Ki[2] = 0.4479153;
        Ki[3] = 0.4557489;
        Ki[4] = 0.5279209;
        Ki[5] = 0.583749;
        Ki[6] = 0.6406937;
        Ki[7] = 0.6341423;
        Ki[8] = 0.6738577;
        Ki[9] = 0.6798307;
        Ki[10] = 0.7175118;
        Ki[11] = 0.7525189;
        Ki[12] = 0.784955;
        Ki[13] = 0.8152731;
        Ki[14] = 0.8437826;
        Ki[15] = 0.3514916;
        Ki[16] = 0.4186954;
        Ki[17] = 0.4533894;
        Ki[18] = 0.3825868;
        Ki[19] = 0.4618263;
        Ki[20] = 0.3589888;
        Ki[21] = 0.4216551;
        this.Gi[2] = 0.027815;
        this.Gi[3] = 0.189065;
        this.Gi[4] = 0.0793;
        this.Gi[5] = 0.141239;
        this.Gi[6] = 0.256692;
        this.Gi[7] = 0.281835;
        this.Gi[8] = 0.332267;
        this.Gi[9] = 0.366911;
        this.Gi[10] = 0.289731;
        this.Gi[11] = 0.337542;
        this.Gi[12] = 0.383381;
        this.Gi[13] = 0.427354;
        this.Gi[14] = 0.469659;
        this.Gi[15] = 0.034369;
        this.Gi[16] = 0.021;
        this.Gi[17] = 0.038953;
        this.Gi[18] = 0.3325;
        this.Gi[19] = 0.0885;
        this.Qi[3] = 0.69;
        this.Qi[18] = 1.06775;
        this.Qi[19] = 0.633276;
        this.Fi[15] = 1.0;
        Si[18] = 1.5822;
        Si[19] = 0.39;
        Wi[18] = 1.0;
        Eij[1][2] = 0.97164;
        Eij[1][3] = 0.960644;
        Eij[1][5] = 0.994635;
        Eij[1][6] = 1.01953;
        Eij[1][7] = 0.989844;
        Eij[1][8] = 1.00235;
        Eij[1][9] = 0.999268;
        Eij[1][10] = 1.107274;
        Eij[1][11] = 0.88088;
        Eij[1][12] = 0.880973;
        Eij[1][13] = 0.881067;
        Eij[1][14] = 0.881161;
        Eij[1][15] = 1.17052;
        Eij[1][17] = 0.990126;
        Eij[1][18] = 0.708218;
        Eij[1][19] = 0.931484;
        Eij[2][3] = 1.02274;
        Eij[2][4] = 0.97012;
        Eij[2][5] = 0.945939;
        Eij[2][6] = 0.946914;
        Eij[2][7] = 0.973384;
        Eij[2][8] = 0.95934;
        Eij[2][9] = 0.94552;
        Eij[2][15] = 1.08632;
        Eij[2][16] = 1.021;
        Eij[2][17] = 1.00571;
        Eij[2][18] = 0.746954;
        Eij[2][19] = 0.902271;
        Eij[3][4] = 0.925053;
        Eij[3][5] = 0.960237;
        Eij[3][6] = 0.906849;
        Eij[3][7] = 0.897362;
        Eij[3][8] = 0.726255;
        Eij[3][9] = 0.859764;
        Eij[3][10] = 0.855134;
        Eij[3][11] = 0.831229;
        Eij[3][12] = 0.80831;
        Eij[3][13] = 0.786323;
        Eij[3][14] = 0.765171;
        Eij[3][15] = 1.28179;
        Eij[3][17] = 1.5;
        Eij[3][18] = 0.849408;
        Eij[3][19] = 0.955052;
        Eij[4][5] = 1.02256;
        Eij[4][7] = 1.01306;
        Eij[4][9] = 1.00532;
        Eij[4][15] = 1.16446;
        Eij[4][18] = 0.693168;
        Eij[4][19] = 0.946871;
        Eij[5][7] = 1.0049;
        Eij[5][15] = 1.034787;
        Eij[6][15] = 1.3;
        Eij[7][15] = 1.3;
        Eij[10][19] = 1.008692;
        Eij[11][19] = 1.010126;
        Eij[12][19] = 1.011501;
        Eij[13][19] = 1.012821;
        Eij[14][19] = 1.014089;
        Eij[15][17] = 1.1;
        Uij[1][2] = 0.886106;
        Uij[1][3] = 0.963827;
        Uij[1][5] = 0.990877;
        Uij[1][7] = 0.992291;
        Uij[1][9] = 1.00367;
        Uij[1][10] = 1.302576;
        Uij[1][11] = 1.191904;
        Uij[1][12] = 1.205769;
        Uij[1][13] = 1.219634;
        Uij[1][14] = 1.233498;
        Uij[1][15] = 1.15639;
        Uij[1][19] = 0.736833;
        Uij[2][3] = 0.835058;
        Uij[2][4] = 0.816431;
        Uij[2][5] = 0.915502;
        Uij[2][7] = 0.993556;
        Uij[2][15] = 0.408838;
        Uij[2][19] = 0.993476;
        Uij[3][4] = 0.96987;
        Uij[3][10] = 1.066638;
        Uij[3][11] = 1.077634;
        Uij[3][12] = 1.088178;
        Uij[3][13] = 1.098291;
        Uij[3][14] = 1.108021;
        Uij[3][17] = 0.9;
        Uij[3][19] = 1.04529;
        Uij[4][5] = 1.065173;
        Uij[4][6] = 1.25;
        Uij[4][7] = 1.25;
        Uij[4][8] = 1.25;
        Uij[4][9] = 1.25;
        Uij[4][15] = 1.61666;
        Uij[4][19] = 0.971926;
        Uij[10][19] = 1.028973;
        Uij[11][19] = 1.033754;
        Uij[12][19] = 1.038338;
        Uij[13][19] = 1.042735;
        Uij[14][19] = 1.046966;
        Kij[1][2] = 1.00363;
        Kij[1][3] = 0.995933;
        Kij[1][5] = 1.007619;
        Kij[1][7] = 0.997596;
        Kij[1][9] = 1.002529;
        Kij[1][10] = 0.982962;
        Kij[1][11] = 0.983565;
        Kij[1][12] = 0.982707;
        Kij[1][13] = 0.981849;
        Kij[1][14] = 0.980991;
        Kij[1][15] = 1.02326;
        Kij[1][19] = 1.00008;
        Kij[2][3] = 0.982361;
        Kij[2][4] = 1.00796;
        Kij[2][15] = 1.03227;
        Kij[2][19] = 0.942596;
        Kij[3][4] = 1.00851;
        Kij[3][10] = 0.910183;
        Kij[3][11] = 0.895362;
        Kij[3][12] = 0.881152;
        Kij[3][13] = 0.86752;
        Kij[3][14] = 0.854406;
        Kij[3][19] = 1.00779;
        Kij[4][5] = 0.986893;
        Kij[4][15] = 1.02034;
        Kij[4][19] = 0.999969;
        Kij[10][19] = 0.96813;
        Kij[11][19] = 0.96287;
        Kij[12][19] = 0.957828;
        Kij[13][19] = 0.952441;
        Kij[14][19] = 0.948338;
        Gij[1][3] = 0.807653;
        Gij[1][15] = 1.95731;
        Gij[2][3] = 0.982746;
        Gij[3][4] = 0.370296;
        Gij[3][18] = 1.67309;
        this.n0i[1][3] = 4.00088;
        this.n0i[1][4] = 0.76315;
        this.n0i[1][5] = 0.0046;
        this.n0i[1][6] = 8.74432;
        this.n0i[1][7] = -4.46921;
        this.n0i[1][1] = 29.83843397;
        this.n0i[1][2] = -15999.69151;
        this.n0i[2][3] = 3.50031;
        this.n0i[2][4] = 0.13732;
        this.n0i[2][5] = -0.1466;
        this.n0i[2][6] = 0.90066;
        this.n0i[2][7] = 0.0;
        this.n0i[2][1] = 17.56770785;
        this.n0i[2][2] = -2801.729072;
        this.n0i[3][3] = 3.50002;
        this.n0i[3][4] = 2.04452;
        this.n0i[3][5] = -1.06044;
        this.n0i[3][6] = 2.03366;
        this.n0i[3][7] = 0.01393;
        this.n0i[3][1] = 20.65844696;
        this.n0i[3][2] = -4902.171516;
        this.n0i[4][3] = 4.00263;
        this.n0i[4][4] = 4.33939;
        this.n0i[4][5] = 1.23722;
        this.n0i[4][6] = 13.1974;
        this.n0i[4][7] = -6.01989;
        this.n0i[4][1] = 36.73005938;
        this.n0i[4][2] = -23639.65301;
        this.n0i[5][3] = 4.02939;
        this.n0i[5][4] = 6.60569;
        this.n0i[5][5] = 3.197;
        this.n0i[5][6] = 19.1921;
        this.n0i[5][7] = -8.37267;
        this.n0i[5][1] = 44.70909619;
        this.n0i[5][2] = -31236.63551;
        this.n0i[6][3] = 4.06714;
        this.n0i[6][4] = 8.97575;
        this.n0i[6][5] = 5.25156;
        this.n0i[6][6] = 25.1423;
        this.n0i[6][7] = 16.1388;
        this.n0i[6][1] = 34.30180349;
        this.n0i[6][2] = -38525.50276;
        this.n0i[7][3] = 4.33944;
        this.n0i[7][4] = 9.44893;
        this.n0i[7][5] = 6.89406;
        this.n0i[7][6] = 24.4618;
        this.n0i[7][7] = 14.7824;
        this.n0i[7][1] = 36.53237783;
        this.n0i[7][2] = -38957.80933;
        this.n0i[8][3] = 4.0;
        this.n0i[8][4] = 11.7618;
        this.n0i[8][5] = 20.1101;
        this.n0i[8][6] = 33.1688;
        this.n0i[8][7] = 0.0;
        this.n0i[8][1] = 43.17218626;
        this.n0i[8][2] = -51198.30946;
        this.n0i[9][3] = 4.0;
        this.n0i[9][4] = 8.95043;
        this.n0i[9][5] = 21.836;
        this.n0i[9][6] = 33.4032;
        this.n0i[9][7] = 0.0;
        this.n0i[9][1] = 42.67837089;
        this.n0i[9][2] = -45215.83;
        this.n0i[10][3] = 4.0;
        this.n0i[10][4] = 11.6977;
        this.n0i[10][5] = 26.8142;
        this.n0i[10][6] = 38.6164;
        this.n0i[10][7] = 0.0;
        this.n0i[10][1] = 46.99717188;
        this.n0i[10][2] = -52746.83318;
        this.n0i[11][3] = 4.0;
        this.n0i[11][4] = 13.7266;
        this.n0i[11][5] = 30.4707;
        this.n0i[11][6] = 43.5561;
        this.n0i[11][7] = 0.0;
        this.n0i[11][1] = 52.07631631;
        this.n0i[11][2] = -57104.81056;
        this.n0i[12][3] = 4.0;
        this.n0i[12][4] = 15.6865;
        this.n0i[12][5] = 33.8029;
        this.n0i[12][6] = 48.1731;
        this.n0i[12][7] = 0.0;
        this.n0i[12][1] = 57.25830934;
        this.n0i[12][2] = -60546.76385;
        this.n0i[13][3] = 4.0;
        this.n0i[13][4] = 18.0241;
        this.n0i[13][5] = 38.1235;
        this.n0i[13][6] = 53.3415;
        this.n0i[13][7] = 0.0;
        this.n0i[13][1] = 62.09646901;
        this.n0i[13][2] = -66600.12837;
        this.n0i[14][3] = 4.0;
        this.n0i[14][4] = 21.0069;
        this.n0i[14][5] = 43.4931;
        this.n0i[14][6] = 58.3657;
        this.n0i[14][7] = 0.0;
        this.n0i[14][1] = 65.93909154;
        this.n0i[14][2] = -74131.45483;
        this.n0i[15][3] = 2.47906;
        this.n0i[15][4] = 0.95806;
        this.n0i[15][5] = 0.45444;
        this.n0i[15][6] = 1.56039;
        this.n0i[15][7] = -1.3756;
        this.n0i[15][1] = 13.07520288;
        this.n0i[15][2] = -5836.943696;
        this.n0i[16][3] = 3.50146;
        this.n0i[16][4] = 1.07558;
        this.n0i[16][5] = 1.01334;
        this.n0i[16][6] = 0.0;
        this.n0i[16][7] = 0.0;
        this.n0i[16][1] = 16.8017173;
        this.n0i[16][2] = -2318.32269;
        this.n0i[17][3] = 3.50055;
        this.n0i[17][4] = 1.02865;
        this.n0i[17][5] = 0.00493;
        this.n0i[17][6] = 0.0;
        this.n0i[17][7] = 0.0;
        this.n0i[17][1] = 17.45786899;
        this.n0i[17][2] = -2635.244116;
        this.n0i[18][3] = 4.00392;
        this.n0i[18][4] = 0.01059;
        this.n0i[18][5] = 0.98763;
        this.n0i[18][6] = 3.06904;
        this.n0i[18][7] = 0.0;
        this.n0i[18][1] = 21.57882705;
        this.n0i[18][2] = -7766.733078;
        this.n0i[19][3] = 4.0;
        this.n0i[19][4] = 3.11942;
        this.n0i[19][5] = 1.00243;
        this.n0i[19][6] = 0.0;
        this.n0i[19][7] = 0.0;
        this.n0i[19][1] = 21.5830944;
        this.n0i[19][2] = -6069.035869;
        this.n0i[20][3] = 2.5;
        this.n0i[20][4] = 0.0;
        this.n0i[20][5] = 0.0;
        this.n0i[20][6] = 0.0;
        this.n0i[20][7] = 0.0;
        this.n0i[20][1] = 10.04639507;
        this.n0i[20][2] = -745.375;
        this.n0i[21][3] = 2.5;
        this.n0i[21][4] = 0.0;
        this.n0i[21][5] = 0.0;
        this.n0i[21][6] = 0.0;
        this.n0i[21][7] = 0.0;
        this.n0i[21][1] = 10.04639507;
        this.n0i[21][2] = -745.375;
        this.th0i[1][4] = 820.659;
        this.th0i[1][5] = 178.41;
        this.th0i[1][6] = 1062.82;
        this.th0i[1][7] = 1090.53;
        this.th0i[2][4] = 662.738;
        this.th0i[2][5] = 680.562;
        this.th0i[2][6] = 1740.06;
        this.th0i[2][7] = 0.0;
        this.th0i[3][4] = 919.306;
        this.th0i[3][5] = 865.07;
        this.th0i[3][6] = 483.553;
        this.th0i[3][7] = 341.109;
        this.th0i[4][4] = 559.314;
        this.th0i[4][5] = 223.284;
        this.th0i[4][6] = 1031.38;
        this.th0i[4][7] = 1071.29;
        this.th0i[5][4] = 479.856;
        this.th0i[5][5] = 200.893;
        this.th0i[5][6] = 955.312;
        this.th0i[5][7] = 1027.29;
        this.th0i[6][4] = 438.27;
        this.th0i[6][5] = 198.018;
        this.th0i[6][6] = 1905.02;
        this.th0i[6][7] = 893.765;
        this.th0i[7][4] = 468.27;
        this.th0i[7][5] = 183.636;
        this.th0i[7][6] = 1914.1;
        this.th0i[7][7] = 903.185;
        this.th0i[8][4] = 292.503;
        this.th0i[8][5] = 910.237;
        this.th0i[8][6] = 1919.37;
        this.th0i[8][7] = 0.0;
        this.th0i[9][4] = 178.67;
        this.th0i[9][5] = 840.538;
        this.th0i[9][6] = 1774.25;
        this.th0i[9][7] = 0.0;
        this.th0i[10][4] = 182.326;
        this.th0i[10][5] = 859.207;
        this.th0i[10][6] = 1826.59;
        this.th0i[10][7] = 0.0;
        this.th0i[11][4] = 169.789;
        this.th0i[11][5] = 836.195;
        this.th0i[11][6] = 1760.46;
        this.th0i[11][7] = 0.0;
        this.th0i[12][4] = 158.922;
        this.th0i[12][5] = 815.064;
        this.th0i[12][6] = 1693.07;
        this.th0i[12][7] = 0.0;
        this.th0i[13][4] = 156.854;
        this.th0i[13][5] = 814.882;
        this.th0i[13][6] = 1693.79;
        this.th0i[13][7] = 0.0;
        this.th0i[14][4] = 164.947;
        this.th0i[14][5] = 836.264;
        this.th0i[14][6] = 1750.24;
        this.th0i[14][7] = 0.0;
        this.th0i[15][4] = 228.734;
        this.th0i[15][5] = 326.843;
        this.th0i[15][6] = 1651.71;
        this.th0i[15][7] = 1671.69;
        this.th0i[16][4] = 2235.71;
        this.th0i[16][5] = 1116.69;
        this.th0i[16][6] = 0.0;
        this.th0i[16][7] = 0.0;
        this.th0i[17][4] = 1550.45;
        this.th0i[17][5] = 704.525;
        this.th0i[17][6] = 0.0;
        this.th0i[17][7] = 0.0;
        this.th0i[18][4] = 268.795;
        this.th0i[18][5] = 1141.41;
        this.th0i[18][6] = 2507.37;
        this.th0i[18][7] = 0.0;
        this.th0i[19][4] = 1833.63;
        this.th0i[19][5] = 847.181;
        this.th0i[19][6] = 0.0;
        this.th0i[19][7] = 0.0;
        this.th0i[20][4] = 0.0;
        this.th0i[20][5] = 0.0;
        this.th0i[20][6] = 0.0;
        this.th0i[20][7] = 0.0;
        this.th0i[21][4] = 0.0;
        this.th0i[21][5] = 0.0;
        this.th0i[21][6] = 0.0;
        this.th0i[21][7] = 0.0;
        for (i = 1; i <= this.MaxFlds; ++i) {
            this.Ki25[i] = Math.pow(Ki[i], 2.5);
            this.Ei25[i] = Math.pow(Ei[i], 2.5);
        }
        for (i = 1; i <= this.MaxFlds; ++i) {
            for (j = i; j <= this.MaxFlds; ++j) {
                for (int n = 1; n <= 18; ++n) {
                    double Bsnij = 1.0;
                    if (this.gn[n] == 1) {
                        Bsnij = Gij[i][j] * (this.Gi[i] + this.Gi[j]) / 2.0;
                    }
                    if (this.qn[n] == 1) {
                        Bsnij = Bsnij * this.Qi[i] * this.Qi[j];
                    }
                    if (this.fn[n] == 1) {
                        Bsnij = Bsnij * this.Fi[i] * this.Fi[j];
                    }
                    if (sn[n] == 1) {
                        Bsnij = Bsnij * Si[i] * Si[j];
                    }
                    if (wn[n] == 1) {
                        Bsnij = Bsnij * Wi[i] * Wi[j];
                    }
                    this.Bsnij2[i][j][n] = this.an[n] * Math.pow(Eij[i][j] * Math.sqrt(Ei[i] * Ei[j]), this.un[n]) * Math.pow(Ki[i] * Ki[j], 1.5) * Bsnij;
                }
                this.Kij5[i][j] = (Math.pow(Kij[i][j], 5.0) - 1.0) * this.Ki25[i] * this.Ki25[j];
                this.Uij5[i][j] = (Math.pow(Uij[i][j], 5.0) - 1.0) * this.Ei25[i] * this.Ei25[j];
                this.Gij5[i][j] = (Gij[i][j] - 1.0) * (this.Gi[i] + this.Gi[j]) / 2.0;
            }
        }
        double d0 = 101.325 / this.RDetail / 298.15;
        for (i = 1; i <= this.MaxFlds; ++i) {
            this.n0i[i][3] = this.n0i[i][3] - 1.0;
            this.n0i[i][1] = this.n0i[i][1] - Math.log(d0);
        }
    }

    public static void main(String[] args) {
        DETAIL test = new DETAIL();
        test.SetupDetail();
        double T = 400.0;
        doubleW D = new doubleW(0.0);
        doubleW P = new doubleW(50000.0);
        intW ierr = new intW(0);
        doubleW Mm = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        boolean iFlag = false;
        StringW herr = new StringW("");
        double[] x = new double[]{0.0, 0.77824, 0.02, 0.06, 0.08, 0.03, 0.0015, 0.003, 5.0E-4, 0.00165, 0.00215, 8.8E-4, 2.4E-4, 1.5E-4, 9.0E-5, 0.004, 0.005, 0.002, 1.0E-4, 0.0025, 0.007, 0.001};
        test.MolarMassDetail(x, Mm);
        System.out.println("mol mass " + Mm.val);
        test.DensityDetail(T, P.val, x, D, ierr, herr);
        System.out.println("density " + D.val);
        test.PressureDetail(T, D.val, x, P, Z);
        System.out.println("pressure " + P.val);
        System.out.println("Z " + Z.val);
        doubleW dPdD = new doubleW(0.0);
        doubleW d2PdD2 = new doubleW(0.0);
        doubleW d2PdTD = new doubleW(0.0);
        doubleW dPdT = new doubleW(0.0);
        doubleW U = new doubleW(0.0);
        doubleW H = new doubleW(0.0);
        doubleW S = new doubleW(0.0);
        doubleW A = new doubleW(0.0);
        doubleW P2 = new doubleW(0.0);
        doubleW Cv = new doubleW(0.0);
        doubleW Cp = new doubleW(0.0);
        doubleW W = new doubleW(0.0);
        doubleW G = new doubleW(0.0);
        doubleW JT = new doubleW(0.0);
        doubleW Kappa = new doubleW(0.0);
        doubleW PP = new doubleW(0.0);
        test.PropertiesDetail(T, D.val, x, P, Z, dPdD, d2PdD2, d2PdTD, dPdT, U, H, S, Cv, Cp, W, G, JT, Kappa);
        System.out.println("JT " + JT.val);
        System.out.println("Kappa " + Kappa.val);
    }
}

