/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.gerg;

import org.netlib.util.StringW;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class GERG2008 {
    double RGERG;
    int NcGERG = 21;
    int MaxFlds = 21;
    int MaxMdl = 10;
    int MaxTrmM = 12;
    int MaxTrmP = 24;
    double epsilon = 1.0E-15;
    int[][] intcoik = new int[this.MaxFlds + 1][this.MaxTrmP + 1];
    int[][] coik = new int[this.MaxFlds + 1][this.MaxTrmP + 1];
    int[][] doik = new int[this.MaxFlds + 1][this.MaxTrmP + 1];
    int[][] dijk = new int[this.MaxMdl + 1][this.MaxTrmM + 1];
    double Drold;
    double Trold;
    double Told;
    double Trold2;
    double[] xold = new double[this.MaxFlds + 1];
    int[][] mNumb = new int[this.MaxFlds + 1][this.MaxFlds + 1];
    int[] kpol = new int[this.MaxFlds + 1];
    int[] kexp = new int[this.MaxFlds + 1];
    int[] kpolij = new int[this.MaxMdl + 1];
    int[] kexpij = new int[this.MaxMdl + 1];
    double[] Dc = new double[this.MaxFlds + 1];
    double[] Tc = new double[this.MaxFlds + 1];
    double[] MMiGERG = new double[this.MaxFlds + 1];
    double[] Vc3 = new double[this.MaxFlds + 1];
    double[] Tc2 = new double[this.MaxFlds + 1];
    double[][] noik = new double[this.MaxFlds + 1][this.MaxTrmP + 1];
    double[][] toik = new double[this.MaxFlds + 1][this.MaxTrmP + 1];
    double[][] cijk = new double[this.MaxMdl + 1][this.MaxTrmM + 1];
    double[][] eijk = new double[this.MaxMdl + 1][this.MaxTrmM + 1];
    double[][] gijk = new double[this.MaxMdl + 1][this.MaxTrmM + 1];
    double[][] nijk = new double[this.MaxMdl + 1][this.MaxTrmM + 1];
    double[][] tijk = new double[this.MaxMdl + 1][this.MaxTrmM + 1];
    double[][] btij = new double[this.MaxFlds + 1][this.MaxFlds + 1];
    double[][] bvij = new double[this.MaxFlds + 1][this.MaxFlds + 1];
    double[][] gtij = new double[this.MaxFlds + 1][this.MaxFlds + 1];
    double[][] gvij = new double[this.MaxFlds + 1][this.MaxFlds + 1];
    double[][] fij = new double[this.MaxFlds + 1][this.MaxFlds + 1];
    double[][] th0i = new double[this.MaxFlds + 1][8];
    double[][] n0i = new double[this.MaxFlds + 1][8];
    double[][] taup = new double[this.MaxFlds + 1][this.MaxTrmP + 1];
    double[][] taupijk = new double[this.MaxFlds + 1][this.MaxTrmM + 1];
    double dPdDsave;

    public void MolarMassGERG(double[] x, doubleW Mm) {
        Mm.val = 0.0;
        for (int i = 1; i <= this.NcGERG; ++i) {
            Mm.val += x[i] * this.MMiGERG[i];
        }
    }

    public void PressureGERG(double T, double D, double[] x, doubleW P, doubleW Z) {
        doubleW[][] ar = new doubleW[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ar[i][j] = new doubleW(0.0);
            }
        }
        this.AlpharGERG(0, 0, T, D, x, ar);
        Z.val = 1.0 + ar[0][1].val;
        P.val = D * this.RGERG * T * Z.val;
        this.dPdDsave = this.RGERG * T * (1.0 + 2.0 * ar[0][1].val + ar[0][2].val);
    }

    public void DensityGERG(int iFlag, double T, double P, double[] x, doubleW D, intW ierr, StringW herr) {
        doubleW Tcx = new doubleW(0.0);
        doubleW Dcx = new doubleW(0.0);
        doubleW dPdD = new doubleW(0.0);
        doubleW d2PdD2 = new doubleW(0.0);
        doubleW d2PdTD = new doubleW(0.0);
        doubleW dPdT = new doubleW(0.0);
        doubleW U = new doubleW(0.0);
        doubleW H = new doubleW(0.0);
        doubleW S = new doubleW(0.0);
        doubleW A = new doubleW(0.0);
        doubleW P2 = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        doubleW Cv = new doubleW(0.0);
        doubleW Cp = new doubleW(0.0);
        doubleW W = new doubleW(0.0);
        doubleW G = new doubleW(0.0);
        doubleW JT = new doubleW(0.0);
        doubleW Kappa = new doubleW(0.0);
        doubleW PP = new doubleW(0.0);
        ierr.val = 0;
        herr.val = "";
        int nFail = 0;
        boolean iFail = false;
        if (P < this.epsilon) {
            D.val = 0.0;
            return;
        }
        double tolr = 1.0E-7;
        this.PseudoCriticalPointGERG(x, Tcx, Dcx);
        if (D.val > -this.epsilon) {
            D.val = P / this.RGERG / T;
            if (iFlag == 2) {
                D.val = Dcx.val * 3.0;
            }
        } else {
            D.val = Math.abs(D.val);
        }
        double plog = Math.log(P);
        double vlog = -Math.log(D.val);
        for (int it = 1; it <= 50; ++it) {
            if (vlog < -7.0 || vlog > 100.0 || it == 20 || it == 30 || it == 40 || iFail) {
                iFail = false;
                if (nFail > 2) {
                    ierr.val = 1;
                    herr.val = "Calculation failed to converge in GERG method, ideal gas density returned.";
                    D.val = P / this.RGERG / T;
                }
                if (++nFail == 1) {
                    D.val = Dcx.val * 3.0;
                } else if (nFail == 2) {
                    D.val = Dcx.val * 2.5;
                } else if (nFail == 3) {
                    D.val = Dcx.val * 2.0;
                }
                vlog = -Math.log(D.val);
            }
            D.val = Math.exp(-vlog);
            this.PressureGERG(T, D.val, x, P2, Z);
            if (this.dPdDsave < this.epsilon || P2.val < this.epsilon) {
                double vinc = 0.1;
                if (D.val > Dcx.val) {
                    vinc = -0.1;
                }
                if (it > 5) {
                    vinc /= 2.0;
                }
                if (it > 10 && it < 20) {
                    vinc /= 5.0;
                }
                vlog += vinc;
                continue;
            }
            double dpdlv = -D.val * this.dPdDsave;
            double vdiff = (Math.log(P2.val) - plog) * P2.val / dpdlv;
            vlog += -vdiff;
            if (!(Math.abs(vdiff) < tolr)) continue;
            if (this.dPdDsave < 0.0) {
                iFail = true;
                continue;
            }
            D.val = Math.exp(-vlog);
            if (iFlag > 0) {
                this.PropertiesGERG(T, D.val, x, PP, Z, dPdD, d2PdD2, d2PdTD, dPdT, U, H, S, Cv, Cp, W, G, JT, Kappa, A);
                if (PP.val <= 0.0 || dPdD.val <= 0.0 || d2PdTD.val <= 0.0 || Cv.val <= 0.0 || Cp.val <= 0.0 || W.val <= 0.0) {
                    ierr.val = 1;
                    herr.val = "Calculation failed to converge in GERG method, ideal gas density returned.";
                    D.val = P / this.RGERG / T;
                }
            }
            return;
        }
        ierr.val = 1;
        herr.val = "Calculation failed to converge in GERG method, ideal gas density returned.";
        D.val = P / this.RGERG / T;
    }

    public void PropertiesGERG(double T, double D, double[] x, doubleW P, doubleW Z, doubleW dPdD, doubleW d2PdD2, doubleW d2PdTD, doubleW dPdT, doubleW U, doubleW H, doubleW S, doubleW Cv, doubleW Cp, doubleW W, doubleW G, doubleW JT, doubleW Kappa, doubleW A) {
        doubleW[] a0 = new doubleW[3];
        for (int i = 0; i < 3; ++i) {
            a0[i] = new doubleW(0.0);
        }
        doubleW[][] ar = new doubleW[4][4];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                ar[i][j] = new doubleW(0.0);
            }
        }
        doubleW Mm = new doubleW(0.0);
        this.MolarMassGERG(x, Mm);
        this.Alpha0GERG(T, D, x, a0);
        this.AlpharGERG(1, 0, T, D, x, ar);
        double R = this.RGERG;
        double RT = R * T;
        Z.val = 1.0 + ar[0][1].val;
        P.val = D * RT * Z.val;
        dPdD.val = RT * (1.0 + 2.0 * ar[0][1].val + ar[0][2].val);
        dPdT.val = D * R * (1.0 + ar[0][1].val - ar[1][1].val);
        d2PdTD.val = R * (1.0 + 2.0 * ar[0][1].val + ar[0][2].val - 2.0 * ar[1][1].val - ar[1][2].val);
        A.val = RT * (a0[0].val + ar[0][0].val);
        G.val = RT * (1.0 + ar[0][1].val + a0[0].val + ar[0][0].val);
        U.val = RT * (a0[1].val + ar[1][0].val);
        H.val = RT * (1.0 + ar[0][1].val + a0[1].val + ar[1][0].val);
        S.val = R * (a0[1].val + ar[1][0].val - a0[0].val - ar[0][0].val);
        Cv.val = -R * (a0[2].val + ar[2][0].val);
        if (D > this.epsilon) {
            Cp.val = Cv.val + T * (dPdT.val / D) * (dPdT.val / D) / dPdD.val;
            d2PdD2.val = RT * (2.0 * ar[0][1].val + 4.0 * ar[0][2].val + ar[0][3].val) / D;
            JT.val = (T / D * dPdT.val / dPdD.val - 1.0) / Cp.val / D;
        } else {
            Cp.val = Cv.val + R;
            d2PdD2.val = 0.0;
            JT.val = 1.0E20;
        }
        W.val = 1000.0 * Cp.val / Cv.val * dPdD.val / Mm.val;
        if (W.val < 0.0) {
            W.val = 0.0;
        }
        W.val = Math.sqrt(W.val);
        Kappa.val = Math.pow(W.val, 2.0) * Mm.val / (RT * 1000.0 * Z.val);
    }

    void ReducingParametersGERG(double[] x, doubleW Tr, doubleW Dr) {
        int i;
        boolean icheck = false;
        for (i = 1; i <= this.NcGERG; ++i) {
            if (Math.abs(x[i] - this.xold[i]) > 1.0E-7) {
                icheck = true;
            }
            this.xold[i] = x[i];
        }
        if (!icheck) {
            Dr.val = this.Drold;
            Tr.val = this.Trold;
            return;
        }
        this.Told = 0.0;
        this.Trold2 = 0.0;
        Dr.val = 0.0;
        double Vr = 0.0;
        Tr.val = 0.0;
        for (i = 1; i <= this.NcGERG; ++i) {
            if (!(x[i] > this.epsilon)) continue;
            double F = 1.0;
            for (int j = i; j <= this.NcGERG; ++j) {
                if (!(x[j] > this.epsilon)) continue;
                double xij = F * (x[i] * x[j]) * (x[i] + x[j]);
                Vr += xij * this.gvij[i][j] / (this.bvij[i][j] * x[i] + x[j]);
                Tr.val += xij * this.gtij[i][j] / (this.btij[i][j] * x[i] + x[j]);
                F = 2.0;
            }
        }
        if (Vr > this.epsilon) {
            Dr.val = 1.0 / Vr;
        }
        this.Drold = Dr.val;
        this.Trold = Tr.val;
    }

    void Alpha0GERG(double T, double D, double[] x, doubleW[] a0) {
        a0[0].val = 0.0;
        a0[1].val = 0.0;
        a0[2].val = 0.0;
        double LogD = D > this.epsilon ? Math.log(D) : Math.log(this.epsilon);
        double LogT = Math.log(T);
        for (int i = 1; i <= this.NcGERG; ++i) {
            if (!(x[i] > this.epsilon)) continue;
            double LogxD = LogD + Math.log(x[i]);
            double SumHyp0 = 0.0;
            double SumHyp1 = 0.0;
            double SumHyp2 = 0.0;
            for (int j = 4; j <= 7; ++j) {
                double LogHyp;
                if (!(this.th0i[i][j] > this.epsilon)) continue;
                double th0T = this.th0i[i][j] / T;
                double ep = Math.exp(th0T);
                double em = 1.0 / ep;
                double hsn = (ep - em) / 2.0;
                double hcn = (ep + em) / 2.0;
                if (j == 4 || j == 6) {
                    LogHyp = Math.log(Math.abs(hsn));
                    SumHyp0 += this.n0i[i][j] * LogHyp;
                    SumHyp1 += this.n0i[i][j] * th0T * hcn / hsn;
                    SumHyp2 += this.n0i[i][j] * (th0T / hsn) * (th0T / hsn);
                    continue;
                }
                LogHyp = Math.log(Math.abs(hcn));
                SumHyp0 -= this.n0i[i][j] * LogHyp;
                SumHyp1 -= this.n0i[i][j] * th0T * hsn / hcn;
                SumHyp2 += this.n0i[i][j] * (th0T / hcn) * (th0T / hcn);
            }
            a0[0].val += x[i] * (LogxD + this.n0i[i][1] + this.n0i[i][2] / T - this.n0i[i][3] * LogT + SumHyp0);
            a0[1].val += x[i] * (this.n0i[i][3] + this.n0i[i][2] / T + SumHyp1);
            a0[2].val += -x[i] * (this.n0i[i][3] + SumHyp2);
        }
    }

    void AlpharGERG(int itau, int idelta, double T, double D, double[] x, doubleW[][] ar) {
        double ex2;
        double ex;
        double ndtt;
        double ndtd;
        double ndt;
        int j;
        int i;
        doubleW Tr = new doubleW(0.0);
        doubleW Dr = new doubleW(0.0);
        double[] delp = new double[8];
        double[] Expd = new double[8];
        for (i = 0; i <= 3; ++i) {
            for (j = 0; j <= 3; ++j) {
                ar[i][j].val = 0.0;
            }
        }
        this.ReducingParametersGERG(x, Tr, Dr);
        double del = D / Dr.val;
        double tau = Tr.val / T;
        double lntau = Math.log(tau);
        delp[1] = del;
        Expd[1] = Math.exp(-delp[1]);
        for (i = 2; i <= 7; ++i) {
            delp[i] = delp[i - 1] * del;
            Expd[i] = Math.exp(-delp[i]);
        }
        if (Math.abs(T - this.Told) > 1.0E-7 || Math.abs(Tr.val - this.Trold2) > 1.0E-7) {
            this.tTermsGERG(lntau, x);
        }
        this.Told = T;
        this.Trold2 = Tr.val;
        for (i = 1; i <= this.NcGERG; ++i) {
            int k;
            if (!(x[i] > this.epsilon)) continue;
            for (k = 1; k <= this.kpol[i]; ++k) {
                ndt = x[i] * delp[this.doik[i][k]] * this.taup[i][k];
                ndtd = ndt * (double)this.doik[i][k];
                ar[0][1].val += ndtd;
                ar[0][2].val += ndtd * (double)(this.doik[i][k] - 1);
                if (itau <= 0) continue;
                ndtt = ndt * this.toik[i][k];
                ar[0][0].val += ndt;
                ar[1][0].val += ndtt;
                ar[2][0].val += ndtt * (this.toik[i][k] - 1.0);
                ar[1][1].val += ndtt * (double)this.doik[i][k];
                ar[1][2].val += ndtt * (double)this.doik[i][k] * (double)(this.doik[i][k] - 1);
                ar[0][3].val += ndtd * (double)(this.doik[i][k] - 1) * (double)(this.doik[i][k] - 2);
            }
            for (k = 1 + this.kpol[i]; k <= this.kpol[i] + this.kexp[i]; ++k) {
                ndt = x[i] * delp[this.doik[i][k]] * this.taup[i][k] * Expd[this.coik[i][k]];
                ex = (double)this.coik[i][k] * delp[this.coik[i][k]];
                ex2 = (double)this.doik[i][k] - ex;
                double ex3 = ex2 * (ex2 - 1.0);
                ar[0][1].val += ndt * ex2;
                ar[0][2].val += ndt * (ex3 - (double)this.coik[i][k] * ex);
                if (itau <= 0) continue;
                ndtt = ndt * this.toik[i][k];
                ar[0][0].val += ndt;
                ar[1][0].val += ndtt;
                ar[2][0].val += ndtt * (this.toik[i][k] - 1.0);
                ar[1][1].val += ndtt * ex2;
                ar[1][2].val += ndtt * (ex3 - (double)this.coik[i][k] * ex);
                ar[0][3].val += ndt * (ex3 * (ex2 - 2.0) - ex * (3.0 * ex2 - 3.0 + (double)this.coik[i][k]) * (double)this.coik[i][k]);
            }
        }
        for (i = 1; i <= this.NcGERG - 1; ++i) {
            if (!(x[i] > this.epsilon)) continue;
            for (j = i + 1; j <= this.NcGERG; ++j) {
                int k;
                int mn;
                if (!(x[j] > this.epsilon) || (mn = this.mNumb[i][j]) < 0) continue;
                double xijf = x[i] * x[j] * this.fij[i][j];
                for (k = 1; k <= this.kpolij[mn]; ++k) {
                    ndt = xijf * delp[this.dijk[mn][k]] * this.taupijk[mn][k];
                    ndtd = ndt * (double)this.dijk[mn][k];
                    ar[0][1].val += ndtd;
                    ar[0][2].val += ndtd * (double)(this.dijk[mn][k] - 1);
                    if (itau <= 0) continue;
                    ndtt = ndt * this.tijk[mn][k];
                    ar[0][0].val += ndt;
                    ar[1][0].val += ndtt;
                    ar[2][0].val += ndtt * (this.tijk[mn][k] - 1.0);
                    ar[1][1].val += ndtt * (double)this.dijk[mn][k];
                    ar[1][2].val += ndtt * (double)this.dijk[mn][k] * (double)(this.dijk[mn][k] - 1);
                    ar[0][3].val += ndtd * (double)(this.dijk[mn][k] - 1) * (double)(this.dijk[mn][k] - 2);
                }
                for (k = 1 + this.kpolij[mn]; k <= this.kpolij[mn] + this.kexpij[mn]; ++k) {
                    double cij0 = this.cijk[mn][k] * delp[2];
                    double eij0 = this.eijk[mn][k] * del;
                    ndt = xijf * this.nijk[mn][k] * delp[this.dijk[mn][k]] * Math.exp(cij0 + eij0 + this.gijk[mn][k] + this.tijk[mn][k] * lntau);
                    ex = (double)this.dijk[mn][k] + 2.0 * cij0 + eij0;
                    ex2 = ex * ex - (double)this.dijk[mn][k] + 2.0 * cij0;
                    ar[0][1].val += ndt * ex;
                    ar[0][2].val += ndt * ex2;
                    if (itau <= 0) continue;
                    ndtt = ndt * this.tijk[mn][k];
                    ar[0][0].val += ndt;
                    ar[1][0].val += ndtt;
                    ar[2][0].val += ndtt * (this.tijk[mn][k] - 1.0);
                    ar[1][1].val += ndtt * ex;
                    ar[1][2].val += ndtt * ex2;
                    ar[0][3].val += ndt * (ex * (ex2 - 2.0 * ((double)this.dijk[mn][k] - 2.0 * cij0)) + (double)(2 * this.dijk[mn][k]));
                }
            }
        }
    }

    void tTermsGERG(double lntau, double[] x) {
        int k;
        double[] taup0 = new double[13];
        int i = 5;
        for (k = 1; k <= this.kpol[i] + this.kexp[i]; ++k) {
            taup0[k] = Math.exp(this.toik[i][k] * lntau);
        }
        for (i = 1; i <= this.NcGERG; ++i) {
            if (!(x[i] > this.epsilon)) continue;
            if (i > 4 && i != 15 && i != 18 && i != 20) {
                for (k = 1; k <= this.kpol[i] + this.kexp[i]; ++k) {
                    this.taup[i][k] = this.noik[i][k] * taup0[k];
                }
                continue;
            }
            for (k = 1; k <= this.kpol[i] + this.kexp[i]; ++k) {
                this.taup[i][k] = this.noik[i][k] * Math.exp(this.toik[i][k] * lntau);
            }
        }
        for (i = 1; i <= this.NcGERG - 1; ++i) {
            if (!(x[i] > this.epsilon)) continue;
            for (int j = i + 1; j <= this.NcGERG; ++j) {
                int mn;
                if (!(x[j] > this.epsilon) || (mn = this.mNumb[i][j]) < 0) continue;
                for (int k2 = 1; k2 <= this.kpolij[mn]; ++k2) {
                    this.taupijk[mn][k2] = this.nijk[mn][k2] * Math.exp(this.tijk[mn][k2] * lntau);
                }
            }
        }
    }

    void PseudoCriticalPointGERG(double[] x, doubleW Tcx, doubleW Dcx) {
        Tcx.val = 0.0;
        double Vcx = 0.0;
        Dcx.val = 0.0;
        for (int i = 1; i <= this.NcGERG; ++i) {
            Tcx.val += x[i] * this.Tc[i];
            Vcx += x[i] / this.Dc[i];
        }
        if (Vcx > this.epsilon) {
            Dcx.val = 1.0 / Vcx;
        }
    }

    /*
     * Opcode count of 15839 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    public void SetupGERG() {
        int j;
        int i;
        double[][] bijk = new double[this.MaxMdl + 1][this.MaxTrmM + 1];
        this.RGERG = 8.314472;
        double Rs = 8.31451;
        double Rsr = Rs / this.RGERG;
        double o13 = 0.3333333333333333;
        for (i = 1; i <= this.MaxFlds; ++i) {
            this.xold[i] = 0.0;
        }
        this.Told = 0.0;
        this.MMiGERG[1] = 16.04246;
        this.MMiGERG[2] = 28.0134;
        this.MMiGERG[3] = 44.0095;
        this.MMiGERG[4] = 30.06904;
        this.MMiGERG[5] = 44.09562;
        this.MMiGERG[6] = 58.1222;
        this.MMiGERG[7] = 58.1222;
        this.MMiGERG[8] = 72.14878;
        this.MMiGERG[9] = 72.14878;
        this.MMiGERG[10] = 86.17536;
        this.MMiGERG[11] = 100.20194;
        this.MMiGERG[12] = 114.22852;
        this.MMiGERG[13] = 128.2551;
        this.MMiGERG[14] = 142.28168;
        this.MMiGERG[15] = 2.01588;
        this.MMiGERG[16] = 31.9988;
        this.MMiGERG[17] = 28.0101;
        this.MMiGERG[18] = 18.01528;
        this.MMiGERG[19] = 34.08088;
        this.MMiGERG[20] = 4.002602;
        this.MMiGERG[21] = 39.948;
        for (i = 1; i <= this.MaxFlds; ++i) {
            this.kpol[i] = 6;
            this.kexp[i] = 6;
        }
        this.kexp[1] = 18;
        this.kexp[2] = 18;
        this.kexp[4] = 18;
        this.kpol[3] = 4;
        this.kexp[3] = 18;
        this.kpol[15] = 5;
        this.kexp[15] = 9;
        this.kpol[18] = 7;
        this.kexp[18] = 9;
        this.kpol[20] = 4;
        this.kexp[20] = 8;
        this.kpolij[1] = 2;
        this.kexpij[1] = 10;
        this.kpolij[2] = 5;
        this.kexpij[2] = 4;
        this.kpolij[3] = 2;
        this.kexpij[3] = 7;
        this.kpolij[4] = 3;
        this.kexpij[4] = 3;
        this.kpolij[5] = 2;
        this.kexpij[5] = 4;
        this.kpolij[6] = 3;
        this.kexpij[6] = 3;
        this.kpolij[7] = 4;
        this.kexpij[7] = 0;
        this.kpolij[10] = 10;
        this.kexpij[10] = 0;
        this.Dc[1] = 10.139342719;
        this.Dc[2] = 11.1839;
        this.Dc[3] = 10.624978698;
        this.Dc[4] = 6.87085454;
        this.Dc[5] = 5.000043088;
        this.Dc[6] = 3.86014294;
        this.Dc[7] = 3.920016792;
        this.Dc[8] = 3.271;
        this.Dc[9] = 3.215577588;
        this.Dc[10] = 2.705877875;
        this.Dc[11] = 2.315324434;
        this.Dc[12] = 2.056404127;
        this.Dc[13] = 1.81;
        this.Dc[14] = 1.64;
        this.Dc[15] = 14.94;
        this.Dc[16] = 13.63;
        this.Dc[17] = 10.85;
        this.Dc[18] = 17.87371609;
        this.Dc[19] = 10.19;
        this.Dc[20] = 17.399;
        this.Dc[21] = 13.407429659;
        this.Tc[1] = 190.564;
        this.Tc[2] = 126.192;
        this.Tc[3] = 304.1282;
        this.Tc[4] = 305.322;
        this.Tc[5] = 369.825;
        this.Tc[6] = 407.817;
        this.Tc[7] = 425.125;
        this.Tc[8] = 460.35;
        this.Tc[9] = 469.7;
        this.Tc[10] = 507.82;
        this.Tc[11] = 540.13;
        this.Tc[12] = 569.32;
        this.Tc[13] = 594.55;
        this.Tc[14] = 617.7;
        this.Tc[15] = 33.19;
        this.Tc[16] = 154.595;
        this.Tc[17] = 132.86;
        this.Tc[18] = 647.096;
        this.Tc[19] = 373.1;
        this.Tc[20] = 5.1953;
        this.Tc[21] = 150.687;
        for (i = 1; i <= this.MaxFlds; ++i) {
            this.Vc3[i] = 1.0 / Math.pow(this.Dc[i], o13) / 2.0;
            this.Tc2[i] = Math.sqrt(this.Tc[i]);
            this.coik[i][1] = 0;
            this.doik[i][1] = 1;
            this.toik[i][1] = 0.25;
            this.coik[i][2] = 0;
            this.doik[i][2] = 1;
            this.toik[i][2] = 1.125;
            this.coik[i][3] = 0;
            this.doik[i][3] = 1;
            this.toik[i][3] = 1.5;
            this.coik[i][4] = 0;
            this.doik[i][4] = 2;
            this.toik[i][4] = 1.375;
            this.coik[i][5] = 0;
            this.doik[i][5] = 3;
            this.toik[i][5] = 0.25;
            this.coik[i][6] = 0;
            this.doik[i][6] = 7;
            this.toik[i][6] = 0.875;
            this.coik[i][7] = 1;
            this.doik[i][7] = 2;
            this.toik[i][7] = 0.625;
            this.coik[i][8] = 1;
            this.doik[i][8] = 5;
            this.toik[i][8] = 1.75;
            this.coik[i][9] = 2;
            this.doik[i][9] = 1;
            this.toik[i][9] = 3.625;
            this.coik[i][10] = 2;
            this.doik[i][10] = 4;
            this.toik[i][10] = 3.625;
            this.coik[i][11] = 3;
            this.doik[i][11] = 3;
            this.toik[i][11] = 14.5;
            this.coik[i][12] = 3;
            this.doik[i][12] = 4;
            this.toik[i][12] = 12.0;
        }
        for (i = 1; i <= 4; ++i) {
            if (i == 3) continue;
            this.coik[i][1] = 0;
            this.doik[i][1] = 1;
            this.toik[i][1] = 0.125;
            this.coik[i][2] = 0;
            this.doik[i][2] = 1;
            this.toik[i][2] = 1.125;
            this.coik[i][3] = 0;
            this.doik[i][3] = 2;
            this.toik[i][3] = 0.375;
            this.coik[i][4] = 0;
            this.doik[i][4] = 2;
            this.toik[i][4] = 1.125;
            this.coik[i][5] = 0;
            this.doik[i][5] = 4;
            this.toik[i][5] = 0.625;
            this.coik[i][6] = 0;
            this.doik[i][6] = 4;
            this.toik[i][6] = 1.5;
            this.coik[i][7] = 1;
            this.doik[i][7] = 1;
            this.toik[i][7] = 0.625;
            this.coik[i][8] = 1;
            this.doik[i][8] = 1;
            this.toik[i][8] = 2.625;
            this.coik[i][9] = 1;
            this.doik[i][9] = 1;
            this.toik[i][9] = 2.75;
            this.coik[i][10] = 1;
            this.doik[i][10] = 2;
            this.toik[i][10] = 2.125;
            this.coik[i][11] = 1;
            this.doik[i][11] = 3;
            this.toik[i][11] = 2.0;
            this.coik[i][12] = 1;
            this.doik[i][12] = 6;
            this.toik[i][12] = 1.75;
            this.coik[i][13] = 2;
            this.doik[i][13] = 2;
            this.toik[i][13] = 4.5;
            this.coik[i][14] = 2;
            this.doik[i][14] = 3;
            this.toik[i][14] = 4.75;
            this.coik[i][15] = 2;
            this.doik[i][15] = 3;
            this.toik[i][15] = 5.0;
            this.coik[i][16] = 2;
            this.doik[i][16] = 4;
            this.toik[i][16] = 4.0;
            this.coik[i][17] = 2;
            this.doik[i][17] = 4;
            this.toik[i][17] = 4.5;
            this.coik[i][18] = 3;
            this.doik[i][18] = 2;
            this.toik[i][18] = 7.5;
            this.coik[i][19] = 3;
            this.doik[i][19] = 3;
            this.toik[i][19] = 14.0;
            this.coik[i][20] = 3;
            this.doik[i][20] = 4;
            this.toik[i][20] = 11.5;
            this.coik[i][21] = 6;
            this.doik[i][21] = 5;
            this.toik[i][21] = 26.0;
            this.coik[i][22] = 6;
            this.doik[i][22] = 6;
            this.toik[i][22] = 28.0;
            this.coik[i][23] = 6;
            this.doik[i][23] = 6;
            this.toik[i][23] = 30.0;
            this.coik[i][24] = 6;
            this.doik[i][24] = 7;
            this.toik[i][24] = 16.0;
        }
        this.noik[1][1] = 0.57335704239162;
        this.noik[1][2] = -1.676068752373;
        this.noik[1][3] = 0.23405291834916;
        this.noik[1][4] = -0.21947376343441;
        this.noik[1][5] = 0.016369201404128;
        this.noik[1][6] = 0.01500440638928;
        this.noik[1][7] = 0.098990489492918;
        this.noik[1][8] = 0.58382770929055;
        this.noik[1][9] = -0.7478686756039;
        this.noik[1][10] = 0.30033302857974;
        this.noik[1][11] = 0.20985543806568;
        this.noik[1][12] = -0.018590151133061;
        this.noik[1][13] = -0.15782558339049;
        this.noik[1][14] = 0.12716735220791;
        this.noik[1][15] = -0.032019743894346;
        this.noik[1][16] = -0.068049729364536;
        this.noik[1][17] = 0.024291412853736;
        this.noik[1][18] = 0.0051440451639444;
        this.noik[1][19] = -0.019084949733532;
        this.noik[1][20] = 0.0055229677241291;
        this.noik[1][21] = -0.0044197392976085;
        this.noik[1][22] = 0.040061416708429;
        this.noik[1][23] = -0.033752085907575;
        this.noik[1][24] = -0.0025127658213357;
        this.noik[2][1] = 0.59889711801201;
        this.noik[2][2] = -1.6941557480731;
        this.noik[2][3] = 0.24579736191718;
        this.noik[2][4] = -0.23722456755175;
        this.noik[2][5] = 0.017954918715141;
        this.noik[2][6] = 0.014592875720215;
        this.noik[2][7] = 0.10008065936206;
        this.noik[2][8] = 0.73157115385532;
        this.noik[2][9] = -0.88372272336366;
        this.noik[2][10] = 0.31887660246708;
        this.noik[2][11] = 0.20766491728799;
        this.noik[2][12] = -0.019379315454158;
        this.noik[2][13] = -0.16936641554983;
        this.noik[2][14] = 0.13546846041701;
        this.noik[2][15] = -0.033066712095307;
        this.noik[2][16] = -0.060690817018557;
        this.noik[2][17] = 0.012797548292871;
        this.noik[2][18] = 0.0058743664107299;
        this.noik[2][19] = -0.018451951971969;
        this.noik[2][20] = 0.0047226622042472;
        this.noik[2][21] = -0.0052024079680599;
        this.noik[2][22] = 0.043563505956635;
        this.noik[2][23] = -0.036251690750939;
        this.noik[2][24] = -0.0028974026866543;
        this.noik[4][1] = 0.63596780450714;
        this.noik[4][2] = -1.7377981785459;
        this.noik[4][3] = 0.28914060926272;
        this.noik[4][4] = -0.33714276845694;
        this.noik[4][5] = 0.022405964699561;
        this.noik[4][6] = 0.015715424886913;
        this.noik[4][7] = 0.11450634253745;
        this.noik[4][8] = 1.0612049379745;
        this.noik[4][9] = -1.2855224439423;
        this.noik[4][10] = 0.39414630777652;
        this.noik[4][11] = 0.31390924682041;
        this.noik[4][12] = -0.021592277117247;
        this.noik[4][13] = -0.21723666564905;
        this.noik[4][14] = -0.28999574439489;
        this.noik[4][15] = 0.42321173025732;
        this.noik[4][16] = 0.04643410025926;
        this.noik[4][17] = -0.13138398329741;
        this.noik[4][18] = 0.011492850364368;
        this.noik[4][19] = -0.033387688429909;
        this.noik[4][20] = 0.015183171583644;
        this.noik[4][21] = -0.0047610805647657;
        this.noik[4][22] = 0.046917166277885;
        this.noik[4][23] = -0.039401755804649;
        this.noik[4][24] = -0.0032569956247611;
        this.noik[5][1] = 1.0403973107358;
        this.noik[5][2] = -2.8318404081403;
        this.noik[5][3] = 0.84393809606294;
        this.noik[5][4] = -0.076559591850023;
        this.noik[5][5] = 0.09469737305728;
        this.noik[5][6] = 2.4796475497006E-4;
        this.noik[5][7] = 0.2774376042287;
        this.noik[5][8] = -0.043846000648377;
        this.noik[5][9] = -0.2699106478435;
        this.noik[5][10] = -0.06931341308986;
        this.noik[5][11] = -0.029632145981653;
        this.noik[5][12] = 0.01404012675138;
        this.noik[6][1] = 1.04293315891;
        this.noik[6][2] = -2.8184272548892;
        this.noik[6][3] = 0.8617623239785;
        this.noik[6][4] = -0.10613619452487;
        this.noik[6][5] = 0.098615749302134;
        this.noik[6][6] = 2.3948208682322E-4;
        this.noik[6][7] = 0.3033000485695;
        this.noik[6][8] = -0.041598156135099;
        this.noik[6][9] = -0.29991937470058;
        this.noik[6][10] = -0.080369342764109;
        this.noik[6][11] = -0.029761373251151;
        this.noik[6][12] = 0.01305963030314;
        this.noik[7][1] = 1.0626277411455;
        this.noik[7][2] = -2.862095182835;
        this.noik[7][3] = 0.88738233403777;
        this.noik[7][4] = -0.12570581155345;
        this.noik[7][5] = 0.10286308708106;
        this.noik[7][6] = 2.5358040602654E-4;
        this.noik[7][7] = 0.32325200233982;
        this.noik[7][8] = -0.037950761057432;
        this.noik[7][9] = -0.32534802014452;
        this.noik[7][10] = -0.079050969051011;
        this.noik[7][11] = -0.020636720547775;
        this.noik[7][12] = 0.005705380933475;
        this.noik[8][1] = 1.0963;
        this.noik[8][2] = -3.0402;
        this.noik[8][3] = 1.0317;
        this.noik[8][4] = -0.1541;
        this.noik[8][5] = 0.11535;
        this.noik[8][6] = 2.9809E-4;
        this.noik[8][7] = 0.39571;
        this.noik[8][8] = -0.045881;
        this.noik[8][9] = -0.35804;
        this.noik[8][10] = -0.10107;
        this.noik[8][11] = -0.035484;
        this.noik[8][12] = 0.018156;
        this.noik[9][1] = 1.0968643098001;
        this.noik[9][2] = -2.9988888298061;
        this.noik[9][3] = 0.99516886799212;
        this.noik[9][4] = -0.16170708558539;
        this.noik[9][5] = 0.11334460072775;
        this.noik[9][6] = 2.6760595150748E-4;
        this.noik[9][7] = 0.40979881986931;
        this.noik[9][8] = -0.040876423083075;
        this.noik[9][9] = -0.38169482469447;
        this.noik[9][10] = -0.10931956843993;
        this.noik[9][11] = -0.03207322332799;
        this.noik[9][12] = 0.016877016216975;
        this.noik[10][1] = 1.0553238013661;
        this.noik[10][2] = -2.6120615890629;
        this.noik[10][3] = 0.7661388296726;
        this.noik[10][4] = -0.29770320622459;
        this.noik[10][5] = 0.11879907733358;
        this.noik[10][6] = 2.7922861062617E-4;
        this.noik[10][7] = 0.46347589844105;
        this.noik[10][8] = 0.011433196980297;
        this.noik[10][9] = -0.48256968738131;
        this.noik[10][10] = -0.093750558924659;
        this.noik[10][11] = -0.0067273247155994;
        this.noik[10][12] = -0.0051141583585428;
        this.noik[11][1] = 1.0543747645262;
        this.noik[11][2] = -2.6500681506144;
        this.noik[11][3] = 0.81730047827543;
        this.noik[11][4] = -0.30451391253428;
        this.noik[11][5] = 0.122538687108;
        this.noik[11][6] = 2.7266472743928E-4;
        this.noik[11][7] = 0.4986582568167;
        this.noik[11][8] = -7.1432815084176E-4;
        this.noik[11][9] = -0.5423689552545;
        this.noik[11][10] = -0.13801821610756;
        this.noik[11][11] = -0.0061595287380011;
        this.noik[11][12] = 4.8602510393022E-4;
        this.noik[12][1] = 1.0722544875633;
        this.noik[12][2] = -2.4632951172003;
        this.noik[12][3] = 0.65386674054928;
        this.noik[12][4] = -0.36324974085628;
        this.noik[12][5] = 0.12713269626764;
        this.noik[12][6] = 3.071357277793E-4;
        this.noik[12][7] = 0.5265685698754;
        this.noik[12][8] = 0.019362862857653;
        this.noik[12][9] = -0.58939426849155;
        this.noik[12][10] = -0.14069963991934;
        this.noik[12][11] = -0.0078966330500036;
        this.noik[12][12] = 0.0033036597968109;
        this.noik[13][1] = 1.1151;
        this.noik[13][2] = -2.702;
        this.noik[13][3] = 0.83416;
        this.noik[13][4] = -0.38828;
        this.noik[13][5] = 0.1376;
        this.noik[13][6] = 2.8185E-4;
        this.noik[13][7] = 0.62037;
        this.noik[13][8] = 0.015847;
        this.noik[13][9] = -0.61726;
        this.noik[13][10] = -0.15043;
        this.noik[13][11] = -0.012982;
        this.noik[13][12] = 0.0044325;
        this.noik[14][1] = 1.0461;
        this.noik[14][2] = -2.4807;
        this.noik[14][3] = 0.74372;
        this.noik[14][4] = -0.52579;
        this.noik[14][5] = 0.15315;
        this.noik[14][6] = 3.2865E-4;
        this.noik[14][7] = 0.84178;
        this.noik[14][8] = 0.055424;
        this.noik[14][9] = -0.73555;
        this.noik[14][10] = -0.18507;
        this.noik[14][11] = -0.020775;
        this.noik[14][12] = 0.012335;
        this.noik[16][1] = 0.88878286369701;
        this.noik[16][2] = -2.4879433312148;
        this.noik[16][3] = 0.59750190775886;
        this.noik[16][4] = 0.0096501817061881;
        this.noik[16][5] = 0.07197042871277;
        this.noik[16][6] = 2.2337443000195E-4;
        this.noik[16][7] = 0.18558686391474;
        this.noik[16][8] = -0.03812936803576;
        this.noik[16][9] = -0.15352245383006;
        this.noik[16][10] = -0.026726814910919;
        this.noik[16][11] = -0.025675298677127;
        this.noik[16][12] = 0.0095714302123668;
        this.noik[17][1] = 0.90554;
        this.noik[17][2] = -2.4515;
        this.noik[17][3] = 0.53149;
        this.noik[17][4] = 0.024173;
        this.noik[17][5] = 0.072156;
        this.noik[17][6] = 1.8818E-4;
        this.noik[17][7] = 0.19405;
        this.noik[17][8] = -0.043268;
        this.noik[17][9] = -0.12778;
        this.noik[17][10] = -0.027896;
        this.noik[17][11] = -0.034154;
        this.noik[17][12] = 0.016329;
        this.noik[19][1] = 0.87641;
        this.noik[19][2] = -2.0367;
        this.noik[19][3] = 0.21634;
        this.noik[19][4] = -0.050199;
        this.noik[19][5] = 0.066994;
        this.noik[19][6] = 1.9076E-4;
        this.noik[19][7] = 0.20227;
        this.noik[19][8] = -0.0045348;
        this.noik[19][9] = -0.2223;
        this.noik[19][10] = -0.034714;
        this.noik[19][11] = -0.014885;
        this.noik[19][12] = 0.0074154;
        this.noik[21][1] = 0.85095714803969;
        this.noik[21][2] = -2.400322294348;
        this.noik[21][3] = 0.54127841476466;
        this.noik[21][4] = 0.016919770692538;
        this.noik[21][5] = 0.068825965019035;
        this.noik[21][6] = 2.1428032815338E-4;
        this.noik[21][7] = 0.17429895321992;
        this.noik[21][8] = -0.033654495604194;
        this.noik[21][9] = -0.13526799857691;
        this.noik[21][10] = -0.016387350791552;
        this.noik[21][11] = -0.024987666851475;
        this.noik[21][12] = 0.0088769204815709;
        this.coik[3][1] = 0;
        this.doik[3][1] = 1;
        this.toik[3][1] = 0.0;
        this.noik[3][1] = 0.52646564804653;
        this.coik[3][2] = 0;
        this.doik[3][2] = 1;
        this.toik[3][2] = 1.25;
        this.noik[3][2] = -1.4995725042592;
        this.coik[3][3] = 0;
        this.doik[3][3] = 2;
        this.toik[3][3] = 1.625;
        this.noik[3][3] = 0.27329786733782;
        this.coik[3][4] = 0;
        this.doik[3][4] = 3;
        this.toik[3][4] = 0.375;
        this.noik[3][4] = 0.12949500022786;
        this.coik[3][5] = 1;
        this.doik[3][5] = 3;
        this.toik[3][5] = 0.375;
        this.noik[3][5] = 0.15404088341841;
        this.coik[3][6] = 1;
        this.doik[3][6] = 3;
        this.toik[3][6] = 1.375;
        this.noik[3][6] = -0.58186950946814;
        this.coik[3][7] = 1;
        this.doik[3][7] = 4;
        this.toik[3][7] = 1.125;
        this.noik[3][7] = -0.18022494838296;
        this.coik[3][8] = 1;
        this.doik[3][8] = 5;
        this.toik[3][8] = 1.375;
        this.noik[3][8] = -0.095389904072812;
        this.coik[3][9] = 1;
        this.doik[3][9] = 6;
        this.toik[3][9] = 0.125;
        this.noik[3][9] = -0.0080486819317679;
        this.coik[3][10] = 1;
        this.doik[3][10] = 6;
        this.toik[3][10] = 1.625;
        this.noik[3][10] = -0.03554775127309;
        this.coik[3][11] = 2;
        this.doik[3][11] = 1;
        this.toik[3][11] = 3.75;
        this.noik[3][11] = -0.28079014882405;
        this.coik[3][12] = 2;
        this.doik[3][12] = 4;
        this.toik[3][12] = 3.5;
        this.noik[3][12] = -0.082435890081677;
        this.coik[3][13] = 3;
        this.doik[3][13] = 1;
        this.toik[3][13] = 7.5;
        this.noik[3][13] = 0.010832427979006;
        this.coik[3][14] = 3;
        this.doik[3][14] = 1;
        this.toik[3][14] = 8.0;
        this.noik[3][14] = -0.0067073993161097;
        this.coik[3][15] = 3;
        this.doik[3][15] = 3;
        this.toik[3][15] = 6.0;
        this.noik[3][15] = -0.0046827907600524;
        this.coik[3][16] = 3;
        this.doik[3][16] = 3;
        this.toik[3][16] = 16.0;
        this.noik[3][16] = -0.028359911832177;
        this.coik[3][17] = 3;
        this.doik[3][17] = 4;
        this.toik[3][17] = 11.0;
        this.noik[3][17] = 0.019500174744098;
        this.coik[3][18] = 5;
        this.doik[3][18] = 5;
        this.toik[3][18] = 24.0;
        this.noik[3][18] = -0.21609137507166;
        this.coik[3][19] = 5;
        this.doik[3][19] = 5;
        this.toik[3][19] = 26.0;
        this.noik[3][19] = 0.43772794926972;
        this.coik[3][20] = 5;
        this.doik[3][20] = 5;
        this.toik[3][20] = 28.0;
        this.noik[3][20] = -0.22130790113593;
        this.coik[3][21] = 6;
        this.doik[3][21] = 5;
        this.toik[3][21] = 24.0;
        this.noik[3][21] = 0.015190189957331;
        this.coik[3][22] = 6;
        this.doik[3][22] = 5;
        this.toik[3][22] = 26.0;
        this.noik[3][22] = -0.0153809489533;
        this.coik[15][1] = 0;
        this.doik[15][1] = 1;
        this.toik[15][1] = 0.5;
        this.noik[15][1] = 5.3579928451252;
        this.coik[15][2] = 0;
        this.doik[15][2] = 1;
        this.toik[15][2] = 0.625;
        this.noik[15][2] = -6.2050252530595;
        this.coik[15][3] = 0;
        this.doik[15][3] = 2;
        this.toik[15][3] = 0.375;
        this.noik[15][3] = 0.13830241327086;
        this.coik[15][4] = 0;
        this.doik[15][4] = 2;
        this.toik[15][4] = 0.625;
        this.noik[15][4] = -0.071397954896129;
        this.coik[15][5] = 0;
        this.doik[15][5] = 4;
        this.toik[15][5] = 1.125;
        this.noik[15][5] = 0.015474053959733;
        this.coik[15][6] = 1;
        this.doik[15][6] = 1;
        this.toik[15][6] = 2.625;
        this.noik[15][6] = -0.14976806405771;
        this.coik[15][7] = 1;
        this.doik[15][7] = 5;
        this.toik[15][7] = 0.0;
        this.noik[15][7] = -0.026368723988451;
        this.coik[15][8] = 1;
        this.doik[15][8] = 5;
        this.toik[15][8] = 0.25;
        this.noik[15][8] = 0.056681303156066;
        this.coik[15][9] = 1;
        this.doik[15][9] = 5;
        this.toik[15][9] = 1.375;
        this.noik[15][9] = -0.060063958030436;
        this.coik[15][10] = 2;
        this.doik[15][10] = 1;
        this.toik[15][10] = 4.0;
        this.noik[15][10] = -0.45043942027132;
        this.coik[15][11] = 2;
        this.doik[15][11] = 1;
        this.toik[15][11] = 4.25;
        this.noik[15][11] = 0.424788402445;
        this.coik[15][12] = 3;
        this.doik[15][12] = 2;
        this.toik[15][12] = 5.0;
        this.noik[15][12] = -0.021997640827139;
        this.coik[15][13] = 3;
        this.doik[15][13] = 5;
        this.toik[15][13] = 8.0;
        this.noik[15][13] = -0.01049952137453;
        this.coik[15][14] = 5;
        this.doik[15][14] = 1;
        this.toik[15][14] = 8.0;
        this.noik[15][14] = -0.0028955902866816;
        this.coik[18][1] = 0;
        this.doik[18][1] = 1;
        this.toik[18][1] = 0.5;
        this.noik[18][1] = 0.82728408749586;
        this.coik[18][2] = 0;
        this.doik[18][2] = 1;
        this.toik[18][2] = 1.25;
        this.noik[18][2] = -1.8602220416584;
        this.coik[18][3] = 0;
        this.doik[18][3] = 1;
        this.toik[18][3] = 1.875;
        this.noik[18][3] = -1.1199009613744;
        this.coik[18][4] = 0;
        this.doik[18][4] = 2;
        this.toik[18][4] = 0.125;
        this.noik[18][4] = 0.15635753976056;
        this.coik[18][5] = 0;
        this.doik[18][5] = 2;
        this.toik[18][5] = 1.5;
        this.noik[18][5] = 0.87375844859025;
        this.coik[18][6] = 0;
        this.doik[18][6] = 3;
        this.toik[18][6] = 1.0;
        this.noik[18][6] = -0.36674403715731;
        this.coik[18][7] = 0;
        this.doik[18][7] = 4;
        this.toik[18][7] = 0.75;
        this.noik[18][7] = 0.053987893432436;
        this.coik[18][8] = 1;
        this.doik[18][8] = 1;
        this.toik[18][8] = 1.5;
        this.noik[18][8] = 1.0957690214499;
        this.coik[18][9] = 1;
        this.doik[18][9] = 5;
        this.toik[18][9] = 0.625;
        this.noik[18][9] = 0.053213037828563;
        this.coik[18][10] = 1;
        this.doik[18][10] = 5;
        this.toik[18][10] = 2.625;
        this.noik[18][10] = 0.013050533930825;
        this.coik[18][11] = 2;
        this.doik[18][11] = 1;
        this.toik[18][11] = 5.0;
        this.noik[18][11] = -0.41079520434476;
        this.coik[18][12] = 2;
        this.doik[18][12] = 2;
        this.toik[18][12] = 4.0;
        this.noik[18][12] = 0.1463744334412;
        this.coik[18][13] = 2;
        this.doik[18][13] = 4;
        this.toik[18][13] = 4.5;
        this.noik[18][13] = -0.055726838623719;
        this.coik[18][14] = 3;
        this.doik[18][14] = 4;
        this.toik[18][14] = 3.0;
        this.noik[18][14] = -0.0112017741438;
        this.coik[18][15] = 5;
        this.doik[18][15] = 1;
        this.toik[18][15] = 4.0;
        this.noik[18][15] = -0.0066062758068099;
        this.coik[18][16] = 5;
        this.doik[18][16] = 1;
        this.toik[18][16] = 6.0;
        this.noik[18][16] = 0.0046918522004538;
        this.coik[20][1] = 0;
        this.doik[20][1] = 1;
        this.toik[20][1] = 0.0;
        this.noik[20][1] = -0.45579024006737;
        this.coik[20][2] = 0;
        this.doik[20][2] = 1;
        this.toik[20][2] = 0.125;
        this.noik[20][2] = 1.2516390754925;
        this.coik[20][3] = 0;
        this.doik[20][3] = 1;
        this.toik[20][3] = 0.75;
        this.noik[20][3] = -1.5438231650621;
        this.coik[20][4] = 0;
        this.doik[20][4] = 4;
        this.toik[20][4] = 1.0;
        this.noik[20][4] = 0.020467489707221;
        this.coik[20][5] = 1;
        this.doik[20][5] = 1;
        this.toik[20][5] = 0.75;
        this.noik[20][5] = -0.34476212380781;
        this.coik[20][6] = 1;
        this.doik[20][6] = 3;
        this.toik[20][6] = 2.625;
        this.noik[20][6] = -0.020858459512787;
        this.coik[20][7] = 1;
        this.doik[20][7] = 5;
        this.toik[20][7] = 0.125;
        this.noik[20][7] = 0.016227414711778;
        this.coik[20][8] = 1;
        this.doik[20][8] = 5;
        this.toik[20][8] = 1.25;
        this.noik[20][8] = -0.057471818200892;
        this.coik[20][9] = 1;
        this.doik[20][9] = 5;
        this.toik[20][9] = 2.0;
        this.noik[20][9] = 0.019462416430715;
        this.coik[20][10] = 2;
        this.doik[20][10] = 2;
        this.toik[20][10] = 1.0;
        this.noik[20][10] = -0.03329568012302;
        this.coik[20][11] = 3;
        this.doik[20][11] = 1;
        this.toik[20][11] = 4.5;
        this.noik[20][11] = -0.010863577372367;
        this.coik[20][12] = 3;
        this.doik[20][12] = 2;
        this.toik[20][12] = 5.0;
        this.noik[20][12] = -0.022173365245954;
        this.dijk[3][1] = 1;
        this.tijk[3][1] = 0.0;
        this.cijk[3][1] = 0.0;
        this.eijk[3][1] = 0.0;
        bijk[3][1] = 0.0;
        this.gijk[3][1] = 0.0;
        this.nijk[3][1] = -0.0098038985517335;
        this.dijk[3][2] = 4;
        this.tijk[3][2] = 1.85;
        this.cijk[3][2] = 0.0;
        this.eijk[3][2] = 0.0;
        bijk[3][2] = 0.0;
        this.gijk[3][2] = 0.0;
        this.nijk[3][2] = 4.2487270143005E-4;
        this.dijk[3][3] = 1;
        this.tijk[3][3] = 7.85;
        this.cijk[3][3] = 1.0;
        this.eijk[3][3] = 0.5;
        bijk[3][3] = 1.0;
        this.gijk[3][3] = 0.5;
        this.nijk[3][3] = -0.034800214576142;
        this.dijk[3][4] = 2;
        this.tijk[3][4] = 5.4;
        this.cijk[3][4] = 1.0;
        this.eijk[3][4] = 0.5;
        bijk[3][4] = 1.0;
        this.gijk[3][4] = 0.5;
        this.nijk[3][4] = -0.13333813013896;
        this.dijk[3][5] = 2;
        this.tijk[3][5] = 0.0;
        this.cijk[3][5] = 0.25;
        this.eijk[3][5] = 0.5;
        bijk[3][5] = 2.5;
        this.gijk[3][5] = 0.5;
        this.nijk[3][5] = -0.011993694974627;
        this.dijk[3][6] = 2;
        this.tijk[3][6] = 0.75;
        this.cijk[3][6] = 0.0;
        this.eijk[3][6] = 0.5;
        bijk[3][6] = 3.0;
        this.gijk[3][6] = 0.5;
        this.nijk[3][6] = 0.069243379775168;
        this.dijk[3][7] = 2;
        this.tijk[3][7] = 2.8;
        this.cijk[3][7] = 0.0;
        this.eijk[3][7] = 0.5;
        bijk[3][7] = 3.0;
        this.gijk[3][7] = 0.5;
        this.nijk[3][7] = -0.31022508148249;
        this.dijk[3][8] = 2;
        this.tijk[3][8] = 4.45;
        this.cijk[3][8] = 0.0;
        this.eijk[3][8] = 0.5;
        bijk[3][8] = 3.0;
        this.gijk[3][8] = 0.5;
        this.nijk[3][8] = 0.24495491753226;
        this.dijk[3][9] = 3;
        this.tijk[3][9] = 4.25;
        this.cijk[3][9] = 0.0;
        this.eijk[3][9] = 0.5;
        bijk[3][9] = 3.0;
        this.gijk[3][9] = 0.5;
        this.nijk[3][9] = 0.22369816716981;
        this.dijk[4][1] = 1;
        this.tijk[4][1] = 2.6;
        this.cijk[4][1] = 0.0;
        this.eijk[4][1] = 0.0;
        bijk[4][1] = 0.0;
        this.gijk[4][1] = 0.0;
        this.nijk[4][1] = -0.10859387354942;
        this.dijk[4][2] = 2;
        this.tijk[4][2] = 1.95;
        this.cijk[4][2] = 0.0;
        this.eijk[4][2] = 0.0;
        bijk[4][2] = 0.0;
        this.gijk[4][2] = 0.0;
        this.nijk[4][2] = 0.080228576727389;
        this.dijk[4][3] = 3;
        this.tijk[4][3] = 0.0;
        this.cijk[4][3] = 0.0;
        this.eijk[4][3] = 0.0;
        bijk[4][3] = 0.0;
        this.gijk[4][3] = 0.0;
        this.nijk[4][3] = -0.0093303985115717;
        this.dijk[4][4] = 1;
        this.tijk[4][4] = 3.95;
        this.cijk[4][4] = 1.0;
        this.eijk[4][4] = 0.5;
        bijk[4][4] = 1.0;
        this.gijk[4][4] = 0.5;
        this.nijk[4][4] = 0.040989274005848;
        this.dijk[4][5] = 2;
        this.tijk[4][5] = 7.95;
        this.cijk[4][5] = 0.5;
        this.eijk[4][5] = 0.5;
        bijk[4][5] = 2.0;
        this.gijk[4][5] = 0.5;
        this.nijk[4][5] = -0.24338019772494;
        this.dijk[4][6] = 3;
        this.tijk[4][6] = 8.0;
        this.cijk[4][6] = 0.0;
        this.eijk[4][6] = 0.5;
        bijk[4][6] = 3.0;
        this.gijk[4][6] = 0.5;
        this.nijk[4][6] = 0.23855347281124;
        this.dijk[1][1] = 3;
        this.tijk[1][1] = 0.65;
        this.cijk[1][1] = 0.0;
        this.eijk[1][1] = 0.0;
        bijk[1][1] = 0.0;
        this.gijk[1][1] = 0.0;
        this.nijk[1][1] = -8.0926050298746E-4;
        this.dijk[1][2] = 4;
        this.tijk[1][2] = 1.55;
        this.cijk[1][2] = 0.0;
        this.eijk[1][2] = 0.0;
        bijk[1][2] = 0.0;
        this.gijk[1][2] = 0.0;
        this.nijk[1][2] = -7.5381925080059E-4;
        this.dijk[1][3] = 1;
        this.tijk[1][3] = 3.1;
        this.cijk[1][3] = 1.0;
        this.eijk[1][3] = 0.5;
        bijk[1][3] = 1.0;
        this.gijk[1][3] = 0.5;
        this.nijk[1][3] = -0.041618768891219;
        this.dijk[1][4] = 2;
        this.tijk[1][4] = 5.9;
        this.cijk[1][4] = 1.0;
        this.eijk[1][4] = 0.5;
        bijk[1][4] = 1.0;
        this.gijk[1][4] = 0.5;
        this.nijk[1][4] = -0.23452173681569;
        this.dijk[1][5] = 2;
        this.tijk[1][5] = 7.05;
        this.cijk[1][5] = 1.0;
        this.eijk[1][5] = 0.5;
        bijk[1][5] = 1.0;
        this.gijk[1][5] = 0.5;
        this.nijk[1][5] = 0.14003840584586;
        this.dijk[1][6] = 2;
        this.tijk[1][6] = 3.35;
        this.cijk[1][6] = 0.875;
        this.eijk[1][6] = 0.5;
        bijk[1][6] = 1.25;
        this.gijk[1][6] = 0.5;
        this.nijk[1][6] = 0.063281744807738;
        this.dijk[1][7] = 2;
        this.tijk[1][7] = 1.2;
        this.cijk[1][7] = 0.75;
        this.eijk[1][7] = 0.5;
        bijk[1][7] = 1.5;
        this.gijk[1][7] = 0.5;
        this.nijk[1][7] = -0.034660425848809;
        this.dijk[1][8] = 2;
        this.tijk[1][8] = 5.8;
        this.cijk[1][8] = 0.5;
        this.eijk[1][8] = 0.5;
        bijk[1][8] = 2.0;
        this.gijk[1][8] = 0.5;
        this.nijk[1][8] = -0.23918747334251;
        this.dijk[1][9] = 2;
        this.tijk[1][9] = 2.7;
        this.cijk[1][9] = 0.0;
        this.eijk[1][9] = 0.5;
        bijk[1][9] = 3.0;
        this.gijk[1][9] = 0.5;
        this.nijk[1][9] = 0.0019855255066891;
        this.dijk[1][10] = 3;
        this.tijk[1][10] = 0.45;
        this.cijk[1][10] = 0.0;
        this.eijk[1][10] = 0.5;
        bijk[1][10] = 3.0;
        this.gijk[1][10] = 0.5;
        this.nijk[1][10] = 6.1777746171555;
        this.dijk[1][11] = 3;
        this.tijk[1][11] = 0.55;
        this.cijk[1][11] = 0.0;
        this.eijk[1][11] = 0.5;
        bijk[1][11] = 3.0;
        this.gijk[1][11] = 0.5;
        this.nijk[1][11] = -6.9575358271105;
        this.dijk[1][12] = 3;
        this.tijk[1][12] = 1.95;
        this.cijk[1][12] = 0.0;
        this.eijk[1][12] = 0.5;
        bijk[1][12] = 3.0;
        this.gijk[1][12] = 0.5;
        this.nijk[1][12] = 1.0630185306388;
        this.dijk[2][1] = 3;
        this.tijk[2][1] = 1.85;
        this.cijk[2][1] = 0.0;
        this.eijk[2][1] = 0.0;
        bijk[2][1] = 0.0;
        this.gijk[2][1] = 0.0;
        this.nijk[2][1] = 0.013746429958576;
        this.dijk[2][2] = 3;
        this.tijk[2][2] = 3.95;
        this.cijk[2][2] = 0.0;
        this.eijk[2][2] = 0.0;
        bijk[2][2] = 0.0;
        this.gijk[2][2] = 0.0;
        this.nijk[2][2] = -0.0074425012129552;
        this.dijk[2][3] = 4;
        this.tijk[2][3] = 0.0;
        this.cijk[2][3] = 0.0;
        this.eijk[2][3] = 0.0;
        bijk[2][3] = 0.0;
        this.gijk[2][3] = 0.0;
        this.nijk[2][3] = -0.0045516600213685;
        this.dijk[2][4] = 4;
        this.tijk[2][4] = 1.85;
        this.cijk[2][4] = 0.0;
        this.eijk[2][4] = 0.0;
        bijk[2][4] = 0.0;
        this.gijk[2][4] = 0.0;
        this.nijk[2][4] = -0.0054546603350237;
        this.dijk[2][5] = 4;
        this.tijk[2][5] = 3.85;
        this.cijk[2][5] = 0.0;
        this.eijk[2][5] = 0.0;
        bijk[2][5] = 0.0;
        this.gijk[2][5] = 0.0;
        this.nijk[2][5] = 0.0023682016824471;
        this.dijk[2][6] = 1;
        this.tijk[2][6] = 5.25;
        this.cijk[2][6] = 0.25;
        this.eijk[2][6] = 0.5;
        bijk[2][6] = 0.75;
        this.gijk[2][6] = 0.5;
        this.nijk[2][6] = 0.18007763721438;
        this.dijk[2][7] = 1;
        this.tijk[2][7] = 3.85;
        this.cijk[2][7] = 0.25;
        this.eijk[2][7] = 0.5;
        bijk[2][7] = 1.0;
        this.gijk[2][7] = 0.5;
        this.nijk[2][7] = -0.44773942932486;
        this.dijk[2][8] = 1;
        this.tijk[2][8] = 0.2;
        this.cijk[2][8] = 0.0;
        this.eijk[2][8] = 0.5;
        bijk[2][8] = 2.0;
        this.gijk[2][8] = 0.5;
        this.nijk[2][8] = 0.0193273748882;
        this.dijk[2][9] = 2;
        this.tijk[2][9] = 6.5;
        this.cijk[2][9] = 0.0;
        this.eijk[2][9] = 0.5;
        bijk[2][9] = 3.0;
        this.gijk[2][9] = 0.5;
        this.nijk[2][9] = -0.30632197804624;
        this.dijk[5][1] = 2;
        this.tijk[5][1] = 1.85;
        this.cijk[5][1] = 0.0;
        this.eijk[5][1] = 0.0;
        bijk[5][1] = 0.0;
        this.gijk[5][1] = 0.0;
        this.nijk[5][1] = 0.28661625028399;
        this.dijk[5][2] = 3;
        this.tijk[5][2] = 1.4;
        this.cijk[5][2] = 0.0;
        this.eijk[5][2] = 0.0;
        bijk[5][2] = 0.0;
        this.gijk[5][2] = 0.0;
        this.nijk[5][2] = -0.10919833861247;
        this.dijk[5][3] = 1;
        this.tijk[5][3] = 3.2;
        this.cijk[5][3] = 0.25;
        this.eijk[5][3] = 0.5;
        bijk[5][3] = 0.75;
        this.gijk[5][3] = 0.5;
        this.nijk[5][3] = -1.137403208227;
        this.dijk[5][4] = 1;
        this.tijk[5][4] = 2.5;
        this.cijk[5][4] = 0.25;
        this.eijk[5][4] = 0.5;
        bijk[5][4] = 1.0;
        this.gijk[5][4] = 0.5;
        this.nijk[5][4] = 0.76580544237358;
        this.dijk[5][5] = 1;
        this.tijk[5][5] = 8.0;
        this.cijk[5][5] = 0.0;
        this.eijk[5][5] = 0.5;
        bijk[5][5] = 2.0;
        this.gijk[5][5] = 0.5;
        this.nijk[5][5] = 0.0042638000926819;
        this.dijk[5][6] = 2;
        this.tijk[5][6] = 3.75;
        this.cijk[5][6] = 0.0;
        this.eijk[5][6] = 0.5;
        bijk[5][6] = 3.0;
        this.gijk[5][6] = 0.5;
        this.nijk[5][6] = 0.17673538204534;
        this.dijk[6][1] = 2;
        this.tijk[6][1] = 0.0;
        this.cijk[6][1] = 0.0;
        this.eijk[6][1] = 0.0;
        bijk[6][1] = 0.0;
        this.gijk[6][1] = 0.0;
        this.nijk[6][1] = -0.47376518126608;
        this.dijk[6][2] = 2;
        this.tijk[6][2] = 0.05;
        this.cijk[6][2] = 0.0;
        this.eijk[6][2] = 0.0;
        bijk[6][2] = 0.0;
        this.gijk[6][2] = 0.0;
        this.nijk[6][2] = 0.48961193461001;
        this.dijk[6][3] = 3;
        this.tijk[6][3] = 0.0;
        this.cijk[6][3] = 0.0;
        this.eijk[6][3] = 0.0;
        bijk[6][3] = 0.0;
        this.gijk[6][3] = 0.0;
        this.nijk[6][3] = -0.0057011062090535;
        this.dijk[6][4] = 1;
        this.tijk[6][4] = 3.65;
        this.cijk[6][4] = 1.0;
        this.eijk[6][4] = 0.5;
        bijk[6][4] = 1.0;
        this.gijk[6][4] = 0.5;
        this.nijk[6][4] = -0.1996682004132;
        this.dijk[6][5] = 2;
        this.tijk[6][5] = 4.9;
        this.cijk[6][5] = 1.0;
        this.eijk[6][5] = 0.5;
        bijk[6][5] = 1.0;
        this.gijk[6][5] = 0.5;
        this.nijk[6][5] = -0.69411103101723;
        this.dijk[6][6] = 2;
        this.tijk[6][6] = 4.45;
        this.cijk[6][6] = 0.875;
        this.eijk[6][6] = 0.5;
        bijk[6][6] = 1.25;
        this.gijk[6][6] = 0.5;
        this.nijk[6][6] = 0.69226192739021;
        this.dijk[7][1] = 1;
        this.tijk[7][1] = 2.0;
        this.cijk[7][1] = 0.0;
        this.eijk[7][1] = 0.0;
        bijk[7][1] = 0.0;
        this.gijk[7][1] = 0.0;
        this.nijk[7][1] = -0.25157134971934;
        this.dijk[7][2] = 3;
        this.tijk[7][2] = -1.0;
        this.cijk[7][2] = 0.0;
        this.eijk[7][2] = 0.0;
        bijk[7][2] = 0.0;
        this.gijk[7][2] = 0.0;
        this.nijk[7][2] = -0.0062203841111983;
        this.dijk[7][3] = 3;
        this.tijk[7][3] = 1.75;
        this.cijk[7][3] = 0.0;
        this.eijk[7][3] = 0.0;
        bijk[7][3] = 0.0;
        this.gijk[7][3] = 0.0;
        this.nijk[7][3] = 0.088850315184396;
        this.dijk[7][4] = 4;
        this.tijk[7][4] = 1.4;
        this.cijk[7][4] = 0.0;
        this.eijk[7][4] = 0.0;
        bijk[7][4] = 0.0;
        this.gijk[7][4] = 0.0;
        this.nijk[7][4] = -0.035592212573239;
        this.dijk[10][1] = 1;
        this.tijk[10][1] = 1.0;
        this.cijk[10][1] = 0.0;
        this.eijk[10][1] = 0.0;
        bijk[10][1] = 0.0;
        this.gijk[10][1] = 0.0;
        this.nijk[10][1] = 2.5574776844118;
        this.dijk[10][2] = 1;
        this.tijk[10][2] = 1.55;
        this.cijk[10][2] = 0.0;
        this.eijk[10][2] = 0.0;
        bijk[10][2] = 0.0;
        this.gijk[10][2] = 0.0;
        this.nijk[10][2] = -7.9846357136353;
        this.dijk[10][3] = 1;
        this.tijk[10][3] = 1.7;
        this.cijk[10][3] = 0.0;
        this.eijk[10][3] = 0.0;
        bijk[10][3] = 0.0;
        this.gijk[10][3] = 0.0;
        this.nijk[10][3] = 4.7859131465806;
        this.dijk[10][4] = 2;
        this.tijk[10][4] = 0.25;
        this.cijk[10][4] = 0.0;
        this.eijk[10][4] = 0.0;
        bijk[10][4] = 0.0;
        this.gijk[10][4] = 0.0;
        this.nijk[10][4] = -0.73265392369587;
        this.dijk[10][5] = 2;
        this.tijk[10][5] = 1.35;
        this.cijk[10][5] = 0.0;
        this.eijk[10][5] = 0.0;
        bijk[10][5] = 0.0;
        this.gijk[10][5] = 0.0;
        this.nijk[10][5] = 1.3805471345312;
        this.dijk[10][6] = 3;
        this.tijk[10][6] = 0.0;
        this.cijk[10][6] = 0.0;
        this.eijk[10][6] = 0.0;
        bijk[10][6] = 0.0;
        this.gijk[10][6] = 0.0;
        this.nijk[10][6] = 0.28349603476365;
        this.dijk[10][7] = 3;
        this.tijk[10][7] = 1.25;
        this.cijk[10][7] = 0.0;
        this.eijk[10][7] = 0.0;
        bijk[10][7] = 0.0;
        this.gijk[10][7] = 0.0;
        this.nijk[10][7] = -0.49087385940425;
        this.dijk[10][8] = 4;
        this.tijk[10][8] = 0.0;
        this.cijk[10][8] = 0.0;
        this.eijk[10][8] = 0.0;
        bijk[10][8] = 0.0;
        this.gijk[10][8] = 0.0;
        this.nijk[10][8] = -0.10291888921447;
        this.dijk[10][9] = 4;
        this.tijk[10][9] = 0.7;
        this.cijk[10][9] = 0.0;
        this.eijk[10][9] = 0.0;
        bijk[10][9] = 0.0;
        this.gijk[10][9] = 0.0;
        this.nijk[10][9] = 0.11836314681968;
        this.dijk[10][10] = 4;
        this.tijk[10][10] = 5.4;
        this.cijk[10][10] = 0.0;
        this.eijk[10][10] = 0.0;
        bijk[10][10] = 0.0;
        this.gijk[10][10] = 0.0;
        this.nijk[10][10] = 5.5527385721943E-5;
        this.fij[1][2] = 1.0;
        this.fij[1][3] = 1.0;
        this.fij[1][4] = 1.0;
        this.fij[1][5] = 1.0;
        this.fij[2][3] = 1.0;
        this.fij[2][4] = 1.0;
        this.fij[1][15] = 1.0;
        this.fij[1][6] = 0.771035405688;
        this.fij[1][7] = 1.0;
        this.fij[4][5] = 0.13042476515;
        this.fij[4][6] = 0.260632376098;
        this.fij[4][7] = 0.281570073085;
        this.fij[5][6] = -0.0551609771024;
        this.fij[5][7] = 0.0312572600489;
        this.fij[6][7] = -0.0551240293009;
        for (i = 1; i <= this.MaxFlds; ++i) {
            this.mNumb[i][i] = -1;
            for (j = i + 1; j <= this.MaxFlds; ++j) {
                this.fij[j][i] = this.fij[i][j];
                this.mNumb[i][j] = -1;
                this.mNumb[j][i] = -1;
            }
        }
        this.mNumb[1][2] = 3;
        this.mNumb[1][3] = 4;
        this.mNumb[1][4] = 1;
        this.mNumb[1][5] = 2;
        this.mNumb[1][6] = 10;
        this.mNumb[1][7] = 10;
        this.mNumb[1][15] = 7;
        this.mNumb[2][3] = 5;
        this.mNumb[2][4] = 6;
        this.mNumb[4][5] = 10;
        this.mNumb[4][6] = 10;
        this.mNumb[4][7] = 10;
        this.mNumb[5][6] = 10;
        this.mNumb[5][7] = 10;
        this.mNumb[6][7] = 10;
        this.n0i[1][3] = 4.00088;
        this.n0i[1][4] = 0.76315;
        this.n0i[1][5] = 0.0046;
        this.n0i[1][6] = 8.74432;
        this.n0i[1][7] = -4.46921;
        this.n0i[1][1] = 29.83843397;
        this.n0i[1][2] = -15999.69151;
        this.n0i[2][3] = 3.50031;
        this.n0i[2][4] = 0.13732;
        this.n0i[2][5] = -0.1466;
        this.n0i[2][6] = 0.90066;
        this.n0i[2][7] = 0.0;
        this.n0i[2][1] = 17.56770785;
        this.n0i[2][2] = -2801.729072;
        this.n0i[3][3] = 3.50002;
        this.n0i[3][4] = 2.04452;
        this.n0i[3][5] = -1.06044;
        this.n0i[3][6] = 2.03366;
        this.n0i[3][7] = 0.01393;
        this.n0i[3][1] = 20.65844696;
        this.n0i[3][2] = -4902.171516;
        this.n0i[4][3] = 4.00263;
        this.n0i[4][4] = 4.33939;
        this.n0i[4][5] = 1.23722;
        this.n0i[4][6] = 13.1974;
        this.n0i[4][7] = -6.01989;
        this.n0i[4][1] = 36.73005938;
        this.n0i[4][2] = -23639.65301;
        this.n0i[5][3] = 4.02939;
        this.n0i[5][4] = 6.60569;
        this.n0i[5][5] = 3.197;
        this.n0i[5][6] = 19.1921;
        this.n0i[5][7] = -8.37267;
        this.n0i[5][1] = 44.70909619;
        this.n0i[5][2] = -31236.63551;
        this.n0i[6][3] = 4.06714;
        this.n0i[6][4] = 8.97575;
        this.n0i[6][5] = 5.25156;
        this.n0i[6][6] = 25.1423;
        this.n0i[6][7] = 16.1388;
        this.n0i[6][1] = 34.30180349;
        this.n0i[6][2] = -38525.50276;
        this.n0i[7][3] = 4.33944;
        this.n0i[7][4] = 9.44893;
        this.n0i[7][5] = 6.89406;
        this.n0i[7][6] = 24.4618;
        this.n0i[7][7] = 14.7824;
        this.n0i[7][1] = 36.53237783;
        this.n0i[7][2] = -38957.80933;
        this.n0i[8][3] = 4.0;
        this.n0i[8][4] = 11.7618;
        this.n0i[8][5] = 20.1101;
        this.n0i[8][6] = 33.1688;
        this.n0i[8][7] = 0.0;
        this.n0i[8][1] = 43.17218626;
        this.n0i[8][2] = -51198.30946;
        this.n0i[9][3] = 4.0;
        this.n0i[9][4] = 8.95043;
        this.n0i[9][5] = 21.836;
        this.n0i[9][6] = 33.4032;
        this.n0i[9][7] = 0.0;
        this.n0i[9][1] = 42.67837089;
        this.n0i[9][2] = -45215.83;
        this.n0i[10][3] = 4.0;
        this.n0i[10][4] = 11.6977;
        this.n0i[10][5] = 26.8142;
        this.n0i[10][6] = 38.6164;
        this.n0i[10][7] = 0.0;
        this.n0i[10][1] = 46.99717188;
        this.n0i[10][2] = -52746.83318;
        this.n0i[11][3] = 4.0;
        this.n0i[11][4] = 13.7266;
        this.n0i[11][5] = 30.4707;
        this.n0i[11][6] = 43.5561;
        this.n0i[11][7] = 0.0;
        this.n0i[11][1] = 52.07631631;
        this.n0i[11][2] = -57104.81056;
        this.n0i[12][3] = 4.0;
        this.n0i[12][4] = 15.6865;
        this.n0i[12][5] = 33.8029;
        this.n0i[12][6] = 48.1731;
        this.n0i[12][7] = 0.0;
        this.n0i[12][1] = 57.25830934;
        this.n0i[12][2] = -60546.76385;
        this.n0i[13][3] = 4.0;
        this.n0i[13][4] = 18.0241;
        this.n0i[13][5] = 38.1235;
        this.n0i[13][6] = 53.3415;
        this.n0i[13][7] = 0.0;
        this.n0i[13][1] = 62.09646901;
        this.n0i[13][2] = -66600.12837;
        this.n0i[14][3] = 4.0;
        this.n0i[14][4] = 21.0069;
        this.n0i[14][5] = 43.4931;
        this.n0i[14][6] = 58.3657;
        this.n0i[14][7] = 0.0;
        this.n0i[14][1] = 65.93909154;
        this.n0i[14][2] = -74131.45483;
        this.n0i[15][3] = 2.47906;
        this.n0i[15][4] = 0.95806;
        this.n0i[15][5] = 0.45444;
        this.n0i[15][6] = 1.56039;
        this.n0i[15][7] = -1.3756;
        this.n0i[15][1] = 13.07520288;
        this.n0i[15][2] = -5836.943696;
        this.n0i[16][3] = 3.50146;
        this.n0i[16][4] = 1.07558;
        this.n0i[16][5] = 1.01334;
        this.n0i[16][6] = 0.0;
        this.n0i[16][7] = 0.0;
        this.n0i[16][1] = 16.8017173;
        this.n0i[16][2] = -2318.32269;
        this.n0i[17][3] = 3.50055;
        this.n0i[17][4] = 1.02865;
        this.n0i[17][5] = 0.00493;
        this.n0i[17][6] = 0.0;
        this.n0i[17][7] = 0.0;
        this.n0i[17][1] = 17.45786899;
        this.n0i[17][2] = -2635.244116;
        this.n0i[18][3] = 4.00392;
        this.n0i[18][4] = 0.01059;
        this.n0i[18][5] = 0.98763;
        this.n0i[18][6] = 3.06904;
        this.n0i[18][7] = 0.0;
        this.n0i[18][1] = 21.57882705;
        this.n0i[18][2] = -7766.733078;
        this.n0i[19][3] = 4.0;
        this.n0i[19][4] = 3.11942;
        this.n0i[19][5] = 1.00243;
        this.n0i[19][6] = 0.0;
        this.n0i[19][7] = 0.0;
        this.n0i[19][1] = 21.5830944;
        this.n0i[19][2] = -6069.035869;
        this.n0i[20][3] = 2.5;
        this.n0i[20][4] = 0.0;
        this.n0i[20][5] = 0.0;
        this.n0i[20][6] = 0.0;
        this.n0i[20][7] = 0.0;
        this.n0i[20][1] = 10.04639507;
        this.n0i[20][2] = -745.375;
        this.n0i[21][3] = 2.5;
        this.n0i[21][4] = 0.0;
        this.n0i[21][5] = 0.0;
        this.n0i[21][6] = 0.0;
        this.n0i[21][7] = 0.0;
        this.n0i[21][1] = 10.04639507;
        this.n0i[21][2] = -745.375;
        this.th0i[1][4] = 820.659;
        this.th0i[1][5] = 178.41;
        this.th0i[1][6] = 1062.82;
        this.th0i[1][7] = 1090.53;
        this.th0i[2][4] = 662.738;
        this.th0i[2][5] = 680.562;
        this.th0i[2][6] = 1740.06;
        this.th0i[2][7] = 0.0;
        this.th0i[3][4] = 919.306;
        this.th0i[3][5] = 865.07;
        this.th0i[3][6] = 483.553;
        this.th0i[3][7] = 341.109;
        this.th0i[4][4] = 559.314;
        this.th0i[4][5] = 223.284;
        this.th0i[4][6] = 1031.38;
        this.th0i[4][7] = 1071.29;
        this.th0i[5][4] = 479.856;
        this.th0i[5][5] = 200.893;
        this.th0i[5][6] = 955.312;
        this.th0i[5][7] = 1027.29;
        this.th0i[6][4] = 438.27;
        this.th0i[6][5] = 198.018;
        this.th0i[6][6] = 1905.02;
        this.th0i[6][7] = 893.765;
        this.th0i[7][4] = 468.27;
        this.th0i[7][5] = 183.636;
        this.th0i[7][6] = 1914.1;
        this.th0i[7][7] = 903.185;
        this.th0i[8][4] = 292.503;
        this.th0i[8][5] = 910.237;
        this.th0i[8][6] = 1919.37;
        this.th0i[8][7] = 0.0;
        this.th0i[9][4] = 178.67;
        this.th0i[9][5] = 840.538;
        this.th0i[9][6] = 1774.25;
        this.th0i[9][7] = 0.0;
        this.th0i[10][4] = 182.326;
        this.th0i[10][5] = 859.207;
        this.th0i[10][6] = 1826.59;
        this.th0i[10][7] = 0.0;
        this.th0i[11][4] = 169.789;
        this.th0i[11][5] = 836.195;
        this.th0i[11][6] = 1760.46;
        this.th0i[11][7] = 0.0;
        this.th0i[12][4] = 158.922;
        this.th0i[12][5] = 815.064;
        this.th0i[12][6] = 1693.07;
        this.th0i[12][7] = 0.0;
        this.th0i[13][4] = 156.854;
        this.th0i[13][5] = 814.882;
        this.th0i[13][6] = 1693.79;
        this.th0i[13][7] = 0.0;
        this.th0i[14][4] = 164.947;
        this.th0i[14][5] = 836.264;
        this.th0i[14][6] = 1750.24;
        this.th0i[14][7] = 0.0;
        this.th0i[15][4] = 228.734;
        this.th0i[15][5] = 326.843;
        this.th0i[15][6] = 1651.71;
        this.th0i[15][7] = 1671.69;
        this.th0i[16][4] = 2235.71;
        this.th0i[16][5] = 1116.69;
        this.th0i[16][6] = 0.0;
        this.th0i[16][7] = 0.0;
        this.th0i[17][4] = 1550.45;
        this.th0i[17][5] = 704.525;
        this.th0i[17][6] = 0.0;
        this.th0i[17][7] = 0.0;
        this.th0i[18][4] = 268.795;
        this.th0i[18][5] = 1141.41;
        this.th0i[18][6] = 2507.37;
        this.th0i[18][7] = 0.0;
        this.th0i[19][4] = 1833.63;
        this.th0i[19][5] = 847.181;
        this.th0i[19][6] = 0.0;
        this.th0i[19][7] = 0.0;
        this.th0i[20][4] = 0.0;
        this.th0i[20][5] = 0.0;
        this.th0i[20][6] = 0.0;
        this.th0i[20][7] = 0.0;
        this.th0i[21][4] = 0.0;
        this.th0i[21][5] = 0.0;
        this.th0i[21][6] = 0.0;
        this.th0i[21][7] = 0.0;
        this.bvij[1][2] = 0.998721377;
        this.gvij[1][2] = 1.013950311;
        this.btij[1][2] = 0.99809883;
        this.gtij[1][2] = 0.979273013;
        this.bvij[1][3] = 0.999518072;
        this.gvij[1][3] = 1.002806594;
        this.btij[1][3] = 1.02262449;
        this.gtij[1][3] = 0.975665369;
        this.bvij[1][4] = 0.997547866;
        this.gvij[1][4] = 1.006617867;
        this.btij[1][4] = 0.996336508;
        this.gtij[1][4] = 1.049707697;
        this.bvij[1][5] = 1.00482707;
        this.gvij[1][5] = 1.038470657;
        this.btij[1][5] = 0.989680305;
        this.gtij[1][5] = 1.098655531;
        this.bvij[1][6] = 1.011240388;
        this.gvij[1][6] = 1.054319053;
        this.btij[1][6] = 0.980315756;
        this.gtij[1][6] = 1.161117729;
        this.bvij[1][7] = 0.979105972;
        this.gvij[1][7] = 1.045375122;
        this.btij[1][7] = 0.99417491;
        this.gtij[1][7] = 1.171607691;
        this.bvij[1][8] = 1.0;
        this.gvij[1][8] = 1.343685343;
        this.btij[1][8] = 1.0;
        this.gtij[1][8] = 1.188899743;
        this.bvij[1][9] = 0.94833012;
        this.gvij[1][9] = 1.124508039;
        this.btij[1][9] = 0.992127525;
        this.gtij[1][9] = 1.249173968;
        this.bvij[1][10] = 0.958015294;
        this.gvij[1][10] = 1.052643846;
        this.btij[1][10] = 0.981844797;
        this.gtij[1][10] = 1.330570181;
        this.bvij[1][11] = 0.962050831;
        this.gvij[1][11] = 1.156655935;
        this.btij[1][11] = 0.977431529;
        this.gtij[1][11] = 1.379850328;
        this.bvij[1][12] = 0.994740603;
        this.gvij[1][12] = 1.116549372;
        this.btij[1][12] = 0.957473785;
        this.gtij[1][12] = 1.449245409;
        this.bvij[1][13] = 1.002852287;
        this.gvij[1][13] = 1.141895355;
        this.btij[1][13] = 0.947716769;
        this.gtij[1][13] = 1.528532478;
        this.bvij[1][14] = 1.033086292;
        this.gvij[1][14] = 1.146089637;
        this.btij[1][14] = 0.937777823;
        this.gtij[1][14] = 1.568231489;
        this.bvij[1][15] = 1.0;
        this.gvij[1][15] = 1.018702573;
        this.btij[1][15] = 1.0;
        this.gtij[1][15] = 1.352643115;
        this.bvij[1][16] = 1.0;
        this.gvij[1][16] = 1.0;
        this.btij[1][16] = 1.0;
        this.gtij[1][16] = 0.95;
        this.bvij[1][17] = 0.997340772;
        this.gvij[1][17] = 1.006102927;
        this.btij[1][17] = 0.987411732;
        this.gtij[1][17] = 0.987473033;
        this.bvij[1][18] = 1.012783169;
        this.gvij[1][18] = 1.585018334;
        this.btij[1][18] = 1.063333913;
        this.gtij[1][18] = 0.775810513;
        this.bvij[1][19] = 1.012599087;
        this.gvij[1][19] = 1.040161207;
        this.btij[1][19] = 1.011090031;
        this.gtij[1][19] = 0.961155729;
        this.bvij[1][20] = 1.0;
        this.gvij[1][20] = 0.881405683;
        this.btij[1][20] = 1.0;
        this.gtij[1][20] = 3.159776855;
        this.bvij[1][21] = 1.034630259;
        this.gvij[1][21] = 1.014678542;
        this.btij[1][21] = 0.990954281;
        this.gtij[1][21] = 0.989843388;
        this.bvij[2][3] = 0.977794634;
        this.gvij[2][3] = 1.047578256;
        this.btij[2][3] = 1.005894529;
        this.gtij[2][3] = 1.107654104;
        this.bvij[2][4] = 0.978880168;
        this.gvij[2][4] = 1.042352891;
        this.btij[2][4] = 1.007671428;
        this.gtij[2][4] = 1.098650964;
        this.bvij[2][5] = 0.974424681;
        this.gvij[2][5] = 1.081025408;
        this.btij[2][5] = 1.002677329;
        this.gtij[2][5] = 1.201264026;
        this.bvij[2][6] = 0.98641583;
        this.gvij[2][6] = 1.100576129;
        this.btij[2][6] = 0.99286813;
        this.gtij[2][6] = 1.284462634;
        this.bvij[2][7] = 0.99608261;
        this.gvij[2][7] = 1.146949309;
        this.btij[2][7] = 0.994515234;
        this.gtij[2][7] = 1.304886838;
        this.bvij[2][8] = 1.0;
        this.gvij[2][8] = 1.154135439;
        this.btij[2][8] = 1.0;
        this.gtij[2][8] = 1.38177077;
        this.bvij[2][9] = 1.0;
        this.gvij[2][9] = 1.078877166;
        this.btij[2][9] = 1.0;
        this.gtij[2][9] = 1.419029041;
        this.bvij[2][10] = 1.0;
        this.gvij[2][10] = 1.195952177;
        this.btij[2][10] = 1.0;
        this.gtij[2][10] = 1.472607971;
        this.bvij[2][11] = 1.0;
        this.gvij[2][11] = 1.40455409;
        this.btij[2][11] = 1.0;
        this.gtij[2][11] = 1.520975334;
        this.bvij[2][12] = 1.0;
        this.gvij[2][12] = 1.186067025;
        this.btij[2][12] = 1.0;
        this.gtij[2][12] = 1.733280051;
        this.bvij[2][13] = 1.0;
        this.gvij[2][13] = 1.100405929;
        this.btij[2][13] = 0.95637945;
        this.gtij[2][13] = 1.749119996;
        this.bvij[2][14] = 1.0;
        this.gvij[2][14] = 1.0;
        this.btij[2][14] = 0.957934447;
        this.gtij[2][14] = 1.822157123;
        this.bvij[2][15] = 0.972532065;
        this.gvij[2][15] = 0.970115357;
        this.btij[2][15] = 0.946134337;
        this.gtij[2][15] = 1.175696583;
        this.bvij[2][16] = 0.99952177;
        this.gvij[2][16] = 0.997082328;
        this.btij[2][16] = 0.997190589;
        this.gtij[2][16] = 0.995157044;
        this.bvij[2][17] = 1.0;
        this.gvij[2][17] = 1.008690943;
        this.btij[2][17] = 1.0;
        this.gtij[2][17] = 0.993425388;
        this.bvij[2][18] = 1.0;
        this.gvij[2][18] = 1.094749685;
        this.btij[2][18] = 1.0;
        this.gtij[2][18] = 0.968808467;
        this.bvij[2][19] = 0.910394249;
        this.gvij[2][19] = 1.256844157;
        this.btij[2][19] = 1.004692366;
        this.gtij[2][19] = 0.9601742;
        this.bvij[2][20] = 0.969501055;
        this.gvij[2][20] = 0.932629867;
        this.btij[2][20] = 0.692868765;
        this.gtij[2][20] = 1.47183158;
        this.bvij[2][21] = 1.004166412;
        this.gvij[2][21] = 1.002212182;
        this.btij[2][21] = 0.999069843;
        this.gtij[2][21] = 0.990034831;
        this.bvij[3][4] = 1.002525718;
        this.gvij[3][4] = 1.032876701;
        this.btij[3][4] = 1.013871147;
        this.gtij[3][4] = 0.90094953;
        this.bvij[3][5] = 0.996898004;
        this.gvij[3][5] = 1.047596298;
        this.btij[3][5] = 1.033620538;
        this.gtij[3][5] = 0.908772477;
        this.bvij[3][6] = 1.076551882;
        this.gvij[3][6] = 1.081909003;
        this.btij[3][6] = 1.023339824;
        this.gtij[3][6] = 0.929982936;
        this.bvij[3][7] = 1.174760923;
        this.gvij[3][7] = 1.222437324;
        this.btij[3][7] = 1.018171004;
        this.gtij[3][7] = 0.911498231;
        this.bvij[3][8] = 1.060793104;
        this.gvij[3][8] = 1.116793198;
        this.btij[3][8] = 1.019180957;
        this.gtij[3][8] = 0.961218039;
        this.bvij[3][9] = 1.024311498;
        this.gvij[3][9] = 1.068406078;
        this.btij[3][9] = 1.027000795;
        this.gtij[3][9] = 0.979217302;
        this.bvij[3][10] = 1.0;
        this.gvij[3][10] = 0.851343711;
        this.btij[3][10] = 1.0;
        this.gtij[3][10] = 1.038675574;
        this.bvij[3][11] = 1.205469976;
        this.gvij[3][11] = 1.164585914;
        this.btij[3][11] = 1.011806317;
        this.gtij[3][11] = 1.046169823;
        this.bvij[3][12] = 1.026169373;
        this.gvij[3][12] = 1.104043935;
        this.btij[3][12] = 1.02969078;
        this.gtij[3][12] = 1.074455386;
        this.bvij[3][13] = 1.0;
        this.gvij[3][13] = 0.973386152;
        this.btij[3][13] = 1.00768862;
        this.gtij[3][13] = 1.140671202;
        this.bvij[3][14] = 1.000151132;
        this.gvij[3][14] = 1.183394668;
        this.btij[3][14] = 1.02002879;
        this.gtij[3][14] = 1.145512213;
        this.bvij[3][15] = 0.904142159;
        this.gvij[3][15] = 1.15279255;
        this.btij[3][15] = 0.942320195;
        this.gtij[3][15] = 1.782924792;
        this.bvij[3][16] = 1.0;
        this.gvij[3][16] = 1.0;
        this.btij[3][16] = 1.0;
        this.gtij[3][16] = 1.0;
        this.bvij[3][17] = 1.0;
        this.gvij[3][17] = 1.0;
        this.btij[3][17] = 1.0;
        this.gtij[3][17] = 1.0;
        this.bvij[3][18] = 0.949055959;
        this.gvij[3][18] = 1.542328793;
        this.btij[3][18] = 0.997372205;
        this.gtij[3][18] = 0.775453996;
        this.bvij[3][19] = 0.906630564;
        this.gvij[3][19] = 1.024085837;
        this.btij[3][19] = 1.016034583;
        this.gtij[3][19] = 0.92601888;
        this.bvij[3][20] = 0.846647561;
        this.gvij[3][20] = 0.864141549;
        this.btij[3][20] = 0.76837763;
        this.gtij[3][20] = 3.207456948;
        this.bvij[3][21] = 1.008392428;
        this.gvij[3][21] = 1.029205465;
        this.btij[3][21] = 0.996512863;
        this.gtij[3][21] = 1.050971635;
        this.bvij[4][5] = 0.997607277;
        this.gvij[4][5] = 1.00303472;
        this.btij[4][5] = 0.996199694;
        this.gtij[4][5] = 1.01473019;
        this.bvij[4][6] = 1.0;
        this.gvij[4][6] = 1.006616886;
        this.btij[4][6] = 1.0;
        this.gtij[4][6] = 1.033283811;
        this.bvij[4][7] = 0.999157205;
        this.gvij[4][7] = 1.006179146;
        this.btij[4][7] = 0.999130554;
        this.gtij[4][7] = 1.034832749;
        this.bvij[4][8] = 1.0;
        this.gvij[4][8] = 1.045439935;
        this.btij[4][8] = 1.0;
        this.gtij[4][8] = 1.021150247;
        this.bvij[4][9] = 0.993851009;
        this.gvij[4][9] = 1.026085655;
        this.btij[4][9] = 0.998688946;
        this.gtij[4][9] = 1.066665676;
        this.bvij[4][10] = 1.0;
        this.gvij[4][10] = 1.169701102;
        this.btij[4][10] = 1.0;
        this.gtij[4][10] = 1.092177796;
        this.bvij[4][11] = 1.0;
        this.gvij[4][11] = 1.057666085;
        this.btij[4][11] = 1.0;
        this.gtij[4][11] = 1.134532014;
        this.bvij[4][12] = 1.007469726;
        this.gvij[4][12] = 1.071917985;
        this.btij[4][12] = 0.984068272;
        this.gtij[4][12] = 1.168636194;
        this.bvij[4][13] = 1.0;
        this.gvij[4][13] = 1.14353473;
        this.btij[4][13] = 1.0;
        this.gtij[4][13] = 1.05603303;
        this.bvij[4][14] = 0.995676258;
        this.gvij[4][14] = 1.098361281;
        this.btij[4][14] = 0.970918061;
        this.gtij[4][14] = 1.237191558;
        this.bvij[4][15] = 0.925367171;
        this.gvij[4][15] = 1.10607204;
        this.btij[4][15] = 0.932969831;
        this.gtij[4][15] = 1.902008495;
        this.bvij[4][16] = 1.0;
        this.gvij[4][16] = 1.0;
        this.btij[4][16] = 1.0;
        this.gtij[4][16] = 1.0;
        this.bvij[4][17] = 1.0;
        this.gvij[4][17] = 1.201417898;
        this.btij[4][17] = 1.0;
        this.gtij[4][17] = 1.069224728;
        this.bvij[4][18] = 1.0;
        this.gvij[4][18] = 1.0;
        this.btij[4][18] = 1.0;
        this.gtij[4][18] = 1.0;
        this.bvij[4][19] = 1.010817909;
        this.gvij[4][19] = 1.030988277;
        this.btij[4][19] = 0.990197354;
        this.gtij[4][19] = 0.90273666;
        this.bvij[4][20] = 1.0;
        this.gvij[4][20] = 1.0;
        this.btij[4][20] = 1.0;
        this.gtij[4][20] = 1.0;
        this.bvij[4][21] = 1.0;
        this.gvij[4][21] = 1.0;
        this.btij[4][21] = 1.0;
        this.gtij[4][21] = 1.0;
        this.bvij[5][6] = 0.999243146;
        this.gvij[5][6] = 1.001156119;
        this.btij[5][6] = 0.998012298;
        this.gtij[5][6] = 1.005250774;
        this.bvij[5][7] = 0.999795868;
        this.gvij[5][7] = 1.003264179;
        this.btij[5][7] = 1.000310289;
        this.gtij[5][7] = 1.007392782;
        this.bvij[5][8] = 1.040459289;
        this.gvij[5][8] = 0.999432118;
        this.btij[5][8] = 0.994364425;
        this.gtij[5][8] = 1.0032695;
        this.bvij[5][9] = 1.044919431;
        this.gvij[5][9] = 1.019921513;
        this.btij[5][9] = 0.996484021;
        this.gtij[5][9] = 1.008344412;
        this.bvij[5][10] = 1.0;
        this.gvij[5][10] = 1.057872566;
        this.btij[5][10] = 1.0;
        this.gtij[5][10] = 1.025657518;
        this.bvij[5][11] = 1.0;
        this.gvij[5][11] = 1.079648053;
        this.btij[5][11] = 1.0;
        this.gtij[5][11] = 1.050044169;
        this.bvij[5][12] = 1.0;
        this.gvij[5][12] = 1.102764612;
        this.btij[5][12] = 1.0;
        this.gtij[5][12] = 1.063694129;
        this.bvij[5][13] = 1.0;
        this.gvij[5][13] = 1.199769134;
        this.btij[5][13] = 1.0;
        this.gtij[5][13] = 1.109973833;
        this.bvij[5][14] = 0.984104227;
        this.gvij[5][14] = 1.053040574;
        this.btij[5][14] = 0.985331233;
        this.gtij[5][14] = 1.140905252;
        this.bvij[5][15] = 1.0;
        this.gvij[5][15] = 1.07400611;
        this.btij[5][15] = 1.0;
        this.gtij[5][15] = 2.308215191;
        this.bvij[5][16] = 1.0;
        this.gvij[5][16] = 1.0;
        this.btij[5][16] = 1.0;
        this.gtij[5][16] = 1.0;
        this.bvij[5][17] = 1.0;
        this.gvij[5][17] = 1.108143673;
        this.btij[5][17] = 1.0;
        this.gtij[5][17] = 1.197564208;
        this.bvij[5][18] = 1.0;
        this.gvij[5][18] = 1.011759763;
        this.btij[5][18] = 1.0;
        this.gtij[5][18] = 0.600340961;
        this.bvij[5][19] = 0.936811219;
        this.gvij[5][19] = 1.010593999;
        this.btij[5][19] = 0.992573556;
        this.gtij[5][19] = 0.905829247;
        this.bvij[5][20] = 1.0;
        this.gvij[5][20] = 1.0;
        this.btij[5][20] = 1.0;
        this.gtij[5][20] = 1.0;
        this.bvij[5][21] = 1.0;
        this.gvij[5][21] = 1.0;
        this.btij[5][21] = 1.0;
        this.gtij[5][21] = 1.0;
        this.bvij[6][7] = 0.999120311;
        this.gvij[6][7] = 1.00041444;
        this.btij[6][7] = 0.999922459;
        this.gtij[6][7] = 1.001432824;
        this.bvij[6][8] = 1.0;
        this.gvij[6][8] = 1.002284353;
        this.btij[6][8] = 1.0;
        this.gtij[6][8] = 1.001835788;
        this.bvij[6][9] = 1.0;
        this.gvij[6][9] = 1.002779804;
        this.btij[6][9] = 1.0;
        this.gtij[6][9] = 1.002495889;
        this.bvij[6][10] = 1.0;
        this.gvij[6][10] = 1.010493989;
        this.btij[6][10] = 1.0;
        this.gtij[6][10] = 1.006018054;
        this.bvij[6][11] = 1.0;
        this.gvij[6][11] = 1.021668316;
        this.btij[6][11] = 1.0;
        this.gtij[6][11] = 1.00988576;
        this.bvij[6][12] = 1.0;
        this.gvij[6][12] = 1.032807063;
        this.btij[6][12] = 1.0;
        this.gtij[6][12] = 1.013945424;
        this.bvij[6][13] = 1.0;
        this.gvij[6][13] = 1.047298475;
        this.btij[6][13] = 1.0;
        this.gtij[6][13] = 1.017817492;
        this.bvij[6][14] = 1.0;
        this.gvij[6][14] = 1.060243344;
        this.btij[6][14] = 1.0;
        this.gtij[6][14] = 1.021624748;
        this.bvij[6][15] = 1.0;
        this.gvij[6][15] = 1.147595688;
        this.btij[6][15] = 1.0;
        this.gtij[6][15] = 1.895305393;
        this.bvij[6][16] = 1.0;
        this.gvij[6][16] = 1.0;
        this.btij[6][16] = 1.0;
        this.gtij[6][16] = 1.0;
        this.bvij[6][17] = 1.0;
        this.gvij[6][17] = 1.087272232;
        this.btij[6][17] = 1.0;
        this.gtij[6][17] = 1.161390082;
        this.bvij[6][18] = 1.0;
        this.gvij[6][18] = 1.0;
        this.btij[6][18] = 1.0;
        this.gtij[6][18] = 1.0;
        this.bvij[6][19] = 1.012994431;
        this.gvij[6][19] = 0.988591117;
        this.btij[6][19] = 0.974550548;
        this.gtij[6][19] = 0.937130844;
        this.bvij[6][20] = 1.0;
        this.gvij[6][20] = 1.0;
        this.btij[6][20] = 1.0;
        this.gtij[6][20] = 1.0;
        this.bvij[6][21] = 1.0;
        this.gvij[6][21] = 1.0;
        this.btij[6][21] = 1.0;
        this.gtij[6][21] = 1.0;
        this.bvij[7][8] = 1.0;
        this.gvij[7][8] = 1.002728434;
        this.btij[7][8] = 1.0;
        this.gtij[7][8] = 1.000792201;
        this.bvij[7][9] = 1.0;
        this.gvij[7][9] = 1.01815965;
        this.btij[7][9] = 1.0;
        this.gtij[7][9] = 1.00214364;
        this.bvij[7][10] = 1.0;
        this.gvij[7][10] = 1.034995284;
        this.btij[7][10] = 1.0;
        this.gtij[7][10] = 1.00915706;
        this.bvij[7][11] = 1.0;
        this.gvij[7][11] = 1.019174227;
        this.btij[7][11] = 1.0;
        this.gtij[7][11] = 1.021283378;
        this.bvij[7][12] = 1.0;
        this.gvij[7][12] = 1.046905515;
        this.btij[7][12] = 1.0;
        this.gtij[7][12] = 1.033180106;
        this.bvij[7][13] = 1.0;
        this.gvij[7][13] = 1.049219137;
        this.btij[7][13] = 1.0;
        this.gtij[7][13] = 1.014096448;
        this.bvij[7][14] = 0.976951968;
        this.gvij[7][14] = 1.027845529;
        this.btij[7][14] = 0.993688386;
        this.gtij[7][14] = 1.076466918;
        this.bvij[7][15] = 1.0;
        this.gvij[7][15] = 1.232939523;
        this.btij[7][15] = 1.0;
        this.gtij[7][15] = 2.509259945;
        this.bvij[7][16] = 1.0;
        this.gvij[7][16] = 1.0;
        this.btij[7][16] = 1.0;
        this.gtij[7][16] = 1.0;
        this.bvij[7][17] = 1.0;
        this.gvij[7][17] = 1.084740904;
        this.btij[7][17] = 1.0;
        this.gtij[7][17] = 1.173916162;
        this.bvij[7][18] = 1.0;
        this.gvij[7][18] = 1.223638763;
        this.btij[7][18] = 1.0;
        this.gtij[7][18] = 0.615512682;
        this.bvij[7][19] = 0.908113163;
        this.gvij[7][19] = 1.033366041;
        this.btij[7][19] = 0.985962886;
        this.gtij[7][19] = 0.926156602;
        this.bvij[7][20] = 1.0;
        this.gvij[7][20] = 1.0;
        this.btij[7][20] = 1.0;
        this.gtij[7][20] = 1.0;
        this.bvij[7][21] = 1.0;
        this.gvij[7][21] = 1.214638734;
        this.btij[7][21] = 1.0;
        this.gtij[7][21] = 1.245039498;
        this.bvij[8][9] = 1.0;
        this.gvij[8][9] = 1.000024335;
        this.btij[8][9] = 1.0;
        this.gtij[8][9] = 1.000050537;
        this.bvij[8][10] = 1.0;
        this.gvij[8][10] = 1.002995876;
        this.btij[8][10] = 1.0;
        this.gtij[8][10] = 1.001204174;
        this.bvij[8][11] = 1.0;
        this.gvij[8][11] = 1.009928206;
        this.btij[8][11] = 1.0;
        this.gtij[8][11] = 1.003194615;
        this.bvij[8][12] = 1.0;
        this.gvij[8][12] = 1.017880545;
        this.btij[8][12] = 1.0;
        this.gtij[8][12] = 1.00564748;
        this.bvij[8][13] = 1.0;
        this.gvij[8][13] = 1.028994325;
        this.btij[8][13] = 1.0;
        this.gtij[8][13] = 1.008191499;
        this.bvij[8][14] = 1.0;
        this.gvij[8][14] = 1.039372957;
        this.btij[8][14] = 1.0;
        this.gtij[8][14] = 1.010825138;
        this.bvij[8][15] = 1.0;
        this.gvij[8][15] = 1.184340443;
        this.btij[8][15] = 1.0;
        this.gtij[8][15] = 1.996386669;
        this.bvij[8][16] = 1.0;
        this.gvij[8][16] = 1.0;
        this.btij[8][16] = 1.0;
        this.gtij[8][16] = 1.0;
        this.bvij[8][17] = 1.0;
        this.gvij[8][17] = 1.116694577;
        this.btij[8][17] = 1.0;
        this.gtij[8][17] = 1.199326059;
        this.bvij[8][18] = 1.0;
        this.gvij[8][18] = 1.0;
        this.btij[8][18] = 1.0;
        this.gtij[8][18] = 1.0;
        this.bvij[8][19] = 1.0;
        this.gvij[8][19] = 0.835763343;
        this.btij[8][19] = 1.0;
        this.gtij[8][19] = 0.982651529;
        this.bvij[8][20] = 1.0;
        this.gvij[8][20] = 1.0;
        this.btij[8][20] = 1.0;
        this.gtij[8][20] = 1.0;
        this.bvij[8][21] = 1.0;
        this.gvij[8][21] = 1.0;
        this.btij[8][21] = 1.0;
        this.gtij[8][21] = 1.0;
        this.bvij[9][10] = 1.0;
        this.gvij[9][10] = 1.002480637;
        this.btij[9][10] = 1.0;
        this.gtij[9][10] = 1.000761237;
        this.bvij[9][11] = 1.0;
        this.gvij[9][11] = 1.008972412;
        this.btij[9][11] = 1.0;
        this.gtij[9][11] = 1.002441051;
        this.bvij[9][12] = 1.0;
        this.gvij[9][12] = 1.069223964;
        this.btij[9][12] = 1.0;
        this.gtij[9][12] = 1.016422347;
        this.bvij[9][13] = 1.0;
        this.gvij[9][13] = 1.034910633;
        this.btij[9][13] = 1.0;
        this.gtij[9][13] = 1.103421755;
        this.bvij[9][14] = 1.0;
        this.gvij[9][14] = 1.016370338;
        this.btij[9][14] = 1.0;
        this.gtij[9][14] = 1.049035838;
        this.bvij[9][15] = 1.0;
        this.gvij[9][15] = 1.188334783;
        this.btij[9][15] = 1.0;
        this.gtij[9][15] = 2.013859174;
        this.bvij[9][16] = 1.0;
        this.gvij[9][16] = 1.0;
        this.btij[9][16] = 1.0;
        this.gtij[9][16] = 1.0;
        this.bvij[9][17] = 1.0;
        this.gvij[9][17] = 1.119954454;
        this.btij[9][17] = 1.0;
        this.gtij[9][17] = 1.206043295;
        this.bvij[9][18] = 1.0;
        this.gvij[9][18] = 0.95667731;
        this.btij[9][18] = 1.0;
        this.gtij[9][18] = 0.447666011;
        this.bvij[9][19] = 0.984613203;
        this.gvij[9][19] = 1.076539234;
        this.btij[9][19] = 0.962006651;
        this.gtij[9][19] = 0.959065662;
        this.bvij[9][20] = 1.0;
        this.gvij[9][20] = 1.0;
        this.btij[9][20] = 1.0;
        this.gtij[9][20] = 1.0;
        this.bvij[9][21] = 1.0;
        this.gvij[9][21] = 1.0;
        this.btij[9][21] = 1.0;
        this.gtij[9][21] = 1.0;
        this.bvij[10][11] = 1.0;
        this.gvij[10][11] = 1.001508227;
        this.btij[10][11] = 1.0;
        this.gtij[10][11] = 0.999762786;
        this.bvij[10][12] = 1.0;
        this.gvij[10][12] = 1.006268954;
        this.btij[10][12] = 1.0;
        this.gtij[10][12] = 1.001633952;
        this.bvij[10][13] = 1.0;
        this.gvij[10][13] = 1.02076168;
        this.btij[10][13] = 1.0;
        this.gtij[10][13] = 1.055369591;
        this.bvij[10][14] = 1.001516371;
        this.gvij[10][14] = 1.013511439;
        this.btij[10][14] = 0.99764101;
        this.gtij[10][14] = 1.028939539;
        this.bvij[10][15] = 1.0;
        this.gvij[10][15] = 1.243461678;
        this.btij[10][15] = 1.0;
        this.gtij[10][15] = 3.021197546;
        this.bvij[10][16] = 1.0;
        this.gvij[10][16] = 1.0;
        this.btij[10][16] = 1.0;
        this.gtij[10][16] = 1.0;
        this.bvij[10][17] = 1.0;
        this.gvij[10][17] = 1.155145836;
        this.btij[10][17] = 1.0;
        this.gtij[10][17] = 1.233272781;
        this.bvij[10][18] = 1.0;
        this.gvij[10][18] = 1.170217596;
        this.btij[10][18] = 1.0;
        this.gtij[10][18] = 0.569681333;
        this.bvij[10][19] = 0.754473958;
        this.gvij[10][19] = 1.339283552;
        this.btij[10][19] = 0.985891113;
        this.gtij[10][19] = 0.956075596;
        this.bvij[10][20] = 1.0;
        this.gvij[10][20] = 1.0;
        this.btij[10][20] = 1.0;
        this.gtij[10][20] = 1.0;
        this.bvij[10][21] = 1.0;
        this.gvij[10][21] = 1.0;
        this.btij[10][21] = 1.0;
        this.gtij[10][21] = 1.0;
        this.bvij[11][12] = 1.0;
        this.gvij[11][12] = 1.006767176;
        this.btij[11][12] = 1.0;
        this.gtij[11][12] = 0.998793111;
        this.bvij[11][13] = 1.0;
        this.gvij[11][13] = 1.001370076;
        this.btij[11][13] = 1.0;
        this.gtij[11][13] = 1.001150096;
        this.bvij[11][14] = 1.0;
        this.gvij[11][14] = 1.002972346;
        this.btij[11][14] = 1.0;
        this.gtij[11][14] = 1.002229938;
        this.bvij[11][15] = 1.0;
        this.gvij[11][15] = 1.159131722;
        this.btij[11][15] = 1.0;
        this.gtij[11][15] = 3.169143057;
        this.bvij[11][16] = 1.0;
        this.gvij[11][16] = 1.0;
        this.btij[11][16] = 1.0;
        this.gtij[11][16] = 1.0;
        this.bvij[11][17] = 1.0;
        this.gvij[11][17] = 1.190354273;
        this.btij[11][17] = 1.0;
        this.gtij[11][17] = 1.256123503;
        this.bvij[11][18] = 1.0;
        this.gvij[11][18] = 1.0;
        this.btij[11][18] = 1.0;
        this.gtij[11][18] = 1.0;
        this.bvij[11][19] = 0.828967164;
        this.gvij[11][19] = 1.087956749;
        this.btij[11][19] = 0.988937417;
        this.gtij[11][19] = 1.013453092;
        this.bvij[11][20] = 1.0;
        this.gvij[11][20] = 1.0;
        this.btij[11][20] = 1.0;
        this.gtij[11][20] = 1.0;
        this.bvij[11][21] = 1.0;
        this.gvij[11][21] = 1.0;
        this.btij[11][21] = 1.0;
        this.gtij[11][21] = 1.0;
        this.bvij[12][13] = 1.0;
        this.gvij[12][13] = 1.001357085;
        this.btij[12][13] = 1.0;
        this.gtij[12][13] = 1.000235044;
        this.bvij[12][14] = 1.0;
        this.gvij[12][14] = 1.002553544;
        this.btij[12][14] = 1.0;
        this.gtij[12][14] = 1.007186267;
        this.bvij[12][15] = 1.0;
        this.gvij[12][15] = 1.305249405;
        this.btij[12][15] = 1.0;
        this.gtij[12][15] = 2.191555216;
        this.bvij[12][16] = 1.0;
        this.gvij[12][16] = 1.0;
        this.btij[12][16] = 1.0;
        this.gtij[12][16] = 1.0;
        this.bvij[12][17] = 1.0;
        this.gvij[12][17] = 1.219206702;
        this.btij[12][17] = 1.0;
        this.gtij[12][17] = 1.276565536;
        this.bvij[12][18] = 1.0;
        this.gvij[12][18] = 0.599484191;
        this.btij[12][18] = 1.0;
        this.gtij[12][18] = 0.662072469;
        this.bvij[12][19] = 1.0;
        this.gvij[12][19] = 1.0;
        this.btij[12][19] = 1.0;
        this.gtij[12][19] = 1.0;
        this.bvij[12][20] = 1.0;
        this.gvij[12][20] = 1.0;
        this.btij[12][20] = 1.0;
        this.gtij[12][20] = 1.0;
        this.bvij[12][21] = 1.0;
        this.gvij[12][21] = 1.0;
        this.btij[12][21] = 1.0;
        this.gtij[12][21] = 1.0;
        this.bvij[13][14] = 1.0;
        this.gvij[13][14] = 1.00081052;
        this.btij[13][14] = 1.0;
        this.gtij[13][14] = 1.000182392;
        this.bvij[13][15] = 1.0;
        this.gvij[13][15] = 1.342647661;
        this.btij[13][15] = 1.0;
        this.gtij[13][15] = 2.23435404;
        this.bvij[13][16] = 1.0;
        this.gvij[13][16] = 1.0;
        this.btij[13][16] = 1.0;
        this.gtij[13][16] = 1.0;
        this.bvij[13][17] = 1.0;
        this.gvij[13][17] = 1.252151449;
        this.btij[13][17] = 1.0;
        this.gtij[13][17] = 1.294070556;
        this.bvij[13][18] = 1.0;
        this.gvij[13][18] = 1.0;
        this.btij[13][18] = 1.0;
        this.gtij[13][18] = 1.0;
        this.bvij[13][19] = 1.0;
        this.gvij[13][19] = 1.082905109;
        this.btij[13][19] = 1.0;
        this.gtij[13][19] = 1.086557826;
        this.bvij[13][20] = 1.0;
        this.gvij[13][20] = 1.0;
        this.btij[13][20] = 1.0;
        this.gtij[13][20] = 1.0;
        this.bvij[13][21] = 1.0;
        this.gvij[13][21] = 1.0;
        this.btij[13][21] = 1.0;
        this.gtij[13][21] = 1.0;
        this.bvij[14][15] = 1.695358382;
        this.gvij[14][15] = 1.120233729;
        this.btij[14][15] = 1.064818089;
        this.gtij[14][15] = 3.786003724;
        this.bvij[14][16] = 1.0;
        this.gvij[14][16] = 1.0;
        this.btij[14][16] = 1.0;
        this.gtij[14][16] = 1.0;
        this.bvij[14][17] = 1.0;
        this.gvij[14][17] = 0.87018496;
        this.btij[14][17] = 1.049594632;
        this.gtij[14][17] = 1.803567587;
        this.bvij[14][18] = 1.0;
        this.gvij[14][18] = 0.551405318;
        this.btij[14][18] = 0.897162268;
        this.gtij[14][18] = 0.740416402;
        this.bvij[14][19] = 0.975187766;
        this.gvij[14][19] = 1.171714677;
        this.btij[14][19] = 0.973091413;
        this.gtij[14][19] = 1.103693489;
        this.bvij[14][20] = 1.0;
        this.gvij[14][20] = 1.0;
        this.btij[14][20] = 1.0;
        this.gtij[14][20] = 1.0;
        this.bvij[14][21] = 1.0;
        this.gvij[14][21] = 1.0;
        this.btij[14][21] = 1.0;
        this.gtij[14][21] = 1.0;
        this.bvij[15][16] = 1.0;
        this.gvij[15][16] = 1.0;
        this.btij[15][16] = 1.0;
        this.gtij[15][16] = 1.0;
        this.bvij[15][17] = 1.0;
        this.gvij[15][17] = 1.121416201;
        this.btij[15][17] = 1.0;
        this.gtij[15][17] = 1.377504607;
        this.bvij[15][18] = 1.0;
        this.gvij[15][18] = 1.0;
        this.btij[15][18] = 1.0;
        this.gtij[15][18] = 1.0;
        this.bvij[15][19] = 1.0;
        this.gvij[15][19] = 1.0;
        this.btij[15][19] = 1.0;
        this.gtij[15][19] = 1.0;
        this.bvij[15][20] = 1.0;
        this.gvij[15][20] = 1.0;
        this.btij[15][20] = 1.0;
        this.gtij[15][20] = 1.0;
        this.bvij[15][21] = 1.0;
        this.gvij[15][21] = 1.0;
        this.btij[15][21] = 1.0;
        this.gtij[15][21] = 1.0;
        this.bvij[16][17] = 1.0;
        this.gvij[16][17] = 1.0;
        this.btij[16][17] = 1.0;
        this.gtij[16][17] = 1.0;
        this.bvij[16][18] = 1.0;
        this.gvij[16][18] = 1.143174289;
        this.btij[16][18] = 1.0;
        this.gtij[16][18] = 0.964767932;
        this.bvij[16][19] = 1.0;
        this.gvij[16][19] = 1.0;
        this.btij[16][19] = 1.0;
        this.gtij[16][19] = 1.0;
        this.bvij[16][20] = 1.0;
        this.gvij[16][20] = 1.0;
        this.btij[16][20] = 1.0;
        this.gtij[16][20] = 1.0;
        this.bvij[16][21] = 0.999746847;
        this.gvij[16][21] = 0.993907223;
        this.btij[16][21] = 1.000023103;
        this.gtij[16][21] = 0.990430423;
        this.bvij[17][18] = 1.0;
        this.gvij[17][18] = 1.0;
        this.btij[17][18] = 1.0;
        this.gtij[17][18] = 1.0;
        this.bvij[17][19] = 0.795660392;
        this.gvij[17][19] = 1.101731308;
        this.btij[17][19] = 1.025536736;
        this.gtij[17][19] = 1.022749748;
        this.bvij[17][20] = 1.0;
        this.gvij[17][20] = 1.0;
        this.btij[17][20] = 1.0;
        this.gtij[17][20] = 1.0;
        this.bvij[17][21] = 1.0;
        this.gvij[17][21] = 1.159720623;
        this.btij[17][21] = 1.0;
        this.gtij[17][21] = 0.954215746;
        this.bvij[18][19] = 1.0;
        this.gvij[18][19] = 1.014832832;
        this.btij[18][19] = 1.0;
        this.gtij[18][19] = 0.940587083;
        this.bvij[18][20] = 1.0;
        this.gvij[18][20] = 1.0;
        this.btij[18][20] = 1.0;
        this.gtij[18][20] = 1.0;
        this.bvij[18][21] = 1.0;
        this.gvij[18][21] = 1.038993495;
        this.btij[18][21] = 1.0;
        this.gtij[18][21] = 1.070941866;
        this.bvij[19][20] = 1.0;
        this.gvij[19][20] = 1.0;
        this.btij[19][20] = 1.0;
        this.gtij[19][20] = 1.0;
        this.bvij[19][21] = 1.0;
        this.gvij[19][21] = 1.0;
        this.btij[19][21] = 1.0;
        this.gtij[19][21] = 1.0;
        this.bvij[20][21] = 1.0;
        this.gvij[20][21] = 1.0;
        this.btij[20][21] = 1.0;
        this.gtij[20][21] = 1.0;
        for (i = 1; i <= this.MaxFlds; ++i) {
            this.bvij[i][i] = 1.0;
            this.btij[i][i] = 1.0;
            this.gvij[i][i] = 1.0 / this.Dc[i];
            this.gtij[i][i] = this.Tc[i];
            for (j = i + 1; j <= this.MaxFlds; ++j) {
                this.gvij[i][j] = this.gvij[i][j] * this.bvij[i][j] * Math.pow(this.Vc3[i] + this.Vc3[j], 3.0);
                this.gtij[i][j] = this.gtij[i][j] * this.btij[i][j] * this.Tc2[i] * this.Tc2[j];
                this.bvij[i][j] = Math.pow(this.bvij[i][j], 2.0);
                this.btij[i][j] = Math.pow(this.btij[i][j], 2.0);
            }
        }
        for (i = 1; i <= this.MaxMdl; ++i) {
            for (j = 1; j <= this.MaxTrmM; ++j) {
                this.gijk[i][j] = -this.cijk[i][j] * Math.pow(this.eijk[i][j], 2.0) + bijk[i][j] * this.gijk[i][j];
                this.eijk[i][j] = 2.0 * this.cijk[i][j] * this.eijk[i][j] - bijk[i][j];
                this.cijk[i][j] = -this.cijk[i][j];
            }
        }
        double T0 = 298.15;
        double d0 = 101.325 / this.RGERG / T0;
        for (i = 1; i <= this.MaxFlds; ++i) {
            this.n0i[i][3] = this.n0i[i][3] - 1.0;
            this.n0i[i][2] = this.n0i[i][2] + T0;
            for (j = 1; j <= 7; ++j) {
                this.n0i[i][j] = Rsr * this.n0i[i][j];
            }
            this.n0i[i][2] = this.n0i[i][2] - T0;
            this.n0i[i][1] = this.n0i[i][1] - Math.log(d0);
        }
    }

    public static void main(String[] args) {
        GERG2008 test = new GERG2008();
        test.SetupGERG();
        double T = 400.0;
        doubleW D = new doubleW(12.79828626082062);
        doubleW P = new doubleW(50000.0);
        intW ierr = new intW(0);
        doubleW Mm = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        int iFlag = 0;
        StringW herr = new StringW("");
        double[] x = new double[]{0.0, 0.77824, 0.02, 0.06, 0.08, 0.03, 0.0015, 0.003, 5.0E-4, 0.00165, 0.00215, 8.8E-4, 2.4E-4, 1.5E-4, 9.0E-5, 0.004, 0.005, 0.002, 1.0E-4, 0.0025, 0.007, 0.001};
        test.MolarMassGERG(x, Mm);
        test.PressureGERG(T, D.val, x, P, Z);
        System.out.println("pressure " + P.val);
        System.out.println("Z " + Z.val);
        test.DensityGERG(iFlag, T, P.val, x, D, ierr, herr);
        System.out.println("density " + D.val);
        doubleW dPdD = new doubleW(0.0);
        doubleW d2PdD2 = new doubleW(0.0);
        doubleW d2PdTD = new doubleW(0.0);
        doubleW dPdT = new doubleW(0.0);
        doubleW U = new doubleW(0.0);
        doubleW H = new doubleW(0.0);
        doubleW S = new doubleW(0.0);
        doubleW A = new doubleW(0.0);
        doubleW P2 = new doubleW(0.0);
        doubleW Cv = new doubleW(0.0);
        doubleW Cp = new doubleW(0.0);
        doubleW W = new doubleW(0.0);
        doubleW G = new doubleW(0.0);
        doubleW JT = new doubleW(0.0);
        doubleW Kappa = new doubleW(0.0);
        doubleW PP = new doubleW(0.0);
        test.PropertiesGERG(T, D.val, x, P, Z, dPdD, d2PdD2, d2PdTD, dPdT, U, H, S, Cv, Cp, W, G, JT, Kappa, A);
        System.out.println("Outputs-----\n");
        System.out.println("Molar mass [g/mol]:                 20.54274450160000 != %0.16g\n" + Mm.val);
        System.out.println("Molar density [mol/l]:              12.79828626082062 != %0.16g\n" + D.val);
        System.out.println("Pressure [kPa]:                     50000.00000000001 != %0.16g\n" + P.val);
        System.out.println("Compressibility factor:             1.174690666383717 != %0.16g\n" + Z.val);
        System.out.println("d(P)/d(rho) [kPa/(mol/l)]:          7000.694030193327 != %0.16g\n" + dPdD.val);
        System.out.println("d^2(P)/d(rho)^2 [kPa/(mol/l)^2]:    1130.481239114938 != %0.16g\n" + d2PdD2.val);
        System.out.println("d(P)/d(T) [kPa/K]:                  235.9832292593096 != %0.16g\n" + dPdT.val);
        System.out.println("Energy [J/mol]:                     -2746.492901212530 != %0.16g\n" + U.val);
        System.out.println("Enthalpy [J/mol]:                   1160.280160510973 != %0.16g\n" + H.val);
        System.out.println("Entropy [J/mol-K]:                  -38.57590392409089 != %0.16g\n" + S.val);
        System.out.println("Isochoric heat capacity [J/mol-K]:  39.02948218156372 != %0.16g\n" + Cv.val);
        System.out.println("Isobaric heat capacity [J/mol-K]:   58.45522051000366 != %0.16g\n" + Cp.val);
        System.out.println("Speed of sound [m/s]:               714.4248840596024 != %0.16g\n" + W.val);
        System.out.println("Gibbs energy [J/mol]:               16590.64173014733 != %0.16g\n" + G.val);
        System.out.println("Joule-Thomson coefficient [K/kPa]:  7.155629581480913E-05 != %0.16g\n" + JT.val);
        System.out.println("Isentropic exponent:                2.683820255058032 != %0.16g\n" + Kappa.val);
    }
}

