/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.gerg;

import neqsim.thermo.phase.PhaseInterface;
import neqsim.thermo.system.SystemSrkEos;
import neqsim.thermo.util.gerg.DETAIL;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import org.netlib.util.StringW;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class NeqSimAGA8Detail {
    double[] normalizedGERGComposition = new double[22];
    double[] notNormalizedGERGComposition = new double[22];
    PhaseInterface phase = null;
    DETAIL DETAIL = new DETAIL();

    public NeqSimAGA8Detail() {
    }

    public NeqSimAGA8Detail(PhaseInterface phase) {
        this.setPhase(phase);
        if (Double.isNaN(this.DETAIL.RDetail) || this.DETAIL.RDetail == 0.0) {
            this.DETAIL.SetupDetail();
        }
    }

    public double getMolarDensity(PhaseInterface phase) {
        this.setPhase(phase);
        return this.getMolarDensity();
    }

    public double getDensity(PhaseInterface phase) {
        this.setPhase(phase);
        return this.getMolarDensity() * phase.getMolarMass() * 1000.0;
    }

    public double getDensity() {
        return this.getMolarDensity() * this.phase.getMolarMass() * 1000.0;
    }

    public double getPressure() {
        double moldens = this.getMolarDensity();
        doubleW P = new doubleW(0.0);
        doubleW Z = new doubleW(0.0);
        this.DETAIL.PressureDetail(this.phase.getTemperature(), moldens, this.normalizedGERGComposition, P, Z);
        return P.val;
    }

    public double getMolarMass() {
        doubleW mm = new doubleW(0.0);
        this.DETAIL.MolarMassDetail(this.normalizedGERGComposition, mm);
        return mm.val / 1000.0;
    }

    public double getMolarDensity() {
        intW ierr = new intW(0);
        StringW herr = new StringW("");
        doubleW D = new doubleW(0.0);
        double pressure = this.phase.getPressure() * 100.0;
        this.DETAIL.DensityDetail(this.phase.getTemperature(), pressure, this.normalizedGERGComposition, D, ierr, herr);
        return D.val;
    }

    public double[] propertiesDetail(PhaseInterface phase) {
        this.setPhase(phase);
        return this.propertiesDetail();
    }

    public double[] getProperties(PhaseInterface phase, String[] properties) {
        double[] allProperties = this.propertiesDetail();
        double[] returnProperties = new double[properties.length];
        block12: for (int i = 0; i < properties.length; ++i) {
            switch (properties[i]) {
                case "density": {
                    returnProperties[i] = allProperties[0];
                    continue block12;
                }
                case "Cp": {
                    returnProperties[i] = allProperties[1];
                    continue block12;
                }
                case "Cv": {
                    returnProperties[i] = allProperties[2];
                    continue block12;
                }
                case "soundSpeed": {
                    returnProperties[i] = allProperties[3];
                }
            }
        }
        return returnProperties;
    }

    public double[] propertiesDetail() {
        doubleW p = new doubleW(0.0);
        doubleW z = new doubleW(0.0);
        doubleW dpdd = new doubleW(0.0);
        doubleW d2pdd2 = new doubleW(0.0);
        doubleW d2pdtd = new doubleW(0.0);
        doubleW dpdt = new doubleW(0.0);
        doubleW u = new doubleW(0.0);
        doubleW h = new doubleW(0.0);
        doubleW s = new doubleW(0.0);
        doubleW cv = new doubleW(0.0);
        doubleW cp = new doubleW(0.0);
        doubleW w = new doubleW(0.0);
        doubleW g = new doubleW(0.0);
        doubleW jt = new doubleW(0.0);
        doubleW kappa = new doubleW(0.0);
        double dens = this.getMolarDensity();
        this.DETAIL.PropertiesDetail(this.phase.getTemperature(), dens, this.normalizedGERGComposition, p, z, dpdd, d2pdd2, d2pdtd, dpdt, u, h, s, cv, cp, w, g, jt, kappa);
        double[] properties = new double[]{p.val, z.val, dpdd.val, d2pdd2.val, d2pdtd.val, dpdt.val, u.val, h.val, s.val, cv.val, cp.val, w.val, g.val, jt.val, kappa.val};
        return properties;
    }

    public void setPhase(PhaseInterface phase) {
        this.phase = phase;
        block46: for (int i = 0; i < phase.getNumberOfComponents(); ++i) {
            String componentName;
            switch (componentName = phase.getComponent(i).getComponentName()) {
                case "methane": {
                    this.notNormalizedGERGComposition[1] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "nitrogen": {
                    this.notNormalizedGERGComposition[2] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "CO2": {
                    this.notNormalizedGERGComposition[3] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "ethane": {
                    this.notNormalizedGERGComposition[4] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "propane": {
                    this.notNormalizedGERGComposition[5] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "i-butane": {
                    this.notNormalizedGERGComposition[6] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "n-butane": {
                    this.notNormalizedGERGComposition[7] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "i-pentane": {
                    this.notNormalizedGERGComposition[8] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "n-pentane": {
                    this.notNormalizedGERGComposition[9] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "n-hexane": {
                    this.notNormalizedGERGComposition[10] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "n-heptane": {
                    this.notNormalizedGERGComposition[11] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "n-octane": {
                    this.notNormalizedGERGComposition[12] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "n-nonane": {
                    this.notNormalizedGERGComposition[13] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "nC10": {
                    this.notNormalizedGERGComposition[14] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "hydrogen": {
                    this.notNormalizedGERGComposition[15] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "oxygen": {
                    this.notNormalizedGERGComposition[16] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "CO": {
                    this.notNormalizedGERGComposition[17] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "water": {
                    this.notNormalizedGERGComposition[18] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "H2S": {
                    this.notNormalizedGERGComposition[19] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "helium": {
                    this.notNormalizedGERGComposition[20] = phase.getComponent(i).getx();
                    continue block46;
                }
                case "argon": {
                    this.notNormalizedGERGComposition[21] = phase.getComponent(i).getx();
                    continue block46;
                }
                default: {
                    double molarMass = phase.getComponent(i).getMolarMass();
                    if (molarMass > 0.044096759796142006 && molarMass < 0.0581236991882324) {
                        this.notNormalizedGERGComposition[7] = this.notNormalizedGERGComposition[7] + phase.getComponent(i).getx();
                    }
                    if (molarMass > 0.0581236991882324 && molarMass < 0.07215064) {
                        this.notNormalizedGERGComposition[8] = this.notNormalizedGERGComposition[8] + phase.getComponent(i).getx();
                    }
                    if (molarMass > 0.07215064 && molarMass < 0.0862) {
                        this.notNormalizedGERGComposition[10] = this.notNormalizedGERGComposition[10] + phase.getComponent(i).getx();
                    }
                    if (molarMass > 0.0862 && molarMass < 0.10020449829101599) {
                        this.notNormalizedGERGComposition[11] = this.notNormalizedGERGComposition[11] + phase.getComponent(i).getx();
                    }
                    if (molarMass > 0.10020449829101599 && molarMass < 0.107) {
                        this.notNormalizedGERGComposition[12] = this.notNormalizedGERGComposition[12] + phase.getComponent(i).getx();
                    }
                    if (molarMass > 0.107 && molarMass < 0.121) {
                        this.notNormalizedGERGComposition[13] = this.notNormalizedGERGComposition[13] + phase.getComponent(i).getx();
                    }
                    if (!(molarMass > 0.121)) continue block46;
                    this.notNormalizedGERGComposition[14] = this.notNormalizedGERGComposition[14] + phase.getComponent(i).getx();
                }
            }
        }
        this.normalizeComposition();
    }

    public void normalizeComposition() {
        double result = 0.0;
        for (double value : this.notNormalizedGERGComposition) {
            result += value;
        }
        for (int k = 0; k < this.normalizedGERGComposition.length; ++k) {
            this.normalizedGERGComposition[k] = this.notNormalizedGERGComposition[k] / result;
        }
    }

    public static void main(String[] args) {
        SystemSrkEos fluid1 = new SystemSrkEos();
        fluid1.addComponent("methane", 90.0);
        fluid1.addComponent("hydrogen", 10.0);
        fluid1.setTemperature(293.15);
        fluid1.setPressure(50.0);
        fluid1.init(0);
        ThermodynamicOperations ops = new ThermodynamicOperations(fluid1);
        ops.TPflash();
        System.out.println("density GERG2008 Detail " + fluid1.getPhase(0).getDensity_GERG2008());
        System.out.println("density AGA8 Detail " + fluid1.getPhase(0).getDensity_AGA8());
        NeqSimAGA8Detail test = new NeqSimAGA8Detail(fluid1.getPhase("gas"));
        System.out.println("density " + test.getDensity());
        System.out.println("pressure " + test.getPressure());
        double[] properties = test.propertiesDetail();
        System.out.println("Pressure [kPa]:            " + properties[0]);
        System.out.println("Compressibility factor:            " + properties[1]);
        System.out.println("d(P)/d(rho) [kPa/(mol/l)]            " + properties[2]);
        System.out.println("d^2(P)/d(rho)^2 [kPa/(mol/l)^2]:            " + properties[3]);
        System.out.println("d2(P)/d2(T) [kPa/K]:             " + properties[4]);
        System.out.println("d(P)/d(T) [kPa/K]:             " + properties[5]);
        System.out.println("Energy [J/mol]:             " + properties[6]);
        System.out.println("Enthalpy [J/mol]:             " + properties[7]);
        System.out.println("Entropy [J/mol-K]:             " + properties[8]);
        System.out.println("Isochoric heat capacity [J/mol-K]:             " + properties[9]);
        System.out.println("Isobaric heat capacity [J/mol-K]:            " + properties[10]);
        System.out.println("Speed of sound [m/s]:            " + properties[11]);
        System.out.println("Gibbs energy [J/mol]:            " + properties[12]);
        System.out.println("Joule-Thomson coefficient [K/kPa]:            " + properties[13]);
        System.out.println("Isentropic exponent:           " + properties[14]);
    }
}

