/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.readwrite;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Arrays;
import neqsim.thermo.phase.PhaseEosInterface;
import neqsim.thermo.system.SystemEos;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermo.system.SystemPrEos;
import neqsim.thermo.system.SystemPrEos1978;
import neqsim.thermo.system.SystemSrkEos;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EclipseFluidReadWrite {
    static Logger logger = LogManager.getLogger(EclipseFluidReadWrite.class);
    public static String pseudoName = "";

    public static void setComposition(SystemInterface fluid, String inputFile, String pseudoNameIn) {
        pseudoName = pseudoNameIn;
        EclipseFluidReadWrite.setComposition(fluid, inputFile);
    }

    public static void setComposition(SystemInterface fluid, String inputFile) {
        fluid.setEmptyFluid();
        try (BufferedReader br = new BufferedReader(new FileReader(new File(inputFile)));){
            String st;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Double> ZI = new ArrayList<Double>();
            while ((st = br.readLine()) != null) {
                if (st.equals("CNAMES")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                        names.add(st);
                    }
                }
                if (!st.equals("ZI")) continue;
                while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--")) {
                    ZI.add(Double.parseDouble(st));
                }
            }
            for (int counter = 0; counter < names.size(); ++counter) {
                String name = (String)names.get(counter);
                if (name.equals("C1")) {
                    name = "methane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C2")) {
                    name = "ethane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("N2")) {
                    name = "nitrogen";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("iC4")) {
                    name = "i-butane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C4")) {
                    name = "n-butane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("iC5")) {
                    name = "i-pentane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C5")) {
                    name = "n-pentane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C6")) {
                    name = "n-hexane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("C3")) {
                    name = "propane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                if (name.equals("CO2")) {
                    name = "CO2";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                    continue;
                }
                fluid.addComponent(name + pseudoName, (double)((Double)ZI.get(counter)));
            }
        }
        catch (RuntimeException ex) {
            logger.error(ex.getMessage());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage());
        }
    }

    public static SystemInterface read(String inputFile, String pseudoNameIn) {
        pseudoName = pseudoNameIn;
        return EclipseFluidReadWrite.read(inputFile);
    }

    public static SystemInterface read(String inputFile) {
        SystemEos fluid = new SystemSrkEos(288.15, 1.01325);
        double[][] kij = null;
        try (BufferedReader br = new BufferedReader(new FileReader(new File(inputFile)));){
            String st;
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Double> TC = new ArrayList<Double>();
            ArrayList<Double> PC = new ArrayList<Double>();
            ArrayList<Double> ACF = new ArrayList<Double>();
            ArrayList<Double> MW = new ArrayList<Double>();
            ArrayList<Double> SSHIFT = new ArrayList<Double>();
            ArrayList<Double> SSHIFTS = new ArrayList<Double>();
            ArrayList<Double> TBOIL = new ArrayList<Double>();
            ArrayList<Double> VCRIT = new ArrayList<Double>();
            ArrayList<Double> PARACHOR = new ArrayList<Double>();
            ArrayList<Double> ZI = new ArrayList<Double>();
            ArrayList<Double> BIC = new ArrayList<Double>();
            while ((st = br.readLine()) != null) {
                String line;
                if (st.trim().equals("EOS")) {
                    String corr;
                    String EOS = br.readLine().replace("/", "");
                    fluid = EOS.contains("SRK") ? new SystemSrkEos(288.15, 1.01325) : (EOS.contains("PR") ? ((corr = br.readLine().replace("/", "")).equals("PRCORR") ? new SystemPrEos1978(288.15, 1.01325) : new SystemPrEos(288.15, 1.01325)) : new SystemPrEos(288.15, 1.01325));
                }
                if (st.equals("CNAMES")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        names.add(st);
                    }
                }
                if (st.equals("TCRIT")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        TC.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("PCRIT")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        PC.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("ACF")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        ACF.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("MW")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        MW.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("TBOIL")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        TBOIL.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("VCRIT")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        VCRIT.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("SSHIFT")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        SSHIFT.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("PARACHOR")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        PARACHOR.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("ZI")) {
                    while ((st = br.readLine().replace("/", "")) != null && !st.startsWith("--") && !st.isEmpty()) {
                        ZI.add(Double.parseDouble(st));
                    }
                }
                if (st.equals("BIC")) {
                    int addedComps = 0;
                    kij = new double[names.size()][names.size()];
                    int lengthLastLine = 0;
                    ArrayList<String> list = new ArrayList<String>();
                    while ((st = br.readLine().replace("/", "")) != null && addedComps < names.size() - 1 && !st.startsWith("--") && !st.isEmpty()) {
                        String[] arr = st.split("  ");
                        ArrayList<String> templist = new ArrayList<String>(Arrays.asList(arr));
                        list.addAll(templist);
                        list.removeAll(Arrays.asList("", null));
                        if (lengthLastLine >= list.size()) continue;
                        lengthLastLine = list.size();
                        for (int i = 0; i < list.size(); ++i) {
                            BIC.add(Double.parseDouble((String)list.get(i)));
                            kij[i][addedComps + 1] = Double.parseDouble((String)list.get(i));
                            kij[addedComps + 1][i] = kij[i][addedComps + 1];
                        }
                        ++addedComps;
                        list.clear();
                    }
                }
                if (!st.equals("SSHIFTS")) continue;
                while ((line = br.readLine()) != null && !(st = line.replace("/", "")).startsWith("--") && !st.isEmpty()) {
                    try {
                        SSHIFTS.add(Double.parseDouble(st));
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Error parsing double value: " + e.getMessage());
                    }
                }
            }
            for (int counter = 0; counter < names.size(); ++counter) {
                String name = (String)names.get(counter);
                if (name.equals("C1") || (Double)TC.get(counter) < 0.0) {
                    name = "methane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C2") || (Double)TC.get(counter) < 0.0) {
                    name = "ethane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("N2") || (Double)TC.get(counter) < 0.0) {
                    name = "nitrogen";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("iC4") || (Double)TC.get(counter) < 0.0) {
                    name = "i-butane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C4") || (Double)TC.get(counter) < 0.0) {
                    name = "n-butane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("iC5") || (Double)TC.get(counter) < 0.0) {
                    name = "i-pentane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C5") || (Double)TC.get(counter) < 0.0) {
                    name = "n-pentane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C6") || (Double)TC.get(counter) < 0.0) {
                    name = "n-hexane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("C3") || (Double)TC.get(counter) < 0.0) {
                    name = "propane";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if (name.equals("CO2") || (Double)TC.get(counter) < 0.0) {
                    name = "CO2";
                    fluid.addComponent(name, (double)((Double)ZI.get(counter)));
                } else if ((Double)TC.get(counter) >= 0.0) {
                    name = (String)names.get(counter);
                    double stddensity = 0.5046 * (Double)MW.get(counter) / 1000.0 + 0.668468;
                    fluid.addTBPfraction(name, (Double)ZI.get(counter), (Double)MW.get(counter) / 1000.0, stddensity);
                    name = name + "_PC";
                } else {
                    name = (String)names.get(counter);
                    double stddensity = 0.5046 * (Double)MW.get(counter) / 1000.0 + 0.668468;
                    fluid.addTBPfraction(name, (Double)ZI.get(counter), (Double)MW.get(counter) / 1000.0, stddensity);
                    name = name + "_PC";
                }
                for (int i = 0; i < fluid.getMaxNumberOfPhases(); ++i) {
                    fluid.getPhase(i).getComponent(name).setTC((Double)TC.get(counter));
                    fluid.getPhase(i).getComponent(name).setPC((Double)PC.get(counter));
                    fluid.getPhase(i).getComponent(name).setAcentricFactor((Double)ACF.get(counter));
                    fluid.getPhase(i).getComponent(name).setMolarMass((Double)MW.get(counter) / 1000.0);
                    fluid.getPhase(i).getComponent(name).setNormalBoilingPoint((Double)TBOIL.get(counter));
                    fluid.getPhase(i).getComponent(name).setCriticalVolume((Double)VCRIT.get(counter));
                    fluid.getPhase(i).getComponent(name).setParachorParameter((Double)PARACHOR.get(counter));
                    if (SSHIFTS.size() > 0) {
                        fluid.getPhase(i).getComponent(name).setVolumeCorrectionConst((Double)SSHIFTS.get(counter));
                    } else {
                        fluid.getPhase(i).getComponent(name).setVolumeCorrectionConst((Double)SSHIFT.get(counter));
                    }
                    fluid.getPhase(i).getComponent(name).setRacketZ(0.29056 - 0.08775 * (Double)ACF.get(counter));
                }
                if (!fluid.getPhase(0).getComponent(name).isIsTBPfraction()) continue;
                fluid.changeComponentName(name, ((String)names.get(counter)).replaceAll("_PC", "") + pseudoName);
            }
            fluid.setMixingRule(2);
            fluid.useVolumeCorrection(true);
            fluid.init(0);
            for (int i = 0; i < names.size(); ++i) {
                for (int j = i; j < names.size(); ++j) {
                    for (int phase = 0; phase < fluid.getMaxNumberOfPhases(); ++phase) {
                        ((PhaseEosInterface)fluid.getPhase(phase)).getMixingRule().setBinaryInteractionParameter(i, j, kij[i][j]);
                        ((PhaseEosInterface)fluid.getPhase(phase)).getMixingRule().setBinaryInteractionParameter(j, i, kij[i][j]);
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return fluid;
    }
}

