/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.readwrite;

import java.io.Serializable;

public class TablePrinter
implements Serializable {
    private static final long serialVersionUID = 1L;

    public static void printTable(String[][] table) {
        if (table == null || table.length == 0 || table[0].length == 0) {
            System.out.println("Table is empty.");
            return;
        }
        int[] columnWidths = TablePrinter.getColumnWidths(table);
        TablePrinter.printHorizontalLine(columnWidths);
        for (String[] row : table) {
            TablePrinter.printRow(row, columnWidths);
            TablePrinter.printHorizontalLine(columnWidths);
        }
    }

    private static int[] getColumnWidths(String[][] table) {
        int columns = table[0].length;
        int[] columnWidths = new int[columns];
        for (String[] row : table) {
            for (int i = 0; i < columns; ++i) {
                int width = row[i].length();
                if (width <= columnWidths[i]) continue;
                columnWidths[i] = width;
            }
        }
        return columnWidths;
    }

    private static void printHorizontalLine(int[] columnWidths) {
        System.out.print("+");
        for (int width : columnWidths) {
            for (int i = 0; i < width + 2; ++i) {
                System.out.print("-");
            }
            System.out.print("+");
        }
        System.out.println();
    }

    private static void printRow(String[] row, int[] columnWidths) {
        System.out.print("|");
        for (int i = 0; i < row.length; ++i) {
            String cell = row[i];
            int padding = columnWidths[i] - cell.length();
            System.out.print(" " + cell);
            for (int j = 0; j < padding; ++j) {
                System.out.print(" ");
            }
            System.out.print(" |");
        }
        System.out.println();
    }

    public static void printTable(double[][] table) {
        TablePrinter.printTable(TablePrinter.convertDoubleToString(table));
    }

    public static String[][] convertDoubleToString(double[][] doubleArray) {
        String[][] stringArray = new String[doubleArray.length][];
        for (int i = 0; i < doubleArray.length; ++i) {
            stringArray[i] = new String[doubleArray[i].length];
            for (int j = 0; j < doubleArray[i].length; ++j) {
                stringArray[i][j] = String.valueOf(doubleArray[i][j]);
            }
        }
        return stringArray;
    }
}

