/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermo.util.referenceequations;

public class methaneBWR32 {
    double gamma = 0.0096;
    double[] N = new double[]{-0.0184, 1.051016206, 16.1, 848.0, -42700.0, 7.66E-4, -0.484, 85.2, -16600.0, -3.75E-5, 0.0286, -2.868528597, 1.19E-4, -0.00853, 3.836506384, 2.5E-5, 5.8E-6, -0.00716, 1.26E-4, 22200.0, -1480000.0, 50.5, 1640000.0, 0.213, 37.8, -1.19E-5, -31.6, -4.1E-6, 0.00149, 3.15E-9, -2.17E-6, 2.4E-5};

    public double calcPressure(double molDens, double temp) {
        double pres = 0.0;
        double R = 0.08205616;
        pres = molDens * R * temp + molDens * molDens * (this.N[0] * temp + this.N[1] * Math.sqrt(temp) + this.N[2] + this.N[3] / temp + this.N[4] / temp / temp) + Math.pow(molDens, 3.0) * (this.N[5] * temp + this.N[6] + this.N[7] / temp + this.N[8] / temp / temp) + Math.pow(molDens, 4.0) * (this.N[9] * temp + this.N[10] + this.N[11] / temp) + Math.pow(molDens, 5.0) * this.N[12] + Math.pow(molDens, 6.0) * (this.N[13] / temp + this.N[14] / temp / temp) + Math.pow(molDens, 7.0) * this.N[15] / temp + Math.pow(molDens, 8.0) * (this.N[16] / temp + this.N[17] / temp / temp) + Math.pow(molDens, 9.0) * this.N[18] / temp / temp + Math.pow(molDens, 3.0) * (this.N[19] / temp / temp + this.N[20] / Math.pow(temp, 3.0)) * Math.exp(-this.gamma * Math.pow(molDens, 2.0)) + Math.pow(molDens, 5.0) * (this.N[21] / temp / temp + this.N[22] / Math.pow(temp, 4.0)) * Math.exp(-this.gamma * Math.pow(molDens, 2.0)) + Math.pow(molDens, 7.0) * (this.N[23] / temp / temp + this.N[24] / Math.pow(temp, 3.0)) * Math.exp(-this.gamma * Math.pow(molDens, 2.0)) + Math.pow(molDens, 9.0) * (this.N[25] / temp / temp + this.N[26] / Math.pow(temp, 4.0)) * Math.exp(-this.gamma * Math.pow(molDens, 2.0)) + Math.pow(molDens, 11.0) * (this.N[27] / temp / temp + this.N[28] / Math.pow(temp, 3.0)) * Math.exp(-this.gamma * Math.pow(molDens, 2.0)) + Math.pow(molDens, 13.0) * (this.N[29] / temp / temp + this.N[30] / Math.pow(temp, 3.0) + this.N[31] / Math.pow(temp, 4.0)) * Math.exp(-this.gamma * Math.pow(molDens, 2.0));
        return pres + 0.01325;
    }

    public double molDens(double temp, double pres, boolean gas) {
        double guessMolDens = 0.04;
        if (!gas) {
            guessMolDens = 1.0;
        }
        double error = 0.0;
        double oldError = 1.0;
        double molVol = 1.0;
        double oldMolVol = 1.0;
        double derrordmolvol = 0.0;
        int iter = 0;
        do {
            guessMolDens = ++iter < 4 ? (guessMolDens -= error / 1000.0) : (guessMolDens -= error / derrordmolvol);
            molVol = guessMolDens;
            error = this.calcPressure(guessMolDens, temp) - pres;
            derrordmolvol = (error - oldError) / (molVol - oldMolVol);
            System.out.println("error " + error);
            oldError = error;
            oldMolVol = molVol;
        } while (Math.abs(error) > 1.0E-10);
        return guessMolDens;
    }

    public static void main(String[] args) {
        methaneBWR32 testMet = new methaneBWR32();
        double pres = testMet.calcPressure(0.04, 298.0);
        System.out.println("molDens " + testMet.molDens(90.15, 1.0, false));
    }
}

