/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.chemicalequilibrium;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.BaseOperation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class ChemicalEquilibrium
extends BaseOperation {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ChemicalEquilibrium.class);
    SystemInterface system;

    public ChemicalEquilibrium(SystemInterface system) {
        this.system = system;
    }

    @Override
    public void run() {
        double chemdev = 0.0;
        int iter = 1;
        if (this.system.isChemicalSystem()) {
            double oldHeat = this.system.getChemicalReactionOperations().getReactionList().reacHeat(this.system.getPhase(1), "HCO3-");
            do {
                ++iter;
                for (int phase = 1; phase < this.system.getNumberOfPhases(); ++phase) {
                    int i;
                    chemdev = 0.0;
                    double[] xchem = new double[this.system.getPhases()[phase].getNumberOfComponents()];
                    for (i = 0; i < this.system.getPhases()[phase].getNumberOfComponents(); ++i) {
                        xchem[i] = this.system.getPhases()[phase].getComponents()[i].getx();
                    }
                    this.system.init(1);
                    this.system.getChemicalReactionOperations().solveChemEq(phase);
                    for (i = 0; i < this.system.getPhases()[phase].getNumberOfComponents(); ++i) {
                        chemdev += Math.abs(xchem[i] - this.system.getPhases()[phase].getComponents()[i].getx());
                    }
                }
            } while (Math.abs(chemdev) > 1.0E-4 && iter < 100);
            double newHeat = this.system.getChemicalReactionOperations().getReactionList().reacHeat(this.system.getPhase(1), "HCO3-");
            this.system.getChemicalReactionOperations().setDeltaReactionHeat(newHeat - oldHeat);
        }
        if (iter > 50) {
            logger.info("iter : " + iter + " in chemicalequilibrium");
        }
    }

    @Override
    public void displayResult() {
        this.system.display();
    }

    @Override
    public void printToFile(String name) {
    }

    @Override
    public double[][] getPoints(int i) {
        return null;
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }

    @Override
    public String[][] getResultTable() {
        return null;
    }
}

