/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import java.io.Serializable;
import neqsim.thermo.component.ComponentInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.util.exception.IsNaNException;
import neqsim.util.exception.TooManyIterationsException;

public class RachfordRice
implements Serializable {
    private static final long serialVersionUID = 1000L;
    private double[] beta = new double[2];
    private static String method = "Michelsen2001";

    public static String getMethod() {
        return method;
    }

    public static void setMethod(String method) {
        RachfordRice.method = method;
    }

    public double calcBeta(double[] K, double[] z) throws IsNaNException, TooManyIterationsException {
        if (method.equals("Michelsen2001")) {
            return this.calcBetaMichelsen2001(K, z);
        }
        if (method.equals("Nielsen2023")) {
            return this.calcBetaNielsen2023(K, z);
        }
        return this.calcBetaMichelsen2001(K, z);
    }

    public double calcBetaMichelsen2001(double[] K, double[] z) throws IsNaNException, TooManyIterationsException {
        int i;
        double tolerance = 1.0E-12;
        double midler = 0.0;
        double minBeta = tolerance;
        double maxBeta = 1.0 - tolerance;
        double g0 = -1.0;
        double g1 = 1.0;
        for (i = 0; i < K.length; ++i) {
            midler = (K[i] * z[i] - 1.0) / (K[i] - 1.0);
            if (midler > minBeta && K[i] > 1.0) {
                minBeta = midler;
            }
            if ((midler = (1.0 - z[i]) / (1.0 - K[i])) < maxBeta && K[i] < 1.0) {
                maxBeta = midler;
            }
            g0 += z[i] * K[i];
            g1 += -z[i] / K[i];
        }
        if (g0 < 0.0) {
            return tolerance;
        }
        if (g1 > 0.0) {
            return 1.0 - tolerance;
        }
        double nybeta = (minBeta + maxBeta) / 2.0;
        double gtest = 0.0;
        for (i = 0; i < K.length; ++i) {
            gtest += z[i] * (K[i] - 1.0) / (1.0 - nybeta + nybeta * K[i]);
        }
        if (gtest >= 0.0) {
            minBeta = nybeta;
        } else {
            maxBeta = nybeta;
        }
        if (gtest < 0.0) {
            double minold = minBeta;
            minBeta = 1.0 - maxBeta;
            maxBeta = 1.0 - minold;
        }
        int iterations = 0;
        int maxIterations = 300;
        double step = 1.0;
        double gbeta = 0.0;
        double deriv = 0.0;
        double betal = 1.0 - nybeta;
        do {
            ++iterations;
            if (gtest >= 0.0) {
                deriv = 0.0;
                gbeta = 0.0;
                for (i = 0; i < K.length; ++i) {
                    double temp1 = K[i] - 1.0;
                    double temp2 = 1.0 + temp1 * nybeta;
                    deriv += -(z[i] * temp1 * temp1) / (temp2 * temp2);
                    gbeta += z[i] * (K[i] - 1.0) / (1.0 + (K[i] - 1.0) * nybeta);
                }
                if (gbeta >= 0.0) {
                    minBeta = nybeta;
                } else {
                    maxBeta = nybeta;
                }
                nybeta -= gbeta / deriv;
                if (nybeta > maxBeta) {
                    nybeta = maxBeta;
                }
                if (!(nybeta < minBeta)) continue;
                nybeta = minBeta;
                continue;
            }
            deriv = 0.0;
            gbeta = 0.0;
            for (i = 0; i < K.length; ++i) {
                deriv -= z[i] * (K[i] - 1.0) * (1.0 - K[i]) / Math.pow(betal + (1.0 - betal) * K[i], 2.0);
                gbeta += z[i] * (K[i] - 1.0) / (betal + (-betal + 1.0) * K[i]);
            }
            if (gbeta < 0.0) {
                minBeta = betal;
            } else {
                maxBeta = betal;
            }
            betal -= gbeta / deriv;
            if (betal > maxBeta) {
                betal = maxBeta;
            }
            if (betal < minBeta) {
                betal = minBeta;
            }
            nybeta = 1.0 - betal;
        } while (Math.abs(step = gbeta / deriv) >= 1.5E-10 && iterations < maxIterations);
        if (nybeta <= tolerance) {
            nybeta = tolerance;
        } else if (nybeta >= 1.0 - tolerance) {
            nybeta = 1.0 - tolerance;
        }
        this.beta[0] = nybeta;
        this.beta[1] = 1.0 - nybeta;
        if (iterations >= maxIterations) {
            throw new TooManyIterationsException(new RachfordRice(), "calcBetaMichelsen2001", (long)maxIterations);
        }
        if (Double.isNaN(nybeta)) {
            throw new IsNaNException(new RachfordRice(), "calcBetaMichelsen2001", "beta");
        }
        return nybeta;
    }

    public double calcBetaNielsen2023(double[] K, double[] z) throws IsNaNException, TooManyIterationsException {
        int i;
        double tolerance = 1.0E-12;
        double g0 = -1.0;
        double g1 = 1.0;
        for (int i2 = 0; i2 < K.length; ++i2) {
            g0 += z[i2] * K[i2];
            g1 += -z[i2] / K[i2];
        }
        if (g0 < 0.0) {
            return tolerance;
        }
        if (g1 > 0.0) {
            return 1.0 - tolerance;
        }
        double V = 0.5;
        double h = 0.0;
        for (i = 0; i < K.length; ++i) {
            h += z[i] * (K[i] - 1.0) / (1.0 + V * (K[i] - 1.0));
        }
        if (h > 0.0) {
            for (i = 0; i < K.length; ++i) {
                K[i] = 1.0 / K[i];
            }
        }
        double Kmax = K[0];
        double Kmin = K[0];
        for (int i3 = 1; i3 < K.length; ++i3) {
            if (K[i3] < Kmin) {
                Kmin = K[i3];
                continue;
            }
            if (!(K[i3] > Kmax)) continue;
            Kmax = K[i3];
        }
        double alphaMin = 1.0 / (1.0 - Kmax);
        double alphaMax = 1.0 / (1.0 - Kmin);
        double alpha = V;
        double a = (alpha - alphaMin) / (alphaMax - alpha);
        double b = 1.0 / (alpha - alphaMin);
        double[] c = new double[K.length];
        double[] d = new double[K.length];
        for (int i4 = 0; i4 < K.length; ++i4) {
            c[i4] = 1.0 / (1.0 - K[i4]);
            d[i4] = (alphaMin - c[i4]) / (alphaMax - alphaMin);
        }
        double hb = 0.0;
        double amax = alpha;
        double bmax = 1.0E20;
        double amin = 0.0;
        double bmin = 1.0 / (alphaMax - alphaMin);
        int iter = 0;
        int maxIterations = 300;
        do {
            ++iter;
            double funk = 0.0;
            double funkder = 0.0;
            hb = 0.0;
            double hbder = 0.0;
            for (int i5 = 0; i5 < K.length; ++i5) {
                funk -= z[i5] * a * (1.0 + a) / (d[i5] + a * (1.0 + d[i5]));
                funkder -= z[i5] * (a * a + (1.0 + a) * (1.0 + a) * d[i5]) / Math.pow(d[i5] + a * (1.0 + d[i5]), 2.0);
                hb += z[i5] * b / (1.0 + b * (alphaMin - c[i5]));
                hbder += z[i5] / Math.pow(1.0 + b * (alphaMin - c[i5]), 2.0);
            }
            if (funk > 0.0) {
                amax = a;
            } else {
                amin = a;
            }
            if (hb > 0.0) {
                bmax = b;
            } else {
                bmin = b;
            }
            if ((a -= funk / funkder) > amax || a < amin) {
                a = (amax + amin) / 2.0;
            }
            if (!((b -= hb / hbder) > bmax) && !(b < bmin)) continue;
            b = (bmax + bmin) / 2.0;
        } while (Math.abs(hb) > 1.0E-10 && iter < maxIterations);
        V = -(1.0 / b / a - alphaMax);
        if (h > 0.0) {
            V = 1.0 - V;
        }
        if (V <= tolerance) {
            V = tolerance;
        } else if (V >= 1.0 - tolerance) {
            V = 1.0 - tolerance;
        }
        this.beta[0] = V;
        this.beta[1] = 1.0 - V;
        if (iter >= maxIterations) {
            throw new TooManyIterationsException(new RachfordRice(), "calcBetaNielsen2023", (long)maxIterations);
        }
        if (Double.isNaN(V)) {
            throw new IsNaNException(new RachfordRice(), "calcBetaNielsen2023", "beta");
        }
        return V;
    }

    public double[] getBeta() {
        return this.beta;
    }

    public final double calcBetaS(SystemInterface system) throws IsNaNException, TooManyIterationsException {
        int i;
        ComponentInterface[] compArray = system.getPhase(0).getComponents();
        double tolerance = 1.0E-12;
        double midler = 0.0;
        double minBeta = tolerance;
        double maxBeta = 1.0 - tolerance;
        double g0 = -1.0;
        double g1 = 1.0;
        for (i = 0; i < system.getNumberOfComponents(); ++i) {
            midler = (compArray[i].getK() * compArray[i].getz() - 1.0) / (compArray[i].getK() - 1.0);
            if (midler > minBeta && compArray[i].getK() > 1.0) {
                minBeta = midler;
            }
            if ((midler = (1.0 - compArray[i].getz()) / (1.0 - compArray[i].getK())) < maxBeta && compArray[i].getK() < 1.0) {
                maxBeta = midler;
            }
            g0 += compArray[i].getz() * compArray[i].getK();
            g1 += -compArray[i].getz() / compArray[i].getK();
        }
        if (g0 < 0.0) {
            this.beta[1] = 1.0 - tolerance;
            this.beta[0] = tolerance;
            return this.beta[0];
        }
        if (g1 > 0.0) {
            this.beta[1] = tolerance;
            this.beta[0] = 1.0 - tolerance;
            return this.beta[0];
        }
        double nybeta = (minBeta + maxBeta) / 2.0;
        double gtest = 0.0;
        for (i = 0; i < system.getNumberOfComponents(); ++i) {
            gtest += compArray[i].getz() * (compArray[i].getK() - 1.0) / (1.0 - nybeta + nybeta * compArray[i].getK());
        }
        if (gtest >= 0.0) {
            minBeta = nybeta;
        } else {
            maxBeta = nybeta;
        }
        if (gtest < 0.0) {
            double minold = minBeta;
            minBeta = 1.0 - maxBeta;
            maxBeta = 1.0 - minold;
        }
        int iterations = 0;
        int maxIterations = 300;
        double step = 1.0;
        double deriv = 0.0;
        double gbeta = 0.0;
        double betal = 1.0 - nybeta;
        do {
            ++iterations;
            if (gtest >= 0.0) {
                deriv = 0.0;
                gbeta = 0.0;
                for (i = 0; i < system.getNumberOfComponents(); ++i) {
                    double temp1 = compArray[i].getK() - 1.0;
                    double temp2 = 1.0 + temp1 * nybeta;
                    deriv += -(compArray[i].getz() * temp1 * temp1) / (temp2 * temp2);
                    gbeta += compArray[i].getz() * (compArray[i].getK() - 1.0) / (1.0 + (compArray[i].getK() - 1.0) * nybeta);
                }
                if (gbeta >= 0.0) {
                    minBeta = nybeta;
                } else {
                    maxBeta = nybeta;
                }
                nybeta -= gbeta / deriv;
                if (nybeta > maxBeta) {
                    nybeta = maxBeta;
                }
                if (!(nybeta < minBeta)) continue;
                nybeta = minBeta;
                continue;
            }
            deriv = 0.0;
            gbeta = 0.0;
            for (i = 0; i < system.getNumberOfComponents(); ++i) {
                deriv -= compArray[i].getz() * (compArray[i].getK() - 1.0) * (1.0 - compArray[i].getK()) / Math.pow(betal + (1.0 - betal) * compArray[i].getK(), 2.0);
                gbeta += compArray[i].getz() * (compArray[i].getK() - 1.0) / (betal + (-betal + 1.0) * compArray[i].getK());
            }
            if (gbeta < 0.0) {
                minBeta = betal;
            } else {
                maxBeta = betal;
            }
            betal -= gbeta / deriv;
            if (betal > maxBeta) {
                betal = maxBeta;
            }
            if (betal < minBeta) {
                betal = minBeta;
            }
            nybeta = 1.0 - betal;
        } while (Math.abs(step = gbeta / deriv) >= 1.0E-10 && iterations < maxIterations);
        if (nybeta <= tolerance) {
            nybeta = tolerance;
        } else if (nybeta >= 1.0 - tolerance) {
            nybeta = 1.0 - tolerance;
        }
        this.beta[0] = nybeta;
        this.beta[1] = 1.0 - nybeta;
        if (iterations >= maxIterations) {
            throw new TooManyIterationsException(this, "calcBetaS", (long)maxIterations);
        }
        if (Double.isNaN(this.beta[1])) {
            throw new IsNaNException(this, "calcBetaS", "beta");
        }
        return this.beta[0];
    }
}

