/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import Jama.Matrix;
import neqsim.thermo.phase.PhaseType;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SolidFlash12
extends TPflash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SolidFlash12.class);
    boolean multiPhaseTest = false;
    double[] dQdbeta;
    double[][] Qmatrix;
    double[] E;
    double Q = 0.0;
    int solidsNumber = 0;
    int solidIndex = 0;

    public SolidFlash12(SystemInterface system) {
        super(system);
    }

    public void calcMultiPhaseBeta() {
    }

    public void setXY() {
        for (int k = 0; k < this.system.getNumberOfPhases() - this.solidsNumber; ++k) {
            for (int i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
                if (i != this.solidIndex) {
                    this.system.getPhase(k).getComponent(i).setx(this.system.getPhase(0).getComponent(i).getz() / this.E[i] / this.system.getPhase(k).getComponent(i).getFugacityCoefficient());
                    continue;
                }
                this.system.getPhase(k).getComponent(i).setx(this.system.getPhases()[3].getComponent(i).getFugacityCoefficient() / this.system.getPhase(k).getComponent(i).getFugacityCoefficient());
            }
        }
    }

    public void checkX() {
        for (int k = 0; k < this.system.getNumberOfPhases() - 1; ++k) {
            double x = 0.0;
            for (int i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
                x += this.system.getPhase(k).getComponent(i).getx();
            }
            logger.info("x tot " + x + " PHASE " + k);
            if (!(x < 0.999999)) continue;
            this.system.setBeta(this.system.getNumberOfPhases() - 2, this.system.getBeta(this.system.getNumberOfPhases() - 1));
            this.system.setBeta(0, 1.0 - this.system.getBeta(this.system.getNumberOfPhases() - 1));
            this.system.setNumberOfPhases(this.system.getNumberOfPhases() - 1);
            this.system.setPhaseIndex(this.system.getNumberOfPhases() - 1, 3);
            this.system.init(1);
            this.calcE();
            this.setXY();
            return;
        }
    }

    public void calcE() {
        this.E = new double[this.system.getPhases()[0].getNumberOfComponents()];
        for (int i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
            this.E[i] = 0.0;
            for (int k = 0; k < this.system.getNumberOfPhases() - this.solidsNumber; ++k) {
                int n = i;
                this.E[n] = this.E[n] + this.system.getBeta(k) / this.system.getPhase(k).getComponent(i).getFugacityCoefficient();
            }
        }
    }

    public double calcQ() {
        int j;
        int i;
        int k;
        this.Q = 0.0;
        double betaTotal = 0.0;
        this.dQdbeta = new double[this.system.getNumberOfPhases() - this.solidsNumber];
        this.Qmatrix = new double[this.system.getNumberOfPhases() - this.solidsNumber][this.system.getNumberOfPhases() - this.solidsNumber];
        for (k = 0; k < this.system.getNumberOfPhases() - this.solidsNumber; ++k) {
            betaTotal += this.system.getBeta(k);
        }
        this.Q = betaTotal;
        for (i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
            if (i == this.solidIndex) continue;
            this.Q -= Math.log(this.E[i]) * this.system.getPhase(0).getComponents()[i].getz();
        }
        for (i = 0; i < this.solidsNumber; ++i) {
            this.Q += this.system.getPhase(0).getComponent(this.solidIndex).getz() * (1.0 - Math.log(this.system.getPhase(0).getComponent(this.solidIndex).getz() / this.system.getPhases()[3].getComponent(this.solidIndex).getFugacityCoefficient()));
            for (j = 0; j < this.system.getNumberOfPhases() - this.solidsNumber; ++j) {
                this.Q -= this.system.getBeta(j) * this.system.getPhases()[3].getComponent(this.solidIndex).getFugacityCoefficient() / this.system.getPhase(j).getComponent(this.solidIndex).getFugacityCoefficient();
            }
        }
        for (k = 0; k < this.system.getNumberOfPhases() - this.solidsNumber; ++k) {
            this.dQdbeta[k] = 1.0;
            for (int i2 = 0; i2 < this.system.getPhases()[0].getNumberOfComponents(); ++i2) {
                if (i2 == this.solidIndex) {
                    int n = k;
                    this.dQdbeta[n] = this.dQdbeta[n] - this.system.getPhases()[3].getComponents()[this.solidIndex].getFugacityCoefficient() / this.system.getPhase(k).getComponent(this.solidIndex).getFugacityCoefficient();
                    continue;
                }
                int n = k;
                this.dQdbeta[n] = this.dQdbeta[n] - this.system.getPhase(0).getComponent(i2).getz() / this.E[i2] / this.system.getPhase(k).getComponent(i2).getFugacityCoefficient();
            }
        }
        for (i = 0; i < this.system.getNumberOfPhases() - this.solidsNumber; ++i) {
            for (j = 0; j < this.system.getNumberOfPhases() - this.solidsNumber; ++j) {
                this.Qmatrix[i][j] = 0.0;
                for (int k2 = 0; k2 < this.system.getPhases()[0].getNumberOfComponents(); ++k2) {
                    if (k2 == this.solidIndex) continue;
                    double[] dArray = this.Qmatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.system.getPhase(0).getComponent(k2).getz() / (this.E[k2] * this.E[k2] * this.system.getPhase(j).getComponent(k2).getFugacityCoefficient() * this.system.getPhase(i).getComponent(k2).getFugacityCoefficient());
                }
            }
        }
        return this.Q;
    }

    public void solveBeta() {
        double[] oldBeta = new double[this.system.getNumberOfPhases() - this.solidsNumber];
        int iter = 0;
        Matrix ans = new Matrix(this.system.getNumberOfPhases() - this.solidsNumber, 1);
        do {
            this.system.init(1);
            this.calcE();
            this.calcQ();
            oldBeta = new double[this.system.getNumberOfPhases() - this.solidsNumber];
            ++iter;
            for (int k = 0; k < this.system.getNumberOfPhases() - this.solidsNumber; ++k) {
                oldBeta[k] = this.system.getBeta(k);
            }
            Matrix betaMatrix = new Matrix(oldBeta, 1).transpose();
            Matrix dQM = new Matrix(this.dQdbeta, 1);
            Matrix dQdBM = new Matrix(this.Qmatrix);
            try {
                ans = dQdBM.solve(dQM.transpose());
            }
            catch (Exception exception) {
                // empty catch block
            }
            dQM.print(10, 10);
            dQdBM.print(10, 10);
            ans.print(30, 30);
            betaMatrix.minusEquals(ans.times(((double)iter + 1.0) / (100.0 + (double)iter)));
            for (int k = 0; k < this.system.getNumberOfPhases() - this.solidsNumber; ++k) {
                this.system.setBeta(k, betaMatrix.get(k, 0));
                if (betaMatrix.get(k, 0) < 0.0) {
                    this.system.setBeta(k, 1.0E-9);
                }
                if (!(betaMatrix.get(k, 0) > 1.0)) continue;
                this.system.setBeta(k, 0.999999999);
            }
            this.calcE();
            this.setXY();
            this.calcSolidBeta();
        } while (ans.norm2() > 1.0E-8 && iter < 100 || iter < 2);
        this.system.init(1);
        this.setXY();
    }

    public void checkGibbs() {
        double gibbs1 = 0.0;
        double gibbs2 = 0.0;
        for (int i = 0; i < this.system.getNumberOfPhases() - 1; ++i) {
            this.system.setPhaseType(i, PhaseType.byValue(0));
            this.system.init(1);
            gibbs1 = this.system.getPhase(i).getGibbsEnergy();
            this.system.setPhaseType(i, PhaseType.byValue(1));
            this.system.init(1);
            gibbs2 = this.system.getPhase(i).getGibbsEnergy();
            if (gibbs1 < gibbs2) {
                this.system.setPhaseType(i, PhaseType.byValue(0));
            } else {
                this.system.setPhaseType(i, PhaseType.byValue(1));
            }
            this.system.init(1);
        }
    }

    public void calcSolidBeta() {
        double tempVar = this.system.getPhase(0).getComponents()[this.solidIndex].getz();
        for (int i = 0; i < this.system.getNumberOfPhases() - 1; ++i) {
            tempVar -= this.system.getBeta(i) * this.system.getPhase(3).getComponent(this.solidIndex).getFugacityCoefficient() / this.system.getPhase(i).getComponent(this.solidIndex).getFugacityCoefficient();
        }
        if (tempVar > 0.0 && tempVar < 1.0) {
            this.system.setBeta(this.system.getNumberOfPhases() - 1, tempVar);
        }
    }

    @Override
    public void run() {
        int iter = 0;
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        this.system.setSolidPhaseCheck(false);
        ops.TPflash();
        this.system.setSolidPhaseCheck(true);
        if (this.checkAndAddSolidPhase() == 0) {
            return;
        }
        if (this.system.getPhase(0).getNumberOfComponents() <= 2) {
            this.solvebeta1();
        }
        do {
            this.solveBeta();
        } while (++iter < 1);
    }

    public int checkAndAddSolidPhase() {
        int i;
        double[] solidCandidate = new double[this.system.getPhases()[0].getNumberOfComponents()];
        for (int k = 0; k < this.system.getPhase(0).getNumberOfComponents(); ++k) {
            if (this.system.getTemperature() > this.system.getPhase(0).getComponent(k).getTriplePointTemperature()) {
                solidCandidate[k] = -10.0;
                continue;
            }
            solidCandidate[k] = this.system.getPhase(0).getComponents()[k].getz();
            this.system.getPhases()[3].getComponent(k).setx(1.0);
            for (int i2 = 0; i2 < this.system.getNumberOfPhases(); ++i2) {
                int n = k;
                solidCandidate[n] = solidCandidate[n] - this.system.getPhases()[3].getComponent(k).fugcoef(this.system.getPhases()[3]) / this.system.getPhase(i2).getComponent(k).getFugacityCoefficient();
            }
        }
        for (i = 0; i < solidCandidate.length; ++i) {
            if (solidCandidate[i] > 0.0) {
                this.system.getPhases()[3].getComponent(i).setx(1.0);
                this.solidIndex = i;
                ++this.solidsNumber;
                continue;
            }
            this.system.getPhases()[3].getComponent(i).setx(0.0);
        }
        for (i = 0; i < this.solidsNumber; ++i) {
            this.system.setNumberOfPhases(this.system.getNumberOfPhases() + 1);
            this.system.setPhaseIndex(this.system.getNumberOfPhases() - 1, 3);
            this.system.setBeta(this.system.getNumberOfPhases() - 1, solidCandidate[this.solidIndex]);
        }
        return this.solidsNumber;
    }

    public double solvebeta1() {
        double solidCandidate = 0.0;
        int iter = 0;
        double dn = -0.01;
        double solidCandidateOld = 0.0;
        do {
            solidCandidateOld = solidCandidate;
            this.system.addComponent(this.system.getPhase(0).getComponent(this.solidIndex).getComponentName(), dn);
            ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
            this.system.setSolidPhaseCheck(false);
            ops.TPflash();
            ++iter;
            solidCandidate = this.system.getPhase(0).getComponents()[this.solidIndex].getz();
            for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
                solidCandidate -= this.system.getPhases()[3].getComponent(this.solidIndex).fugcoef(this.system.getPhases()[3]) / this.system.getPhase(i).getComponent(this.solidIndex).getFugacityCoefficient();
            }
            double dsoliddn = (solidCandidate - solidCandidateOld) / dn;
            dn = -0.5 * solidCandidate / dsoliddn;
            logger.info("solid cand " + solidCandidate);
        } while (solidCandidate > 1.0E-5 && iter < 50);
        return 1.0;
    }
}

