/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import Jama.Matrix;
import neqsim.mathlib.nonlinearsolver.NewtonRhapson;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.system.SystemInterface;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SysNewtonRhapsonPHflash
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(SysNewtonRhapsonPHflash.class);
    int neq = 0;
    int iter = 0;
    int ic02p = -100;
    int ic03p = -100;
    int testcrit = 0;
    int npCrit = 0;
    double beta = 0.0;
    double ds = 0.0;
    double dTmax = 1.0;
    double dPmax = 1.0;
    double avscp = 0.1;
    double TC1 = 0.0;
    double TC2 = 0.0;
    double PC1 = 0.0;
    double PC2 = 0.0;
    double specVar = 0.0;
    Matrix Jac;
    Matrix fvec;
    Matrix gTvec;
    Matrix gPvec;
    Matrix u;
    Matrix uold;
    Matrix Xgij;
    SystemInterface system;
    int numberOfComponents;
    int speceq = 0;
    Matrix a = new Matrix(4, 4);
    Matrix s = new Matrix(1, 4);
    Matrix xg;
    Matrix xcoef;
    NewtonRhapson solver;
    boolean etterCP = false;
    boolean etterCP2 = false;
    double dVdT = 0.0;
    int type = 0;
    double dPdT = 0.0;

    public SysNewtonRhapsonPHflash(SystemInterface system, int numberOfPhases, int numberOfComponents) {
        this.system = system;
        this.numberOfComponents = numberOfComponents;
        this.neq = numberOfComponents;
        this.Jac = new Matrix(this.neq + 2, this.neq + 2);
        this.fvec = new Matrix(this.neq + 2, 1);
        this.gTvec = new Matrix(this.neq, 1);
        this.gPvec = new Matrix(this.neq, 1);
        this.u = new Matrix(this.neq + 2, 1);
        this.Xgij = new Matrix(this.neq + 2, 4);
        this.setu();
        this.uold = this.u.copy();
        this.solver = new NewtonRhapson();
        this.solver.setOrder(3);
    }

    public SysNewtonRhapsonPHflash(SystemInterface system, int numberOfPhases, int numberOfComponents, int type) {
        this(system, numberOfPhases, numberOfComponents);
        this.type = type;
    }

    public void setSpec(double spec) {
        this.specVar = spec;
    }

    public void setfvec() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.fvec.set(i, 0, Math.log(this.system.getPhases()[0].getComponents()[i].getFugacityCoefficient()) + Math.log(this.system.getPhases()[0].getComponents()[i].getx()) - Math.log(this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient()) - Math.log(this.system.getPhases()[1].getComponents()[i].getx()));
        }
        double rP = 0.0;
        double rT = 0.0;
        if (this.type == 0) {
            rT = 1.0 / (8.3144621 * this.system.getTemperature()) * (this.specVar - this.system.getEnthalpy());
            rP = 0.0;
        }
        if (this.type == 1) {
            rT = 0.1202723625380408 * (this.specVar - this.system.getEntropy());
            rP = 0.0;
        }
        this.fvec.set(this.numberOfComponents, 0, rT);
        this.fvec.set(this.numberOfComponents + 1, 0, rP);
    }

    public void setJac() {
        this.Jac.timesEquals(0.0);
        double dij = 0.0;
        double tempJ = 0.0;
        for (int i = 0; i < this.numberOfComponents; ++i) {
            for (int j = 0; j < this.numberOfComponents; ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = 1.0 / this.system.getBeta() * (dij / this.system.getPhases()[0].getComponents()[i].getx() - 1.0 + this.system.getPhases()[0].getComponents()[i].getdfugdx(j)) + 1.0 / (1.0 - this.system.getBeta()) * (dij / this.system.getPhases()[1].getComponents()[i].getx() - 1.0 + this.system.getPhases()[1].getComponents()[i].getdfugdx(j));
                this.Jac.set(i, j, tempJ);
            }
        }
        double[] gT = new double[this.numberOfComponents];
        double[] gP = new double[this.numberOfComponents];
        for (int i = 0; i < this.numberOfComponents; ++i) {
            gT[i] = this.system.getTemperature() * (this.system.getPhases()[0].getComponents()[i].getdfugdt() - this.system.getPhases()[1].getComponents()[i].getdfugdt());
            gP[i] = this.system.getPressure() * (this.system.getPhases()[0].getComponents()[i].getdfugdp() - this.system.getPhases()[1].getComponents()[i].getdfugdp());
            this.Jac.set(this.numberOfComponents, i, gT[i]);
            this.Jac.set(i, this.numberOfComponents, gT[i]);
            this.Jac.set(this.numberOfComponents + 1, i, gP[i]);
            this.Jac.set(i, this.numberOfComponents + 1, gP[i]);
        }
        double Ett = -this.system.getCp() / 8.3144621;
        this.Jac.set(this.numberOfComponents, this.numberOfComponents, Ett);
        double Etp = this.system.getPressure() / 8.3144621 * this.system.getdVdTpn();
        this.Jac.set(this.numberOfComponents, this.numberOfComponents + 1, Etp);
        this.Jac.set(this.numberOfComponents + 1, this.numberOfComponents, Etp);
        double Epp = Math.pow(this.system.getPressure(), 2.0) / (8.3144621 * this.system.getTemperature()) * this.system.getdVdPtn();
        this.Jac.set(this.numberOfComponents + 1, this.numberOfComponents + 1, Epp);
    }

    public void setu() {
        for (int i = 0; i < this.numberOfComponents; ++i) {
            this.u.set(i, 0, 0.0);
        }
        this.u.set(this.numberOfComponents, 0, 0.0);
        this.u.set(this.numberOfComponents + 1, 0, 0.0);
    }

    public void init() {
        int i;
        double temp = this.system.getBeta();
        for (i = 0; i < this.numberOfComponents; ++i) {
            temp += this.u.get(i, 0);
        }
        this.system.setBeta(temp);
        for (i = 0; i < this.numberOfComponents; ++i) {
            double v = 0.0;
            double l = 0.0;
            v = this.system.getPhases()[0].getComponents()[i].getx() * this.system.getBeta() + this.u.get(i, 0);
            l = this.system.getPhases()[0].getComponents()[i].getz() - v;
            this.system.getPhases()[0].getComponents()[i].setx(v / this.system.getBeta());
            this.system.getPhases()[1].getComponents()[i].setx(l / (1.0 - this.system.getBeta()));
            this.system.getPhases()[1].getComponents()[i].setK(this.system.getPhases()[0].getComponents()[i].getx() / this.system.getPhases()[1].getComponents()[i].getx());
            this.system.getPhases()[0].getComponents()[i].setK(this.system.getPhases()[1].getComponents()[i].getK());
        }
        logger.info("temperature: " + this.system.getTemperature());
        this.system.setTemperature(Math.exp(this.u.get(this.numberOfComponents, 0) + Math.log(this.system.getTemperature())));
        this.system.setPressure(Math.exp(this.u.get(this.numberOfComponents + 1, 0) + Math.log(this.system.getPressure())));
        logger.info("etter temperature: " + this.system.getTemperature());
        this.system.init(3);
    }

    public int solve(int np) {
        this.iter = 1;
        do {
            ++this.iter;
            this.init();
            this.setfvec();
            this.setJac();
            this.fvec.print(10, 10);
            this.Jac.print(10, 10);
            this.u = this.Jac.solve(this.fvec.times(-1.0));
            this.fvec.print(10, 10);
            logger.info("iter: " + this.iter);
        } while (this.fvec.norm2() > 1.0E-10 && this.iter < 1000);
        logger.info("iter: " + this.iter);
        logger.info("temperature: " + this.system.getTemperature());
        logger.info("pressure: " + this.system.getPressure());
        this.init();
        return this.iter;
    }
}

