/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import Jama.Matrix;
import java.util.ArrayList;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.TPflash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TPmultiflash_1
extends TPflash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(TPmultiflash_1.class);
    boolean multiPhaseTest = false;
    double[] dQdbeta;
    double[][] Qmatrix;
    double[] E;
    double Q = 0.0;

    public TPmultiflash_1(SystemInterface system) {
        super(system);
    }

    public TPmultiflash_1(SystemInterface system, boolean checkForSolids) {
        super(system, checkForSolids);
    }

    public void calcMultiPhaseBeta() {
    }

    public void setXY() {
        for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
            for (int i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
                this.system.getPhases()[k].getComponents()[i].setx(this.system.getPhases()[k].getComponents()[i].getz() / this.E[i] / this.system.getPhases()[k].getComponents()[i].getFugacityCoefficient());
            }
        }
    }

    public void calcE() {
        this.E = new double[this.system.getPhases()[0].getNumberOfComponents()];
        for (int i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
            for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
                int n = i;
                this.E[n] = this.E[n] + this.system.getPhases()[k].getBeta() / this.system.getPhases()[k].getComponents()[i].getFugacityCoefficient();
            }
        }
    }

    public double calcQ() {
        int i;
        int k;
        this.Q = 0.0;
        double betaTotal = 0.0;
        this.dQdbeta = new double[this.system.getNumberOfPhases()];
        this.Qmatrix = new double[this.system.getNumberOfPhases()][this.system.getNumberOfPhases()];
        for (k = 0; k < this.system.getNumberOfPhases(); ++k) {
            betaTotal += this.system.getPhases()[k].getBeta();
        }
        this.Q = betaTotal;
        this.calcE();
        for (i = 0; i < this.system.getPhases()[0].getNumberOfComponents(); ++i) {
            this.Q -= Math.log(this.E[i]) * this.system.getPhases()[0].getComponents()[i].getz();
        }
        for (k = 0; k < this.system.getNumberOfPhases(); ++k) {
            this.dQdbeta[k] = 1.0;
            for (int i2 = 0; i2 < this.system.getPhases()[0].getNumberOfComponents(); ++i2) {
                int n = k;
                this.dQdbeta[n] = this.dQdbeta[n] - this.system.getPhases()[0].getComponents()[i2].getz() * 1.0 / this.E[i2] / this.system.getPhases()[k].getComponents()[i2].getFugacityCoefficient();
            }
        }
        for (i = 0; i < this.system.getNumberOfPhases(); ++i) {
            for (int j = 0; j < this.system.getNumberOfPhases(); ++j) {
                this.Qmatrix[i][j] = 0.0;
                for (int k2 = 0; k2 < this.system.getPhases()[0].getNumberOfComponents(); ++k2) {
                    double[] dArray = this.Qmatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.system.getPhases()[0].getComponents()[k2].getz() / (this.E[k2] * this.E[k2] * this.system.getPhases()[j].getComponents()[k2].getFugacityCoefficient() * this.system.getPhases()[i].getComponents()[k2].getFugacityCoefficient());
                }
            }
        }
        return this.Q;
    }

    public void solveBeta() {
        Matrix ans;
        double[] oldBeta = new double[this.system.getNumberOfPhases()];
        int iter = 1;
        do {
            ++iter;
            for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
                oldBeta[k] = this.system.getPhases()[k].getBeta();
            }
            this.calcQ();
            Matrix betaMatrix = new Matrix(oldBeta, 1).transpose();
            Matrix dQM = new Matrix(this.dQdbeta, 1);
            Matrix dQdBM = new Matrix(this.Qmatrix);
            ans = dQdBM.solve(dQM.transpose());
            betaMatrix.minusEquals(ans.times((double)iter / ((double)iter + 20.0)));
            betaMatrix.print(10, 2);
            for (int k = 0; k < this.system.getNumberOfPhases(); ++k) {
                this.system.setBeta(k, betaMatrix.get(k, 0));
                if (betaMatrix.get(k, 0) < 0.0) {
                    this.system.setBeta(k, 1.0E-9);
                }
                if (!(betaMatrix.get(k, 0) > 1.0)) continue;
                this.system.setBeta(k, 0.999999999);
            }
            this.calcE();
            this.setXY();
            this.system.init(1);
        } while (ans.norm2() > 1.0E-6);
    }

    @Override
    public void stabilityAnalysis() {
        int j;
        int k;
        double[] logWi = new double[this.system.getPhases()[1].getNumberOfComponents()];
        double[][] Wi = new double[this.system.getPhases()[1].getNumberOfComponents()][this.system.getPhases()[0].getNumberOfComponents()];
        double[] sumw = new double[this.system.getPhases()[1].getNumberOfComponents()];
        double err = 0.0;
        double[] oldlogw = new double[this.system.getPhases()[1].getNumberOfComponents()];
        double[] d = new double[this.system.getPhases()[1].getNumberOfComponents()];
        double[][] x = new double[this.system.getPhases()[1].getNumberOfComponents()][this.system.getPhases()[0].getNumberOfComponents()];
        ArrayList<SystemInterface> clonedSystem = new ArrayList<SystemInterface>(1);
        SystemInterface minimumGibbsEnergySystem = this.system.clone();
        for (int i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
            double numb = 0.0;
            clonedSystem.add(this.system.clone());
            ((SystemInterface)clonedSystem.get(i)).init(0);
            for (int j2 = 0; j2 < this.system.getPhases()[1].getNumberOfComponents(); ++j2) {
                numb = i == j2 ? 1.0 : 0.001;
                ((SystemInterface)clonedSystem.get(i)).getPhases()[1].getComponents()[j2].setx(numb);
            }
            ((SystemInterface)clonedSystem.get(i)).init(1);
        }
        this.lowestGibbsEnergyPhase = 0;
        for (k = 0; k < minimumGibbsEnergySystem.getPhases()[1].getNumberOfComponents(); ++k) {
            for (int i = 0; i < minimumGibbsEnergySystem.getPhases()[1].getNumberOfComponents(); ++i) {
                int n = k;
                sumw[n] = sumw[n] + ((SystemInterface)clonedSystem.get(k)).getPhases()[1].getComponents()[i].getx();
            }
        }
        for (k = 0; k < minimumGibbsEnergySystem.getPhases()[1].getNumberOfComponents(); ++k) {
            for (int i = 0; i < minimumGibbsEnergySystem.getPhases()[1].getNumberOfComponents(); ++i) {
                ((SystemInterface)clonedSystem.get(k)).getPhases()[1].getComponents()[i].setx(((SystemInterface)clonedSystem.get(k)).getPhases()[1].getComponents()[i].getx() / sumw[0]);
            }
            d[k] = Math.log(minimumGibbsEnergySystem.getPhases()[this.lowestGibbsEnergyPhase].getComponents()[k].getx()) + Math.log(minimumGibbsEnergySystem.getPhases()[this.lowestGibbsEnergyPhase].getComponents()[k].getFugacityCoefficient());
        }
        for (j = 0; j < minimumGibbsEnergySystem.getPhases()[1].getNumberOfComponents(); ++j) {
            logWi[j] = 1.0;
        }
        for (j = 0; j < this.system.getPhases()[1].getNumberOfComponents(); ++j) {
            int i;
            do {
                err = 0.0;
                ((SystemInterface)clonedSystem.get(j)).init(1);
                for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
                    oldlogw[i] = logWi[i];
                    logWi[i] = d[i] - Math.log(((SystemInterface)clonedSystem.get(j)).getPhases()[1].getComponents()[i].getFugacityCoefficient());
                    err += Math.abs(logWi[i] - oldlogw[i]);
                    Wi[j][i] = Math.exp(logWi[i]);
                }
                sumw[j] = 0.0;
                for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
                    int n = j;
                    sumw[n] = sumw[n] + Math.exp(logWi[i]);
                }
                for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
                    ((SystemInterface)clonedSystem.get(j)).getPhases()[1].getComponents()[i].setx(Math.exp(logWi[i]) / sumw[j]);
                }
            } while (Math.abs(err) > 1.0E-9);
            this.tm[j] = 1.0;
            for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
                int n = j;
                this.tm[n] = this.tm[n] - Math.exp(logWi[i]);
                x[j][i] = ((SystemInterface)clonedSystem.get(j)).getPhases()[1].getComponents()[i].getx();
            }
            logger.info("tm: " + this.tm[j]);
        }
        int unstabcomp = 0;
        for (int k2 = 0; k2 < this.system.getPhases()[1].getNumberOfComponents(); ++k2) {
            if (!(this.tm[k2] < -1.0E-8) || Double.isNaN(this.tm[k2])) continue;
            this.system.addPhase();
            unstabcomp = k2;
            for (int i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
                this.system.getPhases()[2].getComponents()[i].setx(x[k2][i]);
            }
            this.multiPhaseTest = true;
            this.system.setBeta(this.system.getNumberOfPhases() - 1, this.system.getPhase(0).getComponent(unstabcomp).getz());
            return;
        }
    }

    @Override
    public void run() {
        logger.info("Starting multiphase-flash....");
        this.stabilityAnalysis();
        this.system.init(1);
        if (this.multiPhaseTest && !this.system.isChemicalSystem()) {
            this.solveBeta();
        }
        double chemdev = 0.0;
        if (this.system.isChemicalSystem()) {
            for (int phase = 0; phase < this.system.getNumberOfPhases(); ++phase) {
                chemdev = 0.0;
                double[] xchem = new double[this.system.getPhases()[phase].getNumberOfComponents()];
                this.i = 0;
                while (this.i < this.system.getPhases()[0].getNumberOfComponents()) {
                    xchem[this.i] = this.system.getPhases()[phase].getComponents()[this.i].getx();
                    ++this.i;
                }
                this.system.init(1);
                this.system.getChemicalReactionOperations().solveChemEq(phase, 1);
                this.i = 0;
                while (this.i < this.system.getPhases()[0].getNumberOfComponents()) {
                    chemdev += Math.abs(xchem[this.i] - this.system.getPhases()[phase].getComponents()[this.i].getx());
                    ++this.i;
                }
                logger.info("chemdev: " + chemdev);
            }
        }
    }
}

