/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.Flash;
import neqsim.thermodynamicoperations.flashops.TPflash;
import org.jfree.chart.JFreeChart;

public class TVfractionFlash
extends Flash {
    private static final long serialVersionUID = 1000L;
    double Vfractionspec = 0.0;
    Flash tpFlash;

    public TVfractionFlash(SystemInterface system, double Vfractionspec) {
        this.system = system;
        this.tpFlash = new TPflash(system);
        this.Vfractionspec = Vfractionspec;
    }

    public double calcdQdVdP() {
        double dQdVP = 1.0 / this.system.getPhase(0).getdPdVTn() / this.system.getVolume() + this.system.getPhase(0).getVolume() / Math.pow(this.system.getVolume(), 2.0) * this.system.getdVdPtn();
        return dQdVP;
    }

    public double calcdQdV() {
        double dQ = this.system.getPhase(0).getVolume() / this.system.getVolume() - this.Vfractionspec;
        return dQ;
    }

    public double solveQ() {
        double dqdv;
        double oldPres = this.system.getPressure();
        double nyPres = this.system.getPressure();
        int iterations = 0;
        double error = 100.0;
        double pressureStep = 1.0;
        do {
            this.system.init(3);
            oldPres = nyPres;
            dqdv = this.calcdQdV();
            double dqdvdp = this.calcdQdVdP();
            nyPres = oldPres - (double)(++iterations) / ((double)iterations + 100.0) * dqdv / dqdvdp;
            pressureStep = nyPres - oldPres;
            if (nyPres <= 0.0) {
                nyPres = oldPres * 0.9;
            }
            this.system.setPressure(nyPres);
            this.tpFlash.run();
        } while ((error = Math.abs(dqdv / this.Vfractionspec)) > 1.0E-6 && Math.abs(pressureStep) > 1.0E-6 && iterations < 200 || iterations < 6);
        return nyPres;
    }

    @Override
    public void run() {
        this.tpFlash.run();
        if (this.system.getNumberOfPhases() == 1) {
            do {
                this.system.setPressure(this.system.getPressure() * 0.9);
                this.tpFlash.run();
            } while (this.system.getNumberOfPhases() == 1);
        }
        this.solveQ();
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

