/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BubblePointTemperatureFlash
extends ConstantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(BubblePointTemperatureFlash.class);

    public BubblePointTemperatureFlash(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        int i;
        int iterations = 0;
        int maxNumberOfIterations = 10000;
        double yold = 0.0;
        double ytotal = 1.0;
        double deriv = 0.0;
        double funk = 0.0;
        for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
            this.system.getPhases()[1].getComponents()[i].setx(this.system.getPhases()[0].getComponents()[i].getz());
            this.system.getPhases()[0].getComponents()[i].setx(this.system.getPhases()[0].getComponents()[i].getK() * this.system.getPhases()[1].getComponents()[i].getx());
        }
        this.system.setNumberOfPhases(2);
        do {
            this.system.setTemperature((this.system.getTemperature() + this.system.getTemperature() / ytotal) / 10.0);
            funk = 0.0;
            deriv = 0.0;
            ytotal = 0.0;
            this.system.init(2);
            for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
                do {
                    yold = this.system.getPhases()[0].getComponents()[i].getx();
                    this.system.getPhases()[0].getComponents()[i].setK(this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient() / this.system.getPhases()[0].getComponents()[i].getFugacityCoefficient());
                    this.system.getPhases()[1].getComponents()[i].setK(this.system.getPhases()[0].getComponents()[i].getK());
                    this.system.getPhases()[0].getComponents()[i].setx(this.system.getPhases()[1].getComponents()[i].getx() * this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient() / this.system.getPhases()[0].getComponents()[i].getFugacityCoefficient());
                } while (Math.abs(yold - this.system.getPhases()[1].getComponents()[i].getx()) > 1.0E-10 && ++iterations < maxNumberOfIterations);
                ytotal += this.system.getPhases()[0].getComponents()[i].getx();
                funk += this.system.getPhases()[1].getComponents()[i].getx() * this.system.getPhases()[1].getComponents()[i].getK();
                deriv += this.system.getPhases()[1].getComponents()[i].getx() * this.system.getPhases()[1].getComponents()[i].getK() * (this.system.getPhases()[1].getComponents()[i].getdfugdt() - this.system.getPhases()[0].getComponents()[i].getdfugdt());
            }
            logger.info("temp: " + this.system.getTemperature());
            this.system.setTemperature(-(funk - 1.0) / deriv + this.system.getTemperature());
        } while (Math.abs(ytotal - 1.0) > 1.0E-10 && iterations < maxNumberOfIterations);
    }

    @Override
    public void printToFile(String name) {
    }
}

