/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import Jama.Matrix;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyFlash;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyPressureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CricondebarFlash
extends ConstantDutyPressureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(ConstantDutyFlash.class);
    Matrix Jac;
    Matrix fvec;

    public CricondebarFlash(SystemInterface system) {
        super(system);
        this.Jac = new Matrix(system.getPhase(0).getNumberOfComponents() + 1, system.getPhase(0).getNumberOfComponents() + 1);
        this.fvec = new Matrix(system.getPhase(0).getNumberOfComponents() + 1, 1);
    }

    public double calcx() {
        int i;
        double xtotal = 0.0;
        for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
            this.system.getPhases()[0].getComponents()[i].setK(Math.exp(this.system.getPhases()[1].getComponents()[i].getLogFugacityCoefficient() - this.system.getPhases()[0].getComponents()[i].getLogFugacityCoefficient()));
            this.system.getPhases()[1].getComponents()[i].setK(this.system.getPhases()[0].getComponents()[i].getK());
            this.system.getPhases()[1].getComponents()[i].setx(1.0 / this.system.getPhases()[0].getComponents()[i].getK() * this.system.getPhases()[1].getComponents()[i].getz());
        }
        xtotal = 0.0;
        for (i = 0; i < this.system.getPhases()[1].getNumberOfComponents(); ++i) {
            xtotal += this.system.getPhases()[1].getComponents()[i].getx();
        }
        return xtotal;
    }

    public double initMoleFraction() {
        double[] XI = new double[this.system.getPhase(0).getNumberOfComponents()];
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            XI[i] = Math.exp(Math.log(this.system.getPhase(0).getComponent(i).getz()) + this.system.getPhase(0).getComponent(i).getLogFugacityCoefficient() - this.system.getPhase(1).getComponent(i).getLogFugacityCoefficient());
        }
        double tempSumXI = 1.0;
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            this.system.getPhase(1).getComponent(i).setx(XI[i] / tempSumXI);
        }
        return tempSumXI;
    }

    public void run2() {
        ThermodynamicOperations localOperation = new ThermodynamicOperations(this.system);
        this.system.init(0);
        this.system.setTemperature(this.system.getPhase(0).getPseudoCriticalTemperature() + 20.0);
        this.system.setPressure(this.system.getPhase(0).getPseudoCriticalPressure());
        this.system.init(3);
        int iterations = 0;
        int maxNumberOfIterations = 300;
        try {
            localOperation.dewPointTemperatureFlash();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        this.system.setNumberOfPhases(2);
        this.system.setBeta(0.5);
        this.system.setTemperature(this.system.getTemperature() - 20.0);
        this.system.init(3);
        this.system.display();
        double Q1 = 0.0;
        double Qold = 0.0;
        double dQ1dT = 0.0;
        double oldTemperature = 0.0;
        double oldIterTemp = 0.0;
        do {
            oldIterTemp = this.system.getTemperature();
            iterations = 0;
            do {
                ++iterations;
                this.initMoleFraction();
                this.system.init(3);
                Qold = Q1;
                Q1 = 0.0;
                for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
                    Q1 -= this.system.getPhase(1).getComponent(i).getx() * (this.system.getPhase(0).getComponent(i).getdfugdt() - this.system.getPhase(1).getComponent(i).getdfugdt());
                }
                dQ1dT = iterations > 1 ? (Q1 - Qold) / (this.system.getTemperature() - oldTemperature) : Q1 * 100.0;
                oldTemperature = this.system.getTemperature();
                this.system.setTemperature(this.system.getTemperature() - 0.5 * Q1 / dQ1dT);
                this.system.init(3);
                logger.info("temp " + this.system.getTemperature() + " Q1 " + Q1 + " pressure " + this.system.getPressure());
            } while (Math.abs(Q1) > 1.0E-10 && iterations < maxNumberOfIterations);
            iterations = 0;
            double presOld = this.system.getPressure();
            do {
                logger.info("temp " + this.system.getTemperature() + " Q1 " + Q1 + " pressure " + this.system.getPressure());
                Matrix dx = null;
                ++iterations;
                try {
                    this.system.init(3);
                    this.setfvec();
                    this.setJac();
                    dx = this.Jac.solve(this.fvec);
                }
                catch (Exception ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                }
                double damping = (double)iterations * 1.0 / (10.0 + (double)iterations);
                for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
                    double xlocal = this.system.getPhase(1).getComponent(i).getx() - damping * dx.get(i, 0);
                    if (xlocal < 1.0E-30) {
                        xlocal = 1.0E-30;
                    }
                    if (xlocal > 1.0) {
                        xlocal = 1.0;
                    }
                    logger.info("x" + xlocal + " press " + this.system.getPressure() + " fvec " + this.fvec.norm2());
                    this.system.getPhase(1).getComponent(i).setx(xlocal);
                }
                this.system.setPressure(this.system.getPressure() - damping * dx.get(this.system.getPhase(0).getNumberOfComponents(), 0));
            } while (Math.abs(this.fvec.norm2()) > 1.0E-12 && iterations < maxNumberOfIterations && Math.abs(presOld - this.system.getPressure()) < 10.0);
        } while (Math.abs(oldIterTemp - this.system.getTemperature()) > 0.001);
    }

    @Override
    public void run() {
        ThermodynamicOperations localOperation = new ThermodynamicOperations(this.system);
        this.system.init(0);
        this.system.init(3);
        int iterations = 0;
        localOperation.TPflash();
        double Q1 = 0.0;
        double Qold = 0.0;
        double dQ1dT = 1.0;
        double oldTemperature = 0.0;
        double dewTemp = 0.0;
        for (int ii = 0; ii < 45; ++ii) {
            this.system.setPressure(this.system.getPressure() + 1.0);
            try {
                dewTemp = this.system.getTemperature();
                this.system.getPressure();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
            iterations = 0;
            do {
                ++iterations;
                this.system.init(3);
                localOperation.TPflash();
                this.system.display();
                Qold = Q1;
                Q1 = 0.0;
                for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
                    Q1 -= this.system.getPhase(1).getComponent(i).getx() * (this.system.getPhase(0).getComponent(i).getdfugdt() - this.system.getPhase(1).getComponent(i).getdfugdt());
                }
                dQ1dT = iterations > 3 ? (Q1 - Qold) / (this.system.getTemperature() - oldTemperature) : -Q1 * 100.0;
                oldTemperature = this.system.getTemperature();
                this.system.setTemperature(this.system.getTemperature() - (double)iterations * 1.0 / ((double)iterations + 10.0) * Q1 / dQ1dT);
                logger.info("temp " + this.system.getTemperature() + "dewTemp " + dewTemp + " Q1 " + Q1 + " pressure " + this.system.getPressure());
            } while (Math.abs(Q1) > 1.0E-10 && iterations < 15);
            logger.info("temp " + this.system.getTemperature() + " Q1 " + Q1);
            logger.info("fvec " + this.fvec.norm2() + " pressure " + this.system.getPressure());
        }
    }

    public void setfvec() {
        double sumxx = 0.0;
        for (int i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            sumxx += this.system.getPhases()[1].getComponents()[i].getx();
            this.fvec.set(i, 0, Math.log(this.system.getPhases()[0].getComponents()[i].getFugacityCoefficient() * this.system.getPhases()[0].getComponents()[i].getz() * this.system.getPressure()) - Math.log(this.system.getPhases()[1].getComponents()[i].getFugacityCoefficient() * this.system.getPhases()[1].getComponents()[i].getx() * this.system.getPressure()));
        }
        this.fvec.set(this.system.getPhase(0).getNumberOfComponents(), 0, 1.0 - sumxx);
    }

    public void setJac() {
        int i;
        this.Jac.timesEquals(0.0);
        double dij = 0.0;
        double tempJ = 0.0;
        for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            for (int j = 0; j < this.system.getPhase(0).getNumberOfComponents(); ++j) {
                dij = i == j ? 1.0 : 0.0;
                tempJ = -dij * 1.0 / this.system.getPhases()[1].getComponents()[i].getx() - this.system.getPhases()[1].getComponents()[i].getdfugdx(j);
                this.Jac.set(i, j, tempJ);
            }
        }
        for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            this.Jac.set(this.system.getPhase(0).getNumberOfComponents(), i, -1.0);
        }
        for (i = 0; i < this.system.getPhase(0).getNumberOfComponents(); ++i) {
            this.Jac.set(i, this.system.getPhase(0).getNumberOfComponents(), this.system.getPhases()[0].getComponents()[i].getdfugdp() - this.system.getPhases()[1].getComponents()[i].getdfugdp());
        }
    }

    @Override
    public void printToFile(String name) {
    }
}

