/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import neqsim.thermo.ThermodynamicConstantsInterface;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FreezingPointTemperatureFlash
extends ConstantDutyTemperatureFlash
implements ThermodynamicConstantsInterface {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(FreezingPointTemperatureFlash.class);
    public boolean noFreezeFlash = true;
    public int Niterations = 0;
    public String name = "Frz";
    public String phaseName = "oil";

    public FreezingPointTemperatureFlash(SystemInterface system) {
        super(system);
    }

    public FreezingPointTemperatureFlash(SystemInterface system, boolean Freeze) {
        super(system);
        this.noFreezeFlash = Freeze;
    }

    public double calcFunc() {
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        double funk = 0.0;
        double SolidFugCoeff = 0.0;
        int numbComponents = this.system.getPhases()[0].getNumberOfComponents();
        for (int k = 0; k < numbComponents; ++k) {
            if (!this.system.getPhase(0).getComponent(k).doSolidCheck()) continue;
            ops.TPflash(false);
            SolidFugCoeff = this.system.getPhases()[3].getComponent(k).fugcoef(this.system.getPhases()[3]);
            funk = this.system.getPhase(0).getComponent(k).getz();
            for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
                funk -= this.system.getPhase(i).getBeta() * SolidFugCoeff / this.system.getPhase(i).getComponents()[k].getFugacityCoefficient();
            }
        }
        return funk;
    }

    @Override
    public void run() {
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        int iterations = 0;
        int maxNumberOfIterations = 100;
        double deriv = 0.0;
        double funk = 0.0;
        double funkOld = 0.0;
        double maxTemperature = -500.0;
        double minTemperature = 1000000.0;
        double oldTemperature = 0.0;
        double newTemp = 0.0;
        double SolidFugCoeff = 0.0;
        int numbComponents = this.system.getPhases()[0].getNumberOfComponents();
        String[] FCompNames = new String[numbComponents];
        double[] FCompTemp = new double[numbComponents];
        boolean SolidForms = false;
        for (int k = 0; k < numbComponents; ++k) {
            if (!this.system.getPhase(0).getComponent(k).doSolidCheck()) continue;
            SolidForms = true;
            FCompNames[k] = this.system.getPhase(0).getComponent(k).getComponentName();
            if (this.noFreezeFlash) {
                logger.info("Starting at Triple point temperature " + this.system.getPhase(0).getComponent(k).getComponentName());
            }
            funkOld = 0.0;
            newTemp = 0.0;
            iterations = 0;
            funk = 0.0;
            maxNumberOfIterations = 100;
            do {
                ++iterations;
                ops.TPflash(false);
                SolidFugCoeff = this.system.getPhases()[3].getComponent(k).fugcoef(this.system.getPhases()[3]);
                funk = this.system.getPhase(0).getComponent(k).getz();
                for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
                    funk -= this.system.getPhase(i).getBeta() * SolidFugCoeff / this.system.getPhase(i).getComponents()[k].getFugacityCoefficient();
                }
                logger.info("funk " + funk);
                deriv = iterations > 1 ? (funk - funkOld) / (this.system.getTemperature() - oldTemperature) : funk * 100.0;
                if (Math.abs(funk / deriv) > 10.0) {
                    // empty if block
                }
                logger.info("phase type " + (Object)((Object)this.system.getPhase(0).getType()));
                newTemp = this.system.getTemperature() - 0.9 * funk / deriv;
                logger.info("temperature " + this.system.getTemperature());
                oldTemperature = this.system.getTemperature();
                funkOld = funk;
                this.system.setTemperature(newTemp);
            } while (Math.abs(funk) >= 1.0E-12 && iterations < maxNumberOfIterations);
            FCompTemp[k] = newTemp;
            if (this.system.getTemperature() < minTemperature) {
                minTemperature = oldTemperature;
            }
            if (!(this.system.getTemperature() > maxTemperature)) continue;
            maxTemperature = oldTemperature;
        }
        if (SolidForms) {
            this.system.setTemperature(maxTemperature);
        }
        this.system.init(1);
    }

    public void printToFile(String name, String[] FCompNames, double[] FCompTemp) {
        for (int n = 0; n < this.system.getPhases()[0].getNumberOfComponents(); ++n) {
            name = name + "_" + this.system.getPhase(0).getComponent(n).getComponentName();
        }
        String myFile = "/java/" + name + ".frz";
        try (PrintWriter pr_writer = new PrintWriter(new FileWriter(myFile, true));){
            pr_writer.println("name,freezeT,freezeP,z,iterations");
            pr_writer.flush();
            for (int k = 0; k < this.system.getPhases()[0].getNumberOfComponents(); ++k) {
                pr_writer.println(FCompNames[k] + "," + Double.toString(FCompTemp[k]) + "," + this.system.getPressure() + "," + Double.toString(this.system.getPhases()[0].getComponents()[k].getz()) + "," + this.Niterations);
                pr_writer.flush();
            }
        }
        catch (SecurityException ex) {
            logger.error("writeFile: caught security exception");
        }
        catch (IOException ioe) {
            logger.error("writeFile: caught i/o exception");
        }
    }
}

