/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.flashops.saturationops;

import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.flashops.saturationops.ConstantDutyTemperatureFlash;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FreezingPointTemperatureFlashOld
extends ConstantDutyTemperatureFlash {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(FreezingPointTemperatureFlashOld.class);

    public FreezingPointTemperatureFlashOld(SystemInterface system) {
        super(system);
    }

    @Override
    public void run() {
        ThermodynamicOperations ops = new ThermodynamicOperations(this.system);
        int iterations = 0;
        double deriv = 0.0;
        double funk = 0.0;
        double funkOld = 0.0;
        double maxTemperature = 0.0;
        double minTemperature = 1000000.0;
        double oldTemperature = 0.0;
        for (int k = 0; k < this.system.getPhases()[0].getNumberOfComponents(); ++k) {
            if (!(this.system.getPhase(3).getComponent(k).fugcoef(this.system.getPhase(3)) < 90000.0) || !this.system.getPhase(3).getComponent(k).doSolidCheck()) continue;
            this.system.setTemperature(this.system.getPhases()[0].getComponents()[k].getMeltingPointTemperature());
            this.system.init(0);
            this.system.init(1);
            iterations = 0;
            do {
                funk = 0.0;
                deriv = 0.0;
                ++iterations;
                this.system.setSolidPhaseCheck(false);
                ops.TPflash();
                this.system.getPhase(3).getComponent(k).fugcoef(this.system.getPhase(3));
                funk = this.system.getPhases()[0].getComponents()[k].getz();
                logger.info("phase " + this.system.getNumberOfPhases());
                for (int i = 0; i < this.system.getNumberOfPhases(); ++i) {
                    funk -= this.system.getPhases()[i].getBeta() * this.system.getPhases()[3].getComponents()[k].getFugacityCoefficient() / this.system.getPhases()[i].getComponents()[k].getFugacityCoefficient();
                    deriv -= 0.01 * this.system.getPhases()[i].getBeta() * (this.system.getPhases()[3].getComponents()[k].getFugacityCoefficient() * Math.exp(this.system.getPhases()[i].getComponents()[k].getdfugdt()) * -1.0 / Math.pow(this.system.getPhases()[i].getComponents()[k].getFugacityCoefficient(), 2.0) + Math.exp(this.system.getPhases()[3].getComponents()[k].getdfugdt()) / this.system.getPhases()[i].getComponents()[k].getFugacityCoefficient());
                }
                deriv = iterations >= 2 ? -(funk - funkOld) / (this.system.getTemperature() - oldTemperature) : -funk;
                oldTemperature = this.system.getTemperature();
                funkOld = funk;
                this.system.setTemperature(this.system.getTemperature() + 0.5 * ((double)iterations / (10.0 + (double)iterations)) * funk / deriv);
                logger.info("funk/deriv " + funk / deriv);
                logger.info("temperature " + this.system.getTemperature());
            } while (Math.abs(funk / deriv) >= 1.0E-6 && iterations < 100);
            if (this.system.getTemperature() < minTemperature) {
                minTemperature = this.system.getTemperature();
            }
            if (!(this.system.getTemperature() > maxTemperature)) continue;
            maxTemperature = this.system.getTemperature();
        }
        this.system.setTemperature(maxTemperature);
    }

    @Override
    public void printToFile(String name) {
    }
}

