/*
 * Decompiled with CFR 0.152.
 */
package neqsim.thermodynamicoperations.phaseenvelopeops.multicomponentenvelopeops;

import java.util.ArrayList;
import neqsim.thermo.system.SystemInterface;
import neqsim.thermodynamicoperations.BaseOperation;
import neqsim.thermodynamicoperations.ThermodynamicOperations;
import neqsim.thermodynamicoperations.phaseenvelopeops.multicomponentenvelopeops.SysNewtonRhapsonPhaseEnvelope;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jfree.chart.JFreeChart;

public class PTphaseEnvelopeNew2
extends BaseOperation {
    private static final long serialVersionUID = 1000L;
    static Logger logger = LogManager.getLogger(PTphaseEnvelopeNew2.class);
    double maxPressure = 1000.0;
    double minPressure = 1.0;
    SystemInterface system;
    boolean bubblePointFirst = true;
    boolean calculatesDewPoint = true;
    double[] cricondenTherm = new double[3];
    double[] cricondenBar = new double[3];
    double[] cricondenThermX = new double[100];
    double[] cricondenThermY = new double[100];
    double[] cricondenBarX = new double[100];
    double[] cricondenBarY = new double[100];
    double phaseFraction = 1.0E-10;
    int i;
    int j = 0;
    int nummer = 0;
    int iterations = 0;
    int maxNumberOfIterations = 10000;
    double gibbsEnergy = 0.0;
    double gibbsEnergyOld = 0.0;
    double Kold;
    double deviation = 0.0;
    double g0 = 0.0;
    double g1 = 0.0;
    double lowPres = 1.0;
    double[] lnOldOldK;
    double[] lnK;
    boolean outputToFile = false;
    double[] lnOldK;
    double[] lnKwil;
    double[] oldDeltalnK;
    double[] deltalnK;
    double[] tm = new double[]{1.0, 1.0};
    double beta = 1.0E-5;
    int lowestGibbsEnergyPhase = 0;
    String fileName = "c:/file";
    double temp = 0.0;
    double pres = 0.0;
    double startPres = 0.0;
    boolean moreLines = false;
    boolean restart = true;
    int np = 0;
    int speceq = 0;
    double Tcfirst;
    double Pcfirst;
    double Tmin = 0.0;
    ArrayList<Double> dewPointTemperature = new ArrayList();
    ArrayList<Double> dewPointPressure = new ArrayList();
    ArrayList<Double> bubblePointTemperature = new ArrayList();
    ArrayList<Double> bubblePointPressure = new ArrayList();
    ArrayList<Double> bubblePointEnthalpy = new ArrayList();
    ArrayList<Double> dewPointEnthalpy = new ArrayList();
    ArrayList<Double> bubblePointEntropy = new ArrayList();
    ArrayList<Double> dewPointEntropy = new ArrayList();
    ArrayList<Double> bubblePointVolume = new ArrayList();
    ArrayList<Double> dewPointVolume = new ArrayList();
    double[] cricondenThermfirst = new double[3];
    double[] cricondenBarfirst = new double[3];
    double[] cricondenThermXfirst = new double[100];
    double[] cricondenThermYfirst = new double[100];
    double[] cricondenBarXfirst = new double[100];
    double[] cricondenBarYfirst = new double[100];
    double[] dewPointTemperatureArray;
    double[] dewPointPressureArray;
    double[] dewPointEnthalpyArray;
    double[] dewPointVolumeArray;
    double[] dewPointEntropyArray;
    double[] bubblePointTemperatureArray;
    double[] bubblePointPressureArray;
    double[] bubblePointEnthalpyArray;
    double[] bubblePointVolumeArray;
    double[] bubblePointEntropyArray;

    public PTphaseEnvelopeNew2() {
    }

    public PTphaseEnvelopeNew2(SystemInterface system, String name, double phaseFraction, double lowPres, boolean bubfirst) {
        this.bubblePointFirst = bubfirst;
        if (name != null) {
            this.outputToFile = true;
            this.fileName = name;
        }
        this.system = system;
        this.phaseFraction = phaseFraction;
        this.lnOldOldK = new double[system.getPhase(0).getNumberOfComponents()];
        this.lnOldK = new double[system.getPhase(0).getNumberOfComponents()];
        this.lnK = new double[system.getPhase(0).getNumberOfComponents()];
        this.lowPres = lowPres;
        this.oldDeltalnK = new double[system.getPhase(0).getNumberOfComponents()];
        this.deltalnK = new double[system.getPhase(0).getNumberOfComponents()];
    }

    @Override
    public void run() {
        int i;
        this.speceq = 0;
        try {
            this.system.init(0);
            for (int i2 = 0; i2 < this.system.getPhase(0).getNumberOfComponents(); ++i2) {
                if (this.system.getComponent(i2).getz() < 1.0E-10 || this.system.getPhase(0).getComponent(i2).getIonicCharge() != 0.0) continue;
                if (this.bubblePointFirst && this.system.getPhase(0).getComponents()[this.speceq].getTC() > this.system.getPhase(0).getComponents()[i2].getTC()) {
                    this.speceq = this.system.getPhase(0).getComponent(i2).getComponentNumber();
                }
                if (this.bubblePointFirst || !(this.system.getPhase(0).getComponents()[this.speceq].getTC() < this.system.getPhase(0).getComponents()[i2].getTC())) continue;
                this.speceq = this.system.getPhase(0).getComponent(i2).getComponentNumber();
            }
            this.pres = this.lowPres;
            this.temp = this.tempKWilson(this.phaseFraction, this.pres);
            if (Double.isNaN(this.temp)) {
                this.temp = this.system.getPhase(0).getComponent(this.speceq).getTC() - 20.0;
            }
            this.system.setTemperature(this.temp);
            this.system.setPressure(this.pres);
            ThermodynamicOperations testOps = new ThermodynamicOperations(this.system);
            for (int i3 = 0; i3 < 5; ++i3) {
                try {
                    if (this.phaseFraction < 0.5) {
                        this.temp += (double)(i3 * 2);
                        this.system.setTemperature(this.temp);
                        testOps.bubblePointTemperatureFlash();
                    } else {
                        this.temp += (double)(i3 * 2);
                        this.system.setTemperature(this.temp);
                        testOps.dewPointTemperatureFlash();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                double tempNy = this.system.getTemperature();
                if (Double.isNaN(tempNy)) continue;
                this.temp = tempNy;
                break;
            }
            this.system.setBeta(this.phaseFraction);
            this.system.setPressure(this.pres);
            this.system.setTemperature(this.temp);
            SysNewtonRhapsonPhaseEnvelope nonLinSolver = new SysNewtonRhapsonPhaseEnvelope(this.system, 2, this.system.getPhase(0).getNumberOfComponents());
            this.startPres = this.system.getPressure();
            nonLinSolver.setu();
            this.np = 1;
            while (this.np < 9980) {
                int ii;
                try {
                    nonLinSolver.calcInc(this.np);
                    nonLinSolver.solve(this.np);
                }
                catch (Exception e0) {
                    if (this.restart) {
                        this.calculatesDewPoint = false;
                        this.restart = !this.restart;
                        this.Tcfirst = this.system.getTC();
                        this.Pcfirst = this.system.getPC();
                        this.cricondenBarfirst = this.cricondenBar;
                        this.cricondenBarXfirst = this.cricondenBarX;
                        this.cricondenBarYfirst = this.cricondenBarY;
                        this.cricondenThermfirst = this.cricondenTherm;
                        this.cricondenThermXfirst = this.cricondenThermX;
                        this.cricondenThermYfirst = this.cricondenThermY;
                        this.phaseFraction = 1.0 - this.phaseFraction;
                        this.bubblePointFirst = !this.bubblePointFirst;
                        this.run();
                        break;
                    }
                    --this.np;
                    break;
                }
                double Kvallc = this.system.getPhase(0).getComponent(nonLinSolver.lc).getx() / this.system.getPhase(1).getComponent(nonLinSolver.lc).getx();
                double Kvalhc = this.system.getPhase(0).getComponent(nonLinSolver.hc).getx() / this.system.getPhase(1).getComponent(nonLinSolver.hc).getx();
                if (!nonLinSolver.etterCP && Kvallc < 1.05 && Kvalhc > 0.95) {
                    nonLinSolver.npCrit = this.np;
                    this.system.invertPhaseTypes();
                    nonLinSolver.etterCP = true;
                    this.calculatesDewPoint = false;
                    nonLinSolver.calcCrit();
                }
                if (this.system.getTemperature() > this.cricondenTherm[0]) {
                    this.cricondenTherm[1] = this.system.getPressure();
                    this.cricondenTherm[0] = this.system.getTemperature();
                    for (ii = 0; ii < nonLinSolver.numberOfComponents; ++ii) {
                        this.cricondenThermX[ii] = this.system.getPhase(1).getComponent(ii).getx();
                        this.cricondenThermY[ii] = this.system.getPhase(0).getComponent(ii).getx();
                    }
                } else {
                    nonLinSolver.ettercricoT = true;
                }
                if (this.system.getPressure() > this.cricondenBar[1]) {
                    this.cricondenBar[0] = this.system.getTemperature();
                    this.cricondenBar[1] = this.system.getPressure();
                    for (ii = 0; ii < nonLinSolver.numberOfComponents; ++ii) {
                        this.cricondenBarX[ii] = this.system.getPhase(1).getComponent(ii).getx();
                        this.cricondenBarY[ii] = this.system.getPhase(0).getComponent(ii).getx();
                    }
                }
                if (this.system.getPressure() < this.minPressure && nonLinSolver.ettercricoT || this.system.getPressure() > this.maxPressure || this.system.getTemperature() < this.Tmin) break;
                if (this.system.getTemperature() > 1.0E-6 && this.system.getPressure() > 1.0E-6 && !Double.isNaN(this.system.getTemperature()) && !Double.isNaN(this.system.getPressure())) {
                    if (this.calculatesDewPoint) {
                        this.dewPointTemperature.add(this.system.getTemperature());
                        this.dewPointPressure.add(this.system.getPressure());
                        this.dewPointEnthalpy.add(this.system.getPhase(1).getEnthalpy() / this.system.getPhase(1).getNumberOfMolesInPhase() / this.system.getPhase(1).getMolarMass() / 1000.0);
                        this.dewPointVolume.add(this.system.getPhase(1).getDensity());
                        this.dewPointEntropy.add(this.system.getPhase(1).getEntropy() / this.system.getPhase(1).getNumberOfMolesInPhase() / this.system.getPhase(1).getMolarMass() / 1000.0);
                    } else {
                        this.bubblePointTemperature.add(this.system.getTemperature());
                        this.bubblePointPressure.add(this.system.getPressure());
                        this.bubblePointEnthalpy.add(this.system.getPhase(1).getEnthalpy() / this.system.getPhase(1).getNumberOfMolesInPhase() / this.system.getPhase(1).getMolarMass() / 1000.0);
                        this.bubblePointVolume.add(this.system.getPhase(1).getDensity());
                        this.bubblePointEntropy.add(this.system.getPhase(1).getEntropy() / this.system.getPhase(1).getNumberOfMolesInPhase() / this.system.getPhase(1).getMolarMass() / 1000.0);
                    }
                }
                ++this.np;
            }
            this.system.setTemperature(this.system.getTC());
            this.system.setPressure(this.system.getPC());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        this.dewPointTemperatureArray = new double[this.dewPointTemperature.size()];
        this.dewPointPressureArray = new double[this.dewPointPressure.size()];
        this.dewPointEnthalpyArray = new double[this.dewPointTemperature.size()];
        this.dewPointVolumeArray = new double[this.dewPointPressure.size()];
        this.dewPointEntropyArray = new double[this.dewPointPressure.size()];
        this.bubblePointTemperatureArray = new double[this.bubblePointTemperature.size()];
        this.bubblePointPressureArray = new double[this.bubblePointPressure.size()];
        this.bubblePointEnthalpyArray = new double[this.bubblePointPressure.size()];
        this.bubblePointVolumeArray = new double[this.bubblePointPressure.size()];
        this.bubblePointEntropyArray = new double[this.bubblePointPressure.size()];
        for (i = 0; i < this.dewPointTemperature.size(); ++i) {
            this.dewPointTemperatureArray[i] = this.dewPointTemperature.get(i);
            this.dewPointPressureArray[i] = this.dewPointPressure.get(i);
            this.dewPointEnthalpyArray[i] = this.dewPointEnthalpy.get(i);
            this.dewPointVolumeArray[i] = this.dewPointVolume.get(i);
            this.dewPointEntropyArray[i] = this.dewPointEntropy.get(i);
        }
        for (i = 0; i < this.bubblePointTemperature.size(); ++i) {
            this.bubblePointTemperatureArray[i] = this.bubblePointTemperature.get(i);
            this.bubblePointPressureArray[i] = this.bubblePointPressure.get(i);
            this.bubblePointEnthalpyArray[i] = this.bubblePointEnthalpy.get(i);
            this.bubblePointEntropyArray[i] = this.bubblePointEntropy.get(i);
            this.bubblePointVolumeArray[i] = this.bubblePointVolume.get(i);
        }
    }

    public void calcHydrateLine() {
        ThermodynamicOperations opsHyd = new ThermodynamicOperations(this.system);
        try {
            opsHyd.hydrateEquilibriumLine(10.0, 300.0);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void printToFile(String name) {
    }

    @Override
    public double[] get(String name) {
        if (name.equals("dewT")) {
            return this.dewPointTemperatureArray;
        }
        if (name.equals("dewP")) {
            return this.dewPointPressureArray;
        }
        if (name.equals("bubT")) {
            return this.bubblePointTemperatureArray;
        }
        if (name.equals("bubP")) {
            return this.bubblePointPressureArray;
        }
        if (name.equals("dewH")) {
            return this.dewPointEnthalpyArray;
        }
        if (name.equals("dewDens")) {
            return this.dewPointVolumeArray;
        }
        if (name.equals("dewS")) {
            return this.dewPointEntropyArray;
        }
        if (name.equals("bubH")) {
            return this.bubblePointEnthalpyArray;
        }
        if (name.equals("bubDens")) {
            return this.bubblePointVolumeArray;
        }
        if (name.equals("bubS")) {
            return this.bubblePointEntropyArray;
        }
        if (name.equals("cricondentherm")) {
            return this.cricondenTherm;
        }
        if (name.equals("cricondenthermX")) {
            return this.cricondenThermX;
        }
        if (name.equals("cricondenthermY")) {
            return this.cricondenThermY;
        }
        if (name.equals("cricondenbar")) {
            return this.cricondenBar;
        }
        if (name.equals("cricondenbarX")) {
            return this.cricondenBarX;
        }
        if (name.equals("cricondenbarY")) {
            return this.cricondenBarY;
        }
        if (name.equals("criticalPoint1")) {
            return new double[]{this.system.getTC(), this.system.getPC()};
        }
        if (name.equals("criticalPoint2")) {
            return new double[]{0.0, 0.0};
        }
        return null;
    }

    public boolean isBubblePointFirst() {
        return this.bubblePointFirst;
    }

    public void setBubblePointFirst(boolean bubblePointFirst) {
        this.bubblePointFirst = bubblePointFirst;
    }

    @Override
    public String[][] getResultTable() {
        return null;
    }

    public double tempKWilson(double beta, double P) {
        int i;
        double initTc = 0.0;
        double initPc = 0.0;
        double initAc = 0.0;
        double Tstart = 0.0;
        double Tstartold = 0.0;
        double initT = 0.0;
        double dinitT = 0.0;
        int numberOfComponents = this.system.getPhase(0).getNumberOfComponents();
        int lc = 0;
        int hc = 0;
        double[] Kwil = new double[numberOfComponents];
        double min = 100000.0;
        double max = 0.0;
        for (i = 0; i < numberOfComponents; ++i) {
            if (this.system.getPhase(0).getComponents()[i].getTC() > max) {
                max = this.system.getPhase(0).getComponents()[i].getTC();
                hc = i;
            }
            if (!(this.system.getPhase(0).getComponents()[i].getTC() < min)) continue;
            min = this.system.getPhase(0).getComponents()[i].getTC();
            lc = i;
        }
        try {
            if (beta <= 0.5) {
                initTc = this.system.getPhase(0).getComponents()[lc].getTC();
                initPc = this.system.getPhase(0).getComponents()[lc].getPC();
                initAc = this.system.getPhase(0).getComponents()[lc].getAcentricFactor();
            } else {
                initTc = this.system.getPhase(0).getComponents()[hc].getTC();
                initPc = this.system.getPhase(0).getComponents()[hc].getPC();
                initAc = this.system.getPhase(0).getComponents()[hc].getAcentricFactor();
            }
            Tstart = initTc * 5.373 * (1.0 + initAc) / (5.373 * (1.0 + initAc) - Math.log(P / initPc));
            for (i = 0; i < 1000; ++i) {
                int j;
                initT = 0.0;
                dinitT = 0.0;
                for (j = 0; j < numberOfComponents; ++j) {
                    Kwil[j] = this.system.getPhase(0).getComponents()[j].getPC() / P * Math.exp(5.373 * (1.0 + this.system.getPhase(0).getComponents()[j].getAcentricFactor()) * (1.0 - this.system.getPhase(0).getComponents()[j].getTC() / Tstart));
                }
                for (j = 0; j < numberOfComponents; ++j) {
                    if (beta < 0.5) {
                        initT += this.system.getPhase(0).getComponents()[j].getz() * Kwil[j];
                        dinitT += this.system.getPhase(0).getComponents()[j].getz() * Kwil[j] * 5.373 * (1.0 + this.system.getPhase(0).getComponents()[j].getAcentricFactor()) * this.system.getPhase(0).getComponents()[j].getTC() / (Tstart * Tstart);
                        continue;
                    }
                    initT += this.system.getPhase(0).getComponents()[j].getz() / Kwil[j];
                    dinitT -= this.system.getPhase(0).getComponents()[j].getz() / Kwil[j] * 5.373 * (1.0 + this.system.getPhase(0).getComponents()[j].getAcentricFactor()) * this.system.getPhase(0).getComponents()[j].getTC() / (Tstart * Tstart);
                }
                Tstart = Math.abs((initT -= 1.0) / dinitT) > 0.1 * Tstart ? (Tstart -= 0.001 * initT / dinitT) : (Tstart -= initT / dinitT);
                if (Math.abs(Tstart - Tstartold) < 1.0E-5) {
                    return Tstart;
                }
                Tstartold = Tstart;
            }
        }
        catch (Exception ex) {
            Tstart = initTc * 5.373 * (1.0 + initAc) / (5.373 * (1.0 + initAc) - Math.log(P / initPc));
        }
        if (Double.isNaN(Tstart) || Double.isInfinite(Tstart)) {
            Tstart = initTc * 5.373 * (1.0 + initAc) / (5.373 * (1.0 + initAc) - Math.log(P / initPc));
        }
        return Tstart;
    }

    @Override
    public void displayResult() {
    }

    @Override
    public JFreeChart getJFreeChart(String name) {
        return null;
    }
}

