"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.challenge import Challenge
from agilicus_api.model.challenge_answer import ChallengeAnswer
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.list_totp_enrollment_response import ListTOTPEnrollmentResponse
from agilicus_api.model.list_web_auth_n_enrollment_response import ListWebAuthNEnrollmentResponse
from agilicus_api.model.one_time_use_action_challenge import OneTimeUseActionChallenge
from agilicus_api.model.one_time_use_action_challenge_response import OneTimeUseActionChallengeResponse
from agilicus_api.model.totp_enrollment import TOTPEnrollment
from agilicus_api.model.totp_enrollment_answer import TOTPEnrollmentAnswer
from agilicus_api.model.web_auth_n_enrollment import WebAuthNEnrollment
from agilicus_api.model.web_auth_n_enrollment_answer import WebAuthNEnrollmentAnswer


class ChallengesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_challenge(
            self,
            challenge,
            **kwargs
        ):
            """create a challenge  # noqa: E501

            Creates a challenge according to the provide specification. This challenge will persist for a period of time waiting for the challenge to be passed. It will eventually time out.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_challenge(challenge, async_req=True)
            >>> result = thread.get()

            Args:
                challenge (Challenge): The challenge to create

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Challenge
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['challenge'] = \
                challenge
            return self.call_with_http_info(**kwargs)

        if self.create_challenge is None:
            self.create_challenge = _Endpoint(
                settings={
                    'response_type': (Challenge,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/challenges',
                    'operation_id': 'create_challenge',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'challenge',
                    ],
                    'required': [
                        'challenge',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'challenge':
                            (Challenge,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'challenge': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_challenge
            )

        def __create_one_time_use_action(
            self,
            one_time_use_action_challenge,
            **kwargs
        ):
            """create a one time use action challenge  # noqa: E501

            Creates a one time use challenge according to the provide specification. This challenge will persist for a period of time waiting for the challenge to be passed. It will eventually time out. If the challenge is accepted or declined, the system will perform an action according to the configuration provided on challenge creation and the provided answer.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_one_time_use_action(one_time_use_action_challenge, async_req=True)
            >>> result = thread.get()

            Args:
                one_time_use_action_challenge (OneTimeUseActionChallenge): The challenge to create

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                OneTimeUseActionChallengeResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['one_time_use_action_challenge'] = \
                one_time_use_action_challenge
            return self.call_with_http_info(**kwargs)

        if self.create_one_time_use_action is None:
            self.create_one_time_use_action = _Endpoint(
                settings={
                    'response_type': (OneTimeUseActionChallengeResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/challenges/one_time_use_actions',
                    'operation_id': 'create_one_time_use_action',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'one_time_use_action_challenge',
                    ],
                    'required': [
                        'one_time_use_action_challenge',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'one_time_use_action_challenge':
                            (OneTimeUseActionChallenge,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'one_time_use_action_challenge': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_one_time_use_action
            )

        def __create_totp_enrollment(
            self,
            totp_enrollment,
            **kwargs
        ):
            """create a TOTP challenge enrollment  # noqa: E501

            Creates a TOTP challenge enrollment. The returned body will contain the key the user needs to enroll in their application. The enrollment is not complete until the user provides a valid answer.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_totp_enrollment(totp_enrollment, async_req=True)
            >>> result = thread.get()

            Args:
                totp_enrollment (TOTPEnrollment): The TOTP challenge enrollment to create.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TOTPEnrollment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['totp_enrollment'] = \
                totp_enrollment
            return self.call_with_http_info(**kwargs)

        if self.create_totp_enrollment is None:
            self.create_totp_enrollment = _Endpoint(
                settings={
                    'response_type': (TOTPEnrollment,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/challenge_enrollment/totp',
                    'operation_id': 'create_totp_enrollment',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'totp_enrollment',
                    ],
                    'required': [
                        'totp_enrollment',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'totp_enrollment':
                            (TOTPEnrollment,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'totp_enrollment': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_totp_enrollment
            )

        def __create_webauthn_enrollment(
            self,
            web_auth_n_enrollment,
            **kwargs
        ):
            """create a WebAuthN challenge enrollment  # noqa: E501

            Initiates a WebAuthN challenge enrollment. The enrollment is not complete until the user provides a valid answer.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_webauthn_enrollment(web_auth_n_enrollment, async_req=True)
            >>> result = thread.get()

            Args:
                web_auth_n_enrollment (WebAuthNEnrollment): The WebAuthN challenge enrollment to create.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WebAuthNEnrollment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['web_auth_n_enrollment'] = \
                web_auth_n_enrollment
            return self.call_with_http_info(**kwargs)

        if self.create_webauthn_enrollment is None:
            self.create_webauthn_enrollment = _Endpoint(
                settings={
                    'response_type': (WebAuthNEnrollment,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/challenge_enrollment/webauthn',
                    'operation_id': 'create_webauthn_enrollment',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'web_auth_n_enrollment',
                    ],
                    'required': [
                        'web_auth_n_enrollment',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'web_auth_n_enrollment':
                            (WebAuthNEnrollment,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'web_auth_n_enrollment': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_webauthn_enrollment
            )

        def __delete_challenge(
            self,
            challenge_id,
            **kwargs
        ):
            """Delete the challenge specified by challenge_id  # noqa: E501

            Delete the challenge specified by challenge_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_challenge(challenge_id, async_req=True)
            >>> result = thread.get()

            Args:
                challenge_id (str): A challenge id found in a path.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['challenge_id'] = \
                challenge_id
            return self.call_with_http_info(**kwargs)

        if self.delete_challenge is None:
            self.delete_challenge = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [],
                    'endpoint_path': '/v1/challenges/{challenge_id}',
                    'operation_id': 'delete_challenge',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'challenge_id',
                    ],
                    'required': [
                        'challenge_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'challenge_id':
                            (str,),
                    },
                    'attribute_map': {
                        'challenge_id': 'challenge_id',
                    },
                    'location_map': {
                        'challenge_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_challenge
            )

        def __delete_totp_enrollment(
            self,
            totp_id,
            **kwargs
        ):
            """Delete the TOTP enrollment specified by totp id  # noqa: E501

            Delete the TOTP enrollment specified by totp id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_totp_enrollment(totp_id, async_req=True)
            >>> result = thread.get()

            Args:
                totp_id (str): A totp id found in a path.

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['totp_id'] = \
                totp_id
            return self.call_with_http_info(**kwargs)

        if self.delete_totp_enrollment is None:
            self.delete_totp_enrollment = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/challenge_enrollment/totp/{totp_id}',
                    'operation_id': 'delete_totp_enrollment',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'totp_id',
                        'user_id',
                    ],
                    'required': [
                        'totp_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'totp_id':
                            (str,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'totp_id': 'totp_id',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'totp_id': 'path',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_totp_enrollment
            )

        def __delete_webauthn_enrollment(
            self,
            webauthn_id,
            **kwargs
        ):
            """Delete the WebAuthN enrollment specified by webauthn_id  # noqa: E501

            Delete the WebAuthN enrollment specified by webauthn_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_webauthn_enrollment(webauthn_id, async_req=True)
            >>> result = thread.get()

            Args:
                webauthn_id (str): A webauthn id found in a path.

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['webauthn_id'] = \
                webauthn_id
            return self.call_with_http_info(**kwargs)

        if self.delete_webauthn_enrollment is None:
            self.delete_webauthn_enrollment = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/challenge_enrollment/webauthn/{webauthn_id}',
                    'operation_id': 'delete_webauthn_enrollment',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'webauthn_id',
                        'user_id',
                    ],
                    'required': [
                        'webauthn_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'webauthn_id':
                            (str,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'webauthn_id': 'webauthn_id',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'webauthn_id': 'path',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_webauthn_enrollment
            )

        def __get_answer(
            self,
            challenge_id,
            challenge_answer,
            allowed,
            challenge_type,
            **kwargs
        ):
            """answer a challenge  # noqa: E501

            Checks whether the challenge answer is correct. If the challenge is not accepting answers, or the anwer is incorrect, a failure will be returned. Otherwise, the challenge will be considered answered and the user can log in.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_answer(challenge_id, challenge_answer, allowed, challenge_type, async_req=True)
            >>> result = thread.get()

            Args:
                challenge_id (str): A challenge id found in a path.
                challenge_answer (str): The answer for the challenge
                allowed (bool): Whether the challenge was allowed. If true, then the user can proceed with the login. If false, then the user will be denied their login attempt. Set this to false if the login attempt was not desired. 
                challenge_type (str): challenge method type query

            Keyword Args:
                challenge_uid (str): The user id for the challenge. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ChallengeAnswer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['challenge_id'] = \
                challenge_id
            kwargs['challenge_answer'] = \
                challenge_answer
            kwargs['allowed'] = \
                allowed
            kwargs['challenge_type'] = \
                challenge_type
            return self.call_with_http_info(**kwargs)

        if self.get_answer is None:
            self.get_answer = _Endpoint(
                settings={
                    'response_type': (ChallengeAnswer,),
                    'auth': [],
                    'endpoint_path': '/v1/challenges/{challenge_id}/answers',
                    'operation_id': 'get_answer',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'challenge_id',
                        'challenge_answer',
                        'allowed',
                        'challenge_type',
                        'challenge_uid',
                    ],
                    'required': [
                        'challenge_id',
                        'challenge_answer',
                        'allowed',
                        'challenge_type',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'challenge_id':
                            (str,),
                        'challenge_answer':
                            (str,),
                        'allowed':
                            (bool,),
                        'challenge_type':
                            (str,),
                        'challenge_uid':
                            (str,),
                    },
                    'attribute_map': {
                        'challenge_id': 'challenge_id',
                        'challenge_answer': 'challenge_answer',
                        'allowed': 'allowed',
                        'challenge_type': 'challenge_type',
                        'challenge_uid': 'challenge_uid',
                    },
                    'location_map': {
                        'challenge_id': 'path',
                        'challenge_answer': 'query',
                        'allowed': 'query',
                        'challenge_type': 'query',
                        'challenge_uid': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_answer
            )

        def __get_challenge(
            self,
            challenge_id,
            **kwargs
        ):
            """Get the challenge specified by challenge_id  # noqa: E501

            Get the challenge specified by challenge_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_challenge(challenge_id, async_req=True)
            >>> result = thread.get()

            Args:
                challenge_id (str): A challenge id found in a path.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Challenge
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['challenge_id'] = \
                challenge_id
            return self.call_with_http_info(**kwargs)

        if self.get_challenge is None:
            self.get_challenge = _Endpoint(
                settings={
                    'response_type': (Challenge,),
                    'auth': [],
                    'endpoint_path': '/v1/challenges/{challenge_id}',
                    'operation_id': 'get_challenge',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'challenge_id',
                    ],
                    'required': [
                        'challenge_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'challenge_id':
                            (str,),
                    },
                    'attribute_map': {
                        'challenge_id': 'challenge_id',
                    },
                    'location_map': {
                        'challenge_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_challenge
            )

        def __get_totp_enrollment(
            self,
            totp_id,
            **kwargs
        ):
            """Get the TOTP enrollment specified by totp_id  # noqa: E501

            Get the TOTP enrollment specified by totp_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_totp_enrollment(totp_id, async_req=True)
            >>> result = thread.get()

            Args:
                totp_id (str): A totp id found in a path.

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TOTPEnrollment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['totp_id'] = \
                totp_id
            return self.call_with_http_info(**kwargs)

        if self.get_totp_enrollment is None:
            self.get_totp_enrollment = _Endpoint(
                settings={
                    'response_type': (TOTPEnrollment,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/challenge_enrollment/totp/{totp_id}',
                    'operation_id': 'get_totp_enrollment',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'totp_id',
                        'user_id',
                    ],
                    'required': [
                        'totp_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'totp_id':
                            (str,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'totp_id': 'totp_id',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'totp_id': 'path',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_totp_enrollment
            )

        def __get_webauthn_enrollment(
            self,
            webauthn_id,
            **kwargs
        ):
            """Get the WebAuthN enrollment specified by webauthn_id  # noqa: E501

            Get the WebAuthN enrollment specified by webauthn_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_webauthn_enrollment(webauthn_id, async_req=True)
            >>> result = thread.get()

            Args:
                webauthn_id (str): A webauthn id found in a path.

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WebAuthNEnrollment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['webauthn_id'] = \
                webauthn_id
            return self.call_with_http_info(**kwargs)

        if self.get_webauthn_enrollment is None:
            self.get_webauthn_enrollment = _Endpoint(
                settings={
                    'response_type': (WebAuthNEnrollment,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/challenge_enrollment/webauthn/{webauthn_id}',
                    'operation_id': 'get_webauthn_enrollment',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'webauthn_id',
                        'user_id',
                    ],
                    'required': [
                        'webauthn_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'webauthn_id':
                            (str,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'webauthn_id': 'webauthn_id',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'webauthn_id': 'path',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_webauthn_enrollment
            )

        def __list_totp_enrollment(
            self,
            **kwargs
        ):
            """List the totp enrollment results  # noqa: E501

            List the totp enrollment results  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_totp_enrollment(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListTOTPEnrollmentResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_totp_enrollment is None:
            self.list_totp_enrollment = _Endpoint(
                settings={
                    'response_type': (ListTOTPEnrollmentResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/challenge_enrollment/totp',
                    'operation_id': 'list_totp_enrollment',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'user_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_totp_enrollment
            )

        def __list_webauthn_enrollments(
            self,
            **kwargs
        ):
            """List the webauthn enrollments  # noqa: E501

            List the webauthn enrollments  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_webauthn_enrollments(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListWebAuthNEnrollmentResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_webauthn_enrollments is None:
            self.list_webauthn_enrollments = _Endpoint(
                settings={
                    'response_type': (ListWebAuthNEnrollmentResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/challenge_enrollment/webauthn',
                    'operation_id': 'list_webauthn_enrollments',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'user_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_webauthn_enrollments
            )

        def __replace_challenge(
            self,
            challenge_id,
            challenge,
            **kwargs
        ):
            """Replace the challenge specified by challenge_id  # noqa: E501

            Replace the challenge specified by challenge_id  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_challenge(challenge_id, challenge, async_req=True)
            >>> result = thread.get()

            Args:
                challenge_id (str): A challenge id found in a path.
                challenge (Challenge): The challenge to replace. Note that some fields, such as user_id, cannot be modified.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Challenge
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['challenge_id'] = \
                challenge_id
            kwargs['challenge'] = \
                challenge
            return self.call_with_http_info(**kwargs)

        if self.replace_challenge is None:
            self.replace_challenge = _Endpoint(
                settings={
                    'response_type': (Challenge,),
                    'auth': [],
                    'endpoint_path': '/v1/challenges/{challenge_id}',
                    'operation_id': 'replace_challenge',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'challenge_id',
                        'challenge',
                    ],
                    'required': [
                        'challenge_id',
                        'challenge',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'challenge_id':
                            (str,),
                        'challenge':
                            (Challenge,),
                    },
                    'attribute_map': {
                        'challenge_id': 'challenge_id',
                    },
                    'location_map': {
                        'challenge_id': 'path',
                        'challenge': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_challenge
            )

        def __update_totp_enrollment(
            self,
            totp_id,
            totp_enrollment_answer,
            **kwargs
        ):
            """Update the totp_enrollment if the answer provided is correct.  # noqa: E501

            Update the totp_enrollment if the answer provided is correct. This moves the state from pending to success.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_totp_enrollment(totp_id, totp_enrollment_answer, async_req=True)
            >>> result = thread.get()

            Args:
                totp_id (str): A totp id found in a path.
                totp_enrollment_answer (TOTPEnrollmentAnswer): The answer to the TOTP enrollment specified by totp_id.

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                TOTPEnrollment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['totp_id'] = \
                totp_id
            kwargs['totp_enrollment_answer'] = \
                totp_enrollment_answer
            return self.call_with_http_info(**kwargs)

        if self.update_totp_enrollment is None:
            self.update_totp_enrollment = _Endpoint(
                settings={
                    'response_type': (TOTPEnrollment,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/challenge_enrollment/totp/{totp_id}',
                    'operation_id': 'update_totp_enrollment',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'totp_id',
                        'totp_enrollment_answer',
                        'user_id',
                    ],
                    'required': [
                        'totp_id',
                        'totp_enrollment_answer',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'totp_id':
                            (str,),
                        'totp_enrollment_answer':
                            (TOTPEnrollmentAnswer,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'totp_id': 'totp_id',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'totp_id': 'path',
                        'totp_enrollment_answer': 'body',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__update_totp_enrollment
            )

        def __update_webauthn_enrollment(
            self,
            webauthn_id,
            web_auth_n_enrollment_answer,
            **kwargs
        ):
            """Update the WebAuthN enrollment if the answer provided is correct.  # noqa: E501

            Update the WebAuthN enrollment if the answer provided is correct. This completes the device enrollment.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_webauthn_enrollment(webauthn_id, web_auth_n_enrollment_answer, async_req=True)
            >>> result = thread.get()

            Args:
                webauthn_id (str): A webauthn id found in a path.
                web_auth_n_enrollment_answer (WebAuthNEnrollmentAnswer): The answer to the WebAuthN enrollment specified by webauthn_id.

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                WebAuthNEnrollment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['webauthn_id'] = \
                webauthn_id
            kwargs['web_auth_n_enrollment_answer'] = \
                web_auth_n_enrollment_answer
            return self.call_with_http_info(**kwargs)

        if self.update_webauthn_enrollment is None:
            self.update_webauthn_enrollment = _Endpoint(
                settings={
                    'response_type': (WebAuthNEnrollment,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/challenge_enrollment/webauthn/{webauthn_id}',
                    'operation_id': 'update_webauthn_enrollment',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'webauthn_id',
                        'web_auth_n_enrollment_answer',
                        'user_id',
                    ],
                    'required': [
                        'webauthn_id',
                        'web_auth_n_enrollment_answer',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'webauthn_id':
                            (str,),
                        'web_auth_n_enrollment_answer':
                            (WebAuthNEnrollmentAnswer,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'webauthn_id': 'webauthn_id',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'webauthn_id': 'path',
                        'web_auth_n_enrollment_answer': 'body',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__update_webauthn_enrollment
            )

    create_challenge = None 
    create_one_time_use_action = None 
    create_totp_enrollment = None 
    create_webauthn_enrollment = None 
    delete_challenge = None 
    delete_totp_enrollment = None 
    delete_webauthn_enrollment = None 
    get_answer = None 
    get_challenge = None 
    get_totp_enrollment = None 
    get_webauthn_enrollment = None 
    list_totp_enrollment = None 
    list_webauthn_enrollments = None 
    replace_challenge = None 
    update_totp_enrollment = None 
    update_webauthn_enrollment = None 
