"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.add_group_member_request import AddGroupMemberRequest
from agilicus_api.model.email import Email
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.group import Group
from agilicus_api.model.list_groups_response import ListGroupsResponse
from agilicus_api.model.upstream_group_reconcile import UpstreamGroupReconcile
from agilicus_api.model.upstream_group_reconcile_response import UpstreamGroupReconcileResponse
from agilicus_api.model.user import User


class GroupsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_group_member(
            self,
            group_id,
            add_group_member_request,
            **kwargs
        ):
            """Add a group member  # noqa: E501

            Add a group member  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_group_member(group_id, add_group_member_request, async_req=True)
            >>> result = thread.get()

            Args:
                group_id (str): group_id path
                add_group_member_request (AddGroupMemberRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                User
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['group_id'] = \
                group_id
            kwargs['add_group_member_request'] = \
                add_group_member_request
            return self.call_with_http_info(**kwargs)

        if self.add_group_member is None:
            self.add_group_member = _Endpoint(
                settings={
                    'response_type': (User,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/groups/{group_id}/members',
                    'operation_id': 'add_group_member',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'group_id',
                        'add_group_member_request',
                    ],
                    'required': [
                        'group_id',
                        'add_group_member_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'group_id':
                            (str,),
                        'add_group_member_request':
                            (AddGroupMemberRequest,),
                    },
                    'attribute_map': {
                        'group_id': 'group_id',
                    },
                    'location_map': {
                        'group_id': 'path',
                        'add_group_member_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__add_group_member
            )

        def __create_group(
            self,
            group,
            **kwargs
        ):
            """Create a group  # noqa: E501

            Create a group  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_group(group, async_req=True)
            >>> result = thread.get()

            Args:
                group (Group):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Group
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['group'] = \
                group
            return self.call_with_http_info(**kwargs)

        if self.create_group is None:
            self.create_group = _Endpoint(
                settings={
                    'response_type': (Group,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/groups',
                    'operation_id': 'create_group',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'group',
                    ],
                    'required': [
                        'group',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'group':
                            (Group,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'group': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_group
            )

        def __create_upstream_group_reconcile(
            self,
            upstream_group_reconcile,
            **kwargs
        ):
            """Reconcile a user's groups based on the user's upstream group membership  # noqa: E501

            Reconcile a user's groups based on the user's upstream group membership  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_upstream_group_reconcile(upstream_group_reconcile, async_req=True)
            >>> result = thread.get()

            Args:
                upstream_group_reconcile (UpstreamGroupReconcile):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpstreamGroupReconcileResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['upstream_group_reconcile'] = \
                upstream_group_reconcile
            return self.call_with_http_info(**kwargs)

        if self.create_upstream_group_reconcile is None:
            self.create_upstream_group_reconcile = _Endpoint(
                settings={
                    'response_type': (UpstreamGroupReconcileResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/groups/reconcile_upstream_groups',
                    'operation_id': 'create_upstream_group_reconcile',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'upstream_group_reconcile',
                    ],
                    'required': [
                        'upstream_group_reconcile',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'upstream_group_reconcile':
                            (UpstreamGroupReconcile,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'upstream_group_reconcile': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_upstream_group_reconcile
            )

        def __create_upstream_group_reconcile_sim(
            self,
            upstream_group_reconcile,
            **kwargs
        ):
            """Get the set of groups to reconcile based on the user's upstream group membership  # noqa: E501

            Get the set of groups to reconcile based on the user's upstream group membership This indicates what reconciliatory action will be taken if this endpoint is invoked via a POST.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_upstream_group_reconcile_sim(upstream_group_reconcile, async_req=True)
            >>> result = thread.get()

            Args:
                upstream_group_reconcile (UpstreamGroupReconcile):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                UpstreamGroupReconcileResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['upstream_group_reconcile'] = \
                upstream_group_reconcile
            return self.call_with_http_info(**kwargs)

        if self.create_upstream_group_reconcile_sim is None:
            self.create_upstream_group_reconcile_sim = _Endpoint(
                settings={
                    'response_type': (UpstreamGroupReconcileResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/groups/simulate_reconcile_upstream_groups',
                    'operation_id': 'create_upstream_group_reconcile_sim',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'upstream_group_reconcile',
                    ],
                    'required': [
                        'upstream_group_reconcile',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'upstream_group_reconcile':
                            (UpstreamGroupReconcile,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'upstream_group_reconcile': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_upstream_group_reconcile_sim
            )

        def __delete_group(
            self,
            group_id,
            **kwargs
        ):
            """Delete a group  # noqa: E501

            Delete a group  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_group(group_id, async_req=True)
            >>> result = thread.get()

            Args:
                group_id (str): group_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['group_id'] = \
                group_id
            return self.call_with_http_info(**kwargs)

        if self.delete_group is None:
            self.delete_group = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/groups/{group_id}',
                    'operation_id': 'delete_group',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'group_id',
                        'org_id',
                    ],
                    'required': [
                        'group_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'group_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'group_id': 'group_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'group_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_group
            )

        def __delete_group_member(
            self,
            group_id,
            member_id,
            **kwargs
        ):
            """Remove a group member  # noqa: E501

            Remove a group member  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_group_member(group_id, member_id, async_req=True)
            >>> result = thread.get()

            Args:
                group_id (str): group_id path
                member_id (str): member_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['group_id'] = \
                group_id
            kwargs['member_id'] = \
                member_id
            return self.call_with_http_info(**kwargs)

        if self.delete_group_member is None:
            self.delete_group_member = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/groups/{group_id}/members/{member_id}',
                    'operation_id': 'delete_group_member',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'group_id',
                        'member_id',
                        'org_id',
                    ],
                    'required': [
                        'group_id',
                        'member_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'group_id':
                            (str,),
                        'member_id':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'group_id': 'group_id',
                        'member_id': 'member_id',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'group_id': 'path',
                        'member_id': 'path',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_group_member
            )

        def __get_group(
            self,
            group_id,
            **kwargs
        ):
            """Get a group  # noqa: E501

            Get a group  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_group(group_id, async_req=True)
            >>> result = thread.get()

            Args:
                group_id (str): group_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                flatten_hierarchy (bool): Return the object with the full list of child members . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Group
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['group_id'] = \
                group_id
            return self.call_with_http_info(**kwargs)

        if self.get_group is None:
            self.get_group = _Endpoint(
                settings={
                    'response_type': (Group,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/groups/{group_id}',
                    'operation_id': 'get_group',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'group_id',
                        'org_id',
                        'flatten_hierarchy',
                    ],
                    'required': [
                        'group_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'group_id':
                            (str,),
                        'org_id':
                            (str,),
                        'flatten_hierarchy':
                            (bool,),
                    },
                    'attribute_map': {
                        'group_id': 'group_id',
                        'org_id': 'org_id',
                        'flatten_hierarchy': 'flatten_hierarchy',
                    },
                    'location_map': {
                        'group_id': 'path',
                        'org_id': 'query',
                        'flatten_hierarchy': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_group
            )

        def __list_groups(
            self,
            **kwargs
        ):
            """Get all groups  # noqa: E501

            Get all groups  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_groups(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                type ([str]): The type of groups to search for. Multiple values are ORed together.. [optional] if omitted the server will use the default value of ["group"]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                previous_email (Email): Pagination based query with the user's email as the key. To get the initial entries supply an empty string.. [optional]
                search_direction (str): Direction which the search should go starting from the email_nullable_query parameter. . [optional] if omitted the server will use the default value of "forwards"
                prefix_email_search (Email): Keyword used to search for a list of users based on email. This parameter is case insensitive and finds users with an email that matches the keyword by its prefix. For example, if the keyword \"Foo\" is supplied to this parameter, users with emails of \"foo1@example.com\" and \"Foo2@test.com\" could be returned. . [optional]
                allow_partial_match (bool): Perform a case insensitive partial match of any string query parameters included in the query . [optional]
                first_name (str): query for users with a first name that matches the query parameter. [optional]
                last_name (str): query for users with a last name that matches the query parameter. [optional]
                search_params ([str]): A list of strings to perform a case-insensitive search on all relevant fields in the database for a given collection. Multiple values are ANDed together . [optional]
                show_system_user (bool): If set to false, query users that have is_system_user set to False. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListGroupsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_groups is None:
            self.list_groups = _Endpoint(
                settings={
                    'response_type': (ListGroupsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/groups',
                    'operation_id': 'list_groups',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'org_id',
                        'type',
                        'limit',
                        'previous_email',
                        'search_direction',
                        'prefix_email_search',
                        'allow_partial_match',
                        'first_name',
                        'last_name',
                        'search_params',
                        'show_system_user',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                        'type',
                        'search_direction',
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                        ('type',): {

                            "GROUP": "group",
                            "SYSGROUP": "sysgroup",
                            "BIGROUP": "bigroup"
                        },
                        ('search_direction',): {

                            "BACKWARDS": "backwards",
                            "FORWARDS": "forwards"
                        },
                    },
                    'openapi_types': {
                        'org_id':
                            (str,),
                        'type':
                            ([str],),
                        'limit':
                            (int,),
                        'previous_email':
                            (Email,),
                        'search_direction':
                            (str,),
                        'prefix_email_search':
                            (Email,),
                        'allow_partial_match':
                            (bool,),
                        'first_name':
                            (str,),
                        'last_name':
                            (str,),
                        'search_params':
                            ([str],),
                        'show_system_user':
                            (bool,),
                    },
                    'attribute_map': {
                        'org_id': 'org_id',
                        'type': 'type',
                        'limit': 'limit',
                        'previous_email': 'previous_email',
                        'search_direction': 'search_direction',
                        'prefix_email_search': 'prefix_email_search',
                        'allow_partial_match': 'allow_partial_match',
                        'first_name': 'first_name',
                        'last_name': 'last_name',
                        'search_params': 'search_params',
                        'show_system_user': 'show_system_user',
                    },
                    'location_map': {
                        'org_id': 'query',
                        'type': 'query',
                        'limit': 'query',
                        'previous_email': 'query',
                        'search_direction': 'query',
                        'prefix_email_search': 'query',
                        'allow_partial_match': 'query',
                        'first_name': 'query',
                        'last_name': 'query',
                        'search_params': 'query',
                        'show_system_user': 'query',
                    },
                    'collection_format_map': {
                        'type': 'multi',
                        'search_params': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_groups
            )

        def __replace_group(
            self,
            group_id,
            **kwargs
        ):
            """update a group  # noqa: E501

            update a group  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_group(group_id, async_req=True)
            >>> result = thread.get()

            Args:
                group_id (str): group_id path

            Keyword Args:
                group (Group): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Group
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['group_id'] = \
                group_id
            return self.call_with_http_info(**kwargs)

        if self.replace_group is None:
            self.replace_group = _Endpoint(
                settings={
                    'response_type': (Group,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/groups/{group_id}',
                    'operation_id': 'replace_group',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'group_id',
                        'group',
                    ],
                    'required': [
                        'group_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'group_id':
                            (str,),
                        'group':
                            (Group,),
                    },
                    'attribute_map': {
                        'group_id': 'group_id',
                    },
                    'location_map': {
                        'group_id': 'path',
                        'group': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_group
            )

    add_group_member = None 
    create_group = None 
    create_upstream_group_reconcile = None 
    create_upstream_group_reconcile_sim = None 
    delete_group = None 
    delete_group_member = None 
    get_group = None 
    list_groups = None 
    replace_group = None 
