"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.inbox_item import InboxItem
from agilicus_api.model.list_inbox_items_response import ListInboxItemsResponse
from agilicus_api.model.list_message_endpoints_response import ListMessageEndpointsResponse
from agilicus_api.model.message import Message
from agilicus_api.model.message_endpoint import MessageEndpoint
from agilicus_api.model.message_endpoint_type import MessageEndpointType
from agilicus_api.model.message_endpoints_config import MessageEndpointsConfig
from agilicus_api.model.message_send_request import MessageSendRequest
from agilicus_api.model.message_send_response import MessageSendResponse
from agilicus_api.model.message_tag import MessageTag
from agilicus_api.model.messages_bulk_delete_request import MessagesBulkDeleteRequest
from agilicus_api.model.messages_bulk_delete_response import MessagesBulkDeleteResponse


class MessagesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __bulk_delete_messages(
            self,
            messages_bulk_delete_request,
            **kwargs
        ):
            """Delete a list of messages and inbox items asociated to it.  # noqa: E501

            Delete a list of messages and all associated inbox items. You can only delete so many messages in one request, to avoid long-running tasks that can never complete. To ensure all requests are deleted, iterate until the returned number of deleted messages is 0.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.bulk_delete_messages(messages_bulk_delete_request, async_req=True)
            >>> result = thread.get()

            Args:
                messages_bulk_delete_request (MessagesBulkDeleteRequest): The object that describes the message(s) to delete

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MessagesBulkDeleteResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['messages_bulk_delete_request'] = \
                messages_bulk_delete_request
            return self.call_with_http_info(**kwargs)

        if self.bulk_delete_messages is None:
            self.bulk_delete_messages = _Endpoint(
                settings={
                    'response_type': (MessagesBulkDeleteResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/messages/bulk_delete',
                    'operation_id': 'bulk_delete_messages',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'messages_bulk_delete_request',
                    ],
                    'required': [
                        'messages_bulk_delete_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'messages_bulk_delete_request':
                            (MessagesBulkDeleteRequest,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'messages_bulk_delete_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__bulk_delete_messages
            )

        def __create_message(
            self,
            message_endpoint_id,
            message,
            **kwargs
        ):
            """Send a message to a specific message endpoint.  # noqa: E501

            Send a message to a specific message endpoint.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_message(message_endpoint_id, message, async_req=True)
            >>> result = thread.get()

            Args:
                message_endpoint_id (str): send a message on a message endpoint
                message (Message): Message

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Message
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['message_endpoint_id'] = \
                message_endpoint_id
            kwargs['message'] = \
                message
            return self.call_with_http_info(**kwargs)

        if self.create_message is None:
            self.create_message = _Endpoint(
                settings={
                    'response_type': (Message,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/messages/{message_endpoint_id}/send',
                    'operation_id': 'create_message',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'message_endpoint_id',
                        'message',
                    ],
                    'required': [
                        'message_endpoint_id',
                        'message',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'message_endpoint_id':
                            (str,),
                        'message':
                            (Message,),
                    },
                    'attribute_map': {
                        'message_endpoint_id': 'message_endpoint_id',
                    },
                    'location_map': {
                        'message_endpoint_id': 'path',
                        'message': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_message
            )

        def __create_routed_message(
            self,
            message_send_request,
            **kwargs
        ):
            """Send one or more messages, letting the system choose how to deliver it  # noqa: E501

            Send one or more messages, leting the system choose to which endpoints to send it, based on properties of the message and the user's configuration. Each message can be associated with multiple addresses, each of which target a user. Note that some users, such as a group, may represent multiple recipients, in which case the message will be sent to users represented by the addressed user.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_routed_message(message_send_request, async_req=True)
            >>> result = thread.get()

            Args:
                message_send_request (MessageSendRequest): the request to send a message

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MessageSendResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['message_send_request'] = \
                message_send_request
            return self.call_with_http_info(**kwargs)

        if self.create_routed_message is None:
            self.create_routed_message = _Endpoint(
                settings={
                    'response_type': (MessageSendResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/messages/send_routed',
                    'operation_id': 'create_routed_message',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'message_send_request',
                    ],
                    'required': [
                        'message_send_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'message_send_request':
                            (MessageSendRequest,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'message_send_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_routed_message
            )

        def __create_user_message(
            self,
            user_id,
            message,
            **kwargs
        ):
            """Send a message to a user on all (optionally of a type) endpoints.  # noqa: E501

            Send a message to a user on all (optionally of a type) endpoints.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_user_message(user_id, message, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                message (Message): Message

            Keyword Args:
                message_endpoint_type (MessageEndpointType): messaging endpoint type. [optional]
                address (str): messaging address (direct). [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Message
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['message'] = \
                message
            return self.call_with_http_info(**kwargs)

        if self.create_user_message is None:
            self.create_user_message = _Endpoint(
                settings={
                    'response_type': (Message,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/messages/user/{user_id}/send',
                    'operation_id': 'create_user_message',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'message',
                        'message_endpoint_type',
                        'address',
                    ],
                    'required': [
                        'user_id',
                        'message',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'message':
                            (Message,),
                        'message_endpoint_type':
                            (MessageEndpointType,),
                        'address':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'message_endpoint_type': 'message_endpoint_type',
                        'address': 'address',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'message': 'body',
                        'message_endpoint_type': 'query',
                        'address': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__create_user_message
            )

        def __delete_inbox_item(
            self,
            user_id,
            inbox_item_id,
            **kwargs
        ):
            """Delete an inbox item  # noqa: E501

            Delete a specific inbox item  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_inbox_item(user_id, inbox_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                inbox_item_id (str): The id of the inbox item with which to interact 

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['inbox_item_id'] = \
                inbox_item_id
            return self.call_with_http_info(**kwargs)

        if self.delete_inbox_item is None:
            self.delete_inbox_item = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/inboxes/{user_id}/items/{inbox_item_id}',
                    'operation_id': 'delete_inbox_item',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'inbox_item_id',
                    ],
                    'required': [
                        'user_id',
                        'inbox_item_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'inbox_item_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'inbox_item_id': 'inbox_item_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'inbox_item_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_inbox_item
            )

        def __delete_message_endpoint(
            self,
            message_endpoint_id,
            **kwargs
        ):
            """Delete a messaging endpoint  # noqa: E501

            Delete a messaging endpoint  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_message_endpoint(message_endpoint_id, async_req=True)
            >>> result = thread.get()

            Args:
                message_endpoint_id (str): messaging endpoint id

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['message_endpoint_id'] = \
                message_endpoint_id
            return self.call_with_http_info(**kwargs)

        if self.delete_message_endpoint is None:
            self.delete_message_endpoint = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/messages/{message_endpoint_id}',
                    'operation_id': 'delete_message_endpoint',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'message_endpoint_id',
                        'user_id',
                    ],
                    'required': [
                        'message_endpoint_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'message_endpoint_id':
                            (str,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'message_endpoint_id': 'message_endpoint_id',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'message_endpoint_id': 'path',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_message_endpoint
            )

        def __get_inbox_item(
            self,
            user_id,
            inbox_item_id,
            **kwargs
        ):
            """Get an inbox item  # noqa: E501

            Get a specific inbox item  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_inbox_item(user_id, inbox_item_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                inbox_item_id (str): The id of the inbox item with which to interact 

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InboxItem
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['inbox_item_id'] = \
                inbox_item_id
            return self.call_with_http_info(**kwargs)

        if self.get_inbox_item is None:
            self.get_inbox_item = _Endpoint(
                settings={
                    'response_type': (InboxItem,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/inboxes/{user_id}/items/{inbox_item_id}',
                    'operation_id': 'get_inbox_item',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'inbox_item_id',
                    ],
                    'required': [
                        'user_id',
                        'inbox_item_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'inbox_item_id':
                            (str,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'inbox_item_id': 'inbox_item_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'inbox_item_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_inbox_item
            )

        def __get_message_endpoint(
            self,
            message_endpoint_id,
            **kwargs
        ):
            """Get a message endpoint  # noqa: E501

            Get a message endpoint  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_message_endpoint(message_endpoint_id, async_req=True)
            >>> result = thread.get()

            Args:
                message_endpoint_id (str): messaging endpoint id

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MessageEndpoint
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['message_endpoint_id'] = \
                message_endpoint_id
            return self.call_with_http_info(**kwargs)

        if self.get_message_endpoint is None:
            self.get_message_endpoint = _Endpoint(
                settings={
                    'response_type': (MessageEndpoint,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/messages/{message_endpoint_id}',
                    'operation_id': 'get_message_endpoint',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'message_endpoint_id',
                        'user_id',
                    ],
                    'required': [
                        'message_endpoint_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'message_endpoint_id':
                            (str,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'message_endpoint_id': 'message_endpoint_id',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'message_endpoint_id': 'path',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_message_endpoint
            )

        def __list_inbox_items(
            self,
            user_id,
            **kwargs
        ):
            """Get a list of inbox items items and information about the inbox  # noqa: E501

            Get a list of inbox items and information about the inbox for a user. By default only shows unexpired items.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_inbox_items(user_id, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path

            Keyword Args:
                org_id (str): Organisation Unique identifier. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                message_type (str): optional argument for restricting returned inbox items to only those of a specific type. [optional]
                message_class (str): optional argument for restricting returned inbox items to only those of a specific class. [optional]
                message_class_list ([str]): optional argument for restricting returned inbox items to only those of a list of specific classes. [optional]
                page_at_id (str): Pagination based query with the id as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_id` field from the list response. . [optional]
                page_at_received_date (datetime, none_type): Pagination based query with the date as the key. To get the initial entries supply null. . [optional]
                unread (bool): Search for items that have or have not been read. . [optional]
                expired (bool): Search for items that have or have not expired. . [optional]
                tag (MessageTag): Search messages based on tag. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListInboxItemsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            return self.call_with_http_info(**kwargs)

        if self.list_inbox_items is None:
            self.list_inbox_items = _Endpoint(
                settings={
                    'response_type': (ListInboxItemsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/inboxes/{user_id}/items',
                    'operation_id': 'list_inbox_items',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'org_id',
                        'limit',
                        'message_type',
                        'message_class',
                        'message_class_list',
                        'page_at_id',
                        'page_at_received_date',
                        'unread',
                        'expired',
                        'tag',
                    ],
                    'required': [
                        'user_id',
                    ],
                    'nullable': [
                        'page_at_received_date',
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 0,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'org_id':
                            (str,),
                        'limit':
                            (int,),
                        'message_type':
                            (str,),
                        'message_class':
                            (str,),
                        'message_class_list':
                            ([str],),
                        'page_at_id':
                            (str,),
                        'page_at_received_date':
                            (datetime, none_type,),
                        'unread':
                            (bool,),
                        'expired':
                            (bool,),
                        'tag':
                            (MessageTag,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'org_id': 'org_id',
                        'limit': 'limit',
                        'message_type': 'message_type',
                        'message_class': 'message_class',
                        'message_class_list': 'message_class_list',
                        'page_at_id': 'page_at_id',
                        'page_at_received_date': 'page_at_received_date',
                        'unread': 'unread',
                        'expired': 'expired',
                        'tag': 'tag',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'org_id': 'query',
                        'limit': 'query',
                        'message_type': 'query',
                        'message_class': 'query',
                        'message_class_list': 'query',
                        'page_at_id': 'query',
                        'page_at_received_date': 'query',
                        'unread': 'query',
                        'expired': 'query',
                        'tag': 'query',
                    },
                    'collection_format_map': {
                        'message_class_list': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_inbox_items
            )

        def __list_message_endpoints(
            self,
            **kwargs
        ):
            """List all message endpoints (all users or a single user)  # noqa: E501

            List all message endpoints (all users or a single user)  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_message_endpoints(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                user_id (str): Query based on user id. [optional]
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListMessageEndpointsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_message_endpoints is None:
            self.list_message_endpoints = _Endpoint(
                settings={
                    'response_type': (ListMessageEndpointsResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/messages',
                    'operation_id': 'list_message_endpoints',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'limit',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'limit':
                            (int,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'limit': 'limit',
                    },
                    'location_map': {
                        'user_id': 'query',
                        'limit': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_message_endpoints
            )

        def __list_messages_config(
            self,
            **kwargs
        ):
            """Get the config of the endpoint-types (e.g. public keys etc).  # noqa: E501

            Get the config of the endpoint-types (e.g. public keys etc).  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_messages_config(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MessageEndpointsConfig
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_messages_config is None:
            self.list_messages_config = _Endpoint(
                settings={
                    'response_type': (MessageEndpointsConfig,),
                    'auth': [],
                    'endpoint_path': '/v1/messages/config',
                    'operation_id': 'list_messages_config',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_messages_config
            )

        def __replace_inbox_item(
            self,
            user_id,
            inbox_item_id,
            inbox_item,
            **kwargs
        ):
            """replace an inbox item  # noqa: E501

            update an inbox item's writeable attributes  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_inbox_item(user_id, inbox_item_id, inbox_item, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                inbox_item_id (str): The id of the inbox item with which to interact 
                inbox_item (InboxItem): the inbox item to update

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                InboxItem
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['inbox_item_id'] = \
                inbox_item_id
            kwargs['inbox_item'] = \
                inbox_item
            return self.call_with_http_info(**kwargs)

        if self.replace_inbox_item is None:
            self.replace_inbox_item = _Endpoint(
                settings={
                    'response_type': (InboxItem,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/inboxes/{user_id}/items/{inbox_item_id}',
                    'operation_id': 'replace_inbox_item',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'inbox_item_id',
                        'inbox_item',
                    ],
                    'required': [
                        'user_id',
                        'inbox_item_id',
                        'inbox_item',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'inbox_item_id':
                            (str,),
                        'inbox_item':
                            (InboxItem,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                        'inbox_item_id': 'inbox_item_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'inbox_item_id': 'path',
                        'inbox_item': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_inbox_item
            )

        def __replace_message_endpoint(
            self,
            message_endpoint_id,
            message_endpoint,
            **kwargs
        ):
            """Update a messaging endpoint  # noqa: E501

            Update a messaging endpoint  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_message_endpoint(message_endpoint_id, message_endpoint, async_req=True)
            >>> result = thread.get()

            Args:
                message_endpoint_id (str): messaging endpoint id
                message_endpoint (MessageEndpoint): Message

            Keyword Args:
                user_id (str): Query based on user id. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MessageEndpoint
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['message_endpoint_id'] = \
                message_endpoint_id
            kwargs['message_endpoint'] = \
                message_endpoint
            return self.call_with_http_info(**kwargs)

        if self.replace_message_endpoint is None:
            self.replace_message_endpoint = _Endpoint(
                settings={
                    'response_type': (MessageEndpoint,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/messages/{message_endpoint_id}',
                    'operation_id': 'replace_message_endpoint',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'message_endpoint_id',
                        'message_endpoint',
                        'user_id',
                    ],
                    'required': [
                        'message_endpoint_id',
                        'message_endpoint',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'message_endpoint_id':
                            (str,),
                        'message_endpoint':
                            (MessageEndpoint,),
                        'user_id':
                            (str,),
                    },
                    'attribute_map': {
                        'message_endpoint_id': 'message_endpoint_id',
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'message_endpoint_id': 'path',
                        'message_endpoint': 'body',
                        'user_id': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_message_endpoint
            )

        def __update_message_endpoint(
            self,
            user_id,
            message_endpoint,
            **kwargs
        ):
            """Register a messaging endpoint on a user.  # noqa: E501

            Register a messaging endpoint on a user.  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.update_message_endpoint(user_id, message_endpoint, async_req=True)
            >>> result = thread.get()

            Args:
                user_id (str): user_id path
                message_endpoint (MessageEndpoint): Message

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                MessageEndpoint
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['user_id'] = \
                user_id
            kwargs['message_endpoint'] = \
                message_endpoint
            return self.call_with_http_info(**kwargs)

        if self.update_message_endpoint is None:
            self.update_message_endpoint = _Endpoint(
                settings={
                    'response_type': (MessageEndpoint,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/messages/register/{user_id}',
                    'operation_id': 'update_message_endpoint',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'user_id',
                        'message_endpoint',
                    ],
                    'required': [
                        'user_id',
                        'message_endpoint',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'user_id':
                            (str,),
                        'message_endpoint':
                            (MessageEndpoint,),
                    },
                    'attribute_map': {
                        'user_id': 'user_id',
                    },
                    'location_map': {
                        'user_id': 'path',
                        'message_endpoint': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__update_message_endpoint
            )

    bulk_delete_messages = None 
    create_message = None 
    create_routed_message = None 
    create_user_message = None 
    delete_inbox_item = None 
    delete_message_endpoint = None 
    get_inbox_item = None 
    get_message_endpoint = None 
    list_inbox_items = None 
    list_message_endpoints = None 
    list_messages_config = None 
    replace_inbox_item = None 
    replace_message_endpoint = None 
    update_message_endpoint = None 
