"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.api_client import ApiClient, Endpoint as _Endpoint
from agilicus_api.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from agilicus_api.model.cluster import Cluster
from agilicus_api.model.error_message import ErrorMessage
from agilicus_api.model.list_cluster_response import ListClusterResponse
from agilicus_api.model.list_point_of_presences_response import ListPointOfPresencesResponse
from agilicus_api.model.list_region_response import ListRegionResponse
from agilicus_api.model.list_regional_locations_response import ListRegionalLocationsResponse
from agilicus_api.model.point_of_presence import PointOfPresence
from agilicus_api.model.region import Region
from agilicus_api.model.routing_request import RoutingRequest


class RegionsApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __add_cluster(
            self,
            cluster,
            **kwargs
        ):
            """Add a Cluster  # noqa: E501

            Adds a new Cluster   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_cluster(cluster, async_req=True)
            >>> result = thread.get()

            Args:
                cluster (Cluster):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Cluster
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['cluster'] = \
                cluster
            return self.call_with_http_info(**kwargs)

        if self.add_cluster is None:
            self.add_cluster = _Endpoint(
                settings={
                    'response_type': (Cluster,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/clusters',
                    'operation_id': 'add_cluster',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'cluster',
                    ],
                    'required': [
                        'cluster',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'cluster':
                            (Cluster,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'cluster': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__add_cluster
            )

        def __add_point_of_presence(
            self,
            point_of_presence,
            **kwargs
        ):
            """Add a point of presence.  # noqa: E501

            Adds a new point of presence.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_point_of_presence(point_of_presence, async_req=True)
            >>> result = thread.get()

            Args:
                point_of_presence (PointOfPresence):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PointOfPresence
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['point_of_presence'] = \
                point_of_presence
            return self.call_with_http_info(**kwargs)

        if self.add_point_of_presence is None:
            self.add_point_of_presence = _Endpoint(
                settings={
                    'response_type': (PointOfPresence,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/point_of_presences',
                    'operation_id': 'add_point_of_presence',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'point_of_presence',
                    ],
                    'required': [
                        'point_of_presence',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'point_of_presence':
                            (PointOfPresence,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'point_of_presence': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__add_point_of_presence
            )

        def __add_region(
            self,
            region,
            **kwargs
        ):
            """Add a Region  # noqa: E501

            Adds a new Region   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.add_region(region, async_req=True)
            >>> result = thread.get()

            Args:
                region (Region):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Region
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['region'] = \
                region
            return self.call_with_http_info(**kwargs)

        if self.add_region is None:
            self.add_region = _Endpoint(
                settings={
                    'response_type': (Region,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/regions',
                    'operation_id': 'add_region',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'region',
                    ],
                    'required': [
                        'region',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'region':
                            (Region,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'region': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__add_region
            )

        def __delete_cluster(
            self,
            cluster_id,
            **kwargs
        ):
            """Delete a Cluster  # noqa: E501

            Delete a Cluster  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_cluster(cluster_id, async_req=True)
            >>> result = thread.get()

            Args:
                cluster_id (str): cluster id in path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['cluster_id'] = \
                cluster_id
            return self.call_with_http_info(**kwargs)

        if self.delete_cluster is None:
            self.delete_cluster = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/clusters/{cluster_id}',
                    'operation_id': 'delete_cluster',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'cluster_id',
                    ],
                    'required': [
                        'cluster_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'cluster_id':
                            (str,),
                    },
                    'attribute_map': {
                        'cluster_id': 'cluster_id',
                    },
                    'location_map': {
                        'cluster_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_cluster
            )

        def __delete_point_of_presence(
            self,
            point_of_presence_id,
            **kwargs
        ):
            """Delete a point of presence  # noqa: E501

            Delete a point of presence  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_point_of_presence(point_of_presence_id, async_req=True)
            >>> result = thread.get()

            Args:
                point_of_presence_id (str): point of presence id in path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['point_of_presence_id'] = \
                point_of_presence_id
            return self.call_with_http_info(**kwargs)

        if self.delete_point_of_presence is None:
            self.delete_point_of_presence = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/point_of_presences/{point_of_presence_id}',
                    'operation_id': 'delete_point_of_presence',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'point_of_presence_id',
                    ],
                    'required': [
                        'point_of_presence_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'point_of_presence_id':
                            (str,),
                    },
                    'attribute_map': {
                        'point_of_presence_id': 'point_of_presence_id',
                    },
                    'location_map': {
                        'point_of_presence_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_point_of_presence
            )

        def __delete_region(
            self,
            region_id,
            **kwargs
        ):
            """Delete a Region  # noqa: E501

            Delete a Region  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_region(region_id, async_req=True)
            >>> result = thread.get()

            Args:
                region_id (str): region id in path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['region_id'] = \
                region_id
            return self.call_with_http_info(**kwargs)

        if self.delete_region is None:
            self.delete_region = _Endpoint(
                settings={
                    'response_type': None,
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/regions/{region_id}',
                    'operation_id': 'delete_region',
                    'http_method': 'DELETE',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'region_id',
                    ],
                    'required': [
                        'region_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'region_id':
                            (str,),
                    },
                    'attribute_map': {
                        'region_id': 'region_id',
                    },
                    'location_map': {
                        'region_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__delete_region
            )

        def __get_cluster(
            self,
            cluster_id,
            **kwargs
        ):
            """Get a Cluster  # noqa: E501

            Get a Cluster  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_cluster(cluster_id, async_req=True)
            >>> result = thread.get()

            Args:
                cluster_id (str): cluster id in path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Cluster
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['cluster_id'] = \
                cluster_id
            return self.call_with_http_info(**kwargs)

        if self.get_cluster is None:
            self.get_cluster = _Endpoint(
                settings={
                    'response_type': (Cluster,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/clusters/{cluster_id}',
                    'operation_id': 'get_cluster',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'cluster_id',
                    ],
                    'required': [
                        'cluster_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'cluster_id':
                            (str,),
                    },
                    'attribute_map': {
                        'cluster_id': 'cluster_id',
                    },
                    'location_map': {
                        'cluster_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_cluster
            )

        def __get_point_of_presence(
            self,
            point_of_presence_id,
            **kwargs
        ):
            """Get a point of presence  # noqa: E501

            Get a point of presence  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_point_of_presence(point_of_presence_id, async_req=True)
            >>> result = thread.get()

            Args:
                point_of_presence_id (str): point of presence id in path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PointOfPresence
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['point_of_presence_id'] = \
                point_of_presence_id
            return self.call_with_http_info(**kwargs)

        if self.get_point_of_presence is None:
            self.get_point_of_presence = _Endpoint(
                settings={
                    'response_type': (PointOfPresence,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/point_of_presences/{point_of_presence_id}',
                    'operation_id': 'get_point_of_presence',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'point_of_presence_id',
                    ],
                    'required': [
                        'point_of_presence_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'point_of_presence_id':
                            (str,),
                    },
                    'attribute_map': {
                        'point_of_presence_id': 'point_of_presence_id',
                    },
                    'location_map': {
                        'point_of_presence_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_point_of_presence
            )

        def __get_region(
            self,
            region_id,
            **kwargs
        ):
            """Get a Region  # noqa: E501

            Get a Region  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_region(region_id, async_req=True)
            >>> result = thread.get()

            Args:
                region_id (str): region id in path

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Region
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['region_id'] = \
                region_id
            return self.call_with_http_info(**kwargs)

        if self.get_region is None:
            self.get_region = _Endpoint(
                settings={
                    'response_type': (Region,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/regions/{region_id}',
                    'operation_id': 'get_region',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'region_id',
                    ],
                    'required': [
                        'region_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'region_id':
                            (str,),
                    },
                    'attribute_map': {
                        'region_id': 'region_id',
                    },
                    'location_map': {
                        'region_id': 'path',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_region
            )

        def __get_regional_locations(
            self,
            **kwargs
        ):
            """get regional location(s)  # noqa: E501

            get regional location(s)   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_regional_locations(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                page_at_name (str): Pagination based query with the name as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_name` field from the list response. . [optional]
                org_id (str): Organisation Unique identifier. [optional]
                region_name_list ([str]): region name list query. [optional]
                point_of_presence_name_list ([str]): point of presence name list query. [optional]
                location_name_list ([str]): location name list query. [optional]
                subdomain (str): query based on organisation subdomain . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListRegionalLocationsResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.get_regional_locations is None:
            self.get_regional_locations = _Endpoint(
                settings={
                    'response_type': (ListRegionalLocationsResponse,),
                    'auth': [],
                    'endpoint_path': '/v1/regional_locations',
                    'operation_id': 'get_regional_locations',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'page_at_name',
                        'org_id',
                        'region_name_list',
                        'point_of_presence_name_list',
                        'location_name_list',
                        'subdomain',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'page_at_name':
                            (str,),
                        'org_id':
                            (str,),
                        'region_name_list':
                            ([str],),
                        'point_of_presence_name_list':
                            ([str],),
                        'location_name_list':
                            ([str],),
                        'subdomain':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'page_at_name': 'page_at_name',
                        'org_id': 'org_id',
                        'region_name_list': 'region_name_list',
                        'point_of_presence_name_list': 'point_of_presence_name_list',
                        'location_name_list': 'location_name_list',
                        'subdomain': 'subdomain',
                    },
                    'location_map': {
                        'limit': 'query',
                        'page_at_name': 'query',
                        'org_id': 'query',
                        'region_name_list': 'query',
                        'point_of_presence_name_list': 'query',
                        'location_name_list': 'query',
                        'subdomain': 'query',
                    },
                    'collection_format_map': {
                        'region_name_list': 'multi',
                        'point_of_presence_name_list': 'multi',
                        'location_name_list': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__get_regional_locations
            )

        def __list_clusters(
            self,
            **kwargs
        ):
            """List all Clusters  # noqa: E501

            List all Clusters matching the provided query parameters.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_clusters(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                page_at_name (str): Pagination based query with the name as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_name` field from the list response. . [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListClusterResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_clusters is None:
            self.list_clusters = _Endpoint(
                settings={
                    'response_type': (ListClusterResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/clusters',
                    'operation_id': 'list_clusters',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'page_at_name',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'page_at_name':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'page_at_name': 'page_at_name',
                    },
                    'location_map': {
                        'limit': 'query',
                        'page_at_name': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_clusters
            )

        def __list_point_of_presences(
            self,
            **kwargs
        ):
            """List all regions  # noqa: E501

            List all regions matching the provided query parameters. Perform keyset pagination by setting the page_at_name parameter to the name for the next page to fetch. Set it to `\"\"` to start from the beginning.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_point_of_presences(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                name (str): Filters based on whether or not the items in the collection have the given name. . [optional]
                page_at_name (str): Pagination based query with the name as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_name` field from the list response. . [optional]
                includes_all_tag ([str]): A list of case-sensitive tags to include in the search. Each provided tag must match in order for the item to be returned. . [optional]
                includes_any_tag ([str]): A list of case-sensitive tags to include in the search. If any provided tag matches then the item is returned. . [optional]
                excludes_all_tag ([str]): A list of case-sensitive tags to exclude in the search. If all provided tags match, then the item is not returned. . [optional]
                excludes_any_tag ([str]): A list of case-sensitive tags to exclude in the search. If any provided tag matches, then the item is not returned. . [optional]
                cluster_name (str): query for specific cluster. [optional]
                org_id (str): Organisation Unique identifier. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListPointOfPresencesResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_point_of_presences is None:
            self.list_point_of_presences = _Endpoint(
                settings={
                    'response_type': (ListPointOfPresencesResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/point_of_presences',
                    'operation_id': 'list_point_of_presences',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'name',
                        'page_at_name',
                        'includes_all_tag',
                        'includes_any_tag',
                        'excludes_all_tag',
                        'excludes_any_tag',
                        'cluster_name',
                        'org_id',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'name':
                            (str,),
                        'page_at_name':
                            (str,),
                        'includes_all_tag':
                            ([str],),
                        'includes_any_tag':
                            ([str],),
                        'excludes_all_tag':
                            ([str],),
                        'excludes_any_tag':
                            ([str],),
                        'cluster_name':
                            (str,),
                        'org_id':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'name': 'name',
                        'page_at_name': 'page_at_name',
                        'includes_all_tag': 'includes_all_tag',
                        'includes_any_tag': 'includes_any_tag',
                        'excludes_all_tag': 'excludes_all_tag',
                        'excludes_any_tag': 'excludes_any_tag',
                        'cluster_name': 'cluster_name',
                        'org_id': 'org_id',
                    },
                    'location_map': {
                        'limit': 'query',
                        'name': 'query',
                        'page_at_name': 'query',
                        'includes_all_tag': 'query',
                        'includes_any_tag': 'query',
                        'excludes_all_tag': 'query',
                        'excludes_any_tag': 'query',
                        'cluster_name': 'query',
                        'org_id': 'query',
                    },
                    'collection_format_map': {
                        'includes_all_tag': 'multi',
                        'includes_any_tag': 'multi',
                        'excludes_all_tag': 'multi',
                        'excludes_any_tag': 'multi',
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_point_of_presences
            )

        def __list_regions(
            self,
            **kwargs
        ):
            """List all regions  # noqa: E501

            List all Regions matching the provided query parameters.   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.list_regions(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                limit (int): limit the number of rows in the response. [optional] if omitted the server will use the default value of 500
                page_at_name (str): Pagination based query with the name as the key. To get the initial entries supply an empty string. On subsequent requests, supply the `page_at_name` field from the list response. . [optional]
                org_id (str): Organisation Unique identifier. [optional]
                cluster_name (str): query for specific cluster. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                ListRegionResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        if self.list_regions is None:
            self.list_regions = _Endpoint(
                settings={
                    'response_type': (ListRegionResponse,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/regions',
                    'operation_id': 'list_regions',
                    'http_method': 'GET',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'limit',
                        'page_at_name',
                        'org_id',
                        'cluster_name',
                    ],
                    'required': [],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                        'limit',
                    ]
                },
                root_map={
                    'validations': {
                        ('limit',): {

                            'inclusive_maximum': 500,
                            'inclusive_minimum': 1,
                        },
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'limit':
                            (int,),
                        'page_at_name':
                            (str,),
                        'org_id':
                            (str,),
                        'cluster_name':
                            (str,),
                    },
                    'attribute_map': {
                        'limit': 'limit',
                        'page_at_name': 'page_at_name',
                        'org_id': 'org_id',
                        'cluster_name': 'cluster_name',
                    },
                    'location_map': {
                        'limit': 'query',
                        'page_at_name': 'query',
                        'org_id': 'query',
                        'cluster_name': 'query',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [],
                },
                api_client=api_client,
                callable=__list_regions
            )

        def __replace_cluster(
            self,
            cluster_id,
            **kwargs
        ):
            """update a Cluster  # noqa: E501

            update a Cluster  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_cluster(cluster_id, async_req=True)
            >>> result = thread.get()

            Args:
                cluster_id (str): cluster id in path

            Keyword Args:
                cluster (Cluster): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Cluster
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['cluster_id'] = \
                cluster_id
            return self.call_with_http_info(**kwargs)

        if self.replace_cluster is None:
            self.replace_cluster = _Endpoint(
                settings={
                    'response_type': (Cluster,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/clusters/{cluster_id}',
                    'operation_id': 'replace_cluster',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'cluster_id',
                        'cluster',
                    ],
                    'required': [
                        'cluster_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'cluster_id':
                            (str,),
                        'cluster':
                            (Cluster,),
                    },
                    'attribute_map': {
                        'cluster_id': 'cluster_id',
                    },
                    'location_map': {
                        'cluster_id': 'path',
                        'cluster': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_cluster
            )

        def __replace_point_of_presence(
            self,
            point_of_presence_id,
            **kwargs
        ):
            """update a point of presence  # noqa: E501

            update a point of presence  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_point_of_presence(point_of_presence_id, async_req=True)
            >>> result = thread.get()

            Args:
                point_of_presence_id (str): point of presence id in path

            Keyword Args:
                point_of_presence (PointOfPresence): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                PointOfPresence
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['point_of_presence_id'] = \
                point_of_presence_id
            return self.call_with_http_info(**kwargs)

        if self.replace_point_of_presence is None:
            self.replace_point_of_presence = _Endpoint(
                settings={
                    'response_type': (PointOfPresence,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/point_of_presences/{point_of_presence_id}',
                    'operation_id': 'replace_point_of_presence',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'point_of_presence_id',
                        'point_of_presence',
                    ],
                    'required': [
                        'point_of_presence_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'point_of_presence_id':
                            (str,),
                        'point_of_presence':
                            (PointOfPresence,),
                    },
                    'attribute_map': {
                        'point_of_presence_id': 'point_of_presence_id',
                    },
                    'location_map': {
                        'point_of_presence_id': 'path',
                        'point_of_presence': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_point_of_presence
            )

        def __replace_region(
            self,
            region_id,
            **kwargs
        ):
            """update a Region  # noqa: E501

            update a Region  # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.replace_region(region_id, async_req=True)
            >>> result = thread.get()

            Args:
                region_id (str): region id in path

            Keyword Args:
                region (Region): [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                Region
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['region_id'] = \
                region_id
            return self.call_with_http_info(**kwargs)

        if self.replace_region is None:
            self.replace_region = _Endpoint(
                settings={
                    'response_type': (Region,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/regions/{region_id}',
                    'operation_id': 'replace_region',
                    'http_method': 'PUT',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'region_id',
                        'region',
                    ],
                    'required': [
                        'region_id',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'region_id':
                            (str,),
                        'region':
                            (Region,),
                    },
                    'attribute_map': {
                        'region_id': 'region_id',
                    },
                    'location_map': {
                        'region_id': 'path',
                        'region': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__replace_region
            )

        def __routing_request(
            self,
            routing_request,
            **kwargs
        ):
            """Request routing  # noqa: E501

            Request routing for a particular list of ip_addresses   # noqa: E501
            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.routing_request(routing_request, async_req=True)
            >>> result = thread.get()

            Args:
                routing_request (RoutingRequest):

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                RoutingRequest
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['routing_request'] = \
                routing_request
            return self.call_with_http_info(**kwargs)

        if self.routing_request is None:
            self.routing_request = _Endpoint(
                settings={
                    'response_type': (RoutingRequest,),
                    'auth': [
                        'token-valid'
                    ],
                    'endpoint_path': '/v1/routing_request',
                    'operation_id': 'routing_request',
                    'http_method': 'POST',
                    'servers': None,
                },
                params_map={
                    'all': [
                        'routing_request',
                    ],
                    'required': [
                        'routing_request',
                    ],
                    'nullable': [
                    ],
                    'enum': [
                    ],
                    'validation': [
                    ]
                },
                root_map={
                    'validations': {
                    },
                    'allowed_values': {
                    },
                    'openapi_types': {
                        'routing_request':
                            (RoutingRequest,),
                    },
                    'attribute_map': {
                    },
                    'location_map': {
                        'routing_request': 'body',
                    },
                    'collection_format_map': {
                    }
                },
                headers_map={
                    'accept': [
                        'application/json'
                    ],
                    'content_type': [
                        'application/json'
                    ]
                },
                api_client=api_client,
                callable=__routing_request
            )

    add_cluster = None 
    add_point_of_presence = None 
    add_region = None 
    delete_cluster = None 
    delete_point_of_presence = None 
    delete_region = None 
    get_cluster = None 
    get_point_of_presence = None 
    get_region = None 
    get_regional_locations = None 
    list_clusters = None 
    list_point_of_presences = None 
    list_regions = None 
    replace_cluster = None 
    replace_point_of_presence = None 
    replace_region = None 
    routing_request = None 
