# CertSigningReq

A Certificate Signing Request (CSR).  The Certificate Signing Request workflow: a. User creates a private key and creates and signs    a CSR as a PEM encoded request. Encoded within    the CSR is the Common Name and DNS names    (Subject Alternate Name). b. User will POST this req to the API using this CertSignReq,    using spec.request field. c. System will determine if the request is authorized based    on the clients credentials and if the user is authorized to    issue certificates for the domain(s). d. System will validate that no other certificate exists for    the requested domain(s) based on the signature of the    request.    If a user does a POST again to make an identical    request for the same domain(s) and request,    the POST will respond with a 409,    with a message of resulting domain(s) that are duplicated. e. The system goes through its process to sign the CSR by an    issuer.  Once the issuer has signed    the certificate, the certificate will be updated in the    CertSigningReqCertificateStatus field. f. The client will then read the status field of CertSigningReq    and can download and use the certificate.  Updating and Adding Domains to a Certificate: Should a user wish to add a domain to a certificate, they have two choices,     Update an existing CertSignReq, updating the request with    the added domain. This would invove a PUT to the API    with the updated spec.request field, and then following the approach    above.     or     Create a new CertSignReq via POST for a new certificate for    the requested domain(s).  Certificate Renewal: Certificates are automatically renewed unless specifically disabled using CertSigningReq.spec.auto_renew. When the system renews a certificate, it will update the CertSigningReqCertificateStatus with a new certificate added to the array.  The user may decide to not renew a certificate in which case no action by the system will be taken.  Certificate Removal and Key Rotation: Should new keys be created by the user, the user can PUT a new request to the CertSignReq. This will result in a forced renewal of the certificate and subsequently a newly issued certificate. All existing certificates in the CSR will be removed since they no longer pertain to the new request. Note that there are rate limits on renewals of certificates with identical domain names.  Key Rotation via API: The CertSignReq has a spec.rotate_keys option that allows the backend to signal to a user/client to rotate their keys. This allows a user via an API to remove and update private keys.  Deletion: The CertSignReq can be deleted with valid authorization credentials, although is not typically required. Normally this would be done by an administrator in order for force removal of a CSR. 

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**spec** | [**CertSigningReqSpec**](CertSigningReqSpec.md) |  | 
**metadata** | [**MetadataWithId**](MetadataWithId.md) |  | [optional] 
**status** | [**CertSigningReqStatus**](CertSigningReqStatus.md) |  | [optional] 
**any string name** | **bool, date, datetime, dict, float, int, list, str, none_type** | any string name can be used but the value must be the correct type | [optional]

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


