"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError



class AgentConnectorProxyRequestStatsDetails(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('started',): {
            'inclusive_minimum': 0,
        },
        ('finished',): {
            'inclusive_minimum': 0,
        },
        ('status_1xx',): {
            'inclusive_minimum': 0,
        },
        ('status_2xx',): {
            'inclusive_minimum': 0,
        },
        ('status_3xx',): {
            'inclusive_minimum': 0,
        },
        ('status_4xx',): {
            'inclusive_minimum': 0,
        },
        ('status_5xx',): {
            'inclusive_minimum': 0,
        },
        ('status_unknown',): {
            'inclusive_minimum': 0,
        },
        ('failed_authentication',): {
            'inclusive_minimum': 0,
        },
        ('failed_authorisation',): {
            'inclusive_minimum': 0,
        },
        ('authz_redirected',): {
            'inclusive_minimum': 0,
        },
    }

    @property
    def started(self):
       return self.get("started")

    @started.setter
    def started(self, new_value):
       self.started = new_value

    @property
    def finished(self):
       return self.get("finished")

    @finished.setter
    def finished(self, new_value):
       self.finished = new_value

    @property
    def status_1xx(self):
       return self.get("status_1xx")

    @status_1xx.setter
    def status_1xx(self, new_value):
       self.status_1xx = new_value

    @property
    def status_2xx(self):
       return self.get("status_2xx")

    @status_2xx.setter
    def status_2xx(self, new_value):
       self.status_2xx = new_value

    @property
    def status_3xx(self):
       return self.get("status_3xx")

    @status_3xx.setter
    def status_3xx(self, new_value):
       self.status_3xx = new_value

    @property
    def status_4xx(self):
       return self.get("status_4xx")

    @status_4xx.setter
    def status_4xx(self, new_value):
       self.status_4xx = new_value

    @property
    def status_5xx(self):
       return self.get("status_5xx")

    @status_5xx.setter
    def status_5xx(self, new_value):
       self.status_5xx = new_value

    @property
    def status_unknown(self):
       return self.get("status_unknown")

    @status_unknown.setter
    def status_unknown(self, new_value):
       self.status_unknown = new_value

    @property
    def failed_authentication(self):
       return self.get("failed_authentication")

    @failed_authentication.setter
    def failed_authentication(self, new_value):
       self.failed_authentication = new_value

    @property
    def failed_authorisation(self):
       return self.get("failed_authorisation")

    @failed_authorisation.setter
    def failed_authorisation(self, new_value):
       self.failed_authorisation = new_value

    @property
    def authz_redirected(self):
       return self.get("authz_redirected")

    @authz_redirected.setter
    def authz_redirected(self, new_value):
       self.authz_redirected = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'started': (int,),  # noqa: E501
            'finished': (int,),  # noqa: E501
            'status_1xx': (int,),  # noqa: E501
            'status_2xx': (int,),  # noqa: E501
            'status_3xx': (int,),  # noqa: E501
            'status_4xx': (int,),  # noqa: E501
            'status_5xx': (int,),  # noqa: E501
            'status_unknown': (int,),  # noqa: E501
            'failed_authentication': (int,),  # noqa: E501
            'failed_authorisation': (int,),  # noqa: E501
            'authz_redirected': (int,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'started': 'started',  # noqa: E501
        'finished': 'finished',  # noqa: E501
        'status_1xx': 'status_1xx',  # noqa: E501
        'status_2xx': 'status_2xx',  # noqa: E501
        'status_3xx': 'status_3xx',  # noqa: E501
        'status_4xx': 'status_4xx',  # noqa: E501
        'status_5xx': 'status_5xx',  # noqa: E501
        'status_unknown': 'status_unknown',  # noqa: E501
        'failed_authentication': 'failed_authentication',  # noqa: E501
        'failed_authorisation': 'failed_authorisation',  # noqa: E501
        'authz_redirected': 'authz_redirected',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, started, finished, status_1xx, status_2xx, status_3xx, status_4xx, status_5xx, status_unknown, failed_authentication, failed_authorisation, authz_redirected, *args, **kwargs):  # noqa: E501
        """AgentConnectorProxyRequestStatsDetails - a model defined in OpenAPI

        Args:
            started (int): The total number of requests started by the proxy
            finished (int): The total number of requests finished by the proxy.
            status_1xx (int): The number of requests which completed with a status code between 100 and 199 
            status_2xx (int): The number of requests which completed with a status code between 200 and 299 
            status_3xx (int): The number of requests which completed with a status code between 300 and 399 
            status_4xx (int): The number of requests which completed with a status code between 400 and 499 
            status_5xx (int): The number of requests which completed with a status code between 500 and 599 
            status_unknown (int): The number of requests which completed with an unknown status code 
            failed_authentication (int): The number of requests which failed authentication. 
            failed_authorisation (int): The number of requests which failed authorisation. 
            authz_redirected (int): The number of requests which are redirected during authorisation. 

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.started = started
        self.finished = finished
        self.status_1xx = status_1xx
        self.status_2xx = status_2xx
        self.status_3xx = status_3xx
        self.status_4xx = status_4xx
        self.status_5xx = status_5xx
        self.status_unknown = status_unknown
        self.failed_authentication = failed_authentication
        self.failed_authorisation = failed_authorisation
        self.authz_redirected = authz_redirected
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, started, finished, status_1xx, status_2xx, status_3xx, status_4xx, status_5xx, status_unknown, failed_authentication, failed_authorisation, authz_redirected, *args, **kwargs):  # noqa: E501
        """AgentConnectorProxyRequestStatsDetails - a model defined in OpenAPI

        Args:
            started (int): The total number of requests started by the proxy
            finished (int): The total number of requests finished by the proxy.
            status_1xx (int): The number of requests which completed with a status code between 100 and 199 
            status_2xx (int): The number of requests which completed with a status code between 200 and 299 
            status_3xx (int): The number of requests which completed with a status code between 300 and 399 
            status_4xx (int): The number of requests which completed with a status code between 400 and 499 
            status_5xx (int): The number of requests which completed with a status code between 500 and 599 
            status_unknown (int): The number of requests which completed with an unknown status code 
            failed_authentication (int): The number of requests which failed authentication. 
            failed_authorisation (int): The number of requests which failed authorisation. 
            authz_redirected (int): The number of requests which are redirected during authorisation. 

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.started = started
        self.finished = finished
        self.status_1xx = status_1xx
        self.status_2xx = status_2xx
        self.status_3xx = status_3xx
        self.status_4xx = status_4xx
        self.status_5xx = status_5xx
        self.status_unknown = status_unknown
        self.failed_authentication = failed_authentication
        self.failed_authorisation = failed_authorisation
        self.authz_redirected = authz_redirected
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

