"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError



class NetworkDetailedStats(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
        ('connections_current',): {
            'inclusive_minimum': 0,
        },
        ('connections_timedout',): {
            'inclusive_minimum': 0,
        },
        ('connections_host_not_found',): {
            'inclusive_minimum': 0,
        },
        ('connections_reset',): {
            'inclusive_minimum': 0,
        },
        ('connections_tls_validation_failed',): {
            'inclusive_minimum': 0,
        },
        ('connections_other_failure',): {
            'inclusive_minimum': 0,
        },
        ('connections_tls_protocol_failure',): {
            'inclusive_minimum': 0,
        },
        ('connections_tls_unsupported_version',): {
            'inclusive_minimum': 0,
        },
        ('connections_tls_remote_error',): {
            'inclusive_minimum': 0,
        },
        ('connections_tls_other_error',): {
            'inclusive_minimum': 0,
        },
    }

    @property
    def connections_current(self):
       return self.get("connections_current")

    @connections_current.setter
    def connections_current(self, new_value):
       self.connections_current = new_value

    @property
    def connections_timedout(self):
       return self.get("connections_timedout")

    @connections_timedout.setter
    def connections_timedout(self, new_value):
       self.connections_timedout = new_value

    @property
    def connections_host_not_found(self):
       return self.get("connections_host_not_found")

    @connections_host_not_found.setter
    def connections_host_not_found(self, new_value):
       self.connections_host_not_found = new_value

    @property
    def connections_reset(self):
       return self.get("connections_reset")

    @connections_reset.setter
    def connections_reset(self, new_value):
       self.connections_reset = new_value

    @property
    def connections_tls_validation_failed(self):
       return self.get("connections_tls_validation_failed")

    @connections_tls_validation_failed.setter
    def connections_tls_validation_failed(self, new_value):
       self.connections_tls_validation_failed = new_value

    @property
    def connections_other_failure(self):
       return self.get("connections_other_failure")

    @connections_other_failure.setter
    def connections_other_failure(self, new_value):
       self.connections_other_failure = new_value

    @property
    def connections_tls_protocol_failure(self):
       return self.get("connections_tls_protocol_failure")

    @connections_tls_protocol_failure.setter
    def connections_tls_protocol_failure(self, new_value):
       self.connections_tls_protocol_failure = new_value

    @property
    def connections_tls_unsupported_version(self):
       return self.get("connections_tls_unsupported_version")

    @connections_tls_unsupported_version.setter
    def connections_tls_unsupported_version(self, new_value):
       self.connections_tls_unsupported_version = new_value

    @property
    def connections_tls_remote_error(self):
       return self.get("connections_tls_remote_error")

    @connections_tls_remote_error.setter
    def connections_tls_remote_error(self, new_value):
       self.connections_tls_remote_error = new_value

    @property
    def connections_tls_other_error(self):
       return self.get("connections_tls_other_error")

    @connections_tls_other_error.setter
    def connections_tls_other_error(self, new_value):
       self.connections_tls_other_error = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'connections_current': (int,),  # noqa: E501
            'connections_timedout': (int,),  # noqa: E501
            'connections_host_not_found': (int,),  # noqa: E501
            'connections_reset': (int,),  # noqa: E501
            'connections_tls_validation_failed': (int,),  # noqa: E501
            'connections_other_failure': (int,),  # noqa: E501
            'connections_tls_protocol_failure': (int,),  # noqa: E501
            'connections_tls_unsupported_version': (int,),  # noqa: E501
            'connections_tls_remote_error': (int,),  # noqa: E501
            'connections_tls_other_error': (int,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'connections_current': 'connections_current',  # noqa: E501
        'connections_timedout': 'connections_timedout',  # noqa: E501
        'connections_host_not_found': 'connections_host_not_found',  # noqa: E501
        'connections_reset': 'connections_reset',  # noqa: E501
        'connections_tls_validation_failed': 'connections_tls_validation_failed',  # noqa: E501
        'connections_other_failure': 'connections_other_failure',  # noqa: E501
        'connections_tls_protocol_failure': 'connections_tls_protocol_failure',  # noqa: E501
        'connections_tls_unsupported_version': 'connections_tls_unsupported_version',  # noqa: E501
        'connections_tls_remote_error': 'connections_tls_remote_error',  # noqa: E501
        'connections_tls_other_error': 'connections_tls_other_error',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, connections_current, connections_timedout, connections_host_not_found, connections_reset, connections_tls_validation_failed, connections_other_failure, *args, **kwargs):  # noqa: E501
        """NetworkDetailedStats - a model defined in OpenAPI

        Args:
            connections_current (int): The total number of connections currently established or establishing. This value is a guage, meaning it is not monotonic. 
            connections_timedout (int): The number of times a connection attempt failed because it took too long to establish
            connections_host_not_found (int): The number of times a connection attempt failed because a host lookup failed
            connections_reset (int): The number of times a connection attempt failed because the target host reset the connection 
            connections_tls_validation_failed (int): The number of times a connection attempt failed because TLS validation did not succeed. This is typically because either the server certificate did not match the expected one, or because we did not trust it. Try to fix this problem by ensuring that the certitifate is valid, matches the hostname the client connects to, and that it is issued by a certificate authority trusted by the client. Alternatively, if this is not possible, disable certificate validation. 
            connections_other_failure (int): The number of times a connection attempt failed for reasons other than the explicitly enumerated ones. 

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            connections_tls_protocol_failure (int): The number of times a connection attempt failed because the upstream returned an invalid TLS response. Typically this happens because the upstream is not configured to use TLS, but it could be due to a bug in the upstream server, or some other incompatibility (e.g. an unsupported version whose versioning mechanism is unknown). Check that the server is configured to serve TLS, or connect to it using plaintext. . [optional]  # noqa: E501
            connections_tls_unsupported_version (int): The number of times a connection attempt failed because the upstream server replied that it did not support one of the versions supported by the client. Typically this is because the server is running a fairly old version of software. See if there is a new version of the software available, or ensure that it provides a maximum TLS version of at least 1.2. . [optional]  # noqa: E501
            connections_tls_remote_error (int): The number of times a connection attempt failed because the upstream server replied that it was unable to accept the connection request. This can be for various reasons such as an incompatible set of cipher suites. Check that the server supports a modern set of cipher suites, or look at its logs to see if it indicates the reason for the failure. . [optional]  # noqa: E501
            connections_tls_other_error (int): The number of times a connection attempt failed because the TLS negotiation failed for reasons other than the explicitly enumerated ones. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.connections_current = connections_current
        self.connections_timedout = connections_timedout
        self.connections_host_not_found = connections_host_not_found
        self.connections_reset = connections_reset
        self.connections_tls_validation_failed = connections_tls_validation_failed
        self.connections_other_failure = connections_other_failure
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, connections_current, connections_timedout, connections_host_not_found, connections_reset, connections_tls_validation_failed, connections_other_failure, *args, **kwargs):  # noqa: E501
        """NetworkDetailedStats - a model defined in OpenAPI

        Args:
            connections_current (int): The total number of connections currently established or establishing. This value is a guage, meaning it is not monotonic. 
            connections_timedout (int): The number of times a connection attempt failed because it took too long to establish
            connections_host_not_found (int): The number of times a connection attempt failed because a host lookup failed
            connections_reset (int): The number of times a connection attempt failed because the target host reset the connection 
            connections_tls_validation_failed (int): The number of times a connection attempt failed because TLS validation did not succeed. This is typically because either the server certificate did not match the expected one, or because we did not trust it. Try to fix this problem by ensuring that the certitifate is valid, matches the hostname the client connects to, and that it is issued by a certificate authority trusted by the client. Alternatively, if this is not possible, disable certificate validation. 
            connections_other_failure (int): The number of times a connection attempt failed for reasons other than the explicitly enumerated ones. 

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            connections_tls_protocol_failure (int): The number of times a connection attempt failed because the upstream returned an invalid TLS response. Typically this happens because the upstream is not configured to use TLS, but it could be due to a bug in the upstream server, or some other incompatibility (e.g. an unsupported version whose versioning mechanism is unknown). Check that the server is configured to serve TLS, or connect to it using plaintext. . [optional]  # noqa: E501
            connections_tls_unsupported_version (int): The number of times a connection attempt failed because the upstream server replied that it did not support one of the versions supported by the client. Typically this is because the server is running a fairly old version of software. See if there is a new version of the software available, or ensure that it provides a maximum TLS version of at least 1.2. . [optional]  # noqa: E501
            connections_tls_remote_error (int): The number of times a connection attempt failed because the upstream server replied that it was unable to accept the connection request. This can be for various reasons such as an incompatible set of cipher suites. Check that the server supports a modern set of cipher suites, or look at its logs to see if it indicates the reason for the failure. . [optional]  # noqa: E501
            connections_tls_other_error (int): The number of times a connection attempt failed because the TLS negotiation failed for reasons other than the explicitly enumerated ones. . [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.connections_current = connections_current
        self.connections_timedout = connections_timedout
        self.connections_host_not_found = connections_host_not_found
        self.connections_reset = connections_reset
        self.connections_tls_validation_failed = connections_tls_validation_failed
        self.connections_other_failure = connections_other_failure
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

