"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from agilicus_api.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)
from ..model_utils import OpenApiModel
from agilicus_api.exceptions import ApiAttributeError


def lazy_import():
    from agilicus_api.model.admin_status import AdminStatus
    from agilicus_api.model.auto_create_status import AutoCreateStatus
    from agilicus_api.model.operational_status import OperationalStatus
    globals()['AdminStatus'] = AdminStatus
    globals()['AutoCreateStatus'] = AutoCreateStatus
    globals()['OperationalStatus'] = OperationalStatus


class OIDCUpstreamIdentityProvider(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('prompt_mode',): {
            'AUTO': "auto",
            'DISABLED': "disabled",
        },
        ('oidc_flavor',): {
            'OIDC': "oidc",
            'MICROSOFT': "microsoft",
        },
    }

    validations = {
        ('name',): {
            'max_length': 100,
            'min_length': 1,
        },
        ('issuer',): {
            'max_length': 511,
            'min_length': 1,
        },
        ('client_id',): {
            'max_length': 100,
            'min_length': 1,
        },
        ('icon',): {
            'max_length': 50,
            'regex': {
                'pattern': r'^$|^[0-9a-zA-Z-_.]+$',  # noqa: E501
            },
        },
        ('client_secret',): {
            'max_length': 255,
        },
        ('issuer_external_host',): {
            'max_length': 255,
        },
        ('username_key',): {
            'max_length': 255,
        },
        ('email_key',): {
            'max_length': 255,
        },
        ('user_id_key',): {
            'max_length': 255,
        },
    }

    @property
    def name(self):
       return self.get("name")

    @name.setter
    def name(self, new_value):
       self.name = new_value

    @property
    def icon(self):
       return self.get("icon")

    @icon.setter
    def icon(self, new_value):
       self.icon = new_value

    @property
    def issuer(self):
       return self.get("issuer")

    @issuer.setter
    def issuer(self, new_value):
       self.issuer = new_value

    @property
    def client_id(self):
       return self.get("client_id")

    @client_id.setter
    def client_id(self, new_value):
       self.client_id = new_value

    @property
    def client_secret(self):
       return self.get("client_secret")

    @client_secret.setter
    def client_secret(self, new_value):
       self.client_secret = new_value

    @property
    def issuer_external_host(self):
       return self.get("issuer_external_host")

    @issuer_external_host.setter
    def issuer_external_host(self, new_value):
       self.issuer_external_host = new_value

    @property
    def username_key(self):
       return self.get("username_key")

    @username_key.setter
    def username_key(self, new_value):
       self.username_key = new_value

    @property
    def email_key(self):
       return self.get("email_key")

    @email_key.setter
    def email_key(self, new_value):
       self.email_key = new_value

    @property
    def email_verification_required(self):
       return self.get("email_verification_required")

    @email_verification_required.setter
    def email_verification_required(self, new_value):
       self.email_verification_required = new_value

    @property
    def request_user_info(self):
       return self.get("request_user_info")

    @request_user_info.setter
    def request_user_info(self, new_value):
       self.request_user_info = new_value

    @property
    def user_id_key(self):
       return self.get("user_id_key")

    @user_id_key.setter
    def user_id_key(self, new_value):
       self.user_id_key = new_value

    @property
    def auto_create_status(self):
       return self.get("auto_create_status")

    @auto_create_status.setter
    def auto_create_status(self, new_value):
       self.auto_create_status = new_value

    @property
    def prompt_mode(self):
       return self.get("prompt_mode")

    @prompt_mode.setter
    def prompt_mode(self, new_value):
       self.prompt_mode = new_value

    @property
    def oidc_flavor(self):
       return self.get("oidc_flavor")

    @oidc_flavor.setter
    def oidc_flavor(self, new_value):
       self.oidc_flavor = new_value

    @property
    def client_authorization_type(self):
       return self.get("client_authorization_type")

    @client_authorization_type.setter
    def client_authorization_type(self, new_value):
       self.client_authorization_type = new_value

    @property
    def admin_status(self):
       return self.get("admin_status")

    @admin_status.setter
    def admin_status(self, new_value):
       self.admin_status = new_value

    @property
    def trap_disabled(self):
       return self.get("trap_disabled")

    @trap_disabled.setter
    def trap_disabled(self, new_value):
       self.trap_disabled = new_value

    @property
    def operational_status(self):
       return self.get("operational_status")

    @operational_status.setter
    def operational_status(self, new_value):
       self.operational_status = new_value

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        lazy_import()
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'name': (str,),  # noqa: E501
            'issuer': (str,),  # noqa: E501
            'client_id': (str,),  # noqa: E501
            'icon': (str,),  # noqa: E501
            'client_secret': (str,),  # noqa: E501
            'issuer_external_host': (str,),  # noqa: E501
            'username_key': (str,),  # noqa: E501
            'email_key': (str,),  # noqa: E501
            'email_verification_required': (bool,),  # noqa: E501
            'request_user_info': (bool,),  # noqa: E501
            'user_id_key': (str,),  # noqa: E501
            'auto_create_status': (AutoCreateStatus,),  # noqa: E501
            'prompt_mode': (str,),  # noqa: E501
            'oidc_flavor': (str,),  # noqa: E501
            'client_authorization_type': (str, none_type,),  # noqa: E501
            'admin_status': (AdminStatus,),  # noqa: E501
            'trap_disabled': (bool,),  # noqa: E501
            'operational_status': (OperationalStatus,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None



    attribute_map = {
        'name': 'name',  # noqa: E501
        'issuer': 'issuer',  # noqa: E501
        'client_id': 'client_id',  # noqa: E501
        'icon': 'icon',  # noqa: E501
        'client_secret': 'client_secret',  # noqa: E501
        'issuer_external_host': 'issuer_external_host',  # noqa: E501
        'username_key': 'username_key',  # noqa: E501
        'email_key': 'email_key',  # noqa: E501
        'email_verification_required': 'email_verification_required',  # noqa: E501
        'request_user_info': 'request_user_info',  # noqa: E501
        'user_id_key': 'user_id_key',  # noqa: E501
        'auto_create_status': 'auto_create_status',  # noqa: E501
        'prompt_mode': 'prompt_mode',  # noqa: E501
        'oidc_flavor': 'oidc_flavor',  # noqa: E501
        'client_authorization_type': 'client_authorization_type',  # noqa: E501
        'admin_status': 'admin_status',  # noqa: E501
        'trap_disabled': 'trap_disabled',  # noqa: E501
        'operational_status': 'operational_status',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, name, issuer, client_id, *args, **kwargs):  # noqa: E501
        """OIDCUpstreamIdentityProvider - a model defined in OpenAPI

        Args:
            name (str): A name used to uniquely refer to the upstream identity provider configuration. This is the text that will be displayed when presenting the upstream identity for login.
            issuer (str): The upstream issuer uri. This is the URI which identifies the issuer against which users selecting this OIDCUpstreamIdentityProvider will authenticate. The issuer must support the OpenID Connect discovery document described here: https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderConfig.
            client_id (str): The client ID for the upstream identity provider

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            icon (str): The icon file to be used, limited to: numbers, letters, underscores, hyphens and periods. It is part of a css class (with the periods replaced by underscores).  To use a custom icon than the provided default you will need to add the icon the static/img folder and update the static css file to add a new css button like below ```json .dex-btn-icon--<your-logo_svg> {   background-image: url(../static/img/<your-logo.svg>); } ```  To use a default icon simply enter an icon name from the pre-provided defaults found in the static/img folder The default icons are   - bitbucket   - coreos   - email   - github   - gitlab   - google   - ldap   - linkedin   - microsoft   - oidc   - saml . [optional]  # noqa: E501
            client_secret (str): The secret presented to the upstream during any workflows which require authentication. [optional]  # noqa: E501
            issuer_external_host (str): A proxy standing in for the main issuer host. Use this if fronting the upstream through the Agilicus infrastructure. [optional]  # noqa: E501
            username_key (str): Allows changing the key in the OIDC response claims used to determine the full name of the user. If not present, defaults to the standard name. [optional]  # noqa: E501
            email_key (str): Allows changing the key in the OIDC response claims used to determine the email address of the user. If not present, defaults to the standard email. [optional]  # noqa: E501
            email_verification_required (bool): Controls whether email verification is required for this OIDC provider. Some OIDC providers do not take steps to verify the email address of users, or may not do so in all cases. Setting this value to true will reject any successful upstream logins for users which have not had their email address verified.. [optional] if omitted the server will use the default value of True  # noqa: E501
            request_user_info (bool): Controls whether the system will retrieve extra information about the user from the provider's user_info endpoint. This can be useful if the initial OIDC response does not contain sufficient information to determine the email address or user's name. Setting this value to true will cause extra requests to be generated to the upstream every time a user logs in to it.. [optional]  # noqa: E501
            user_id_key (str): Changes the key used to determine the id of the user in this upstream. The key will be used to retrieve the user id from the id token claims returned from the upstream when the user logs in. This user id is in turn used to link the user to its identity within the system. If not present, the system will fall back on the default, which is `sub`. . [optional]  # noqa: E501
            auto_create_status (AutoCreateStatus): [optional]  # noqa: E501
            prompt_mode (str): Controls how the issuer sets the 'prompt' field of the request to the upstream identity provider. It can take the following values: - `auto`: Determine whether to set the prompt field based on other criteria of the request, such as whether offline   mode is requested. - `disabled`: Never set the prompt field. . [optional]  # noqa: E501
            oidc_flavor (str): Controls the type/flavor of the upstream OIDC provider. Some providers have specific functionality that differs from standard oidc. For example, Microsoft utilizes the Graph API for group management. For example, if the upstream issuer is microsoft, setting this flavor to microsoft will query the groups by name so that Agilicus will reconcile all groups by the name, rather than its guid. . [optional] if omitted the server will use the default value of "oidc"  # noqa: E501
            client_authorization_type (str, none_type): supports values:   '' or null/not set: client_secret authorization is used   'federated-credential': Supports Microsoft federated credential.     In side the Microsoft Application Registration,     in \"Certificates & Secrets\" section, choose 'Federated credentials'. Choose \"Other Issuer\", and specify     the URL of the issuer (ie. https://auth.<org domain>). Choose Explicit subject identifier, and enter     the client ID of the Microsoft Application. . [optional]  # noqa: E501
            admin_status (AdminStatus): [optional]  # noqa: E501
            trap_disabled (bool): Inidicates whether traps (notifications) should be disabled for this entity. A true state indicates notifications will not be sent on transition. . [optional]  # noqa: E501
            operational_status (OperationalStatus): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.name = name
        self.issuer = issuer
        self.client_id = client_id
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    def __python_set(val):
        return set(val)
 
    required_properties = __python_set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, name, issuer, client_id, *args, **kwargs):  # noqa: E501
        """OIDCUpstreamIdentityProvider - a model defined in OpenAPI

        Args:
            name (str): A name used to uniquely refer to the upstream identity provider configuration. This is the text that will be displayed when presenting the upstream identity for login.
            issuer (str): The upstream issuer uri. This is the URI which identifies the issuer against which users selecting this OIDCUpstreamIdentityProvider will authenticate. The issuer must support the OpenID Connect discovery document described here: https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderConfig.
            client_id (str): The client ID for the upstream identity provider

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            icon (str): The icon file to be used, limited to: numbers, letters, underscores, hyphens and periods. It is part of a css class (with the periods replaced by underscores).  To use a custom icon than the provided default you will need to add the icon the static/img folder and update the static css file to add a new css button like below ```json .dex-btn-icon--<your-logo_svg> {   background-image: url(../static/img/<your-logo.svg>); } ```  To use a default icon simply enter an icon name from the pre-provided defaults found in the static/img folder The default icons are   - bitbucket   - coreos   - email   - github   - gitlab   - google   - ldap   - linkedin   - microsoft   - oidc   - saml . [optional]  # noqa: E501
            client_secret (str): The secret presented to the upstream during any workflows which require authentication. [optional]  # noqa: E501
            issuer_external_host (str): A proxy standing in for the main issuer host. Use this if fronting the upstream through the Agilicus infrastructure. [optional]  # noqa: E501
            username_key (str): Allows changing the key in the OIDC response claims used to determine the full name of the user. If not present, defaults to the standard name. [optional]  # noqa: E501
            email_key (str): Allows changing the key in the OIDC response claims used to determine the email address of the user. If not present, defaults to the standard email. [optional]  # noqa: E501
            email_verification_required (bool): Controls whether email verification is required for this OIDC provider. Some OIDC providers do not take steps to verify the email address of users, or may not do so in all cases. Setting this value to true will reject any successful upstream logins for users which have not had their email address verified.. [optional] if omitted the server will use the default value of True  # noqa: E501
            request_user_info (bool): Controls whether the system will retrieve extra information about the user from the provider's user_info endpoint. This can be useful if the initial OIDC response does not contain sufficient information to determine the email address or user's name. Setting this value to true will cause extra requests to be generated to the upstream every time a user logs in to it.. [optional]  # noqa: E501
            user_id_key (str): Changes the key used to determine the id of the user in this upstream. The key will be used to retrieve the user id from the id token claims returned from the upstream when the user logs in. This user id is in turn used to link the user to its identity within the system. If not present, the system will fall back on the default, which is `sub`. . [optional]  # noqa: E501
            auto_create_status (AutoCreateStatus): [optional]  # noqa: E501
            prompt_mode (str): Controls how the issuer sets the 'prompt' field of the request to the upstream identity provider. It can take the following values: - `auto`: Determine whether to set the prompt field based on other criteria of the request, such as whether offline   mode is requested. - `disabled`: Never set the prompt field. . [optional]  # noqa: E501
            oidc_flavor (str): Controls the type/flavor of the upstream OIDC provider. Some providers have specific functionality that differs from standard oidc. For example, Microsoft utilizes the Graph API for group management. For example, if the upstream issuer is microsoft, setting this flavor to microsoft will query the groups by name so that Agilicus will reconcile all groups by the name, rather than its guid. . [optional] if omitted the server will use the default value of "oidc"  # noqa: E501
            client_authorization_type (str, none_type): supports values:   '' or null/not set: client_secret authorization is used   'federated-credential': Supports Microsoft federated credential.     In side the Microsoft Application Registration,     in \"Certificates & Secrets\" section, choose 'Federated credentials'. Choose \"Other Issuer\", and specify     the URL of the issuer (ie. https://auth.<org domain>). Choose Explicit subject identifier, and enter     the client ID of the Microsoft Application. . [optional]  # noqa: E501
            admin_status (AdminStatus): [optional]  # noqa: E501
            trap_disabled (bool): Inidicates whether traps (notifications) should be disabled for this entity. A true state indicates notifications will not be sent on transition. . [optional]  # noqa: E501
            operational_status (OperationalStatus): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.name = name
        self.issuer = issuer
        self.client_id = client_id
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")

