"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import unittest

import agilicus_api
from agilicus_api.api.application_services_api import ApplicationServicesApi  # noqa: E501


class TestApplicationServicesApi(unittest.TestCase):
    """ApplicationServicesApi unit test stubs"""

    def setUp(self):
        self.api = ApplicationServicesApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_create_application_service(self):
        """Test case for create_application_service

        Create an ApplicationService  # noqa: E501
        """
        pass

    def test_create_application_service_token(self):
        """Test case for create_application_service_token

        create a token for an application service  # noqa: E501
        """
        pass

    def test_create_client_configuration(self):
        """Test case for create_client_configuration

        Create a client configuration  # noqa: E501
        """
        pass

    def test_create_database_resource(self):
        """Test case for create_database_resource

        Create a DatabaseResource  # noqa: E501
        """
        pass

    def test_create_desktop_resource(self):
        """Test case for create_desktop_resource

        Create a DesktopResource  # noqa: E501
        """
        pass

    def test_create_file_share_service(self):
        """Test case for create_file_share_service

        Create an FileShareService  # noqa: E501
        """
        pass

    def test_create_server_configuration(self):
        """Test case for create_server_configuration

        Create a server configuration  # noqa: E501
        """
        pass

    def test_create_service_forwarder(self):
        """Test case for create_service_forwarder

        Create an ServiceForwarder  # noqa: E501
        """
        pass

    def test_create_ssh_resource(self):
        """Test case for create_ssh_resource

        Create a SSHResource  # noqa: E501
        """
        pass

    def test_delete_application_service(self):
        """Test case for delete_application_service

        Remove an ApplicationService  # noqa: E501
        """
        pass

    def test_delete_database_resource(self):
        """Test case for delete_database_resource

        Remove a DatabaseResource  # noqa: E501
        """
        pass

    def test_delete_desktop_resource(self):
        """Test case for delete_desktop_resource

        Remove a DesktopResource  # noqa: E501
        """
        pass

    def test_delete_file_share_service(self):
        """Test case for delete_file_share_service

        Remove an FileShareService  # noqa: E501
        """
        pass

    def test_delete_service_forwarder(self):
        """Test case for delete_service_forwarder

        Remove an ServiceForwarder  # noqa: E501
        """
        pass

    def test_delete_ssh_resource(self):
        """Test case for delete_ssh_resource

        Remove a SSHResource  # noqa: E501
        """
        pass

    def test_get_application_service(self):
        """Test case for get_application_service

        Get a single ApplicationService  # noqa: E501
        """
        pass

    def test_get_application_service_stats(self):
        """Test case for get_application_service_stats

        Get ApplicationServiceStats  # noqa: E501
        """
        pass

    def test_get_application_service_usage_metrics(self):
        """Test case for get_application_service_usage_metrics

        Get application service metrics  # noqa: E501
        """
        pass

    def test_get_database_resource(self):
        """Test case for get_database_resource

        Get a single DatabaseResource  # noqa: E501
        """
        pass

    def test_get_desktop_resource(self):
        """Test case for get_desktop_resource

        Get a single DesktopResource  # noqa: E501
        """
        pass

    def test_get_file_share_service(self):
        """Test case for get_file_share_service

        Get a single FileShareService  # noqa: E501
        """
        pass

    def test_get_file_share_usage_metrics(self):
        """Test case for get_file_share_usage_metrics

        Get file share service metrics  # noqa: E501
        """
        pass

    def test_get_service_forwarder(self):
        """Test case for get_service_forwarder

        Get a single ServiceForwarder  # noqa: E501
        """
        pass

    def test_get_ssh_resource(self):
        """Test case for get_ssh_resource

        Get a single SSHResource  # noqa: E501
        """
        pass

    def test_list_application_services(self):
        """Test case for list_application_services

        Get a subset of the ApplicationServices  # noqa: E501
        """
        pass

    def test_list_database_resources(self):
        """Test case for list_database_resources

        Get a subset of the DatabaseResource objects.  # noqa: E501
        """
        pass

    def test_list_desktop_resources(self):
        """Test case for list_desktop_resources

        Get a subset of the DesktopResource objects.  # noqa: E501
        """
        pass

    def test_list_file_share_services(self):
        """Test case for list_file_share_services

        Get a subset of the FileShareServices  # noqa: E501
        """
        pass

    def test_list_service_forwarders(self):
        """Test case for list_service_forwarders

        Get a subset of the ServiceForwarder objects  # noqa: E501
        """
        pass

    def test_list_ssh_resources(self):
        """Test case for list_ssh_resources

        Get a subset of the SSHResource objects.  # noqa: E501
        """
        pass

    def test_replace_application_service(self):
        """Test case for replace_application_service

        Create or update an Application Service.  # noqa: E501
        """
        pass

    def test_replace_database_resource(self):
        """Test case for replace_database_resource

        Create or update a DatabaseResource.  # noqa: E501
        """
        pass

    def test_replace_desktop_resource(self):
        """Test case for replace_desktop_resource

        Create or update a DesktopResource.  # noqa: E501
        """
        pass

    def test_replace_file_share_service(self):
        """Test case for replace_file_share_service

        Create or update an FileShareService.  # noqa: E501
        """
        pass

    def test_replace_service_forwarder(self):
        """Test case for replace_service_forwarder

        Create or update an ServiceForwarder.  # noqa: E501
        """
        pass

    def test_replace_ssh_resource(self):
        """Test case for replace_ssh_resource

        Create or update a SSHResource.  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
