"""
    Agilicus API

    Agilicus is API-first. Modern software is controlled by other software, is open, is available for you to use the way you want, securely, simply.  The OpenAPI Specification in YAML format is available on [www](https://www.agilicus.com/www/api/agilicus-openapi.yaml) for importing to other tools.  A rendered, online viewable and usable version of this specification is available at [api](https://www.agilicus.com/api). You may try the API inline directly in the web page. To do so, first obtain an Authentication Token (the simplest way is to install the Python SDK, and then run `agilicus-cli --issuer https://MYISSUER get-token`). You will need an org-id for most calls (and can obtain from `agilicus-cli --issuer https://MYISSUER list-orgs`). The `MYISSUER` will typically be `auth.MYDOMAIN`, and you will see it as you sign-in to the administrative UI.  This API releases on Bearer-Token authentication. To obtain a valid bearer token you will need to Authenticate to an Issuer with OpenID Connect (a superset of OAUTH2).  Your \"issuer\" will look like https://auth.MYDOMAIN. For example, when you signed-up, if you said \"use my own domain name\" and assigned a CNAME of cloud.example.com, then your issuer would be https://auth.cloud.example.com.  If you selected \"use an Agilicus supplied domain name\", your issuer would look like https://auth.myorg.agilicus.cloud.  For test purposes you can use our [Python SDK](https://pypi.org/project/agilicus/) and run `agilicus-cli --issuer https://auth.MYDOMAIN get-token`.  This API may be used in any language runtime that supports OpenAPI 3.0, or, you may use our [Python SDK](https://pypi.org/project/agilicus/), our [Typescript SDK](https://www.npmjs.com/package/@agilicus/angular), or our [Golang SDK](https://git.agilicus.com/pub/sdk-go).  100% of the activities in our system our API-driven, from our web-admin, through our progressive web applications, to all internals: there is nothing that is not accessible.  For more information, see [developer resources](https://www.agilicus.com/developer).   # noqa: E501

    The version of the OpenAPI document: 2025.07.28
    Contact: dev@agilicus.com
    Generated by: https://openapi-generator.tech
"""


import unittest

import agilicus_api
from agilicus_api.api.tokens_api import TokensApi  # noqa: E501


class TestTokensApi(unittest.TestCase):
    """TokensApi unit test stubs"""

    def setUp(self):
        self.api = TokensApi()  # noqa: E501

    def tearDown(self):
        pass

    def test_create_api_key(self):
        """Test case for create_api_key

        Create an API Key  # noqa: E501
        """
        pass

    def test_create_api_key_introspection(self):
        """Test case for create_api_key_introspection

        Introspect an API Key  # noqa: E501
        """
        pass

    def test_create_authentication_document(self):
        """Test case for create_authentication_document

        Create a authentication document  # noqa: E501
        """
        pass

    def test_create_bulk_delete_session_task(self):
        """Test case for create_bulk_delete_session_task

        Delete a set of sessions  # noqa: E501
        """
        pass

    def test_create_bulk_revoke_session_task(self):
        """Test case for create_bulk_revoke_session_task

        Revoke a set of sessions  # noqa: E501
        """
        pass

    def test_create_bulk_revoke_token_task(self):
        """Test case for create_bulk_revoke_token_task

        Revoke a set of tokens  # noqa: E501
        """
        pass

    def test_create_introspect_token(self):
        """Test case for create_introspect_token

        Introspect a token  # noqa: E501
        """
        pass

    def test_create_introspect_token_all_sub_orgs(self):
        """Test case for create_introspect_token_all_sub_orgs

        Introspect a token in all sub orgs  # noqa: E501
        """
        pass

    def test_create_reissued_token(self):
        """Test case for create_reissued_token

        Issue a new token from another  # noqa: E501
        """
        pass

    def test_create_revoke_token_task(self):
        """Test case for create_revoke_token_task

        Revoke a token  # noqa: E501
        """
        pass

    def test_create_session(self):
        """Test case for create_session

        Create a session  # noqa: E501
        """
        pass

    def test_create_session_and_token(self):
        """Test case for create_session_and_token

        Create a session and a token associated with the session  # noqa: E501
        """
        pass

    def test_create_session_challenge(self):
        """Test case for create_session_challenge

        Create a user challenge request for a session  # noqa: E501
        """
        pass

    def test_create_token(self):
        """Test case for create_token

        Create a token  # noqa: E501
        """
        pass

    def test_create_token_validation(self):
        """Test case for create_token_validation

        Validate a token request  # noqa: E501
        """
        pass

    def test_create_user_data_token(self):
        """Test case for create_user_data_token

        Create a User Data Token  # noqa: E501
        """
        pass

    def test_delete_api_key(self):
        """Test case for delete_api_key

        Delete an API Key  # noqa: E501
        """
        pass

    def test_delete_authentication_document(self):
        """Test case for delete_authentication_document

        Delete a authentication document  # noqa: E501
        """
        pass

    def test_delete_session(self):
        """Test case for delete_session

        Delete a session  # noqa: E501
        """
        pass

    def test_get_api_key(self):
        """Test case for get_api_key

        Get an API Key  # noqa: E501
        """
        pass

    def test_get_authentication_document(self):
        """Test case for get_authentication_document

        Get a authentication document  # noqa: E501
        """
        pass

    def test_get_jwks(self):
        """Test case for get_jwks

        Return JSON Web Key Set (JWKS)  # noqa: E501
        """
        pass

    def test_get_session(self):
        """Test case for get_session

        Get a session  # noqa: E501
        """
        pass

    def test_get_token(self):
        """Test case for get_token

        introspect token  # noqa: E501
        """
        pass

    def test_get_user_data_jwks(self):
        """Test case for get_user_data_jwks

        Return JSON Web Key Set (JWKS)  # noqa: E501
        """
        pass

    def test_list_api_keys(self):
        """Test case for list_api_keys

        List API Keys  # noqa: E501
        """
        pass

    def test_list_authentication_documents(self):
        """Test case for list_authentication_documents

        List authentication documents  # noqa: E501
        """
        pass

    def test_list_sessions(self):
        """Test case for list_sessions

        List Sessions  # noqa: E501
        """
        pass

    def test_list_tokens(self):
        """Test case for list_tokens

        Query tokens  # noqa: E501
        """
        pass

    def test_refresh_token(self):
        """Test case for refresh_token

        Refresh a token  # noqa: E501
        """
        pass

    def test_replace_api_key(self):
        """Test case for replace_api_key

        Update an API key  # noqa: E501
        """
        pass

    def test_replace_session(self):
        """Test case for replace_session

        Update a session  # noqa: E501
        """
        pass

    def test_update_session_challenge(self):
        """Test case for update_session_challenge

        Update a session with its challenge answer  # noqa: E501
        """
        pass

    def test_validate_identity_assertion(self):
        """Test case for validate_identity_assertion

        Validate an identity assertion  # noqa: E501
        """
        pass


if __name__ == '__main__':
    unittest.main()
