import * as lambda from '@aws-cdk/aws-lambda';
import * as s3 from '@aws-cdk/aws-s3';
import { Construct } from '@aws-cdk/core';
/**
 * Use a Lambda function as a bucket notification destination.
 *
 * @stability stable
 */
export declare class LambdaDestination implements s3.IBucketNotificationDestination {
    private readonly fn;
    /**
     * @stability stable
     */
    constructor(fn: lambda.IFunction);
    /**
     * Registers this resource to receive notifications for the specified bucket.
     *
     * This method will only be called once for each destination/bucket
     * pair and the result will be cached, so there is no need to implement
     * idempotency in each destination.
     *
     * @stability stable
     */
    bind(_scope: Construct, bucket: s3.IBucket): s3.BucketNotificationDestinationConfig;
}
