"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * Use a Lambda function as a bucket notification destination.
 *
 * @stability stable
 */
class LambdaDestination {
    /**
     * @stability stable
     */
    constructor(fn) {
        this.fn = fn;
    }
    /**
     * Registers this resource to receive notifications for the specified bucket.
     *
     * This method will only be called once for each destination/bucket
     * pair and the result will be cached, so there is no need to implement
     * idempotency in each destination.
     *
     * @stability stable
     */
    bind(_scope, bucket) {
        const permissionId = `AllowBucketNotificationsTo${core_1.Names.nodeUniqueId(this.fn.permissionsNode)}`;
        if (!core_2.Construct.isConstruct(bucket)) {
            throw new Error(`LambdaDestination for function ${core_1.Names.nodeUniqueId(this.fn.permissionsNode)} can only be configured on a
        bucket construct (Bucket ${bucket.bucketName})`);
        }
        if (bucket.node.tryFindChild(permissionId) === undefined) {
            this.fn.addPermission(permissionId, {
                sourceAccount: core_1.Stack.of(bucket).account,
                principal: new iam.ServicePrincipal('s3.amazonaws.com'),
                sourceArn: bucket.bucketArn,
                // Placing the permissions node in the same scope as the s3 bucket.
                // Otherwise, there is a circular dependency when the s3 bucket
                // and lambda functions declared in different stacks.
                scope: bucket,
            });
        }
        // if we have a permission resource for this relationship, add it as a dependency
        // to the bucket notifications resource, so it will be created first.
        const permission = bucket.node.tryFindChild(permissionId);
        return {
            type: s3.BucketNotificationDestinationType.LAMBDA,
            arn: this.fn.functionArn,
            dependencies: permission ? [permission] : undefined,
        };
    }
}
exports.LambdaDestination = LambdaDestination;
_a = JSII_RTTI_SYMBOL_1;
LambdaDestination[_a] = { fqn: "@aws-cdk/aws-s3-notifications.LambdaDestination", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,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