import * as s3 from '@aws-cdk/aws-s3';
import * as sns from '@aws-cdk/aws-sns';
import { Construct } from '@aws-cdk/core';
/**
 * Use an SNS topic as a bucket notification destination.
 *
 * @stability stable
 */
export declare class SnsDestination implements s3.IBucketNotificationDestination {
    private readonly topic;
    /**
     * @stability stable
     */
    constructor(topic: sns.ITopic);
    /**
     * Registers this resource to receive notifications for the specified bucket.
     *
     * This method will only be called once for each destination/bucket
     * pair and the result will be cached, so there is no need to implement
     * idempotency in each destination.
     *
     * @stability stable
     */
    bind(_scope: Construct, bucket: s3.IBucket): s3.BucketNotificationDestinationConfig;
}
