"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
/**
 * Use an SNS topic as a bucket notification destination.
 *
 * @stability stable
 */
class SnsDestination {
    /**
     * @stability stable
     */
    constructor(topic) {
        this.topic = topic;
    }
    /**
     * Registers this resource to receive notifications for the specified bucket.
     *
     * This method will only be called once for each destination/bucket
     * pair and the result will be cached, so there is no need to implement
     * idempotency in each destination.
     *
     * @stability stable
     */
    bind(_scope, bucket) {
        this.topic.addToResourcePolicy(new iam.PolicyStatement({
            principals: [new iam.ServicePrincipal('s3.amazonaws.com')],
            actions: ['sns:Publish'],
            resources: [this.topic.topicArn],
            conditions: {
                ArnLike: { 'aws:SourceArn': bucket.bucketArn },
            },
        }));
        return {
            arn: this.topic.topicArn,
            type: s3.BucketNotificationDestinationType.TOPIC,
            dependencies: [this.topic],
        };
    }
}
exports.SnsDestination = SnsDestination;
_a = JSII_RTTI_SYMBOL_1;
SnsDestination[_a] = { fqn: "@aws-cdk/aws-s3-notifications.SnsDestination", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,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