import * as s3 from '@aws-cdk/aws-s3';
import * as sqs from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
/**
 * Use an SQS queue as a bucket notification destination.
 *
 * @stability stable
 */
export declare class SqsDestination implements s3.IBucketNotificationDestination {
    private readonly queue;
    /**
     * @stability stable
     */
    constructor(queue: sqs.IQueue);
    /**
     * Allows using SQS queues as destinations for bucket notifications.
     *
     * Use `bucket.onEvent(event, queue)` to subscribe.
     *
     * @stability stable
     */
    bind(_scope: Construct, bucket: s3.IBucket): s3.BucketNotificationDestinationConfig;
}
