"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsDestination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const s3 = require("@aws-cdk/aws-s3");
/**
 * Use an SQS queue as a bucket notification destination.
 *
 * @stability stable
 */
class SqsDestination {
    /**
     * @stability stable
     */
    constructor(queue) {
        this.queue = queue;
    }
    /**
     * Allows using SQS queues as destinations for bucket notifications.
     *
     * Use `bucket.onEvent(event, queue)` to subscribe.
     *
     * @stability stable
     */
    bind(_scope, bucket) {
        this.queue.grantSendMessages(new iam.ServicePrincipal('s3.amazonaws.com', {
            conditions: {
                ArnLike: { 'aws:SourceArn': bucket.bucketArn },
            },
        }));
        // if this queue is encrypted, we need to allow S3 to read messages since that's how
        // it verifies that the notification destination configuration is valid.
        if (this.queue.encryptionMasterKey) {
            this.queue.encryptionMasterKey.addToResourcePolicy(new iam.PolicyStatement({
                principals: [new iam.ServicePrincipal('s3.amazonaws.com')],
                actions: ['kms:GenerateDataKey*', 'kms:Decrypt'],
                resources: ['*'],
            }), /* allowNoOp */ false);
        }
        return {
            arn: this.queue.queueArn,
            type: s3.BucketNotificationDestinationType.QUEUE,
            dependencies: [this.queue],
        };
    }
}
exports.SqsDestination = SqsDestination;
_a = JSII_RTTI_SYMBOL_1;
SqsDestination[_a] = { fqn: "@aws-cdk/aws-s3-notifications.SqsDestination", version: "1.139.0" };
//# sourceMappingURL=data:application/json;base64,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