# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..resources.auth.resources.default.client import DefaultClient
from .client_wrapper import SyncClientWrapper


class OAuthTokenProvider:
    BUFFER_IN_MINUTES = 2

    def __init__(self, *, client_id: str, client_secret: str, client_wrapper: SyncClientWrapper):
        self._client_id = client_id
        self._client_secret = client_secret
        self._access_token: typing.Optional[str] = None
        self._expires_at: dt.datetime = dt.datetime.now()
        self._auth_client = DefaultClient(client_wrapper=client_wrapper)

    def get_token(self) -> str:
        if self._access_token and self._expires_at > dt.datetime.now():
            return self._access_token
        return self._refresh()

    def _refresh(self) -> str:
        token_response = self._auth_client.get_token(client_id=self._client_id, client_secret=self._client_secret)
        self._access_token = token_response.access_token
        self._expires_at = self._get_expires_at(
            expires_in_seconds=token_response.expires_in, buffer_in_minutes=self.BUFFER_IN_MINUTES
        )
        return self._access_token

    def _get_expires_at(self, *, expires_in_seconds: int, buffer_in_minutes: int):
        return dt.datetime.now() + dt.timedelta(seconds=expires_in_seconds) - dt.timedelta(minutes=buffer_in_minutes)
