# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from .raw_client import AsyncRawDefaultClient, RawDefaultClient
from .types.auth_get_token_response import AuthGetTokenResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DefaultClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDefaultClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDefaultClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDefaultClient
        """
        return self._raw_client

    def get_token(
        self, *, client_id: str, client_secret: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AuthGetTokenResponse:
        """
        <Callout intent="info">
        Candid Health SDKs automatically handle authentication workflows after configuring them with the `client_id` and
        `client_secret`.
        </Callout>

        Candid Health utilizes the [OAuth 2.0 bearer token authentication scheme](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication) in our auth flow. You obtain the bearer token for all
        subsequent API requests via the `/auth/v2/token` endpoint defined below, which requires you to provide your `client_id` and `client_secret`. Your `client_id` and `client_secret` can be [generated](https://support.joincandidhealth.com/hc/en-us/articles/23065219476244--Generating-Candid-API-Keys) from the "Users & Credentials" tab by your org admin.

        The `/auth/v2/token` endpoint accepts both `Content-Type: application/json` and `Content-Type: application/x-www-form-urlencoded`. The request body should contain the `client_id` and `client_secret` as follows:

        ```json
        {
          "client_id": "YOUR_CLIENT_ID",
          "client_secret": "YOUR_CLIENT_SECRET"
        }
        ```
        or as URL-encoded form data:

        ```
        client_id=YOUR_CLIENT_ID&client_secret=YOUR_CLIENT_SECRET
        ```

        The bearer token is a signed [JWT](https://jwt.io/). The public key for the JWT can be found [here](https://candidhealth.auth0.com/pem) for any verification workflows.

        The bearer token should be provided in the `Authorization` header for all subsequent API calls.

        <Callout intent="warning">
        The bearer token expires 5 hours after it has been created. After it has expired, the client will receive an "HTTP 401
        Unauthorized" error, at which point the client should generate a new token. It is important that tokens be reused between
        requests; if the client attempts to generate a token too often, it will be rate-limited and will receive an `HTTP 429 Too Many Requests` error.
        </Callout>

        Parameters
        ----------
        client_id : str
            Your application's Client ID.

        client_secret : str
            Your application's Client Secret.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthGetTokenResponse

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.auth.default.get_token(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        """
        _response = self._raw_client.get_token(
            client_id=client_id, client_secret=client_secret, request_options=request_options
        )
        return _response.data


class AsyncDefaultClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDefaultClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDefaultClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDefaultClient
        """
        return self._raw_client

    async def get_token(
        self, *, client_id: str, client_secret: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AuthGetTokenResponse:
        """
        <Callout intent="info">
        Candid Health SDKs automatically handle authentication workflows after configuring them with the `client_id` and
        `client_secret`.
        </Callout>

        Candid Health utilizes the [OAuth 2.0 bearer token authentication scheme](https://developer.mozilla.org/en-US/docs/Web/HTTP/Authentication) in our auth flow. You obtain the bearer token for all
        subsequent API requests via the `/auth/v2/token` endpoint defined below, which requires you to provide your `client_id` and `client_secret`. Your `client_id` and `client_secret` can be [generated](https://support.joincandidhealth.com/hc/en-us/articles/23065219476244--Generating-Candid-API-Keys) from the "Users & Credentials" tab by your org admin.

        The `/auth/v2/token` endpoint accepts both `Content-Type: application/json` and `Content-Type: application/x-www-form-urlencoded`. The request body should contain the `client_id` and `client_secret` as follows:

        ```json
        {
          "client_id": "YOUR_CLIENT_ID",
          "client_secret": "YOUR_CLIENT_SECRET"
        }
        ```
        or as URL-encoded form data:

        ```
        client_id=YOUR_CLIENT_ID&client_secret=YOUR_CLIENT_SECRET
        ```

        The bearer token is a signed [JWT](https://jwt.io/). The public key for the JWT can be found [here](https://candidhealth.auth0.com/pem) for any verification workflows.

        The bearer token should be provided in the `Authorization` header for all subsequent API calls.

        <Callout intent="warning">
        The bearer token expires 5 hours after it has been created. After it has expired, the client will receive an "HTTP 401
        Unauthorized" error, at which point the client should generate a new token. It is important that tokens be reused between
        requests; if the client attempts to generate a token too often, it will be rate-limited and will receive an `HTTP 429 Too Many Requests` error.
        </Callout>

        Parameters
        ----------
        client_id : str
            Your application's Client ID.

        client_secret : str
            Your application's Client Secret.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AuthGetTokenResponse

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.auth.default.get_token(
                client_id="YOUR_CLIENT_ID",
                client_secret="YOUR_CLIENT_SECRET",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_token(
            client_id=client_id, client_secret=client_secret, request_options=request_options
        )
        return _response.data
