# This file was auto-generated by Fern from our API Definition.

import typing

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....commons.types.encounter_id import EncounterId
from .raw_client import AsyncRawV2Client, RawV2Client
from .types.billing_note import BillingNote
from .types.billing_note_id import BillingNoteId

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V2Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV2Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV2Client
        """
        return self._raw_client

    def create(
        self, *, encounter_id: EncounterId, text: str, request_options: typing.Optional[RequestOptions] = None
    ) -> BillingNote:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        text : str
            Empty string not allowed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BillingNote

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.billing_notes.v_2.create(
            encounter_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.create(encounter_id=encounter_id, text=text, request_options=request_options)
        return _response.data

    def delete(
        self, billing_note_id: BillingNoteId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        billing_note_id : BillingNoteId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.billing_notes.v_2.delete(
            billing_note_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.delete(billing_note_id, request_options=request_options)
        return _response.data

    def update(
        self, billing_note_id: BillingNoteId, *, text: str, request_options: typing.Optional[RequestOptions] = None
    ) -> BillingNote:
        """
        Parameters
        ----------
        billing_note_id : BillingNoteId

        text : str
            Empty string not allowed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BillingNote

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.billing_notes.v_2.update(
            billing_note_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
            text="text",
        )
        """
        _response = self._raw_client.update(billing_note_id, text=text, request_options=request_options)
        return _response.data


class AsyncV2Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV2Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV2Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV2Client
        """
        return self._raw_client

    async def create(
        self, *, encounter_id: EncounterId, text: str, request_options: typing.Optional[RequestOptions] = None
    ) -> BillingNote:
        """
        Parameters
        ----------
        encounter_id : EncounterId

        text : str
            Empty string not allowed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BillingNote

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.billing_notes.v_2.create(
                encounter_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(encounter_id=encounter_id, text=text, request_options=request_options)
        return _response.data

    async def delete(
        self, billing_note_id: BillingNoteId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        Parameters
        ----------
        billing_note_id : BillingNoteId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.billing_notes.v_2.delete(
                billing_note_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(billing_note_id, request_options=request_options)
        return _response.data

    async def update(
        self, billing_note_id: BillingNoteId, *, text: str, request_options: typing.Optional[RequestOptions] = None
    ) -> BillingNote:
        """
        Parameters
        ----------
        billing_note_id : BillingNoteId

        text : str
            Empty string not allowed.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BillingNote

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.billing_notes.v_2.update(
                billing_note_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
                text="text",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(billing_note_id, text=text, request_options=request_options)
        return _response.data
