# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2
from .....commons.types.encounter_id import EncounterId
from .billing_note_base import BillingNoteBase
from .billing_note_id import BillingNoteId


class BillingNote(BillingNoteBase):
    """
    Examples
    --------
    import datetime
    import uuid

    from candid.resources.billing_notes.resources.v_2 import BillingNote

    BillingNote(
        billing_note_id=uuid.UUID(
            "99882eea-936f-4e71-bc4f-520e4d14e3e2",
        ),
        encounter_id=uuid.UUID(
            "8bcfb6a8-2876-4111-9e3f-602b541fcf62",
        ),
        created_at=datetime.datetime.fromisoformat(
            "2023-01-01 00:00:00+00:00",
        ),
        author_auth_0_id="F0DE3BF9-F9A1-4FA7-BF6B-28C0B46BADD8",
        author_name="John Doe",
        text="Patient was billed for an MRI.",
    )
    """

    billing_note_id: BillingNoteId
    encounter_id: EncounterId
    created_at: dt.datetime = pydantic.Field()
    """
    An [RFC 3339, section 5.6 datetime](https://ijmacd.github.io/rfc3339-iso8601/).
    For example, 2017-07-21T17:32:28Z.
    """

    author_auth_0_id: typing.Optional[str] = pydantic.Field(alias="author_auth0_id", default=None)
    author_name: typing.Optional[str] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
