# This file was auto-generated by Fern from our API Definition.

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .raw_client import AsyncRawChargeCaptureClient, RawChargeCaptureClient
from .resources.v_1.client import AsyncV1Client, V1Client


class ChargeCaptureClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawChargeCaptureClient(client_wrapper=client_wrapper)
        self.v_1 = V1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawChargeCaptureClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawChargeCaptureClient
        """
        return self._raw_client


class AsyncChargeCaptureClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawChargeCaptureClient(client_wrapper=client_wrapper)
        self.v_1 = AsyncV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawChargeCaptureClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawChargeCaptureClient
        """
        return self._raw_client
