# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....commons.errors.entity_not_found_error import EntityNotFoundError
from ....commons.errors.http_request_validations_error import HttpRequestValidationsError
from ....commons.errors.unauthorized_error import UnauthorizedError
from ....commons.errors.unprocessable_entity_error import UnprocessableEntityError
from ....commons.types.charge_capture_claim_creation_id import ChargeCaptureClaimCreationId
from ....commons.types.charge_capture_id import ChargeCaptureId
from ....commons.types.charge_capture_post_billed_change_id import ChargeCapturePostBilledChangeId
from ....commons.types.encounter_id import EncounterId
from ....commons.types.entity_not_found_error_message import EntityNotFoundErrorMessage
from ....commons.types.page_token import PageToken
from ....commons.types.request_validation_error import RequestValidationError
from ....commons.types.sort_direction import SortDirection
from ....commons.types.unauthorized_error_message import UnauthorizedErrorMessage
from ....commons.types.unprocessable_entity_error_message import UnprocessableEntityErrorMessage
from ....encounters.resources.v_4.errors.schema_instance_validation_http_failure import (
    SchemaInstanceValidationHttpFailure,
)
from ....encounters.resources.v_4.types.billable_status_type import BillableStatusType
from ....encounters.resources.v_4.types.responsible_party_type import ResponsiblePartyType
from ....encounters.resources.v_4.types.schema_instance_validation_failure import SchemaInstanceValidationFailure
from .errors.charge_external_id_conflict_error import ChargeExternalIdConflictError
from .types.charge_capture import ChargeCapture
from .types.charge_capture_data import ChargeCaptureData
from .types.charge_capture_page import ChargeCapturePage
from .types.charge_capture_post_billed_change import ChargeCapturePostBilledChange
from .types.charge_capture_sort_field import ChargeCaptureSortField
from .types.charge_capture_status import ChargeCaptureStatus
from .types.charge_external_id_conflict_error_message import ChargeExternalIdConflictErrorMessage

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create(
        self,
        *,
        data: ChargeCaptureData,
        charge_external_id: str,
        patient_external_id: str,
        status: ChargeCaptureStatus,
        originating_system: typing.Optional[str] = OMIT,
        claim_creation_category: typing.Optional[str] = OMIT,
        ehr_source_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ChargeCapture]:
        """
        Parameters
        ----------
        data : ChargeCaptureData
            Charge Capture data contains all the fields needed to create an encounter, but listed as optional. Candid will use this data when attempting to bundle multiple Charge Captures into a single encounter.

        charge_external_id : str
            A client-specified unique ID to associate with this encounter; for example, your internal encounter ID or a Dr. Chrono encounter ID. This field should not contain PHI.

        patient_external_id : str
            The patient ID from the external EMR platform for the patient

        status : ChargeCaptureStatus
            the status of the charge capture

        originating_system : typing.Optional[str]
            An optional string field denoting the originating system of the charge.

        claim_creation_category : typing.Optional[str]
            An optional string field denoting the user defined category of the claim creation.

        ehr_source_url : typing.Optional[str]
            External URL reference that links to Charge Capture details within the external system (e.g. the EHR visit page). Send full URL format for the external link (e.g. https://emr_charge_capture_url.com/123).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ChargeCapture]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/charge_captures/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json={
                "data": data,
                "charge_external_id": charge_external_id,
                "originating_system": originating_system,
                "claim_creation_category": claim_creation_category,
                "ehr_source_url": ehr_source_url,
                "patient_external_id": patient_external_id,
                "status": status,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCapture,
                parse_obj_as(
                    type_=ChargeCapture,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "SchemaInstanceValidationHttpFailure":
                raise SchemaInstanceValidationHttpFailure(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        SchemaInstanceValidationFailure,
                        parse_obj_as(
                            type_=SchemaInstanceValidationFailure,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "ChargeExternalIdConflictError":
                raise ChargeExternalIdConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ChargeExternalIdConflictErrorMessage,
                        parse_obj_as(
                            type_=ChargeExternalIdConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        charge_capture_id: ChargeCaptureId,
        *,
        data: typing.Optional[ChargeCaptureData] = OMIT,
        charge_external_id: typing.Optional[str] = OMIT,
        ehr_source_url: typing.Optional[str] = OMIT,
        originating_system: typing.Optional[str] = OMIT,
        claim_creation_category: typing.Optional[str] = OMIT,
        patient_external_id: typing.Optional[str] = OMIT,
        status: typing.Optional[ChargeCaptureStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ChargeCapture]:
        """
        Parameters
        ----------
        charge_capture_id : ChargeCaptureId

        data : typing.Optional[ChargeCaptureData]

        charge_external_id : typing.Optional[str]
            A client-specified unique ID to associate with this encounter;
            for example, your internal encounter ID or a Dr. Chrono encounter ID.
            This field should not contain PHI.

        ehr_source_url : typing.Optional[str]
            External URL reference that links to Charge Capture details within the external system (e.g. the EHR visit page).
            Send full URL format for the external link (e.g. https://emr_charge_capture_url.com/123).

        originating_system : typing.Optional[str]
            An optional string field denoting the originating system of the charge.

        claim_creation_category : typing.Optional[str]
            An optional string field denoting the user defined category of the claim creation.

        patient_external_id : typing.Optional[str]
            The patient ID from the external EMR platform for the patient

        status : typing.Optional[ChargeCaptureStatus]
            the status of the charge capture

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ChargeCapture]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/charge_captures/v1/{jsonable_encoder(charge_capture_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json={
                "data": data,
                "charge_external_id": charge_external_id,
                "ehr_source_url": ehr_source_url,
                "originating_system": originating_system,
                "claim_creation_category": claim_creation_category,
                "patient_external_id": patient_external_id,
                "status": status,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCapture,
                parse_obj_as(
                    type_=ChargeCapture,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "SchemaInstanceValidationHttpFailure":
                raise SchemaInstanceValidationHttpFailure(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        SchemaInstanceValidationFailure,
                        parse_obj_as(
                            type_=SchemaInstanceValidationFailure,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get(
        self, charge_capture_id: ChargeCaptureId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ChargeCapture]:
        """
        Parameters
        ----------
        charge_capture_id : ChargeCaptureId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ChargeCapture]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/charge_captures/v1/{jsonable_encoder(charge_capture_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCapture,
                parse_obj_as(
                    type_=ChargeCapture,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_all(
        self,
        *,
        limit: typing.Optional[int] = None,
        sort: typing.Optional[ChargeCaptureSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        patient_external_id: typing.Optional[str] = None,
        status: typing.Optional[ChargeCaptureStatus] = None,
        charge_external_id: typing.Optional[str] = None,
        date_of_service_min: typing.Optional[dt.date] = None,
        date_of_service_max: typing.Optional[dt.date] = None,
        claim_ids: typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]] = None,
        claim_creation_ids: typing.Optional[
            typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]
        ] = None,
        billing_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        service_facility_name: typing.Optional[str] = None,
        primary_payer_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        exclude_charges_linked_to_claims: typing.Optional[bool] = None,
        patient_external_id_ranked_sort: typing.Optional[str] = None,
        status_ranked_sort: typing.Optional[ChargeCaptureStatus] = None,
        charge_external_id_ranked_sort: typing.Optional[str] = None,
        date_of_service_min_ranked_sort: typing.Optional[dt.date] = None,
        date_of_service_max_ranked_sort: typing.Optional[dt.date] = None,
        search_term: typing.Optional[str] = None,
        billable_status: typing.Optional[BillableStatusType] = None,
        responsible_party: typing.Optional[ResponsiblePartyType] = None,
        claim_ids_ranked_sort: typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]] = None,
        claim_creation_ids_ranked_sort: typing.Optional[
            typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]
        ] = None,
        billing_provider_npis_ranked_sort: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        service_facility_name_ranked_sort: typing.Optional[str] = None,
        primary_payer_ids_ranked_sort: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_npis_ranked_sort: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_names_ranked_sort: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_npis_ranked_sort: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_names_ranked_sort: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ChargeCapturePage]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Maximum number of entities per page, defaults to 100.

        sort : typing.Optional[ChargeCaptureSortField]
            Defaults to created_at

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        patient_external_id : typing.Optional[str]
            The patient ID from the external EMR platform for the patient

        status : typing.Optional[ChargeCaptureStatus]
            the status of the charge captures

        charge_external_id : typing.Optional[str]
            A client-specified unique ID to associate with this encounter;
            for example, your internal encounter ID or a Dr. Chrono encounter ID.
            This field should not contain PHI.

        date_of_service_min : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        date_of_service_max : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        claim_ids : typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]]
            A list of claim IDs to filter by. This will return all charge captures that have a resulting claim with one of the IDs in this list.

        claim_creation_ids : typing.Optional[typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]]
            A list of Claim Creation IDs to filter by.

        billing_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of billing provider NPIs to filter by. This will return all charge captures with one of the NPIs in this list.

        service_facility_name : typing.Optional[str]
            A string to filter by. This will return all charge captures with this service facility name.

        primary_payer_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of primary payer IDs to filter by. This will return all charge captures with one of the primary payer IDs in this list.

        rendering_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider NPIs to filter by. This will return all charge captures with one of the NPIs in this list.

        rendering_provider_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider names to filter by. This will return all charge captures with one of the names in this list.

        supervising_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider NPIs to filter by. This will return all charge captures with one of the NPIs in this list.

        supervising_provider_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider names to filter by. This will return all charge captures with one of the names in this list.

        exclude_charges_linked_to_claims : typing.Optional[bool]
            Whether to exclude charge captures which are part of a claim creation.

        patient_external_id_ranked_sort : typing.Optional[str]
            The patient ID from the external EMR platform for the patient

        status_ranked_sort : typing.Optional[ChargeCaptureStatus]
            The charge capture status to show first

        charge_external_id_ranked_sort : typing.Optional[str]
            A client-specified unique ID to associate with this encounter;
            for example, your internal encounter ID or a Dr. Chrono encounter ID.
            This field should not contain PHI.

        date_of_service_min_ranked_sort : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        date_of_service_max_ranked_sort : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        search_term : typing.Optional[str]
            Filter by any of the following fields: charge_id, claim_id, patient external_id,
            patient date of birth, patient first name, patient last name,
            or charge external id.

        billable_status : typing.Optional[BillableStatusType]
            Defines if the Encounter is to be billed by Candid to the responsible_party. Examples for when this should be set to NOT_BILLABLE include if the Encounter has not occurred yet or if there is no intention of ever billing the responsible_party.

        responsible_party : typing.Optional[ResponsiblePartyType]
            Defines the party to be billed with the initial balance owed on the claim. Use SELF_PAY if you intend to bill self pay/cash pay.

        claim_ids_ranked_sort : typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]]
            A list of claim IDs to show first. This will return all charge captures that have a resulting claim with one of the IDs in this list.

        claim_creation_ids_ranked_sort : typing.Optional[typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]]
            A list of Claim Creation IDs to show first.

        billing_provider_npis_ranked_sort : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of billing provider NPIs to show first. This will return all charge captures with one of the NPIs in this list.

        service_facility_name_ranked_sort : typing.Optional[str]
            A string to show first. This will return all charge captures with this service facility name.

        primary_payer_ids_ranked_sort : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of primary payer IDs to show first. This will return all charge captures with one of the primary payer IDs in this list.

        rendering_provider_npis_ranked_sort : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider NPIs to show first. This will return all charge captures with one of the NPIs in this list.

        rendering_provider_names_ranked_sort : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider names to show first. This will return all charge captures with one of the names in this list.

        supervising_provider_npis_ranked_sort : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider NPIs to show first. This will return all charge captures with one of the NPIs in this list.

        supervising_provider_names_ranked_sort : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider names to show first. This will return all charge captures with one of the names in this list.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ChargeCapturePage]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/charge_captures/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "limit": limit,
                "sort": sort,
                "sort_direction": sort_direction,
                "page_token": page_token,
                "patient_external_id": patient_external_id,
                "status": status,
                "charge_external_id": charge_external_id,
                "date_of_service_min": str(date_of_service_min) if date_of_service_min is not None else None,
                "date_of_service_max": str(date_of_service_max) if date_of_service_max is not None else None,
                "claim_ids": claim_ids,
                "claim_creation_ids": claim_creation_ids,
                "billing_provider_npis": billing_provider_npis,
                "service_facility_name": service_facility_name,
                "primary_payer_ids": primary_payer_ids,
                "rendering_provider_npis": rendering_provider_npis,
                "rendering_provider_names": rendering_provider_names,
                "supervising_provider_npis": supervising_provider_npis,
                "supervising_provider_names": supervising_provider_names,
                "exclude_charges_linked_to_claims": exclude_charges_linked_to_claims,
                "patient_external_id_ranked_sort": patient_external_id_ranked_sort,
                "status_ranked_sort": status_ranked_sort,
                "charge_external_id_ranked_sort": charge_external_id_ranked_sort,
                "date_of_service_min_ranked_sort": str(date_of_service_min_ranked_sort)
                if date_of_service_min_ranked_sort is not None
                else None,
                "date_of_service_max_ranked_sort": str(date_of_service_max_ranked_sort)
                if date_of_service_max_ranked_sort is not None
                else None,
                "search_term": search_term,
                "billable_status": billable_status,
                "responsible_party": responsible_party,
                "claim_ids_ranked_sort": claim_ids_ranked_sort,
                "claim_creation_ids_ranked_sort": claim_creation_ids_ranked_sort,
                "billing_provider_npis_ranked_sort": billing_provider_npis_ranked_sort,
                "service_facility_name_ranked_sort": service_facility_name_ranked_sort,
                "primary_payer_ids_ranked_sort": primary_payer_ids_ranked_sort,
                "rendering_provider_npis_ranked_sort": rendering_provider_npis_ranked_sort,
                "rendering_provider_names_ranked_sort": rendering_provider_names_ranked_sort,
                "supervising_provider_npis_ranked_sort": supervising_provider_npis_ranked_sort,
                "supervising_provider_names_ranked_sort": supervising_provider_names_ranked_sort,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCapturePage,
                parse_obj_as(
                    type_=ChargeCapturePage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_post_billed_changes(
        self,
        *,
        charge_capture_change_ids: typing.Sequence[ChargeCapturePostBilledChangeId],
        resolved: bool,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ChargeCapturePostBilledChange]]:
        """
        Parameters
        ----------
        charge_capture_change_ids : typing.Sequence[ChargeCapturePostBilledChangeId]
            A list of UUIDs corresponding to ChargeCapturePostBilledChanges.
            All of the charges sent will be marked as resolved

        resolved : bool
            Whether the change has been resolved. If true, the change will be marked as resolved.
            If false, the change will be marked as unresolved.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ChargeCapturePostBilledChange]]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/charge_captures/v1/changes/",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json={
                "charge_capture_change_ids": charge_capture_change_ids,
                "resolved": resolved,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                typing.List[ChargeCapturePostBilledChange],
                parse_obj_as(
                    type_=typing.List[ChargeCapturePostBilledChange],  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create(
        self,
        *,
        data: ChargeCaptureData,
        charge_external_id: str,
        patient_external_id: str,
        status: ChargeCaptureStatus,
        originating_system: typing.Optional[str] = OMIT,
        claim_creation_category: typing.Optional[str] = OMIT,
        ehr_source_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ChargeCapture]:
        """
        Parameters
        ----------
        data : ChargeCaptureData
            Charge Capture data contains all the fields needed to create an encounter, but listed as optional. Candid will use this data when attempting to bundle multiple Charge Captures into a single encounter.

        charge_external_id : str
            A client-specified unique ID to associate with this encounter; for example, your internal encounter ID or a Dr. Chrono encounter ID. This field should not contain PHI.

        patient_external_id : str
            The patient ID from the external EMR platform for the patient

        status : ChargeCaptureStatus
            the status of the charge capture

        originating_system : typing.Optional[str]
            An optional string field denoting the originating system of the charge.

        claim_creation_category : typing.Optional[str]
            An optional string field denoting the user defined category of the claim creation.

        ehr_source_url : typing.Optional[str]
            External URL reference that links to Charge Capture details within the external system (e.g. the EHR visit page). Send full URL format for the external link (e.g. https://emr_charge_capture_url.com/123).

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ChargeCapture]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/charge_captures/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="POST",
            json={
                "data": data,
                "charge_external_id": charge_external_id,
                "originating_system": originating_system,
                "claim_creation_category": claim_creation_category,
                "ehr_source_url": ehr_source_url,
                "patient_external_id": patient_external_id,
                "status": status,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCapture,
                parse_obj_as(
                    type_=ChargeCapture,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "SchemaInstanceValidationHttpFailure":
                raise SchemaInstanceValidationHttpFailure(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        SchemaInstanceValidationFailure,
                        parse_obj_as(
                            type_=SchemaInstanceValidationFailure,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "ChargeExternalIdConflictError":
                raise ChargeExternalIdConflictError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        ChargeExternalIdConflictErrorMessage,
                        parse_obj_as(
                            type_=ChargeExternalIdConflictErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        charge_capture_id: ChargeCaptureId,
        *,
        data: typing.Optional[ChargeCaptureData] = OMIT,
        charge_external_id: typing.Optional[str] = OMIT,
        ehr_source_url: typing.Optional[str] = OMIT,
        originating_system: typing.Optional[str] = OMIT,
        claim_creation_category: typing.Optional[str] = OMIT,
        patient_external_id: typing.Optional[str] = OMIT,
        status: typing.Optional[ChargeCaptureStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ChargeCapture]:
        """
        Parameters
        ----------
        charge_capture_id : ChargeCaptureId

        data : typing.Optional[ChargeCaptureData]

        charge_external_id : typing.Optional[str]
            A client-specified unique ID to associate with this encounter;
            for example, your internal encounter ID or a Dr. Chrono encounter ID.
            This field should not contain PHI.

        ehr_source_url : typing.Optional[str]
            External URL reference that links to Charge Capture details within the external system (e.g. the EHR visit page).
            Send full URL format for the external link (e.g. https://emr_charge_capture_url.com/123).

        originating_system : typing.Optional[str]
            An optional string field denoting the originating system of the charge.

        claim_creation_category : typing.Optional[str]
            An optional string field denoting the user defined category of the claim creation.

        patient_external_id : typing.Optional[str]
            The patient ID from the external EMR platform for the patient

        status : typing.Optional[ChargeCaptureStatus]
            the status of the charge capture

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ChargeCapture]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/charge_captures/v1/{jsonable_encoder(charge_capture_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json={
                "data": data,
                "charge_external_id": charge_external_id,
                "ehr_source_url": ehr_source_url,
                "originating_system": originating_system,
                "claim_creation_category": claim_creation_category,
                "patient_external_id": patient_external_id,
                "status": status,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCapture,
                parse_obj_as(
                    type_=ChargeCapture,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "HttpRequestValidationsError":
                raise HttpRequestValidationsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.List[RequestValidationError],
                        parse_obj_as(
                            type_=typing.List[RequestValidationError],  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "SchemaInstanceValidationHttpFailure":
                raise SchemaInstanceValidationHttpFailure(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        SchemaInstanceValidationFailure,
                        parse_obj_as(
                            type_=SchemaInstanceValidationFailure,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnprocessableEntityError":
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnprocessableEntityErrorMessage,
                        parse_obj_as(
                            type_=UnprocessableEntityErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get(
        self, charge_capture_id: ChargeCaptureId, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ChargeCapture]:
        """
        Parameters
        ----------
        charge_capture_id : ChargeCaptureId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ChargeCapture]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/charge_captures/v1/{jsonable_encoder(charge_capture_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCapture,
                parse_obj_as(
                    type_=ChargeCapture,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_all(
        self,
        *,
        limit: typing.Optional[int] = None,
        sort: typing.Optional[ChargeCaptureSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        patient_external_id: typing.Optional[str] = None,
        status: typing.Optional[ChargeCaptureStatus] = None,
        charge_external_id: typing.Optional[str] = None,
        date_of_service_min: typing.Optional[dt.date] = None,
        date_of_service_max: typing.Optional[dt.date] = None,
        claim_ids: typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]] = None,
        claim_creation_ids: typing.Optional[
            typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]
        ] = None,
        billing_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        service_facility_name: typing.Optional[str] = None,
        primary_payer_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        exclude_charges_linked_to_claims: typing.Optional[bool] = None,
        patient_external_id_ranked_sort: typing.Optional[str] = None,
        status_ranked_sort: typing.Optional[ChargeCaptureStatus] = None,
        charge_external_id_ranked_sort: typing.Optional[str] = None,
        date_of_service_min_ranked_sort: typing.Optional[dt.date] = None,
        date_of_service_max_ranked_sort: typing.Optional[dt.date] = None,
        search_term: typing.Optional[str] = None,
        billable_status: typing.Optional[BillableStatusType] = None,
        responsible_party: typing.Optional[ResponsiblePartyType] = None,
        claim_ids_ranked_sort: typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]] = None,
        claim_creation_ids_ranked_sort: typing.Optional[
            typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]
        ] = None,
        billing_provider_npis_ranked_sort: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        service_facility_name_ranked_sort: typing.Optional[str] = None,
        primary_payer_ids_ranked_sort: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_npis_ranked_sort: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_names_ranked_sort: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_npis_ranked_sort: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_names_ranked_sort: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ChargeCapturePage]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Maximum number of entities per page, defaults to 100.

        sort : typing.Optional[ChargeCaptureSortField]
            Defaults to created_at

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        patient_external_id : typing.Optional[str]
            The patient ID from the external EMR platform for the patient

        status : typing.Optional[ChargeCaptureStatus]
            the status of the charge captures

        charge_external_id : typing.Optional[str]
            A client-specified unique ID to associate with this encounter;
            for example, your internal encounter ID or a Dr. Chrono encounter ID.
            This field should not contain PHI.

        date_of_service_min : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        date_of_service_max : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        claim_ids : typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]]
            A list of claim IDs to filter by. This will return all charge captures that have a resulting claim with one of the IDs in this list.

        claim_creation_ids : typing.Optional[typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]]
            A list of Claim Creation IDs to filter by.

        billing_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of billing provider NPIs to filter by. This will return all charge captures with one of the NPIs in this list.

        service_facility_name : typing.Optional[str]
            A string to filter by. This will return all charge captures with this service facility name.

        primary_payer_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of primary payer IDs to filter by. This will return all charge captures with one of the primary payer IDs in this list.

        rendering_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider NPIs to filter by. This will return all charge captures with one of the NPIs in this list.

        rendering_provider_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider names to filter by. This will return all charge captures with one of the names in this list.

        supervising_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider NPIs to filter by. This will return all charge captures with one of the NPIs in this list.

        supervising_provider_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider names to filter by. This will return all charge captures with one of the names in this list.

        exclude_charges_linked_to_claims : typing.Optional[bool]
            Whether to exclude charge captures which are part of a claim creation.

        patient_external_id_ranked_sort : typing.Optional[str]
            The patient ID from the external EMR platform for the patient

        status_ranked_sort : typing.Optional[ChargeCaptureStatus]
            The charge capture status to show first

        charge_external_id_ranked_sort : typing.Optional[str]
            A client-specified unique ID to associate with this encounter;
            for example, your internal encounter ID or a Dr. Chrono encounter ID.
            This field should not contain PHI.

        date_of_service_min_ranked_sort : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        date_of_service_max_ranked_sort : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        search_term : typing.Optional[str]
            Filter by any of the following fields: charge_id, claim_id, patient external_id,
            patient date of birth, patient first name, patient last name,
            or charge external id.

        billable_status : typing.Optional[BillableStatusType]
            Defines if the Encounter is to be billed by Candid to the responsible_party. Examples for when this should be set to NOT_BILLABLE include if the Encounter has not occurred yet or if there is no intention of ever billing the responsible_party.

        responsible_party : typing.Optional[ResponsiblePartyType]
            Defines the party to be billed with the initial balance owed on the claim. Use SELF_PAY if you intend to bill self pay/cash pay.

        claim_ids_ranked_sort : typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]]
            A list of claim IDs to show first. This will return all charge captures that have a resulting claim with one of the IDs in this list.

        claim_creation_ids_ranked_sort : typing.Optional[typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]]
            A list of Claim Creation IDs to show first.

        billing_provider_npis_ranked_sort : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of billing provider NPIs to show first. This will return all charge captures with one of the NPIs in this list.

        service_facility_name_ranked_sort : typing.Optional[str]
            A string to show first. This will return all charge captures with this service facility name.

        primary_payer_ids_ranked_sort : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of primary payer IDs to show first. This will return all charge captures with one of the primary payer IDs in this list.

        rendering_provider_npis_ranked_sort : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider NPIs to show first. This will return all charge captures with one of the NPIs in this list.

        rendering_provider_names_ranked_sort : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider names to show first. This will return all charge captures with one of the names in this list.

        supervising_provider_npis_ranked_sort : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider NPIs to show first. This will return all charge captures with one of the NPIs in this list.

        supervising_provider_names_ranked_sort : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider names to show first. This will return all charge captures with one of the names in this list.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ChargeCapturePage]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/charge_captures/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "limit": limit,
                "sort": sort,
                "sort_direction": sort_direction,
                "page_token": page_token,
                "patient_external_id": patient_external_id,
                "status": status,
                "charge_external_id": charge_external_id,
                "date_of_service_min": str(date_of_service_min) if date_of_service_min is not None else None,
                "date_of_service_max": str(date_of_service_max) if date_of_service_max is not None else None,
                "claim_ids": claim_ids,
                "claim_creation_ids": claim_creation_ids,
                "billing_provider_npis": billing_provider_npis,
                "service_facility_name": service_facility_name,
                "primary_payer_ids": primary_payer_ids,
                "rendering_provider_npis": rendering_provider_npis,
                "rendering_provider_names": rendering_provider_names,
                "supervising_provider_npis": supervising_provider_npis,
                "supervising_provider_names": supervising_provider_names,
                "exclude_charges_linked_to_claims": exclude_charges_linked_to_claims,
                "patient_external_id_ranked_sort": patient_external_id_ranked_sort,
                "status_ranked_sort": status_ranked_sort,
                "charge_external_id_ranked_sort": charge_external_id_ranked_sort,
                "date_of_service_min_ranked_sort": str(date_of_service_min_ranked_sort)
                if date_of_service_min_ranked_sort is not None
                else None,
                "date_of_service_max_ranked_sort": str(date_of_service_max_ranked_sort)
                if date_of_service_max_ranked_sort is not None
                else None,
                "search_term": search_term,
                "billable_status": billable_status,
                "responsible_party": responsible_party,
                "claim_ids_ranked_sort": claim_ids_ranked_sort,
                "claim_creation_ids_ranked_sort": claim_creation_ids_ranked_sort,
                "billing_provider_npis_ranked_sort": billing_provider_npis_ranked_sort,
                "service_facility_name_ranked_sort": service_facility_name_ranked_sort,
                "primary_payer_ids_ranked_sort": primary_payer_ids_ranked_sort,
                "rendering_provider_npis_ranked_sort": rendering_provider_npis_ranked_sort,
                "rendering_provider_names_ranked_sort": rendering_provider_names_ranked_sort,
                "supervising_provider_npis_ranked_sort": supervising_provider_npis_ranked_sort,
                "supervising_provider_names_ranked_sort": supervising_provider_names_ranked_sort,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCapturePage,
                parse_obj_as(
                    type_=ChargeCapturePage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_post_billed_changes(
        self,
        *,
        charge_capture_change_ids: typing.Sequence[ChargeCapturePostBilledChangeId],
        resolved: bool,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ChargeCapturePostBilledChange]]:
        """
        Parameters
        ----------
        charge_capture_change_ids : typing.Sequence[ChargeCapturePostBilledChangeId]
            A list of UUIDs corresponding to ChargeCapturePostBilledChanges.
            All of the charges sent will be marked as resolved

        resolved : bool
            Whether the change has been resolved. If true, the change will be marked as resolved.
            If false, the change will be marked as unresolved.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ChargeCapturePostBilledChange]]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/charge_captures/v1/changes/",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json={
                "charge_capture_change_ids": charge_capture_change_ids,
                "resolved": resolved,
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                typing.List[ChargeCapturePostBilledChange],
                parse_obj_as(
                    type_=typing.List[ChargeCapturePostBilledChange],  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
