# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.charge_capture_claim_creation_id import ChargeCaptureClaimCreationId
from .....commons.types.charge_capture_id import ChargeCaptureId
from .....commons.types.patient_external_id import PatientExternalId
from .charge_capture_data import ChargeCaptureData
from .charge_capture_error import ChargeCaptureError
from .charge_capture_post_billed_change import ChargeCapturePostBilledChange
from .charge_capture_status import ChargeCaptureStatus


class ChargeCapture(UniversalBaseModel):
    id: ChargeCaptureId
    status: ChargeCaptureStatus
    charge_capture_data: ChargeCaptureData
    date_of_service: typing.Optional[dt.date] = None
    patient_external_id: PatientExternalId
    charge_external_id: str
    ehr_source_url: typing.Optional[str] = None
    originating_system: typing.Optional[str] = None
    claim_creation_category: typing.Optional[str] = None
    error: typing.Optional[ChargeCaptureError] = None
    updates: typing.List[ChargeCapturePostBilledChange]
    claim_creation_id: typing.Optional[ChargeCaptureClaimCreationId] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
