# This file was auto-generated by Fern from our API Definition.

import typing
import uuid

import pydantic
from ......core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .....commons.types.charge_capture_claim_creation_id import ChargeCaptureClaimCreationId
from .....commons.types.charge_capture_id import ChargeCaptureId


class ChargeCaptureError(UniversalBaseModel):
    id: uuid.UUID
    charge_capture_id: typing.Optional[ChargeCaptureId] = pydantic.Field(default=None)
    """
    The underlying Charge Capture that this error object references.
    The Charge Capture referenced will be a part of the Claim Creation tied to this error.
    Errors may also refer to all charge_captures present in a Claim Creation, in which case this field will be null.
    """

    message: str = pydantic.Field()
    """
    A human readable error explaining why this charge capture Claim Creation failed to create a claim.
    """

    resolved: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the error has been resolved as part of user workflows
    """

    resolved_by: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string denoting who resolved the error within candid's system.
    """

    resolution_reason: typing.Optional[str] = pydantic.Field(default=None)
    """
    A string denoting how or why an error was resolved.
    """

    field_in_error: typing.Optional[str] = pydantic.Field(default=None)
    """
    The field of the corresponding underlying ChargeCapture that has a field that is failing validations,
    is not present but marked as required, or otherwise in error.
    """

    claim_creation_id: ChargeCaptureClaimCreationId = pydantic.Field()
    """
    The ID of the ChargeCaptureClaimCreation associated with this Error.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
