# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
import uuid

from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.request_options import RequestOptions
from ....charge_capture.resources.v_1.types.charge_capture_status import ChargeCaptureStatus
from ....commons.types.charge_capture_claim_creation_id import ChargeCaptureClaimCreationId
from ....commons.types.encounter_id import EncounterId
from ....commons.types.page_token import PageToken
from ....commons.types.sort_direction import SortDirection
from .raw_client import AsyncRawV1Client, RawV1Client
from .types.charge_capture_claim_creation import ChargeCaptureClaimCreation
from .types.charge_capture_claim_creation_page import ChargeCaptureClaimCreationPage
from .types.charge_capture_claim_creation_sort_field import ChargeCaptureClaimCreationSortField
from .types.charge_capture_claim_creation_status import ChargeCaptureClaimCreationStatus
from .types.charge_capture_claim_creation_summary import ChargeCaptureClaimCreationSummary

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class V1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawV1Client
        """
        return self._raw_client

    def get(
        self,
        charge_capture_claim_creation_id: ChargeCaptureClaimCreationId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ChargeCaptureClaimCreation:
        """
        Parameters
        ----------
        charge_capture_claim_creation_id : ChargeCaptureClaimCreationId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChargeCaptureClaimCreation

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.charge_capture_bundles.v_1.get(
            charge_capture_claim_creation_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.get(charge_capture_claim_creation_id, request_options=request_options)
        return _response.data

    def get_summary(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ChargeCaptureClaimCreationSummary:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChargeCaptureClaimCreationSummary

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.charge_capture_bundles.v_1.get_summary()
        """
        _response = self._raw_client.get_summary(request_options=request_options)
        return _response.data

    def resolve_charge_creation_error(
        self,
        charge_capture_bundle_error_id: uuid.UUID,
        *,
        resolved_by: typing.Optional[str] = OMIT,
        resolution_reason: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        charge_capture_bundle_error_id : uuid.UUID

        resolved_by : typing.Optional[str]
            A string, denoting who resolved the error for audit trail purposes.

        resolution_reason : typing.Optional[str]
            A string denoting why or how the error was dealt with for audit trail purposes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import uuid

        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.charge_capture_bundles.v_1.resolve_charge_creation_error(
            charge_capture_bundle_error_id=uuid.UUID(
                "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
            ),
        )
        """
        _response = self._raw_client.resolve_charge_creation_error(
            charge_capture_bundle_error_id,
            resolved_by=resolved_by,
            resolution_reason=resolution_reason,
            request_options=request_options,
        )
        return _response.data

    def get_all(
        self,
        *,
        limit: typing.Optional[int] = None,
        sort: typing.Optional[ChargeCaptureClaimCreationSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        patient_external_id: typing.Optional[str] = None,
        claim_creation_status: typing.Optional[ChargeCaptureClaimCreationStatus] = None,
        charge_status: typing.Optional[ChargeCaptureStatus] = None,
        charge_external_id: typing.Optional[str] = None,
        date_of_service_min: typing.Optional[dt.date] = None,
        date_of_service_max: typing.Optional[dt.date] = None,
        claim_ids: typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]] = None,
        claim_creation_ids: typing.Optional[
            typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]
        ] = None,
        billing_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        service_facility_name: typing.Optional[str] = None,
        primary_payer_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        has_charge_capture_updates: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ChargeCaptureClaimCreationPage:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Maximum number of entities per page, defaults to 100.

        sort : typing.Optional[ChargeCaptureClaimCreationSortField]
            Defaults to created_at

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        patient_external_id : typing.Optional[str]
            The patient ID from the external EMR platform for the patient

        claim_creation_status : typing.Optional[ChargeCaptureClaimCreationStatus]
            the status of the charge capture Claim Creation, refers to whether it was able to create a claim.

        charge_status : typing.Optional[ChargeCaptureStatus]
            the status of the charge captures

        charge_external_id : typing.Optional[str]
            A client-specified unique ID to associate with this encounter;
            for example, your internal encounter ID or a Dr. Chrono encounter ID.
            This field should not contain PHI.

        date_of_service_min : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        date_of_service_max : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        claim_ids : typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]]
            A list of claim IDs to filter by. This will return all charge capture claim_creations that have a resulting claim with one of the IDs in this list.

        claim_creation_ids : typing.Optional[typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]]
            A list of Claim Creation IDs to filter by.

        billing_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of billing provider NPIs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the NPIs in this list.

        service_facility_name : typing.Optional[str]
            A string to filter by. This will return all charge capture claim_creations which include one or more charges with this service facility name.

        primary_payer_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of primary payer IDs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the primary payer IDs in this list.

        rendering_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider NPIs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the NPIs in this list.

        rendering_provider_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider names to filter by. This will return all charge capture claim_creations which include one or more charges with one of the names in this list.

        supervising_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider NPIs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the NPIs in this list.

        supervising_provider_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider names to filter by. This will return all charge capture claim_creations which include one or more charges with one of the names in this list.

        has_charge_capture_updates : typing.Optional[bool]
            If true, only return claim_creations that have charge captures that have been updated since the Claim Creation has had a status of BILLED. See the updates property on ChargeCapture for more details.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChargeCaptureClaimCreationPage

        Examples
        --------
        from candid import CandidApiClient

        client = CandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )
        client.charge_capture_bundles.v_1.get_all()
        """
        _response = self._raw_client.get_all(
            limit=limit,
            sort=sort,
            sort_direction=sort_direction,
            page_token=page_token,
            patient_external_id=patient_external_id,
            claim_creation_status=claim_creation_status,
            charge_status=charge_status,
            charge_external_id=charge_external_id,
            date_of_service_min=date_of_service_min,
            date_of_service_max=date_of_service_max,
            claim_ids=claim_ids,
            claim_creation_ids=claim_creation_ids,
            billing_provider_npis=billing_provider_npis,
            service_facility_name=service_facility_name,
            primary_payer_ids=primary_payer_ids,
            rendering_provider_npis=rendering_provider_npis,
            rendering_provider_names=rendering_provider_names,
            supervising_provider_npis=supervising_provider_npis,
            supervising_provider_names=supervising_provider_names,
            has_charge_capture_updates=has_charge_capture_updates,
            request_options=request_options,
        )
        return _response.data


class AsyncV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawV1Client(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawV1Client:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawV1Client
        """
        return self._raw_client

    async def get(
        self,
        charge_capture_claim_creation_id: ChargeCaptureClaimCreationId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ChargeCaptureClaimCreation:
        """
        Parameters
        ----------
        charge_capture_claim_creation_id : ChargeCaptureClaimCreationId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChargeCaptureClaimCreation

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.charge_capture_bundles.v_1.get(
                charge_capture_claim_creation_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(charge_capture_claim_creation_id, request_options=request_options)
        return _response.data

    async def get_summary(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ChargeCaptureClaimCreationSummary:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChargeCaptureClaimCreationSummary

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.charge_capture_bundles.v_1.get_summary()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_summary(request_options=request_options)
        return _response.data

    async def resolve_charge_creation_error(
        self,
        charge_capture_bundle_error_id: uuid.UUID,
        *,
        resolved_by: typing.Optional[str] = OMIT,
        resolution_reason: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Parameters
        ----------
        charge_capture_bundle_error_id : uuid.UUID

        resolved_by : typing.Optional[str]
            A string, denoting who resolved the error for audit trail purposes.

        resolution_reason : typing.Optional[str]
            A string denoting why or how the error was dealt with for audit trail purposes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio
        import uuid

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.charge_capture_bundles.v_1.resolve_charge_creation_error(
                charge_capture_bundle_error_id=uuid.UUID(
                    "d5e9c84f-c2b2-4bf4-b4b0-7ffd7a9ffc32",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.resolve_charge_creation_error(
            charge_capture_bundle_error_id,
            resolved_by=resolved_by,
            resolution_reason=resolution_reason,
            request_options=request_options,
        )
        return _response.data

    async def get_all(
        self,
        *,
        limit: typing.Optional[int] = None,
        sort: typing.Optional[ChargeCaptureClaimCreationSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        patient_external_id: typing.Optional[str] = None,
        claim_creation_status: typing.Optional[ChargeCaptureClaimCreationStatus] = None,
        charge_status: typing.Optional[ChargeCaptureStatus] = None,
        charge_external_id: typing.Optional[str] = None,
        date_of_service_min: typing.Optional[dt.date] = None,
        date_of_service_max: typing.Optional[dt.date] = None,
        claim_ids: typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]] = None,
        claim_creation_ids: typing.Optional[
            typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]
        ] = None,
        billing_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        service_facility_name: typing.Optional[str] = None,
        primary_payer_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        has_charge_capture_updates: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ChargeCaptureClaimCreationPage:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Maximum number of entities per page, defaults to 100.

        sort : typing.Optional[ChargeCaptureClaimCreationSortField]
            Defaults to created_at

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        patient_external_id : typing.Optional[str]
            The patient ID from the external EMR platform for the patient

        claim_creation_status : typing.Optional[ChargeCaptureClaimCreationStatus]
            the status of the charge capture Claim Creation, refers to whether it was able to create a claim.

        charge_status : typing.Optional[ChargeCaptureStatus]
            the status of the charge captures

        charge_external_id : typing.Optional[str]
            A client-specified unique ID to associate with this encounter;
            for example, your internal encounter ID or a Dr. Chrono encounter ID.
            This field should not contain PHI.

        date_of_service_min : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        date_of_service_max : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        claim_ids : typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]]
            A list of claim IDs to filter by. This will return all charge capture claim_creations that have a resulting claim with one of the IDs in this list.

        claim_creation_ids : typing.Optional[typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]]
            A list of Claim Creation IDs to filter by.

        billing_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of billing provider NPIs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the NPIs in this list.

        service_facility_name : typing.Optional[str]
            A string to filter by. This will return all charge capture claim_creations which include one or more charges with this service facility name.

        primary_payer_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of primary payer IDs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the primary payer IDs in this list.

        rendering_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider NPIs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the NPIs in this list.

        rendering_provider_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider names to filter by. This will return all charge capture claim_creations which include one or more charges with one of the names in this list.

        supervising_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider NPIs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the NPIs in this list.

        supervising_provider_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider names to filter by. This will return all charge capture claim_creations which include one or more charges with one of the names in this list.

        has_charge_capture_updates : typing.Optional[bool]
            If true, only return claim_creations that have charge captures that have been updated since the Claim Creation has had a status of BILLED. See the updates property on ChargeCapture for more details.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChargeCaptureClaimCreationPage

        Examples
        --------
        import asyncio

        from candid import AsyncCandidApiClient

        client = AsyncCandidApiClient(
            client_id="YOUR_CLIENT_ID",
            client_secret="YOUR_CLIENT_SECRET",
        )


        async def main() -> None:
            await client.charge_capture_bundles.v_1.get_all()


        asyncio.run(main())
        """
        _response = await self._raw_client.get_all(
            limit=limit,
            sort=sort,
            sort_direction=sort_direction,
            page_token=page_token,
            patient_external_id=patient_external_id,
            claim_creation_status=claim_creation_status,
            charge_status=charge_status,
            charge_external_id=charge_external_id,
            date_of_service_min=date_of_service_min,
            date_of_service_max=date_of_service_max,
            claim_ids=claim_ids,
            claim_creation_ids=claim_creation_ids,
            billing_provider_npis=billing_provider_npis,
            service_facility_name=service_facility_name,
            primary_payer_ids=primary_payer_ids,
            rendering_provider_npis=rendering_provider_npis,
            rendering_provider_names=rendering_provider_names,
            supervising_provider_npis=supervising_provider_npis,
            supervising_provider_names=supervising_provider_names,
            has_charge_capture_updates=has_charge_capture_updates,
            request_options=request_options,
        )
        return _response.data
