# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
import uuid
from json.decoder import JSONDecodeError

from .....core.api_error import ApiError
from .....core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .....core.http_response import AsyncHttpResponse, HttpResponse
from .....core.jsonable_encoder import jsonable_encoder
from .....core.pydantic_utilities import parse_obj_as
from .....core.request_options import RequestOptions
from ....charge_capture.resources.v_1.types.charge_capture_status import ChargeCaptureStatus
from ....commons.errors.entity_not_found_error import EntityNotFoundError
from ....commons.errors.unauthorized_error import UnauthorizedError
from ....commons.types.charge_capture_claim_creation_id import ChargeCaptureClaimCreationId
from ....commons.types.encounter_id import EncounterId
from ....commons.types.entity_not_found_error_message import EntityNotFoundErrorMessage
from ....commons.types.page_token import PageToken
from ....commons.types.sort_direction import SortDirection
from ....commons.types.unauthorized_error_message import UnauthorizedErrorMessage
from .types.charge_capture_claim_creation import ChargeCaptureClaimCreation
from .types.charge_capture_claim_creation_page import ChargeCaptureClaimCreationPage
from .types.charge_capture_claim_creation_sort_field import ChargeCaptureClaimCreationSortField
from .types.charge_capture_claim_creation_status import ChargeCaptureClaimCreationStatus
from .types.charge_capture_claim_creation_summary import ChargeCaptureClaimCreationSummary

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawV1Client:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get(
        self,
        charge_capture_claim_creation_id: ChargeCaptureClaimCreationId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ChargeCaptureClaimCreation]:
        """
        Parameters
        ----------
        charge_capture_claim_creation_id : ChargeCaptureClaimCreationId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ChargeCaptureClaimCreation]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/charge_capture_claim_creation/v1/{jsonable_encoder(charge_capture_claim_creation_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCaptureClaimCreation,
                parse_obj_as(
                    type_=ChargeCaptureClaimCreation,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_summary(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ChargeCaptureClaimCreationSummary]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ChargeCaptureClaimCreationSummary]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/charge_capture_claim_creation/v1/all/summary",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCaptureClaimCreationSummary,
                parse_obj_as(
                    type_=ChargeCaptureClaimCreationSummary,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def resolve_charge_creation_error(
        self,
        charge_capture_bundle_error_id: uuid.UUID,
        *,
        resolved_by: typing.Optional[str] = OMIT,
        resolution_reason: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[None]:
        """
        Parameters
        ----------
        charge_capture_bundle_error_id : uuid.UUID

        resolved_by : typing.Optional[str]
            A string, denoting who resolved the error for audit trail purposes.

        resolution_reason : typing.Optional[str]
            A string denoting why or how the error was dealt with for audit trail purposes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"api/charge_capture_claim_creation/v1/error/{jsonable_encoder(charge_capture_bundle_error_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json={
                "resolved_by": resolved_by,
                "resolution_reason": resolution_reason,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return HttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_all(
        self,
        *,
        limit: typing.Optional[int] = None,
        sort: typing.Optional[ChargeCaptureClaimCreationSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        patient_external_id: typing.Optional[str] = None,
        claim_creation_status: typing.Optional[ChargeCaptureClaimCreationStatus] = None,
        charge_status: typing.Optional[ChargeCaptureStatus] = None,
        charge_external_id: typing.Optional[str] = None,
        date_of_service_min: typing.Optional[dt.date] = None,
        date_of_service_max: typing.Optional[dt.date] = None,
        claim_ids: typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]] = None,
        claim_creation_ids: typing.Optional[
            typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]
        ] = None,
        billing_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        service_facility_name: typing.Optional[str] = None,
        primary_payer_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        has_charge_capture_updates: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ChargeCaptureClaimCreationPage]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Maximum number of entities per page, defaults to 100.

        sort : typing.Optional[ChargeCaptureClaimCreationSortField]
            Defaults to created_at

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        patient_external_id : typing.Optional[str]
            The patient ID from the external EMR platform for the patient

        claim_creation_status : typing.Optional[ChargeCaptureClaimCreationStatus]
            the status of the charge capture Claim Creation, refers to whether it was able to create a claim.

        charge_status : typing.Optional[ChargeCaptureStatus]
            the status of the charge captures

        charge_external_id : typing.Optional[str]
            A client-specified unique ID to associate with this encounter;
            for example, your internal encounter ID or a Dr. Chrono encounter ID.
            This field should not contain PHI.

        date_of_service_min : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        date_of_service_max : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        claim_ids : typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]]
            A list of claim IDs to filter by. This will return all charge capture claim_creations that have a resulting claim with one of the IDs in this list.

        claim_creation_ids : typing.Optional[typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]]
            A list of Claim Creation IDs to filter by.

        billing_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of billing provider NPIs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the NPIs in this list.

        service_facility_name : typing.Optional[str]
            A string to filter by. This will return all charge capture claim_creations which include one or more charges with this service facility name.

        primary_payer_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of primary payer IDs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the primary payer IDs in this list.

        rendering_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider NPIs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the NPIs in this list.

        rendering_provider_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider names to filter by. This will return all charge capture claim_creations which include one or more charges with one of the names in this list.

        supervising_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider NPIs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the NPIs in this list.

        supervising_provider_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider names to filter by. This will return all charge capture claim_creations which include one or more charges with one of the names in this list.

        has_charge_capture_updates : typing.Optional[bool]
            If true, only return claim_creations that have charge captures that have been updated since the Claim Creation has had a status of BILLED. See the updates property on ChargeCapture for more details.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ChargeCaptureClaimCreationPage]
        """
        _response = self._client_wrapper.httpx_client.request(
            "api/charge_capture_claim_creation/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "limit": limit,
                "sort": sort,
                "sort_direction": sort_direction,
                "page_token": page_token,
                "patient_external_id": patient_external_id,
                "claim_creation_status": claim_creation_status,
                "charge_status": charge_status,
                "charge_external_id": charge_external_id,
                "date_of_service_min": str(date_of_service_min) if date_of_service_min is not None else None,
                "date_of_service_max": str(date_of_service_max) if date_of_service_max is not None else None,
                "claim_ids": claim_ids,
                "claim_creation_ids": claim_creation_ids,
                "billing_provider_npis": billing_provider_npis,
                "service_facility_name": service_facility_name,
                "primary_payer_ids": primary_payer_ids,
                "rendering_provider_npis": rendering_provider_npis,
                "rendering_provider_names": rendering_provider_names,
                "supervising_provider_npis": supervising_provider_npis,
                "supervising_provider_names": supervising_provider_names,
                "has_charge_capture_updates": has_charge_capture_updates,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCaptureClaimCreationPage,
                parse_obj_as(
                    type_=ChargeCaptureClaimCreationPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return HttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawV1Client:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get(
        self,
        charge_capture_claim_creation_id: ChargeCaptureClaimCreationId,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ChargeCaptureClaimCreation]:
        """
        Parameters
        ----------
        charge_capture_claim_creation_id : ChargeCaptureClaimCreationId

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ChargeCaptureClaimCreation]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/charge_capture_claim_creation/v1/{jsonable_encoder(charge_capture_claim_creation_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCaptureClaimCreation,
                parse_obj_as(
                    type_=ChargeCaptureClaimCreation,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_summary(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ChargeCaptureClaimCreationSummary]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ChargeCaptureClaimCreationSummary]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/charge_capture_claim_creation/v1/all/summary",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCaptureClaimCreationSummary,
                parse_obj_as(
                    type_=ChargeCaptureClaimCreationSummary,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def resolve_charge_creation_error(
        self,
        charge_capture_bundle_error_id: uuid.UUID,
        *,
        resolved_by: typing.Optional[str] = OMIT,
        resolution_reason: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[None]:
        """
        Parameters
        ----------
        charge_capture_bundle_error_id : uuid.UUID

        resolved_by : typing.Optional[str]
            A string, denoting who resolved the error for audit trail purposes.

        resolution_reason : typing.Optional[str]
            A string denoting why or how the error was dealt with for audit trail purposes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"api/charge_capture_claim_creation/v1/error/{jsonable_encoder(charge_capture_bundle_error_id)}",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="PATCH",
            json={
                "resolved_by": resolved_by,
                "resolution_reason": resolution_reason,
            },
            request_options=request_options,
            omit=OMIT,
        )
        if 200 <= _response.status_code < 300:
            return AsyncHttpResponse(response=_response, data=None)
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if "errorName" in _response_json:
            if _response_json["errorName"] == "EntityNotFoundError":
                raise EntityNotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        EntityNotFoundErrorMessage,
                        parse_obj_as(
                            type_=EntityNotFoundErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
            if _response_json["errorName"] == "UnauthorizedError":
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        UnauthorizedErrorMessage,
                        parse_obj_as(
                            type_=UnauthorizedErrorMessage,  # type: ignore
                            object_=_response_json["content"],
                        ),
                    ),
                )
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_all(
        self,
        *,
        limit: typing.Optional[int] = None,
        sort: typing.Optional[ChargeCaptureClaimCreationSortField] = None,
        sort_direction: typing.Optional[SortDirection] = None,
        page_token: typing.Optional[PageToken] = None,
        patient_external_id: typing.Optional[str] = None,
        claim_creation_status: typing.Optional[ChargeCaptureClaimCreationStatus] = None,
        charge_status: typing.Optional[ChargeCaptureStatus] = None,
        charge_external_id: typing.Optional[str] = None,
        date_of_service_min: typing.Optional[dt.date] = None,
        date_of_service_max: typing.Optional[dt.date] = None,
        claim_ids: typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]] = None,
        claim_creation_ids: typing.Optional[
            typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]
        ] = None,
        billing_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        service_facility_name: typing.Optional[str] = None,
        primary_payer_ids: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        rendering_provider_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_npis: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        supervising_provider_names: typing.Optional[typing.Union[str, typing.Sequence[str]]] = None,
        has_charge_capture_updates: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ChargeCaptureClaimCreationPage]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]
            Maximum number of entities per page, defaults to 100.

        sort : typing.Optional[ChargeCaptureClaimCreationSortField]
            Defaults to created_at

        sort_direction : typing.Optional[SortDirection]
            Sort direction. Defaults to descending order if not provided.

        page_token : typing.Optional[PageToken]

        patient_external_id : typing.Optional[str]
            The patient ID from the external EMR platform for the patient

        claim_creation_status : typing.Optional[ChargeCaptureClaimCreationStatus]
            the status of the charge capture Claim Creation, refers to whether it was able to create a claim.

        charge_status : typing.Optional[ChargeCaptureStatus]
            the status of the charge captures

        charge_external_id : typing.Optional[str]
            A client-specified unique ID to associate with this encounter;
            for example, your internal encounter ID or a Dr. Chrono encounter ID.
            This field should not contain PHI.

        date_of_service_min : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        date_of_service_max : typing.Optional[dt.date]
            Date formatted as YYYY-MM-DD; eg: 2019-08-24.
            This date must be the local date in the timezone where the service occurred.

        claim_ids : typing.Optional[typing.Union[EncounterId, typing.Sequence[EncounterId]]]
            A list of claim IDs to filter by. This will return all charge capture claim_creations that have a resulting claim with one of the IDs in this list.

        claim_creation_ids : typing.Optional[typing.Union[ChargeCaptureClaimCreationId, typing.Sequence[ChargeCaptureClaimCreationId]]]
            A list of Claim Creation IDs to filter by.

        billing_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of billing provider NPIs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the NPIs in this list.

        service_facility_name : typing.Optional[str]
            A string to filter by. This will return all charge capture claim_creations which include one or more charges with this service facility name.

        primary_payer_ids : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of primary payer IDs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the primary payer IDs in this list.

        rendering_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider NPIs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the NPIs in this list.

        rendering_provider_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of rendering provider names to filter by. This will return all charge capture claim_creations which include one or more charges with one of the names in this list.

        supervising_provider_npis : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider NPIs to filter by. This will return all charge capture claim_creations which include one or more charges with one of the NPIs in this list.

        supervising_provider_names : typing.Optional[typing.Union[str, typing.Sequence[str]]]
            A list of supervising provider names to filter by. This will return all charge capture claim_creations which include one or more charges with one of the names in this list.

        has_charge_capture_updates : typing.Optional[bool]
            If true, only return claim_creations that have charge captures that have been updated since the Claim Creation has had a status of BILLED. See the updates property on ChargeCapture for more details.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ChargeCaptureClaimCreationPage]
        """
        _response = await self._client_wrapper.httpx_client.request(
            "api/charge_capture_claim_creation/v1",
            base_url=self._client_wrapper.get_environment().candid_api,
            method="GET",
            params={
                "limit": limit,
                "sort": sort,
                "sort_direction": sort_direction,
                "page_token": page_token,
                "patient_external_id": patient_external_id,
                "claim_creation_status": claim_creation_status,
                "charge_status": charge_status,
                "charge_external_id": charge_external_id,
                "date_of_service_min": str(date_of_service_min) if date_of_service_min is not None else None,
                "date_of_service_max": str(date_of_service_max) if date_of_service_max is not None else None,
                "claim_ids": claim_ids,
                "claim_creation_ids": claim_creation_ids,
                "billing_provider_npis": billing_provider_npis,
                "service_facility_name": service_facility_name,
                "primary_payer_ids": primary_payer_ids,
                "rendering_provider_npis": rendering_provider_npis,
                "rendering_provider_names": rendering_provider_names,
                "supervising_provider_npis": supervising_provider_npis,
                "supervising_provider_names": supervising_provider_names,
                "has_charge_capture_updates": has_charge_capture_updates,
            },
            request_options=request_options,
        )
        try:
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        if 200 <= _response.status_code < 300:
            _data = typing.cast(
                ChargeCaptureClaimCreationPage,
                parse_obj_as(
                    type_=ChargeCaptureClaimCreationPage,  # type: ignore
                    object_=_response_json,
                ),
            )
            return AsyncHttpResponse(response=_response, data=_data)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
