# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ChargeCaptureClaimCreationStatus(str, enum.Enum):
    NOT_STARTED = "not-started"
    IN_ERROR = "in-error"
    SUCCESSFUL = "successful"
    SUCCESSFUL_DRY_RUN = "successful-dry-run"
    ABORTED = "aborted"
    HELD = "held"
    """
    This Claim Creation has potential charges that are in a planned state, the Claim Creation will be held until those charges are converted
    """

    _UNKNOWN = "__CHARGECAPTURECLAIMCREATIONSTATUS_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ChargeCaptureClaimCreationStatus":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        not_started: typing.Callable[[], T_Result],
        in_error: typing.Callable[[], T_Result],
        successful: typing.Callable[[], T_Result],
        successful_dry_run: typing.Callable[[], T_Result],
        aborted: typing.Callable[[], T_Result],
        held: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ChargeCaptureClaimCreationStatus.NOT_STARTED:
            return not_started()
        if self is ChargeCaptureClaimCreationStatus.IN_ERROR:
            return in_error()
        if self is ChargeCaptureClaimCreationStatus.SUCCESSFUL:
            return successful()
        if self is ChargeCaptureClaimCreationStatus.SUCCESSFUL_DRY_RUN:
            return successful_dry_run()
        if self is ChargeCaptureClaimCreationStatus.ABORTED:
            return aborted()
        if self is ChargeCaptureClaimCreationStatus.HELD:
            return held()
        return _unknown_member(self._value_)
