# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class InsuranceTypeCode(str, enum.Enum):
    """
    Code identifying the type of insurance policy within a specific insurance program (X12 008020 Element 1336)
    """

    C_01 = "01"
    """
    Short Term Insurance
    """

    C_12 = "12"
    """
    Medicare Secondary Working Aged Beneficiary or Spouse with Employer Group Health Plan
    """

    C_13 = "13"
    """
    Medicare Secondary End-Stage Renal Disease Beneficiary in the Mandated Coordination Period with an Employer's Group Health Plan
    """

    C_14 = "14"
    """
    Medicare Secondary, No-fault Insurance including Auto is Primary
    """

    C_15 = "15"
    """
    Medicare Secondary Worker's Compensation
    """

    C_16 = "16"
    """
    Medicare Secondary Public Health Service (PHS) or Other Federal Agency
    """

    C_17 = "17"
    """
    Dental
    """

    C_18 = "18"
    """
    Vision
    """

    C_19 = "19"
    """
    Prescription Drugs
    """

    C_41 = "41"
    """
    Medicare Secondary Black Lung
    """

    C_42 = "42"
    """
    Medicare Secondary Veteran's Administration
    """

    C_43 = "43"
    """
    Medicare Secondary Disabled Beneficiary Under Age 65 with Large Group Health Plan (LGHP)
    """

    C_47 = "47"
    """
    Medicare Secondary, Other Liability Insurance is Primary
    """

    CAP = "AP"
    """
    Auto Insurance Policy
    """

    CC_1 = "C1"
    """
    Commercial
    """

    CCO = "CO"
    """
    Consolidated Omnibus Budget Reconciliation Act (COBRA)
    """

    CCP = "CP"
    """
    Medicare Conditionally Primary
    """

    CD = "D"
    """
    Disability - Provides periodic payments to replace income when an insured person is unable to work as a result of illness, injury or disease
    """

    CDB = "DB"
    """
    Disability Benefits
    """

    CE = "E"
    """
    Medicare - Point of Service (POS)
    """

    CEP = "EP"
    """
    Exclusive Provider Organization - Gives subscriber a choice of providers from an approved/contracted payer list; there are fixed dollar co-payments for most covered services in return for using plan providers
    """

    CFF = "FF"
    """
    Family or Friends
    """

    CGP = "GP"
    """
    Group Policy - Two or more people who are part of complete unit who enter into an insurance contract with an insurance company
    """

    CHA = "HA"
    """
    Health Insurance Exchange (HIX) Silver
    """

    CHB = "HB"
    """
    Health Insurance Exchange (HIX) Bronze
    """

    CHD = "HD"
    """
    High Deductible Health Plan
    """

    CHG = "HG"
    """
    Health Insurance Exchange (HIX) Gold
    """

    CHM = "HM"
    """
    Health Maintenance Organization (HMO)
    """

    CHN = "HN"
    """
    Health Maintenance Organization (HMO) - Medicare Risk
    """

    CHP = "HP"
    """
    Health Insurance Exchange (HIX) Platinum
    """

    CHS = "HS"
    """
    Special Low Income Medicare Beneficiary - An individual eligible for Medicare for whom Medicaid pays only Medicare premiums
    """

    CIN = "IN"
    """
    Indemnity - Gives a subscriber the choice to select any provider.  Payment is fixed percentage of the cost for covered care after satisfying an annual deductible
    """

    CIP = "IP"
    """
    Individual Policy
    """

    CLC = "LC"
    """
    Long Term Care - Coverage designed to help pay for some or all long term care costs, reducing the risk that a policy-holder would need to deplete all of his or her assets to pay for long term care
    """

    CLD = "LD"
    """
    Long Term Policy
    """

    CLI = "LI"
    """
    Life Insurance
    """

    CLT = "LT"
    """
    Litigation
    """

    CM = "M"
    """
    Medicare Advantage Point of Service (POS) Plan that excludes Part D coverage
    """

    CMA = "MA"
    """
    Medicare Part A
    """

    CMB = "MB"
    """
    Medicare Part B
    """

    CMC = "MC"
    """
    Medicaid - Program of health care services made available to medically indigent and other needy persons, regardless of age, under terms of a 1965 amendment to the U.S. Social Security Act
    """

    CMD = "MD"
    """
    Medicare Part D
    """

    CME = "ME"
    """
    Medicare Advantage Preferred Provider Organization (PPO) Plan that excludes Part D Coverage
    """

    CMF = "MF"
    """
    Medicare Advantage Private Fee for Service
    """

    CMH = "MH"
    """
    Medigap Part A - Health insurance policy intended to cover the non-covered portion of expenses eligible for Medicare Part A reimbursement which must be paid by a Medicare beneficiary for health care services and/or supplies received
    """

    CMI = "MI"
    """
    Medigap Part B - Health insurance policy intended to cover the non-covered portion of expenses eligible for Medicare Part B reimbursement which must be paid by a Medicare beneficiary for health care services and/or supplies received
    """

    CMJ = "MJ"
    """
    Medicare Advantage Health Maintenance Organization (HMO) Plan that includes Part D Coverage
    """

    CMK = "MK"
    """
    Medicare Advantage Health Maintenance Organization (HMO) Risk Plan that includes Part D Coverage
    """

    CML = "ML"
    """
    Medicare Advantage Indemnity Plan that includes Part D Coverage
    """

    CMM = "MM"
    """
    Medicare Advantage Preferred Provider Organization (PPO) Plan that includes Part D Coverage
    """

    CMN = "MN"
    """
    Medicare Advantage Indemnity Plan that excludes Part D coverage
    """

    CMO = "MO"
    """
    Medicare Advantage Point of Service (POS) Plan that includes Part D Coverage
    """

    CMP = "MP"
    """
    Medicare Primary - Medicare has the primary responsibility to pay for health care services and/or supplies received by a covered beneficiary (a person entitled to Medicare benefits)
    """

    CMR = "MR"
    """
    Medicare Advantage Health Maintenance Organization (HMO) Risk Plan that excludes Part D coverage
    """

    CMT = "MT"
    """
    Medicare Advantage Health Maintenance Organization (HMO) Plan that excludes Part D coverage
    """

    CMV = "MV"
    """
    Medicare Advantage
    """

    COA = "OA"
    """
    Open Access Point of Service Plan
    """

    COT = "OT"
    """
    Other
    """

    CPE = "PE"
    """
    Property Insurance - Personal
    """

    CPL = "PL"
    """
    Personal
    """

    CPP = "PP"
    """
    Personal Payment (Cash - No Insurance)
    """

    CPR = "PR"
    """
    Preferred Provider Organization (PPO)
    """

    CPS = "PS"
    """
    Point of Service (POS)
    """

    CQM = "QM"
    """
    Qualified Medicare Beneficiary - Coverage for a Medicare eligible individual for whom Medicaid pays only for Medicare premiums, co-insurance, and deductibles
    """

    CRP = "RP"
    """
    Property Insurance - Real
    """

    CSP = "SP"
    """
    Supplemental Policy - An insurance policy intended to cover non-covered charges of another insurance policy
    """

    CTF = "TF"
    """
    Tax Equity Fiscal Responsibility Act (TEFRA)
    """

    CU = "U"
    """
    Multiple Options Health Plan
    """

    CWC = "WC"
    """
    Workers Compensation - Coverage provides medical treatment, rehabilitation, lost wages and related expenses arising from a job related injury or disease
    """

    CWU = "WU"
    """
    Wrap Up Policy - A Workers Compensation Policy written for a specific job site, which will include or cover more than one insured
    """

    _UNKNOWN = "__INSURANCETYPECODE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "InsuranceTypeCode":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        c_01: typing.Callable[[], T_Result],
        c_12: typing.Callable[[], T_Result],
        c_13: typing.Callable[[], T_Result],
        c_14: typing.Callable[[], T_Result],
        c_15: typing.Callable[[], T_Result],
        c_16: typing.Callable[[], T_Result],
        c_17: typing.Callable[[], T_Result],
        c_18: typing.Callable[[], T_Result],
        c_19: typing.Callable[[], T_Result],
        c_41: typing.Callable[[], T_Result],
        c_42: typing.Callable[[], T_Result],
        c_43: typing.Callable[[], T_Result],
        c_47: typing.Callable[[], T_Result],
        cap: typing.Callable[[], T_Result],
        cc_1: typing.Callable[[], T_Result],
        cco: typing.Callable[[], T_Result],
        ccp: typing.Callable[[], T_Result],
        cd: typing.Callable[[], T_Result],
        cdb: typing.Callable[[], T_Result],
        ce: typing.Callable[[], T_Result],
        cep: typing.Callable[[], T_Result],
        cff: typing.Callable[[], T_Result],
        cgp: typing.Callable[[], T_Result],
        cha: typing.Callable[[], T_Result],
        chb: typing.Callable[[], T_Result],
        chd: typing.Callable[[], T_Result],
        chg: typing.Callable[[], T_Result],
        chm: typing.Callable[[], T_Result],
        chn: typing.Callable[[], T_Result],
        chp: typing.Callable[[], T_Result],
        chs: typing.Callable[[], T_Result],
        cin: typing.Callable[[], T_Result],
        cip: typing.Callable[[], T_Result],
        clc: typing.Callable[[], T_Result],
        cld: typing.Callable[[], T_Result],
        cli: typing.Callable[[], T_Result],
        clt: typing.Callable[[], T_Result],
        cm: typing.Callable[[], T_Result],
        cma: typing.Callable[[], T_Result],
        cmb: typing.Callable[[], T_Result],
        cmc: typing.Callable[[], T_Result],
        cmd: typing.Callable[[], T_Result],
        cme: typing.Callable[[], T_Result],
        cmf: typing.Callable[[], T_Result],
        cmh: typing.Callable[[], T_Result],
        cmi: typing.Callable[[], T_Result],
        cmj: typing.Callable[[], T_Result],
        cmk: typing.Callable[[], T_Result],
        cml: typing.Callable[[], T_Result],
        cmm: typing.Callable[[], T_Result],
        cmn: typing.Callable[[], T_Result],
        cmo: typing.Callable[[], T_Result],
        cmp: typing.Callable[[], T_Result],
        cmr: typing.Callable[[], T_Result],
        cmt: typing.Callable[[], T_Result],
        cmv: typing.Callable[[], T_Result],
        coa: typing.Callable[[], T_Result],
        cot: typing.Callable[[], T_Result],
        cpe: typing.Callable[[], T_Result],
        cpl: typing.Callable[[], T_Result],
        cpp: typing.Callable[[], T_Result],
        cpr: typing.Callable[[], T_Result],
        cps: typing.Callable[[], T_Result],
        cqm: typing.Callable[[], T_Result],
        crp: typing.Callable[[], T_Result],
        csp: typing.Callable[[], T_Result],
        ctf: typing.Callable[[], T_Result],
        cu: typing.Callable[[], T_Result],
        cwc: typing.Callable[[], T_Result],
        cwu: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is InsuranceTypeCode.C_01:
            return c_01()
        if self is InsuranceTypeCode.C_12:
            return c_12()
        if self is InsuranceTypeCode.C_13:
            return c_13()
        if self is InsuranceTypeCode.C_14:
            return c_14()
        if self is InsuranceTypeCode.C_15:
            return c_15()
        if self is InsuranceTypeCode.C_16:
            return c_16()
        if self is InsuranceTypeCode.C_17:
            return c_17()
        if self is InsuranceTypeCode.C_18:
            return c_18()
        if self is InsuranceTypeCode.C_19:
            return c_19()
        if self is InsuranceTypeCode.C_41:
            return c_41()
        if self is InsuranceTypeCode.C_42:
            return c_42()
        if self is InsuranceTypeCode.C_43:
            return c_43()
        if self is InsuranceTypeCode.C_47:
            return c_47()
        if self is InsuranceTypeCode.CAP:
            return cap()
        if self is InsuranceTypeCode.CC_1:
            return cc_1()
        if self is InsuranceTypeCode.CCO:
            return cco()
        if self is InsuranceTypeCode.CCP:
            return ccp()
        if self is InsuranceTypeCode.CD:
            return cd()
        if self is InsuranceTypeCode.CDB:
            return cdb()
        if self is InsuranceTypeCode.CE:
            return ce()
        if self is InsuranceTypeCode.CEP:
            return cep()
        if self is InsuranceTypeCode.CFF:
            return cff()
        if self is InsuranceTypeCode.CGP:
            return cgp()
        if self is InsuranceTypeCode.CHA:
            return cha()
        if self is InsuranceTypeCode.CHB:
            return chb()
        if self is InsuranceTypeCode.CHD:
            return chd()
        if self is InsuranceTypeCode.CHG:
            return chg()
        if self is InsuranceTypeCode.CHM:
            return chm()
        if self is InsuranceTypeCode.CHN:
            return chn()
        if self is InsuranceTypeCode.CHP:
            return chp()
        if self is InsuranceTypeCode.CHS:
            return chs()
        if self is InsuranceTypeCode.CIN:
            return cin()
        if self is InsuranceTypeCode.CIP:
            return cip()
        if self is InsuranceTypeCode.CLC:
            return clc()
        if self is InsuranceTypeCode.CLD:
            return cld()
        if self is InsuranceTypeCode.CLI:
            return cli()
        if self is InsuranceTypeCode.CLT:
            return clt()
        if self is InsuranceTypeCode.CM:
            return cm()
        if self is InsuranceTypeCode.CMA:
            return cma()
        if self is InsuranceTypeCode.CMB:
            return cmb()
        if self is InsuranceTypeCode.CMC:
            return cmc()
        if self is InsuranceTypeCode.CMD:
            return cmd()
        if self is InsuranceTypeCode.CME:
            return cme()
        if self is InsuranceTypeCode.CMF:
            return cmf()
        if self is InsuranceTypeCode.CMH:
            return cmh()
        if self is InsuranceTypeCode.CMI:
            return cmi()
        if self is InsuranceTypeCode.CMJ:
            return cmj()
        if self is InsuranceTypeCode.CMK:
            return cmk()
        if self is InsuranceTypeCode.CML:
            return cml()
        if self is InsuranceTypeCode.CMM:
            return cmm()
        if self is InsuranceTypeCode.CMN:
            return cmn()
        if self is InsuranceTypeCode.CMO:
            return cmo()
        if self is InsuranceTypeCode.CMP:
            return cmp()
        if self is InsuranceTypeCode.CMR:
            return cmr()
        if self is InsuranceTypeCode.CMT:
            return cmt()
        if self is InsuranceTypeCode.CMV:
            return cmv()
        if self is InsuranceTypeCode.COA:
            return coa()
        if self is InsuranceTypeCode.COT:
            return cot()
        if self is InsuranceTypeCode.CPE:
            return cpe()
        if self is InsuranceTypeCode.CPL:
            return cpl()
        if self is InsuranceTypeCode.CPP:
            return cpp()
        if self is InsuranceTypeCode.CPR:
            return cpr()
        if self is InsuranceTypeCode.CPS:
            return cps()
        if self is InsuranceTypeCode.CQM:
            return cqm()
        if self is InsuranceTypeCode.CRP:
            return crp()
        if self is InsuranceTypeCode.CSP:
            return csp()
        if self is InsuranceTypeCode.CTF:
            return ctf()
        if self is InsuranceTypeCode.CU:
            return cu()
        if self is InsuranceTypeCode.CWC:
            return cwc()
        if self is InsuranceTypeCode.CWU:
            return cwu()
        return _unknown_member(self._value_)
