# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class IntendedSubmissionMedium(str, enum.Enum):
    """
    The medium (paper or electronic) via which we intended to submit the claim. The clearinghouse to which we sent the claim may use a different medium in certain cases, e.g., if the payer does not support electronic claims.
    """

    PAPER = "paper"
    ELECTRONIC = "electronic"
    _UNKNOWN = "__INTENDEDSUBMISSIONMEDIUM_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "IntendedSubmissionMedium":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        paper: typing.Callable[[], T_Result],
        electronic: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is IntendedSubmissionMedium.PAPER:
            return paper()
        if self is IntendedSubmissionMedium.ELECTRONIC:
            return electronic()
        return _unknown_member(self._value_)
