# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class Primitive(str, enum.Enum):
    """
    The BOOLEAN and STRING primitives respectively map to the `boolean` and `string` JSON data types.
    The DOUBLE and INTEGER primitives must be written as a JSON `number` type.
    """

    BOOLEAN = "BOOLEAN"
    DOUBLE = "DOUBLE"
    INTEGER = "INTEGER"
    STRING = "STRING"
    _UNKNOWN = "__PRIMITIVE_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "Primitive":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        boolean: typing.Callable[[], T_Result],
        double: typing.Callable[[], T_Result],
        integer: typing.Callable[[], T_Result],
        string: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is Primitive.BOOLEAN:
            return boolean()
        if self is Primitive.DOUBLE:
            return double()
        if self is Primitive.INTEGER:
            return integer()
        if self is Primitive.STRING:
            return string()
        return _unknown_member(self._value_)
