# This file was auto-generated by Fern from our API Definition.

import enum
import typing

T_Result = typing.TypeVar("T_Result")


class ProcedureModifier(str, enum.Enum):
    AV = "AV"
    """
    Ambulance service provided as a volunteer ambulance service organization as defined by the state
    """

    AU = "AU"
    """
    Item furnished in conjunction with a urological, ostomy, or tracheostomy supply
    """

    AW = "AW"
    """
    Item furnished in conjunction with dialysis services
    """

    TWENTY_TWO = "22"
    """
    Increased Procedural Services
    """

    TWENTY_THREE = "23"
    """
    Unusual Anesthesia
    """

    TWENTY_FOUR = "24"
    """
    Unrelated Evaluation and Management Service by the Same Physician or Other Qualified Health Care Professional During a Postoperative Period
    """

    TWENTY_FIVE = "25"
    """
    Significant, Separately Identifiable Evaluation and Management Service by the Same Physician or Other Qualified Health Care Professional on the Same Day of the Procedure or Other Service
    """

    TWENTY_SIX = "26"
    """
    Professional Component
    """

    TWENTY_SEVEN = "27"
    """
    Multiple Outpatient Hospital E/M Encounters on the Same Date
    """

    THIRTY_TWO = "32"
    """
    Mandated Services
    """

    THIRTY_THREE = "33"
    """
    Preventive Services
    """

    FORTY_SEVEN = "47"
    """
    Anesthesia by Surgeon
    """

    FIFTY = "50"
    """
    Bilateral Procedure
    """

    FIFTY_ONE = "51"
    """
    Multiple Procedures
    """

    FIFTY_TWO = "52"
    """
    Reduced Services
    """

    FIFTY_THREE = "53"
    """
    Discontinued Procedure
    """

    FIFTY_FOUR = "54"
    """
    Surgical Care Only
    """

    FIFTY_FIVE = "55"
    """
    Postoperative Management Only
    """

    FIFTY_SIX = "56"
    """
    Preoperative Management Only
    """

    FIFTY_SEVEN = "57"
    """
    Decision for Surgery
    """

    FIFTY_EIGHT = "58"
    """
    Staged or Related Procedure or Service by the Same Physician or Other Qualified Health Care Professional During the Postoperative Period
    """

    FIFTY_NINE = "59"
    """
    Distinct Procedural Service
    """

    SIXTY_TWO = "62"
    """
    Two Surgeons
    """

    SIXTY_THREE = "63"
    """
    Procedure Performed on Infants less than 4 kg
    """

    SIXTY_SIX = "66"
    """
    Surgical Team
    """

    SEVENTY_FOUR = "74"
    """
    Discontinued Outpatient Hospital/Ambulatory Surgery Center (ASC) Procedure After Administration of Anesthesia
    """

    SEVENTY_SIX = "76"
    """
    Repeat Procedure or Service by Same Physician or Other Qualified Health Care Professional
    """

    SEVENTY_SEVEN = "77"
    """
    Repeat Procedure by Another Physician or Other Qualified Health Care Professional
    """

    SEVENTY_EIGHT = "78"
    """
    Unplanned Return to the Operating/Procedure Room by the Same Physician or Other Qualified Health Care Professional Following Initial Procedure for a Related Procedure During the Postoperative Period
    """

    SEVENTY_NINE = "79"
    """
    Unrelated Procedure or Service by the Same Physician or Other Qualified Health Care Professional During the Postoperative Period
    """

    EIGHTY = "80"
    """
    Assistant Surgeon
    """

    EIGHTY_ONE = "81"
    """
    Minimum Assistant Surgeon
    """

    EIGHTY_TWO = "82"
    """
    Assistant Surgeon (when qualified resident surgeon not available)
    """

    NINETY = "90"
    """
    Reference (Outside) Laboratory
    """

    NINETY_ONE = "91"
    """
    Repeat Clinical Diagnostic Laboratory Test
    """

    NINETY_TWO = "92"
    """
    Alternative Laboratory Platform Testing
    """

    NINETY_THREE = "93"
    """
    Synchronous Telemedicine Service Rendered Via Telephone or Other Real-Time Interactive Audio-Only Telecommunications System
    """

    NINETY_FIVE = "95"
    """
    Synchronous Telemedicine Service Rendered via a Real-Time Interactive Audio and Video Telecommunications System
    """

    NINETY_SIX = "96"
    """
    Habilitative Services
    """

    NINETY_SEVEN = "97"
    """
    Rehabilitative Services
    """

    NINETY_NINE = "99"
    """
    Multiple Modifiers
    """

    A_1 = "A1"
    """
    Dressing for one wound
    """

    A_2 = "A2"
    """
    Dressing for two wounds
    """

    A_3 = "A3"
    """
    Dressing for three wounds
    """

    A_4 = "A4"
    """
    Dressing for four wounds
    """

    A_5 = "A5"
    """
    Dressing for five wounds
    """

    A_6 = "A6"
    """
    Dressing for six wounds
    """

    A_7 = "A7"
    """
    Dressing for seven wounds
    """

    A_8 = "A8"
    """
    Dressing for eight wounds
    """

    A_9 = "A9"
    """
    Dressing for nine wounds
    """

    AA = "AA"
    """
    Anesthesia services performed personally by anesthesiologist
    """

    AB = "AB"
    """
    Audiology service furnished personally by an audiologist without a physician/npp order for non-acute hearing assessment ...
    """

    AD = "AD"
    """
    Medical supervision by a physician: more than four concurrent anesthesia procedures
    """

    AE = "AE"
    """
    Registered dietician
    """

    AF = "AF"
    """
    Specialty physician
    """

    AG = "AG"
    """
    Primary physician
    """

    AH = "AH"
    """
    Clinical psychologist
    """

    AI = "AI"
    """
    Principal physician of record
    """

    AJ = "AJ"
    """
    Clinical social worker
    """

    AK = "AK"
    """
    Non participating physician
    """

    AM = "AM"
    """
    Physician, team member service
    """

    AO = "AO"
    """
    Alternate payment method declined by provider of service
    """

    AP = "AP"
    """
    Determination of refractive state was not performed in the course of diagnostic ophthalmological examination
    """

    AQ = "AQ"
    """
    Physician providing a service in an unlisted health professional shortage area (hpsa)
    """

    AR = "AR"
    """
    Physician provider services in a physician scarcity area
    """

    AS = "AS"
    """
    Physician assistant, nurse practitioner, or clinical nurse specialist services for assistant at surgery
    """

    AT = "AT"
    """
    Acute treatment
    """

    AZ = "AZ"
    """
    Physician providing a service in a dental health professional shortage area for the purpose of an EHR incentive payment
    """

    BA = "BA"
    """
    Item furnished in conjunction with parenteral enteral nutrition (pen) services
    """

    BL = "BL"
    """
    Special acquisition of blood and blood products
    """

    BO = "BO"
    """
    Orally administered nutrition, not by feeding tube
    """

    BP = "BP"
    """
    The beneficiary has been informed of the purchase and rental options and has elected to purchase the item
    """

    BR = "BR"
    """
    The beneficiary has been informed of the purchase and rental options and has elected to rent the item
    """

    BU = "BU"
    """
    The beneficiary has been informed of the purchase and rental options and after 30 days has not informed the supplier
    """

    CA = "CA"
    """
    Procedure payable only in the inpatient setting when performed emergently on an outpatient who expires prior to admission
    """

    CB = "CB"
    """
    Service ordered by a renal dialysis facility (rdf) physician as part of the ESRD beneficiary's dialysis benefit
    """

    CC = "CC"
    """
    Procedure code change
    """

    CD = "CD"
    """
    Amcc test has been ordered by an ESRD facility or MCP physician that is not separately billable
    """

    CE = "CE"
    """
    Amcc test has been ordered by an esrd facility or mcp physician that is beyond the normal frequency covered
    """

    CF = "CF"
    """
    Amcc test has been ordered by an esrd facility or mcp physician that is separately billable
    """

    CG = "CG"
    """
    Policy criteria applied
    """

    CH = "CH"
    """
    0 percent impaired, limited or restricted
    """

    CI = "CI"
    """
    At least 1 percent but less than 20 percent impaired, limited or restricted
    """

    CJ = "CJ"
    """
    At least 20 percent but less than 40 percent impaired, limited or restricted
    """

    CK = "CK"
    """
    At least 40 percent but less than 60 percent impaired, limited or restricted
    """

    CL = "CL"
    """
    At least 60 percent but less than 80 percent impaired, limited or restricted
    """

    CM = "CM"
    """
    At least 80 percent but less than 100 percent impaired, limited or restricted
    """

    CN = "CN"
    """
    100 percent impaired, limited or restricted
    """

    CR = "CR"
    """
    Catastrophe/disaster related
    """

    CS = "CS"
    """
    Cost sharing for COVID-19 testing
    """

    CT = "CT"
    """
    Computed tomography services furnished using equipment that does not meet xr-29-2013 standard
    """

    CO = "CO"
    """
    Outpatient physical therapy services furnished in whole or in part by a occupational therapist assistant
    """

    CQ = "CQ"
    """
    Outpatient physical therapy services furnished in whole or in part by a physical therapist assistant
    """

    DA = "DA"
    """
    Oral health assessment by a licensed health professional other than a dentist
    """

    E_1 = "E1"
    """
    Upper left, eyelid
    """

    E_2 = "E2"
    """
    Lower left, eyelid
    """

    E_3 = "E3"
    """
    Upper right, eyelid
    """

    E_4 = "E4"
    """
    Lower right, eyelid
    """

    EA = "EA"
    """
    Erythropoetic stimulating agent (esa) administered to treat anemia due to anti-cancer chemotherapy
    """

    EB = "EB"
    """
    Erythropoetic stimulating agent (esa) administered to treat anemia due to anti-cancer radiotherapy
    """

    EC = "EC"
    """
    Erythropoetic stimulating agent (esa) administered to treat anemia not due to anti-cancer radiotherapy or chemotherapy
    """

    ED = "ED"
    """
    Hematocrit level has exceeded 39% (or hemoglobin level has exceeded 13.0 g/dl) for 3 or more consecutive billing cycles
    """

    EE = "EE"
    """
    Hematocrit level has not exceeded 39% (or hemoglobin level has not exceeded 13.0 g/dl) for 3 or more billing cycles
    """

    EJ = "EJ"
    """
    Subsequent claims for a defined course of therapy, e.g., epo, sodium hyaluronate, infliximab
    """

    EM = "EM"
    """
    Emergency reserve supply (for esrd benefit only)
    """

    EP = "EP"
    """
    Service provided as part of medicaid early periodic screening diagnosis and treatment (epsdt) program
    """

    ER = "ER"
    """
    Items and services furnished by a provider-based, off-campus emergency department
    """

    ET = "ET"
    """
    Emergency services
    """

    EX = "EX"
    """
    Expatriate beneficiary
    """

    EY = "EY"
    """
    No physician or other licensed health care provider order for this item or service
    """

    F_1 = "F1"
    """
    Left hand, second digit
    """

    F_2 = "F2"
    """
    Left hand, third digit
    """

    F_3 = "F3"
    """
    Left hand, fourth digit
    """

    F_4 = "F4"
    """
    Left hand, fifth digit
    """

    F_5 = "F5"
    """
    Right hand, thumb
    """

    F_6 = "F6"
    """
    Right hand, second digit
    """

    F_7 = "F7"
    """
    Right hand, third digit
    """

    F_8 = "F8"
    """
    Right hand, fourth digit
    """

    F_9 = "F9"
    """
    Right hand, fifth digit
    """

    FA = "FA"
    """
    Right hand, thumb
    """

    FB = "FB"
    """
    Item provided without cost to provider, supplier or practitioner, or full credit received for replaced device
    """

    FC = "FC"
    """
    Partial credit received for replaced device
    """

    FP = "FP"
    """
    Service provided as part of family planning program
    """

    FQ = "FQ"
    """
    Telehealth service furnished using real-time audio-only communication technology.
    """

    FR = "FR"
    """
    A supervising practitioner was present through a real-time two-way, audio/video communication technology.
    """

    FS = "FS"
    """
    Split (or shared) evaluation and management visit.
    """

    FT = "FT"
    """
    Unrelated evaluation and management (e/m) visit on the same day as another e/m visit or during a global procedure
    """

    FX = "FX"
    """
    X-ray taken using film
    """

    FY = "FY"
    """
    X-ray taken using computed radiography technology/cassette-based imaging
    """

    G_0 = "G0"
    """
    Telehealth Services For Diagnosis, Evaluation, Or Treatment, Of Symptoms Of An Acute Stroke
    """

    G_1 = "G1"
    """
    Most recent urr reading of less than 60
    """

    G_2 = "G2"
    """
    Most recent urr reading of 60 to 64.9
    """

    G_3 = "G3"
    """
    Most recent urr reading of 65 to 69.9
    """

    G_4 = "G4"
    """
    Most recent urr reading of 70 to 74.9
    """

    G_5 = "G5"
    """
    Most recent urr reading of 75 or greater
    """

    G_6 = "G6"
    """
    ESRD patient for whom less than six dialysis sessions have been provided in a month
    """

    G_7 = "G7"
    """
    Pregnancy resulted from rape or incest or pregnancy certified by physician as life threatening
    """

    G_8 = "G8"
    """
    Monitored anesthesia care (mac) for deep complex, complicated, or markedly invasive surgical procedure
    """

    G_9 = "G9"
    """
    Monitored anesthesia care for patient who has history of severe cardio-pulmonary condition
    """

    GA = "GA"
    """
    Waiver of liability statement issued as required by payer policy, individual case
    """

    GB = "GB"
    """
    Claim being re-submitted for payment because it is no longer covered under a global payment demonstration
    """

    GC = "GC"
    """
    This service has been performed in part by a resident under the direction of a teaching physician
    """

    GE = "GE"
    """
    This service has been performed by a resident without the presence of a teaching physician under the primary care exception
    """

    GF = "GF"
    """
    Non-physician (e.g. nurse practitioner (np), certified registered nurse anesthetist (crna), certified registered nurse (crn), clinical nurse specialist (cns), physician assistant (pa)) services in a critical access hospital
    """

    GG = "GG"
    """
    Performance and payment of a screening mammogram and diagnostic mammogram on the same patient, same day
    """

    GH = "GH"
    """
    Diagnostic mammogram converted from screening mammogram on same day
    """

    GJ = "GJ"
    """
    opt out physician or practitioner emergency or urgent service
    """

    GK = "GK"
    """
    Reasonable and necessary item/service associated with a ga or gz modifier
    """

    GL = "GL"
    """
    Medically unnecessary upgrade provided instead of non-upgraded item, no charge, no advance beneficiary notice (abn)
    """

    GM = "GM"
    """
    Multiple patients on one ambulance trip
    """

    GN = "GN"
    """
    Services delivered under an outpatient speech-language pathology plan of care
    """

    GO = "GO"
    """
    Service delivered personally by an occupational therapist or under an outpatient occupational therapy plan of care
    """

    GP = "GP"
    """
    Service delivered personally by a physical therapist or under an outpatient physical therapy plan of care
    """

    GQ = "GQ"
    """
    Services provided via an asynchronous telecommunications system
    """

    GR = "GR"
    """
    This service was performed in whole or in part by a resident in a department of veterans affairs medical center or clinic, supervised in accordance with va policy
    """

    GS = "GS"
    """
    Dosage of erythropoietin stimulating agent has been reduced and maintained in response to hematocrit or hemoglobin level
    """

    GT = "GT"
    """
    Services took place via an interactive audio and video telecommunications system
    """

    GU = "GU"
    """
    Waiver of liability statement issued as required by payer policy, routine notice
    """

    GV = "GV"
    """
    Attending physician not employed or paid under arrangement by the patient's hospice provider
    """

    GW = "GW"
    """
    Service not related to the hospice patient's terminal condition
    """

    GX = "GX"
    """
    Notice of liability issued, voluntary under payer policy
    """

    GY = "GY"
    """
    Not a covered benefit
    """

    GZ = "GZ"
    """
    Item or service expected to be denied as not reasonable and necessary
    """

    HA = "HA"
    """
    Child/adolescent program
    """

    HB = "HB"
    """
    Adult program, non geriatric
    """

    HC = "HC"
    """
    Adult program, geriatric
    """

    HD = "HD"
    """
    Pregnant/parenting women's program
    """

    HE = "HE"
    """
    Mental health program
    """

    HF = "HF"
    """
    Substance abuse program
    """

    HG = "HG"
    """
    Opioid addiction treatment program
    """

    HH = "HH"
    """
    Integrated mental health/substance abuse program
    """

    HI = "HI"
    """
    Integrated mental health and intellectual disability/developmental disabilities program
    """

    HJ = "HJ"
    """
    Employee assistance program
    """

    HK = "HK"
    """
    Specialized mental health programs for high-risk populations
    """

    HL = "HL"
    """
    Intern
    """

    HM = "HM"
    """
    The rendering provider has a highest educational attainment of less than a bachelor's degree
    """

    HN = "HN"
    """
    The rendering provider has a highest educational attainment of a bachelor's degree
    """

    HO = "HO"
    """
    The rendering provider has a highest educational attainment of a master's degree
    """

    HP = "HP"
    """
    The rendering provider has a highest educational attainment of a doctoral degree
    """

    HQ = "HQ"
    """
    Group setting
    """

    HR = "HR"
    """
    Family/couple with client present
    """

    HS = "HS"
    """
    Family/couple without client present
    """

    HT = "HT"
    """
    Multi-disciplinary team
    """

    HU = "HU"
    """
    Funded by child welfare agency
    """

    HV = "HV"
    """
    Funded by state addictions agency
    """

    HW = "HW"
    """
    Funded by state mental health agency
    """

    HX = "HX"
    """
    Funded by county/local agency
    """

    HY = "HY"
    """
    Funded by juvenile justice agency
    """

    HZ = "HZ"
    """
    Funded by criminal justice agency
    """

    J_1 = "J1"
    """
    Competitive acquisition program no-pay submission for a prescription number
    """

    J_2 = "J2"
    """
    Competitive acquisition program, restocking of emergency drugs after emergency administration
    """

    J_3 = "J3"
    """
    Competitive acquisition program (cap) reimbursed under average sales price methodology
    """

    J_4 = "J4"
    """
    DMEPOS item subject to DMEPOS competitive bidding program that is furnished by a hospital upon discharge
    """

    J_5 = "J5"
    """
    Off-the-shelf orthotic subject to DMEPOS competitive bidding program
    """

    JA = "JA"
    """
    Administered intravenously
    """

    JB = "JB"
    """
    Administered subcutaneously
    """

    JC = "JC"
    """
    Skin substitute used as a graft
    """

    JD = "JD"
    """
    Skin substitute not used as a graft
    """

    JE = "JE"
    """
    Administered via dialysate
    """

    JG = "JG"
    """
    Drug or biological acquired with 340b drug pricing program discount
    """

    JW = "JW"
    """
    Drug amount discarded/not administered to any patient
    """

    JZ = "JZ"
    """
    Zero drug amount discarded/not administered to any patient
    """

    K_0 = "K0"
    """
    Lower extremity prosthesis functional level 0
    """

    K_1 = "K1"
    """
    Lower extremity prosthesis functional level 1
    """

    K_2 = "K2"
    """
    Lower extremity prosthesis functional level 2
    """

    K_3 = "K3"
    """
    Lower extremity prosthesis functional level 3
    """

    K_4 = "K4"
    """
    Lower extremity prosthesis functional level 4
    """

    KA = "KA"
    """
    Add on option/accessory for wheelchair
    """

    KB = "KB"
    """
    Beneficiary requested upgrade for abn, more than 4 modifiers identified on claim
    """

    KC = "KC"
    """
    Replacement of special power wheelchair interface
    """

    KD = "KD"
    """
    Drug or biological infused through DME
    """

    KE = "KE"
    """
    Bid under round one of the DMEPOS competitive bidding program
    """

    KF = "KF"
    """
    Item designated by FDA as class III device
    """

    KG = "KG"
    """
    DMEPOS item subject to DMEPOS competitive bidding program number 1
    """

    KH = "KH"
    """
    DMEPOS item, initial claim, purchase or first month rental
    """

    KI = "KI"
    """
    DMEPOS item, second or third month rental
    """

    KJ = "KJ"
    """
    DMEPOS item, parenteral enteral nutrition (pen) pump or capped rental, months four to fifteen
    """

    KK = "KK"
    """
    DMEPOS item subject to DMEPOS competitive bidding program number 2
    """

    KL = "KL"
    """
    DMEPOS item delivered via mail
    """

    KM = "KM"
    """
    Replacement of facial prosthesis including new impression/moulage
    """

    KN = "KN"
    """
    Replacement of facial prosthesis using previous master model
    """

    KO = "KO"
    """
    Single drug unit dose formulation
    """

    KP = "KP"
    """
    First drug of a multiple drug unit dose formulation
    """

    KQ = "KQ"
    """
    Second or subsequent drug of a multiple drug unit dose formulation
    """

    KR = "KR"
    """
    Rental item, billing for partial month
    """

    KS = "KS"
    """
    Glucose monitor supply for diabetic beneficiary not treated with insulin
    """

    KT = "KT"
    """
    Beneficiary resides in a competitive bidding area and travels outside that competitive bidding area
    """

    KU = "KU"
    """
    DMEPOS item subject to DMEPOS competitive bidding program number 3
    """

    KV = "KV"
    """
    DMEPOS item subject to DMEPOS competitive bidding program that is furnished as part of a professional service
    """

    KW = "KW"
    """
    DMEPOS item subject to DMEPOS competitive bidding program number 4
    """

    KX = "KX"
    """
    Requirements specified in the medical policy have been met
    """

    KY = "KY"
    """
    DMEPOS item subject to DMEPOS competitive bidding program number 5
    """

    KZ = "KZ"
    """
    New coverage not implemented by managed care
    """

    LC = "LC"
    """
    Left circumflex coronary artery
    """

    LD = "LD"
    """
    Left anterior descending coronary artery
    """

    LL = "LL"
    """
    Lease/rental
    """

    LM = "LM"
    """
    Left main coronary artery
    """

    LR = "LR"
    """
    Laboratory round trip
    """

    LS = "LS"
    """
    FDA-monitored intraocular lens implant
    """

    LT = "LT"
    """
    Left side (used to identify procedures performed on the left side of the body)
    """

    LU = "LU"
    """
    Fractionated payment of CAR-T therapy
    """

    M_2 = "M2"
    """
    Medicare secondary payer
    """

    MA = "MA"
    """
    Not required to consult clinical decision support... for patient with a suspected or confirmed emergency medical condition
    """

    MB = "MB"
    """
    Not required to consult clinical decision support mechanism due to insufficient internet access
    """

    MC = "MC"
    """
    Not required to consult clinical decision support mechanism due to electronic health record vendor issues
    """

    MD = "MD"
    """
    Not required to consult clinical decision support mechanism due to extreme/uncontrollable circumstances
    """

    ME = "ME"
    """
    Adheres to appropriate use criteria in the clinical decision support mechanism consulted by the ordering professional
    """

    MF = "MF"
    """
    Does not adhere to the criteria in the clinical decision support mechanism consulted by the ordering professional
    """

    MG = "MG"
    """
    Does not have appropriate use criteria in the clinical decision support mechanism consulted by the ordering professional
    """

    MH = "MH"
    """
    Unknown if ordering professional consulted a clinical decision support mechanism for this service
    """

    MS = "MS"
    """
    Six month maintenance and servicing fee for parts and labor, not covered under any manufacturer or supplier warranty
    """

    N_1 = "N1"
    """
    Group 1 oxygen coverage criteria met
    """

    N_2 = "N2"
    """
    Group 2 oxygen coverage criteria met
    """

    N_3 = "N3"
    """
    Group 3 oxygen coverage criteria met
    """

    NB = "NB"
    """
    Nebulizer system, any type, FDA-cleared for use with specific drug
    """

    NR = "NR"
    """
    New when rented
    """

    NU = "NU"
    """
    New durable medical equipment purchase
    """

    P_1 = "P1"
    """
    A normal healthy patient
    """

    P_2 = "P2"
    """
    A patient with a mild systemic disease
    """

    P_3 = "P3"
    """
    A patient with severe systemic disease
    """

    P_4 = "P4"
    """
    A patient with severe systemic disease that is a constant threat to life
    """

    P_5 = "P5"
    """
    A moribund patient who is not expected to survive without the operation
    """

    P_6 = "P6"
    """
    A declared brain-dead patient whose organs are being removed for donor purposes
    """

    PA = "PA"
    """
    Surgical or other invasive procedure on wrong body part
    """

    PB = "PB"
    """
    Surgical or other invasive procedure on wrong patient
    """

    PC = "PC"
    """
    Wrong surgery or other invasive procedure on patient
    """

    PD = "PD"
    """
    Diagnostic or related non diagnostic item or service provided in a wholly owned or operated entity to a patient who is admitted as an inpatient within 3 days
    """

    PI = "PI"
    """
    Positron emission tomography (PET) or PET/computed tomography (CT)
    """

    PL = "PL"
    """
    Progressive addition lenses
    """

    PM = "PM"
    """
    Post-mortem
    """

    PN = "PN"
    """
    Non-excepted service provided at an off-campus, outpatient, provider-based department of a hospital
    """

    PO = "PO"
    """
    Excepted service provided at an off-campus, outpatient, provider-based department of a hospital
    """

    PS = "PS"
    """
    Positron emission tomography (PET) or pet/computed tomography (CT) to inform the treatment strategy of cancerous tumors
    """

    PT = "PT"
    """
    Colorectal cancer screening test; converted to diagnostic test or other procedure
    """

    Q_0 = "Q0"
    """
    Investigational clinical service provided in a clinical research study that is in an approved clinical research study
    """

    Q_1 = "Q1"
    """
    Routine clinical service provided in a clinical research study that is in an approved clinical research study
    """

    Q_2 = "Q2"
    """
    Demonstration procedure/service
    """

    Q_3 = "Q3"
    """
    Live kidney donor surgery and related services
    """

    Q_4 = "Q4"
    """
    Service for ordering/referring physician qualifies as a service exemption
    """

    Q_5 = "Q5"
    """
    Service furnished under a reciprocal billing arrangement by a substitute physician; or by a substitute physical therapist furnishing outpatient physical therapy services in a health professional shortage area, a medically underserved area, or a rural area
    """

    Q_6 = "Q6"
    """
    Service furnished under a fee-for-time compensation arrangement by a substitute physician; or by a substitute physical therapist furnishing outpatient physical therapy services in a health professional shortage area, a medically underserved area, or a rural area
    """

    Q_7 = "Q7"
    """
    One Class A finding
    """

    Q_8 = "Q8"
    """
    Two Class A findings
    """

    Q_9 = "Q9"
    """
    One Class B and two Class C findings
    """

    QA = "QA"
    """
    Prescribed amounts of stationary oxygen for daytime use differ ... <1 liter per minute
    """

    QB = "QB"
    """
    Prescribed amounts of stationary oxygen for daytime use differ ... >4 liters per minute
    """

    QC = "QC"
    """
    Single channel monitoring
    """

    QD = "QD"
    """
    Recording and storage in solid state memory by a digital recorder
    """

    QE = "QE"
    """
    Prescribed amount of stationary oxygen while at rest is less than 1 liter per minute (lpm)
    """

    QF = "QF"
    """
    Prescribed amount of stationary oxygen while at rest exceeds 4 liters per minute (lpm) and portable oxygen is prescribed
    """

    QG = "QG"
    """
    Prescribed amount of stationary oxygen while at rest is greater than 4 liters per minute (lpm)
    """

    QH = "QH"
    """
    Oxygen conserving device is being used with an oxygen delivery system
    """

    QJ = "QJ"
    """
    Services/items provided to a prisoner or patient in state or local custody, however the state or local government, as applicable, meets the requirements in 42 cfr 411.4 (b)
    """

    QK = "QK"
    """
    Medical direction of two, three, or four concurrent anesthesia procedure involving qualified individuals
    """

    QL = "QL"
    """
    Patient pronounced dead after ambulance called
    """

    QM = "QM"
    """
    Ambulance service provided under arrangement by a provider of services
    """

    QN = "QN"
    """
    Ambulance service furnished directly by a provider of services
    """

    QP = "QP"
    """
    Laboratory test(s) was ordered individually or ordered as a cpt-recognized panel other than automated profile codes
    """

    QQ = "QQ"
    """
    Ordering professional consulted a qualified clinical decision support mechanism for this service
    """

    QR = "QR"
    """
    Amounts of stationary oxygen for daytime use and nighttime use differ; average of the amounts >4 liters per minute
    """

    QS = "QS"
    """
    Monitored anesthesia care service
    """

    QT = "QT"
    """
    Recording and storage on tape by an analog tape recorder
    """

    QW = "QW"
    """
    CLIA waived
    """

    QX = "QX"
    """
    CRNA service: with medical direction by a physician
    """

    QY = "QY"
    """
    Medical direction of one certified registered nurse anesthetist (CRNA) by an anesthesiologist
    """

    QZ = "QZ"
    """
    CRNA service: without medical direction by a physician
    """

    RA = "RA"
    """
    Replacement of a DME, orthotic or prosthetic item
    """

    RB = "RB"
    """
    Replacement of a part of a DME, orthotic or prosthetic item
    """

    RC = "RC"
    """
    Right coronary artery
    """

    RD = "RD"
    """
    Drug provided to beneficiary, but not administered 'incident-to'
    """

    RE = "RE"
    """
    Furnished in full compliance with FDA-mandated risk evaluation and mitigation strategy (REMS)
    """

    RI = "RI"
    """
    Ramus intermedius coronary artery
    """

    RR = "RR"
    """
    Rental (Use this ‘RR' modifier when DME is to be rented)
    """

    RT = "RT"
    """
    Right side (used to identify procedures performed on the right side of the body)
    """

    SA = "SA"
    """
    Physician assistant, nurse practitioner, or clinical nurse specialist services for non-surgical services
    """

    SB = "SB"
    """
    Nurse midwife
    """

    SC = "SC"
    """
    Medically necessary service or supply
    """

    SD = "SD"
    """
    Services provided by registered nurse with specialized, highly technical home infusion training
    """

    SE = "SE"
    """
    State- and/or federally-funded programs/services
    """

    SF = "SF"
    """
    Second opinion ordered by a professional review organization (PRO) per section 9401, p.l. 99-272
    """

    SG = "SG"
    """
    Ambulatory surgical center (ASC) facility service
    """

    SH = "SH"
    """
    Second concurrently administered infusion therapy
    """

    SJ = "SJ"
    """
    Third or more concurrently administered infusion therapy
    """

    SL = "SL"
    """
    Addresses reimbursement guidelines for vaccines provided at no cost to the provider by a state or federal agency
    """

    SM = "SM"
    """
    Second surgical opinion
    """

    SN = "SN"
    """
    Third surgical opinion
    """

    SQ = "SQ"
    """
    Item ordered by home health
    """

    SS = "SS"
    """
    Home infusion services provided in the infusion suite of the IV therapy provider
    """

    ST = "ST"
    """
    Related to trauma or injury
    """

    SU = "SU"
    """
    Procedure performed in physician's office (to denote use of facility and equipment)
    """

    SV = "SV"
    """
    Pharamceuticals delivered to patient's home but not utilized
    """

    SW = "SW"
    """
    Services provided by a certified diabetic educator
    """

    SY = "SY"
    """
    Persons who are in close contact with member of high-risk population (use only with codes for immunization)
    """

    T_1 = "T1"
    """
    Left foot, second digit
    """

    T_2 = "T2"
    """
    Left foot, third digit
    """

    T_3 = "T3"
    """
    Left foot, fourth digit
    """

    T_4 = "T4"
    """
    Left foot, fifth digit
    """

    T_5 = "T5"
    """
    Right foot, great toe
    """

    T_6 = "T6"
    """
    Right foot, second digit
    """

    T_7 = "T7"
    """
    Right foot, third digit
    """

    T_8 = "T8"
    """
    Right foot, fourth digit
    """

    T_9 = "T9"
    """
    Right foot, fifth digit
    """

    TA = "TA"
    """
    Left foot, great toe
    """

    TB = "TB"
    """
    Drug or biological acquired with 340b drug pricing program discount, reported for informational purposes
    """

    TC = "TC"
    """
    Technical Component
    """

    TD = "TD"
    """
    Registered nurse (RN)
    """

    TE = "TE"
    """
    Licensed vocational nurse (LVN) or licensed practical nurse (LPN)
    """

    TF = "TF"
    """
    Intermediate level of care
    """

    TG = "TG"
    """
    Complex/high tech level of care
    """

    TH = "TH"
    """
    Obstetrical treatment/services, prenatal or postpart
    """

    TJ = "TJ"
    """
    Program group, child and/or adolescent
    """

    TK = "TK"
    """
    Extra patient or passenger, non-ambulance
    """

    TL = "TL"
    """
    Early Intervention/Individualized Family Service Plan
    """

    TM = "TM"
    """
    Individualized education program (IEP)
    """

    TN = "TN"
    """
    Rural/outside providers' customary service area
    """

    TP = "TP"
    """
    Medical transport, unloaded vehicle
    """

    TQ = "TQ"
    """
    Basic life support transport by a volunteer ambulance provider
    """

    TR = "TR"
    """
    School-based individualized education program (IEP) services provided outside the public school district
    """

    TS = "TS"
    """
    Follow-up service
    """

    TT = "TT"
    """
    Individualized service provided to more than one patient in same setting
    """

    TU = "TU"
    """
    Special payment rate, overtime
    """

    TV = "TV"
    """
    Special payment rates, holidays/weekends
    """

    TW = "TW"
    """
    Back-up equipment
    """

    U_1 = "U1"
    """
    Medicaid level of care 1, as defined by each state
    """

    U_2 = "U2"
    """
    Medicaid level of care 2, as defined by each state
    """

    U_3 = "U3"
    """
    Medicaid level of care 3, as defined by each state
    """

    U_4 = "U4"
    """
    Medicaid level of care 4, as defined by each state
    """

    U_5 = "U5"
    """
    Medicaid level of care 5, as defined by each state
    """

    U_6 = "U6"
    """
    Medicaid level of care 6, as defined by each state
    """

    U_7 = "U7"
    """
    Medicaid level of care 7, as defined by each state
    """

    U_8 = "U8"
    """
    Medicaid level of care 8, as defined by each state
    """

    U_9 = "U9"
    """
    Medicaid level of care 9, as defined by each state
    """

    UA = "UA"
    """
    Medicaid level of care 10, as defined by each state
    """

    UB = "UB"
    """
    Medicaid level of care 11, as defined by each state
    """

    UC = "UC"
    """
    Medicaid level of care 12, as defined by each state
    """

    UD = "UD"
    """
    Medicaid level of care 13, as defined by each state
    """

    UE = "UE"
    """
    Used durable medical equipment
    """

    UF = "UF"
    """
    Services provided in the morning
    """

    UG = "UG"
    """
    Services provided in the afternoon
    """

    UH = "UH"
    """
    Services provided in the evening
    """

    UJ = "UJ"
    """
    Services provided at night
    """

    UK = "UK"
    """
    Services provided on behalf of the client to someone other than the client (collateral relationship)
    """

    UN = "UN"
    """
    Two patients served
    """

    UP = "UP"
    """
    Three patients served
    """

    UQ = "UQ"
    """
    Four patients served
    """

    UR = "UR"
    """
    Five patients served
    """

    US = "US"
    """
    Six patients served
    """

    V_1 = "V1"
    """
    One patient visit in a month
    """

    V_2 = "V2"
    """
    Two patient visits in a month
    """

    V_3 = "V3"
    """
    Three patient visits in a month
    """

    W_1 = "W1"
    """
    Indicates that the service was provided under a state-mandated reimbursement rate for workers' compensation claims
    """

    W_2 = "W2"
    """
    Used when a Medicare Set-Aside (MSA) account is used to pay for services related to a workers' compensation settlement
    """

    W_3 = "W3"
    """
    The treatment was approved under the workers’ compensation plan
    """

    X_4 = "X4"
    """
    Episodic/Focused Services - Reported by a specialty focused clinician who provides care that is time-limited
    """

    XE = "XE"
    """
    Two or more separate patient visits on the same date of service
    """

    XP = "XP"
    """
    A service that is distinct because it was performed by a different practitioner
    """

    XS = "XS"
    """
    A service that is distinct because it was performed on a separate organ/structure
    """

    XU = "XU"
    """
    The use of a service that is distinct because it does not overlap usual components of the main service
    """

    XY = "XY"
    """
    Custom modifier
    """

    _UNKNOWN = "__PROCEDUREMODIFIER_UNKNOWN__"
    """
    This member is used for forward compatibility. If the value is not recognized by the enum, it will be stored here, and the raw value is accessible through `.value`.
    """

    @classmethod
    def _missing_(cls, value: typing.Any) -> "ProcedureModifier":
        unknown = cls._UNKNOWN
        unknown._value_ = value
        return unknown

    def visit(
        self,
        av: typing.Callable[[], T_Result],
        au: typing.Callable[[], T_Result],
        aw: typing.Callable[[], T_Result],
        twenty_two: typing.Callable[[], T_Result],
        twenty_three: typing.Callable[[], T_Result],
        twenty_four: typing.Callable[[], T_Result],
        twenty_five: typing.Callable[[], T_Result],
        twenty_six: typing.Callable[[], T_Result],
        twenty_seven: typing.Callable[[], T_Result],
        thirty_two: typing.Callable[[], T_Result],
        thirty_three: typing.Callable[[], T_Result],
        forty_seven: typing.Callable[[], T_Result],
        fifty: typing.Callable[[], T_Result],
        fifty_one: typing.Callable[[], T_Result],
        fifty_two: typing.Callable[[], T_Result],
        fifty_three: typing.Callable[[], T_Result],
        fifty_four: typing.Callable[[], T_Result],
        fifty_five: typing.Callable[[], T_Result],
        fifty_six: typing.Callable[[], T_Result],
        fifty_seven: typing.Callable[[], T_Result],
        fifty_eight: typing.Callable[[], T_Result],
        fifty_nine: typing.Callable[[], T_Result],
        sixty_two: typing.Callable[[], T_Result],
        sixty_three: typing.Callable[[], T_Result],
        sixty_six: typing.Callable[[], T_Result],
        seventy_four: typing.Callable[[], T_Result],
        seventy_six: typing.Callable[[], T_Result],
        seventy_seven: typing.Callable[[], T_Result],
        seventy_eight: typing.Callable[[], T_Result],
        seventy_nine: typing.Callable[[], T_Result],
        eighty: typing.Callable[[], T_Result],
        eighty_one: typing.Callable[[], T_Result],
        eighty_two: typing.Callable[[], T_Result],
        ninety: typing.Callable[[], T_Result],
        ninety_one: typing.Callable[[], T_Result],
        ninety_two: typing.Callable[[], T_Result],
        ninety_three: typing.Callable[[], T_Result],
        ninety_five: typing.Callable[[], T_Result],
        ninety_six: typing.Callable[[], T_Result],
        ninety_seven: typing.Callable[[], T_Result],
        ninety_nine: typing.Callable[[], T_Result],
        a_1: typing.Callable[[], T_Result],
        a_2: typing.Callable[[], T_Result],
        a_3: typing.Callable[[], T_Result],
        a_4: typing.Callable[[], T_Result],
        a_5: typing.Callable[[], T_Result],
        a_6: typing.Callable[[], T_Result],
        a_7: typing.Callable[[], T_Result],
        a_8: typing.Callable[[], T_Result],
        a_9: typing.Callable[[], T_Result],
        aa: typing.Callable[[], T_Result],
        ab: typing.Callable[[], T_Result],
        ad: typing.Callable[[], T_Result],
        ae: typing.Callable[[], T_Result],
        af: typing.Callable[[], T_Result],
        ag: typing.Callable[[], T_Result],
        ah: typing.Callable[[], T_Result],
        ai: typing.Callable[[], T_Result],
        aj: typing.Callable[[], T_Result],
        ak: typing.Callable[[], T_Result],
        am: typing.Callable[[], T_Result],
        ao: typing.Callable[[], T_Result],
        ap: typing.Callable[[], T_Result],
        aq: typing.Callable[[], T_Result],
        ar: typing.Callable[[], T_Result],
        as_: typing.Callable[[], T_Result],
        at: typing.Callable[[], T_Result],
        az: typing.Callable[[], T_Result],
        ba: typing.Callable[[], T_Result],
        bl: typing.Callable[[], T_Result],
        bo: typing.Callable[[], T_Result],
        bp: typing.Callable[[], T_Result],
        br: typing.Callable[[], T_Result],
        bu: typing.Callable[[], T_Result],
        ca: typing.Callable[[], T_Result],
        cb: typing.Callable[[], T_Result],
        cc: typing.Callable[[], T_Result],
        cd: typing.Callable[[], T_Result],
        ce: typing.Callable[[], T_Result],
        cf: typing.Callable[[], T_Result],
        cg: typing.Callable[[], T_Result],
        ch: typing.Callable[[], T_Result],
        ci: typing.Callable[[], T_Result],
        cj: typing.Callable[[], T_Result],
        ck: typing.Callable[[], T_Result],
        cl: typing.Callable[[], T_Result],
        cm: typing.Callable[[], T_Result],
        cn: typing.Callable[[], T_Result],
        cr: typing.Callable[[], T_Result],
        cs: typing.Callable[[], T_Result],
        ct: typing.Callable[[], T_Result],
        co: typing.Callable[[], T_Result],
        cq: typing.Callable[[], T_Result],
        da: typing.Callable[[], T_Result],
        e_1: typing.Callable[[], T_Result],
        e_2: typing.Callable[[], T_Result],
        e_3: typing.Callable[[], T_Result],
        e_4: typing.Callable[[], T_Result],
        ea: typing.Callable[[], T_Result],
        eb: typing.Callable[[], T_Result],
        ec: typing.Callable[[], T_Result],
        ed: typing.Callable[[], T_Result],
        ee: typing.Callable[[], T_Result],
        ej: typing.Callable[[], T_Result],
        em: typing.Callable[[], T_Result],
        ep: typing.Callable[[], T_Result],
        er: typing.Callable[[], T_Result],
        et: typing.Callable[[], T_Result],
        ex: typing.Callable[[], T_Result],
        ey: typing.Callable[[], T_Result],
        f_1: typing.Callable[[], T_Result],
        f_2: typing.Callable[[], T_Result],
        f_3: typing.Callable[[], T_Result],
        f_4: typing.Callable[[], T_Result],
        f_5: typing.Callable[[], T_Result],
        f_6: typing.Callable[[], T_Result],
        f_7: typing.Callable[[], T_Result],
        f_8: typing.Callable[[], T_Result],
        f_9: typing.Callable[[], T_Result],
        fa: typing.Callable[[], T_Result],
        fb: typing.Callable[[], T_Result],
        fc: typing.Callable[[], T_Result],
        fp: typing.Callable[[], T_Result],
        fq: typing.Callable[[], T_Result],
        fr: typing.Callable[[], T_Result],
        fs: typing.Callable[[], T_Result],
        ft: typing.Callable[[], T_Result],
        fx: typing.Callable[[], T_Result],
        fy: typing.Callable[[], T_Result],
        g_0: typing.Callable[[], T_Result],
        g_1: typing.Callable[[], T_Result],
        g_2: typing.Callable[[], T_Result],
        g_3: typing.Callable[[], T_Result],
        g_4: typing.Callable[[], T_Result],
        g_5: typing.Callable[[], T_Result],
        g_6: typing.Callable[[], T_Result],
        g_7: typing.Callable[[], T_Result],
        g_8: typing.Callable[[], T_Result],
        g_9: typing.Callable[[], T_Result],
        ga: typing.Callable[[], T_Result],
        gb: typing.Callable[[], T_Result],
        gc: typing.Callable[[], T_Result],
        ge: typing.Callable[[], T_Result],
        gf: typing.Callable[[], T_Result],
        gg: typing.Callable[[], T_Result],
        gh: typing.Callable[[], T_Result],
        gj: typing.Callable[[], T_Result],
        gk: typing.Callable[[], T_Result],
        gl: typing.Callable[[], T_Result],
        gm: typing.Callable[[], T_Result],
        gn: typing.Callable[[], T_Result],
        go: typing.Callable[[], T_Result],
        gp: typing.Callable[[], T_Result],
        gq: typing.Callable[[], T_Result],
        gr: typing.Callable[[], T_Result],
        gs: typing.Callable[[], T_Result],
        gt: typing.Callable[[], T_Result],
        gu: typing.Callable[[], T_Result],
        gv: typing.Callable[[], T_Result],
        gw: typing.Callable[[], T_Result],
        gx: typing.Callable[[], T_Result],
        gy: typing.Callable[[], T_Result],
        gz: typing.Callable[[], T_Result],
        ha: typing.Callable[[], T_Result],
        hb: typing.Callable[[], T_Result],
        hc: typing.Callable[[], T_Result],
        hd: typing.Callable[[], T_Result],
        he: typing.Callable[[], T_Result],
        hf: typing.Callable[[], T_Result],
        hg: typing.Callable[[], T_Result],
        hh: typing.Callable[[], T_Result],
        hi: typing.Callable[[], T_Result],
        hj: typing.Callable[[], T_Result],
        hk: typing.Callable[[], T_Result],
        hl: typing.Callable[[], T_Result],
        hm: typing.Callable[[], T_Result],
        hn: typing.Callable[[], T_Result],
        ho: typing.Callable[[], T_Result],
        hp: typing.Callable[[], T_Result],
        hq: typing.Callable[[], T_Result],
        hr: typing.Callable[[], T_Result],
        hs: typing.Callable[[], T_Result],
        ht: typing.Callable[[], T_Result],
        hu: typing.Callable[[], T_Result],
        hv: typing.Callable[[], T_Result],
        hw: typing.Callable[[], T_Result],
        hx: typing.Callable[[], T_Result],
        hy: typing.Callable[[], T_Result],
        hz: typing.Callable[[], T_Result],
        j_1: typing.Callable[[], T_Result],
        j_2: typing.Callable[[], T_Result],
        j_3: typing.Callable[[], T_Result],
        j_4: typing.Callable[[], T_Result],
        j_5: typing.Callable[[], T_Result],
        ja: typing.Callable[[], T_Result],
        jb: typing.Callable[[], T_Result],
        jc: typing.Callable[[], T_Result],
        jd: typing.Callable[[], T_Result],
        je: typing.Callable[[], T_Result],
        jg: typing.Callable[[], T_Result],
        jw: typing.Callable[[], T_Result],
        jz: typing.Callable[[], T_Result],
        k_0: typing.Callable[[], T_Result],
        k_1: typing.Callable[[], T_Result],
        k_2: typing.Callable[[], T_Result],
        k_3: typing.Callable[[], T_Result],
        k_4: typing.Callable[[], T_Result],
        ka: typing.Callable[[], T_Result],
        kb: typing.Callable[[], T_Result],
        kc: typing.Callable[[], T_Result],
        kd: typing.Callable[[], T_Result],
        ke: typing.Callable[[], T_Result],
        kf: typing.Callable[[], T_Result],
        kg: typing.Callable[[], T_Result],
        kh: typing.Callable[[], T_Result],
        ki: typing.Callable[[], T_Result],
        kj: typing.Callable[[], T_Result],
        kk: typing.Callable[[], T_Result],
        kl: typing.Callable[[], T_Result],
        km: typing.Callable[[], T_Result],
        kn: typing.Callable[[], T_Result],
        ko: typing.Callable[[], T_Result],
        kp: typing.Callable[[], T_Result],
        kq: typing.Callable[[], T_Result],
        kr: typing.Callable[[], T_Result],
        ks: typing.Callable[[], T_Result],
        kt: typing.Callable[[], T_Result],
        ku: typing.Callable[[], T_Result],
        kv: typing.Callable[[], T_Result],
        kw: typing.Callable[[], T_Result],
        kx: typing.Callable[[], T_Result],
        ky: typing.Callable[[], T_Result],
        kz: typing.Callable[[], T_Result],
        lc: typing.Callable[[], T_Result],
        ld: typing.Callable[[], T_Result],
        ll: typing.Callable[[], T_Result],
        lm: typing.Callable[[], T_Result],
        lr: typing.Callable[[], T_Result],
        ls: typing.Callable[[], T_Result],
        lt: typing.Callable[[], T_Result],
        lu: typing.Callable[[], T_Result],
        m_2: typing.Callable[[], T_Result],
        ma: typing.Callable[[], T_Result],
        mb: typing.Callable[[], T_Result],
        mc: typing.Callable[[], T_Result],
        md: typing.Callable[[], T_Result],
        me: typing.Callable[[], T_Result],
        mf: typing.Callable[[], T_Result],
        mg: typing.Callable[[], T_Result],
        mh: typing.Callable[[], T_Result],
        ms: typing.Callable[[], T_Result],
        n_1: typing.Callable[[], T_Result],
        n_2: typing.Callable[[], T_Result],
        n_3: typing.Callable[[], T_Result],
        nb: typing.Callable[[], T_Result],
        nr: typing.Callable[[], T_Result],
        nu: typing.Callable[[], T_Result],
        p_1: typing.Callable[[], T_Result],
        p_2: typing.Callable[[], T_Result],
        p_3: typing.Callable[[], T_Result],
        p_4: typing.Callable[[], T_Result],
        p_5: typing.Callable[[], T_Result],
        p_6: typing.Callable[[], T_Result],
        pa: typing.Callable[[], T_Result],
        pb: typing.Callable[[], T_Result],
        pc: typing.Callable[[], T_Result],
        pd: typing.Callable[[], T_Result],
        pi: typing.Callable[[], T_Result],
        pl: typing.Callable[[], T_Result],
        pm: typing.Callable[[], T_Result],
        pn: typing.Callable[[], T_Result],
        po: typing.Callable[[], T_Result],
        ps: typing.Callable[[], T_Result],
        pt: typing.Callable[[], T_Result],
        q_0: typing.Callable[[], T_Result],
        q_1: typing.Callable[[], T_Result],
        q_2: typing.Callable[[], T_Result],
        q_3: typing.Callable[[], T_Result],
        q_4: typing.Callable[[], T_Result],
        q_5: typing.Callable[[], T_Result],
        q_6: typing.Callable[[], T_Result],
        q_7: typing.Callable[[], T_Result],
        q_8: typing.Callable[[], T_Result],
        q_9: typing.Callable[[], T_Result],
        qa: typing.Callable[[], T_Result],
        qb: typing.Callable[[], T_Result],
        qc: typing.Callable[[], T_Result],
        qd: typing.Callable[[], T_Result],
        qe: typing.Callable[[], T_Result],
        qf: typing.Callable[[], T_Result],
        qg: typing.Callable[[], T_Result],
        qh: typing.Callable[[], T_Result],
        qj: typing.Callable[[], T_Result],
        qk: typing.Callable[[], T_Result],
        ql: typing.Callable[[], T_Result],
        qm: typing.Callable[[], T_Result],
        qn: typing.Callable[[], T_Result],
        qp: typing.Callable[[], T_Result],
        qq: typing.Callable[[], T_Result],
        qr: typing.Callable[[], T_Result],
        qs: typing.Callable[[], T_Result],
        qt: typing.Callable[[], T_Result],
        qw: typing.Callable[[], T_Result],
        qx: typing.Callable[[], T_Result],
        qy: typing.Callable[[], T_Result],
        qz: typing.Callable[[], T_Result],
        ra: typing.Callable[[], T_Result],
        rb: typing.Callable[[], T_Result],
        rc: typing.Callable[[], T_Result],
        rd: typing.Callable[[], T_Result],
        re: typing.Callable[[], T_Result],
        ri: typing.Callable[[], T_Result],
        rr: typing.Callable[[], T_Result],
        rt: typing.Callable[[], T_Result],
        sa: typing.Callable[[], T_Result],
        sb: typing.Callable[[], T_Result],
        sc: typing.Callable[[], T_Result],
        sd: typing.Callable[[], T_Result],
        se: typing.Callable[[], T_Result],
        sf: typing.Callable[[], T_Result],
        sg: typing.Callable[[], T_Result],
        sh: typing.Callable[[], T_Result],
        sj: typing.Callable[[], T_Result],
        sl: typing.Callable[[], T_Result],
        sm: typing.Callable[[], T_Result],
        sn: typing.Callable[[], T_Result],
        sq: typing.Callable[[], T_Result],
        ss: typing.Callable[[], T_Result],
        st: typing.Callable[[], T_Result],
        su: typing.Callable[[], T_Result],
        sv: typing.Callable[[], T_Result],
        sw: typing.Callable[[], T_Result],
        sy: typing.Callable[[], T_Result],
        t_1: typing.Callable[[], T_Result],
        t_2: typing.Callable[[], T_Result],
        t_3: typing.Callable[[], T_Result],
        t_4: typing.Callable[[], T_Result],
        t_5: typing.Callable[[], T_Result],
        t_6: typing.Callable[[], T_Result],
        t_7: typing.Callable[[], T_Result],
        t_8: typing.Callable[[], T_Result],
        t_9: typing.Callable[[], T_Result],
        ta: typing.Callable[[], T_Result],
        tb: typing.Callable[[], T_Result],
        tc: typing.Callable[[], T_Result],
        td: typing.Callable[[], T_Result],
        te: typing.Callable[[], T_Result],
        tf: typing.Callable[[], T_Result],
        tg: typing.Callable[[], T_Result],
        th: typing.Callable[[], T_Result],
        tj: typing.Callable[[], T_Result],
        tk: typing.Callable[[], T_Result],
        tl: typing.Callable[[], T_Result],
        tm: typing.Callable[[], T_Result],
        tn: typing.Callable[[], T_Result],
        tp: typing.Callable[[], T_Result],
        tq: typing.Callable[[], T_Result],
        tr: typing.Callable[[], T_Result],
        ts: typing.Callable[[], T_Result],
        tt: typing.Callable[[], T_Result],
        tu: typing.Callable[[], T_Result],
        tv: typing.Callable[[], T_Result],
        tw: typing.Callable[[], T_Result],
        u_1: typing.Callable[[], T_Result],
        u_2: typing.Callable[[], T_Result],
        u_3: typing.Callable[[], T_Result],
        u_4: typing.Callable[[], T_Result],
        u_5: typing.Callable[[], T_Result],
        u_6: typing.Callable[[], T_Result],
        u_7: typing.Callable[[], T_Result],
        u_8: typing.Callable[[], T_Result],
        u_9: typing.Callable[[], T_Result],
        ua: typing.Callable[[], T_Result],
        ub: typing.Callable[[], T_Result],
        uc: typing.Callable[[], T_Result],
        ud: typing.Callable[[], T_Result],
        ue: typing.Callable[[], T_Result],
        uf: typing.Callable[[], T_Result],
        ug: typing.Callable[[], T_Result],
        uh: typing.Callable[[], T_Result],
        uj: typing.Callable[[], T_Result],
        uk: typing.Callable[[], T_Result],
        un: typing.Callable[[], T_Result],
        up: typing.Callable[[], T_Result],
        uq: typing.Callable[[], T_Result],
        ur: typing.Callable[[], T_Result],
        us: typing.Callable[[], T_Result],
        v_1: typing.Callable[[], T_Result],
        v_2: typing.Callable[[], T_Result],
        v_3: typing.Callable[[], T_Result],
        w_1: typing.Callable[[], T_Result],
        w_2: typing.Callable[[], T_Result],
        w_3: typing.Callable[[], T_Result],
        x_4: typing.Callable[[], T_Result],
        xe: typing.Callable[[], T_Result],
        xp: typing.Callable[[], T_Result],
        xs: typing.Callable[[], T_Result],
        xu: typing.Callable[[], T_Result],
        xy: typing.Callable[[], T_Result],
        _unknown_member: typing.Callable[[str], T_Result],
    ) -> T_Result:
        if self is ProcedureModifier.AV:
            return av()
        if self is ProcedureModifier.AU:
            return au()
        if self is ProcedureModifier.AW:
            return aw()
        if self is ProcedureModifier.TWENTY_TWO:
            return twenty_two()
        if self is ProcedureModifier.TWENTY_THREE:
            return twenty_three()
        if self is ProcedureModifier.TWENTY_FOUR:
            return twenty_four()
        if self is ProcedureModifier.TWENTY_FIVE:
            return twenty_five()
        if self is ProcedureModifier.TWENTY_SIX:
            return twenty_six()
        if self is ProcedureModifier.TWENTY_SEVEN:
            return twenty_seven()
        if self is ProcedureModifier.THIRTY_TWO:
            return thirty_two()
        if self is ProcedureModifier.THIRTY_THREE:
            return thirty_three()
        if self is ProcedureModifier.FORTY_SEVEN:
            return forty_seven()
        if self is ProcedureModifier.FIFTY:
            return fifty()
        if self is ProcedureModifier.FIFTY_ONE:
            return fifty_one()
        if self is ProcedureModifier.FIFTY_TWO:
            return fifty_two()
        if self is ProcedureModifier.FIFTY_THREE:
            return fifty_three()
        if self is ProcedureModifier.FIFTY_FOUR:
            return fifty_four()
        if self is ProcedureModifier.FIFTY_FIVE:
            return fifty_five()
        if self is ProcedureModifier.FIFTY_SIX:
            return fifty_six()
        if self is ProcedureModifier.FIFTY_SEVEN:
            return fifty_seven()
        if self is ProcedureModifier.FIFTY_EIGHT:
            return fifty_eight()
        if self is ProcedureModifier.FIFTY_NINE:
            return fifty_nine()
        if self is ProcedureModifier.SIXTY_TWO:
            return sixty_two()
        if self is ProcedureModifier.SIXTY_THREE:
            return sixty_three()
        if self is ProcedureModifier.SIXTY_SIX:
            return sixty_six()
        if self is ProcedureModifier.SEVENTY_FOUR:
            return seventy_four()
        if self is ProcedureModifier.SEVENTY_SIX:
            return seventy_six()
        if self is ProcedureModifier.SEVENTY_SEVEN:
            return seventy_seven()
        if self is ProcedureModifier.SEVENTY_EIGHT:
            return seventy_eight()
        if self is ProcedureModifier.SEVENTY_NINE:
            return seventy_nine()
        if self is ProcedureModifier.EIGHTY:
            return eighty()
        if self is ProcedureModifier.EIGHTY_ONE:
            return eighty_one()
        if self is ProcedureModifier.EIGHTY_TWO:
            return eighty_two()
        if self is ProcedureModifier.NINETY:
            return ninety()
        if self is ProcedureModifier.NINETY_ONE:
            return ninety_one()
        if self is ProcedureModifier.NINETY_TWO:
            return ninety_two()
        if self is ProcedureModifier.NINETY_THREE:
            return ninety_three()
        if self is ProcedureModifier.NINETY_FIVE:
            return ninety_five()
        if self is ProcedureModifier.NINETY_SIX:
            return ninety_six()
        if self is ProcedureModifier.NINETY_SEVEN:
            return ninety_seven()
        if self is ProcedureModifier.NINETY_NINE:
            return ninety_nine()
        if self is ProcedureModifier.A_1:
            return a_1()
        if self is ProcedureModifier.A_2:
            return a_2()
        if self is ProcedureModifier.A_3:
            return a_3()
        if self is ProcedureModifier.A_4:
            return a_4()
        if self is ProcedureModifier.A_5:
            return a_5()
        if self is ProcedureModifier.A_6:
            return a_6()
        if self is ProcedureModifier.A_7:
            return a_7()
        if self is ProcedureModifier.A_8:
            return a_8()
        if self is ProcedureModifier.A_9:
            return a_9()
        if self is ProcedureModifier.AA:
            return aa()
        if self is ProcedureModifier.AB:
            return ab()
        if self is ProcedureModifier.AD:
            return ad()
        if self is ProcedureModifier.AE:
            return ae()
        if self is ProcedureModifier.AF:
            return af()
        if self is ProcedureModifier.AG:
            return ag()
        if self is ProcedureModifier.AH:
            return ah()
        if self is ProcedureModifier.AI:
            return ai()
        if self is ProcedureModifier.AJ:
            return aj()
        if self is ProcedureModifier.AK:
            return ak()
        if self is ProcedureModifier.AM:
            return am()
        if self is ProcedureModifier.AO:
            return ao()
        if self is ProcedureModifier.AP:
            return ap()
        if self is ProcedureModifier.AQ:
            return aq()
        if self is ProcedureModifier.AR:
            return ar()
        if self is ProcedureModifier.AS:
            return as_()
        if self is ProcedureModifier.AT:
            return at()
        if self is ProcedureModifier.AZ:
            return az()
        if self is ProcedureModifier.BA:
            return ba()
        if self is ProcedureModifier.BL:
            return bl()
        if self is ProcedureModifier.BO:
            return bo()
        if self is ProcedureModifier.BP:
            return bp()
        if self is ProcedureModifier.BR:
            return br()
        if self is ProcedureModifier.BU:
            return bu()
        if self is ProcedureModifier.CA:
            return ca()
        if self is ProcedureModifier.CB:
            return cb()
        if self is ProcedureModifier.CC:
            return cc()
        if self is ProcedureModifier.CD:
            return cd()
        if self is ProcedureModifier.CE:
            return ce()
        if self is ProcedureModifier.CF:
            return cf()
        if self is ProcedureModifier.CG:
            return cg()
        if self is ProcedureModifier.CH:
            return ch()
        if self is ProcedureModifier.CI:
            return ci()
        if self is ProcedureModifier.CJ:
            return cj()
        if self is ProcedureModifier.CK:
            return ck()
        if self is ProcedureModifier.CL:
            return cl()
        if self is ProcedureModifier.CM:
            return cm()
        if self is ProcedureModifier.CN:
            return cn()
        if self is ProcedureModifier.CR:
            return cr()
        if self is ProcedureModifier.CS:
            return cs()
        if self is ProcedureModifier.CT:
            return ct()
        if self is ProcedureModifier.CO:
            return co()
        if self is ProcedureModifier.CQ:
            return cq()
        if self is ProcedureModifier.DA:
            return da()
        if self is ProcedureModifier.E_1:
            return e_1()
        if self is ProcedureModifier.E_2:
            return e_2()
        if self is ProcedureModifier.E_3:
            return e_3()
        if self is ProcedureModifier.E_4:
            return e_4()
        if self is ProcedureModifier.EA:
            return ea()
        if self is ProcedureModifier.EB:
            return eb()
        if self is ProcedureModifier.EC:
            return ec()
        if self is ProcedureModifier.ED:
            return ed()
        if self is ProcedureModifier.EE:
            return ee()
        if self is ProcedureModifier.EJ:
            return ej()
        if self is ProcedureModifier.EM:
            return em()
        if self is ProcedureModifier.EP:
            return ep()
        if self is ProcedureModifier.ER:
            return er()
        if self is ProcedureModifier.ET:
            return et()
        if self is ProcedureModifier.EX:
            return ex()
        if self is ProcedureModifier.EY:
            return ey()
        if self is ProcedureModifier.F_1:
            return f_1()
        if self is ProcedureModifier.F_2:
            return f_2()
        if self is ProcedureModifier.F_3:
            return f_3()
        if self is ProcedureModifier.F_4:
            return f_4()
        if self is ProcedureModifier.F_5:
            return f_5()
        if self is ProcedureModifier.F_6:
            return f_6()
        if self is ProcedureModifier.F_7:
            return f_7()
        if self is ProcedureModifier.F_8:
            return f_8()
        if self is ProcedureModifier.F_9:
            return f_9()
        if self is ProcedureModifier.FA:
            return fa()
        if self is ProcedureModifier.FB:
            return fb()
        if self is ProcedureModifier.FC:
            return fc()
        if self is ProcedureModifier.FP:
            return fp()
        if self is ProcedureModifier.FQ:
            return fq()
        if self is ProcedureModifier.FR:
            return fr()
        if self is ProcedureModifier.FS:
            return fs()
        if self is ProcedureModifier.FT:
            return ft()
        if self is ProcedureModifier.FX:
            return fx()
        if self is ProcedureModifier.FY:
            return fy()
        if self is ProcedureModifier.G_0:
            return g_0()
        if self is ProcedureModifier.G_1:
            return g_1()
        if self is ProcedureModifier.G_2:
            return g_2()
        if self is ProcedureModifier.G_3:
            return g_3()
        if self is ProcedureModifier.G_4:
            return g_4()
        if self is ProcedureModifier.G_5:
            return g_5()
        if self is ProcedureModifier.G_6:
            return g_6()
        if self is ProcedureModifier.G_7:
            return g_7()
        if self is ProcedureModifier.G_8:
            return g_8()
        if self is ProcedureModifier.G_9:
            return g_9()
        if self is ProcedureModifier.GA:
            return ga()
        if self is ProcedureModifier.GB:
            return gb()
        if self is ProcedureModifier.GC:
            return gc()
        if self is ProcedureModifier.GE:
            return ge()
        if self is ProcedureModifier.GF:
            return gf()
        if self is ProcedureModifier.GG:
            return gg()
        if self is ProcedureModifier.GH:
            return gh()
        if self is ProcedureModifier.GJ:
            return gj()
        if self is ProcedureModifier.GK:
            return gk()
        if self is ProcedureModifier.GL:
            return gl()
        if self is ProcedureModifier.GM:
            return gm()
        if self is ProcedureModifier.GN:
            return gn()
        if self is ProcedureModifier.GO:
            return go()
        if self is ProcedureModifier.GP:
            return gp()
        if self is ProcedureModifier.GQ:
            return gq()
        if self is ProcedureModifier.GR:
            return gr()
        if self is ProcedureModifier.GS:
            return gs()
        if self is ProcedureModifier.GT:
            return gt()
        if self is ProcedureModifier.GU:
            return gu()
        if self is ProcedureModifier.GV:
            return gv()
        if self is ProcedureModifier.GW:
            return gw()
        if self is ProcedureModifier.GX:
            return gx()
        if self is ProcedureModifier.GY:
            return gy()
        if self is ProcedureModifier.GZ:
            return gz()
        if self is ProcedureModifier.HA:
            return ha()
        if self is ProcedureModifier.HB:
            return hb()
        if self is ProcedureModifier.HC:
            return hc()
        if self is ProcedureModifier.HD:
            return hd()
        if self is ProcedureModifier.HE:
            return he()
        if self is ProcedureModifier.HF:
            return hf()
        if self is ProcedureModifier.HG:
            return hg()
        if self is ProcedureModifier.HH:
            return hh()
        if self is ProcedureModifier.HI:
            return hi()
        if self is ProcedureModifier.HJ:
            return hj()
        if self is ProcedureModifier.HK:
            return hk()
        if self is ProcedureModifier.HL:
            return hl()
        if self is ProcedureModifier.HM:
            return hm()
        if self is ProcedureModifier.HN:
            return hn()
        if self is ProcedureModifier.HO:
            return ho()
        if self is ProcedureModifier.HP:
            return hp()
        if self is ProcedureModifier.HQ:
            return hq()
        if self is ProcedureModifier.HR:
            return hr()
        if self is ProcedureModifier.HS:
            return hs()
        if self is ProcedureModifier.HT:
            return ht()
        if self is ProcedureModifier.HU:
            return hu()
        if self is ProcedureModifier.HV:
            return hv()
        if self is ProcedureModifier.HW:
            return hw()
        if self is ProcedureModifier.HX:
            return hx()
        if self is ProcedureModifier.HY:
            return hy()
        if self is ProcedureModifier.HZ:
            return hz()
        if self is ProcedureModifier.J_1:
            return j_1()
        if self is ProcedureModifier.J_2:
            return j_2()
        if self is ProcedureModifier.J_3:
            return j_3()
        if self is ProcedureModifier.J_4:
            return j_4()
        if self is ProcedureModifier.J_5:
            return j_5()
        if self is ProcedureModifier.JA:
            return ja()
        if self is ProcedureModifier.JB:
            return jb()
        if self is ProcedureModifier.JC:
            return jc()
        if self is ProcedureModifier.JD:
            return jd()
        if self is ProcedureModifier.JE:
            return je()
        if self is ProcedureModifier.JG:
            return jg()
        if self is ProcedureModifier.JW:
            return jw()
        if self is ProcedureModifier.JZ:
            return jz()
        if self is ProcedureModifier.K_0:
            return k_0()
        if self is ProcedureModifier.K_1:
            return k_1()
        if self is ProcedureModifier.K_2:
            return k_2()
        if self is ProcedureModifier.K_3:
            return k_3()
        if self is ProcedureModifier.K_4:
            return k_4()
        if self is ProcedureModifier.KA:
            return ka()
        if self is ProcedureModifier.KB:
            return kb()
        if self is ProcedureModifier.KC:
            return kc()
        if self is ProcedureModifier.KD:
            return kd()
        if self is ProcedureModifier.KE:
            return ke()
        if self is ProcedureModifier.KF:
            return kf()
        if self is ProcedureModifier.KG:
            return kg()
        if self is ProcedureModifier.KH:
            return kh()
        if self is ProcedureModifier.KI:
            return ki()
        if self is ProcedureModifier.KJ:
            return kj()
        if self is ProcedureModifier.KK:
            return kk()
        if self is ProcedureModifier.KL:
            return kl()
        if self is ProcedureModifier.KM:
            return km()
        if self is ProcedureModifier.KN:
            return kn()
        if self is ProcedureModifier.KO:
            return ko()
        if self is ProcedureModifier.KP:
            return kp()
        if self is ProcedureModifier.KQ:
            return kq()
        if self is ProcedureModifier.KR:
            return kr()
        if self is ProcedureModifier.KS:
            return ks()
        if self is ProcedureModifier.KT:
            return kt()
        if self is ProcedureModifier.KU:
            return ku()
        if self is ProcedureModifier.KV:
            return kv()
        if self is ProcedureModifier.KW:
            return kw()
        if self is ProcedureModifier.KX:
            return kx()
        if self is ProcedureModifier.KY:
            return ky()
        if self is ProcedureModifier.KZ:
            return kz()
        if self is ProcedureModifier.LC:
            return lc()
        if self is ProcedureModifier.LD:
            return ld()
        if self is ProcedureModifier.LL:
            return ll()
        if self is ProcedureModifier.LM:
            return lm()
        if self is ProcedureModifier.LR:
            return lr()
        if self is ProcedureModifier.LS:
            return ls()
        if self is ProcedureModifier.LT:
            return lt()
        if self is ProcedureModifier.LU:
            return lu()
        if self is ProcedureModifier.M_2:
            return m_2()
        if self is ProcedureModifier.MA:
            return ma()
        if self is ProcedureModifier.MB:
            return mb()
        if self is ProcedureModifier.MC:
            return mc()
        if self is ProcedureModifier.MD:
            return md()
        if self is ProcedureModifier.ME:
            return me()
        if self is ProcedureModifier.MF:
            return mf()
        if self is ProcedureModifier.MG:
            return mg()
        if self is ProcedureModifier.MH:
            return mh()
        if self is ProcedureModifier.MS:
            return ms()
        if self is ProcedureModifier.N_1:
            return n_1()
        if self is ProcedureModifier.N_2:
            return n_2()
        if self is ProcedureModifier.N_3:
            return n_3()
        if self is ProcedureModifier.NB:
            return nb()
        if self is ProcedureModifier.NR:
            return nr()
        if self is ProcedureModifier.NU:
            return nu()
        if self is ProcedureModifier.P_1:
            return p_1()
        if self is ProcedureModifier.P_2:
            return p_2()
        if self is ProcedureModifier.P_3:
            return p_3()
        if self is ProcedureModifier.P_4:
            return p_4()
        if self is ProcedureModifier.P_5:
            return p_5()
        if self is ProcedureModifier.P_6:
            return p_6()
        if self is ProcedureModifier.PA:
            return pa()
        if self is ProcedureModifier.PB:
            return pb()
        if self is ProcedureModifier.PC:
            return pc()
        if self is ProcedureModifier.PD:
            return pd()
        if self is ProcedureModifier.PI:
            return pi()
        if self is ProcedureModifier.PL:
            return pl()
        if self is ProcedureModifier.PM:
            return pm()
        if self is ProcedureModifier.PN:
            return pn()
        if self is ProcedureModifier.PO:
            return po()
        if self is ProcedureModifier.PS:
            return ps()
        if self is ProcedureModifier.PT:
            return pt()
        if self is ProcedureModifier.Q_0:
            return q_0()
        if self is ProcedureModifier.Q_1:
            return q_1()
        if self is ProcedureModifier.Q_2:
            return q_2()
        if self is ProcedureModifier.Q_3:
            return q_3()
        if self is ProcedureModifier.Q_4:
            return q_4()
        if self is ProcedureModifier.Q_5:
            return q_5()
        if self is ProcedureModifier.Q_6:
            return q_6()
        if self is ProcedureModifier.Q_7:
            return q_7()
        if self is ProcedureModifier.Q_8:
            return q_8()
        if self is ProcedureModifier.Q_9:
            return q_9()
        if self is ProcedureModifier.QA:
            return qa()
        if self is ProcedureModifier.QB:
            return qb()
        if self is ProcedureModifier.QC:
            return qc()
        if self is ProcedureModifier.QD:
            return qd()
        if self is ProcedureModifier.QE:
            return qe()
        if self is ProcedureModifier.QF:
            return qf()
        if self is ProcedureModifier.QG:
            return qg()
        if self is ProcedureModifier.QH:
            return qh()
        if self is ProcedureModifier.QJ:
            return qj()
        if self is ProcedureModifier.QK:
            return qk()
        if self is ProcedureModifier.QL:
            return ql()
        if self is ProcedureModifier.QM:
            return qm()
        if self is ProcedureModifier.QN:
            return qn()
        if self is ProcedureModifier.QP:
            return qp()
        if self is ProcedureModifier.QQ:
            return qq()
        if self is ProcedureModifier.QR:
            return qr()
        if self is ProcedureModifier.QS:
            return qs()
        if self is ProcedureModifier.QT:
            return qt()
        if self is ProcedureModifier.QW:
            return qw()
        if self is ProcedureModifier.QX:
            return qx()
        if self is ProcedureModifier.QY:
            return qy()
        if self is ProcedureModifier.QZ:
            return qz()
        if self is ProcedureModifier.RA:
            return ra()
        if self is ProcedureModifier.RB:
            return rb()
        if self is ProcedureModifier.RC:
            return rc()
        if self is ProcedureModifier.RD:
            return rd()
        if self is ProcedureModifier.RE:
            return re()
        if self is ProcedureModifier.RI:
            return ri()
        if self is ProcedureModifier.RR:
            return rr()
        if self is ProcedureModifier.RT:
            return rt()
        if self is ProcedureModifier.SA:
            return sa()
        if self is ProcedureModifier.SB:
            return sb()
        if self is ProcedureModifier.SC:
            return sc()
        if self is ProcedureModifier.SD:
            return sd()
        if self is ProcedureModifier.SE:
            return se()
        if self is ProcedureModifier.SF:
            return sf()
        if self is ProcedureModifier.SG:
            return sg()
        if self is ProcedureModifier.SH:
            return sh()
        if self is ProcedureModifier.SJ:
            return sj()
        if self is ProcedureModifier.SL:
            return sl()
        if self is ProcedureModifier.SM:
            return sm()
        if self is ProcedureModifier.SN:
            return sn()
        if self is ProcedureModifier.SQ:
            return sq()
        if self is ProcedureModifier.SS:
            return ss()
        if self is ProcedureModifier.ST:
            return st()
        if self is ProcedureModifier.SU:
            return su()
        if self is ProcedureModifier.SV:
            return sv()
        if self is ProcedureModifier.SW:
            return sw()
        if self is ProcedureModifier.SY:
            return sy()
        if self is ProcedureModifier.T_1:
            return t_1()
        if self is ProcedureModifier.T_2:
            return t_2()
        if self is ProcedureModifier.T_3:
            return t_3()
        if self is ProcedureModifier.T_4:
            return t_4()
        if self is ProcedureModifier.T_5:
            return t_5()
        if self is ProcedureModifier.T_6:
            return t_6()
        if self is ProcedureModifier.T_7:
            return t_7()
        if self is ProcedureModifier.T_8:
            return t_8()
        if self is ProcedureModifier.T_9:
            return t_9()
        if self is ProcedureModifier.TA:
            return ta()
        if self is ProcedureModifier.TB:
            return tb()
        if self is ProcedureModifier.TC:
            return tc()
        if self is ProcedureModifier.TD:
            return td()
        if self is ProcedureModifier.TE:
            return te()
        if self is ProcedureModifier.TF:
            return tf()
        if self is ProcedureModifier.TG:
            return tg()
        if self is ProcedureModifier.TH:
            return th()
        if self is ProcedureModifier.TJ:
            return tj()
        if self is ProcedureModifier.TK:
            return tk()
        if self is ProcedureModifier.TL:
            return tl()
        if self is ProcedureModifier.TM:
            return tm()
        if self is ProcedureModifier.TN:
            return tn()
        if self is ProcedureModifier.TP:
            return tp()
        if self is ProcedureModifier.TQ:
            return tq()
        if self is ProcedureModifier.TR:
            return tr()
        if self is ProcedureModifier.TS:
            return ts()
        if self is ProcedureModifier.TT:
            return tt()
        if self is ProcedureModifier.TU:
            return tu()
        if self is ProcedureModifier.TV:
            return tv()
        if self is ProcedureModifier.TW:
            return tw()
        if self is ProcedureModifier.U_1:
            return u_1()
        if self is ProcedureModifier.U_2:
            return u_2()
        if self is ProcedureModifier.U_3:
            return u_3()
        if self is ProcedureModifier.U_4:
            return u_4()
        if self is ProcedureModifier.U_5:
            return u_5()
        if self is ProcedureModifier.U_6:
            return u_6()
        if self is ProcedureModifier.U_7:
            return u_7()
        if self is ProcedureModifier.U_8:
            return u_8()
        if self is ProcedureModifier.U_9:
            return u_9()
        if self is ProcedureModifier.UA:
            return ua()
        if self is ProcedureModifier.UB:
            return ub()
        if self is ProcedureModifier.UC:
            return uc()
        if self is ProcedureModifier.UD:
            return ud()
        if self is ProcedureModifier.UE:
            return ue()
        if self is ProcedureModifier.UF:
            return uf()
        if self is ProcedureModifier.UG:
            return ug()
        if self is ProcedureModifier.UH:
            return uh()
        if self is ProcedureModifier.UJ:
            return uj()
        if self is ProcedureModifier.UK:
            return uk()
        if self is ProcedureModifier.UN:
            return un()
        if self is ProcedureModifier.UP:
            return up()
        if self is ProcedureModifier.UQ:
            return uq()
        if self is ProcedureModifier.UR:
            return ur()
        if self is ProcedureModifier.US:
            return us()
        if self is ProcedureModifier.V_1:
            return v_1()
        if self is ProcedureModifier.V_2:
            return v_2()
        if self is ProcedureModifier.V_3:
            return v_3()
        if self is ProcedureModifier.W_1:
            return w_1()
        if self is ProcedureModifier.W_2:
            return w_2()
        if self is ProcedureModifier.W_3:
            return w_3()
        if self is ProcedureModifier.X_4:
            return x_4()
        if self is ProcedureModifier.XE:
            return xe()
        if self is ProcedureModifier.XP:
            return xp()
        if self is ProcedureModifier.XS:
            return xs()
        if self is ProcedureModifier.XU:
            return xu()
        if self is ProcedureModifier.XY:
            return xy()
        return _unknown_member(self._value_)
